// This source code is generated by UdpGeneratorTool, not recommend to modify it directly
#include <errno.h>
#include <unistd.h>
#include <sys/types.h>
#include <sys/socket.h>

#include "Debug2MnldInterface.h"
#include "mtk_socket_data_coder.h"

// Debug2MnldInterface_DebugReqStatusCategory
const char* Debug2MnldInterface_DebugReqStatusCategory_to_string(Debug2MnldInterface_DebugReqStatusCategory data) {
    switch(data) {
    case DEBUG2MNLD_INTERFACE_DEBUG_REQ_STATUS_CATEGORY_STOP_DEBUG:
        return "stopDebug";
    case DEBUG2MNLD_INTERFACE_DEBUG_REQ_STATUS_CATEGORY_START_DEBUG:
        return "startDebug";
    case DEBUG2MNLD_INTERFACE_DEBUG_REQ_STATUS_CATEGORY_END:
        return "end";
    default:
        break;
    }
    return "UNKNOWN";
}
void Debug2MnldInterface_DebugReqStatusCategory_array_dump(Debug2MnldInterface_DebugReqStatusCategory data[], int size) {
    int i = 0;
    SOCK_LOGD("Debug2MnldInterface_DebugReqStatusCategory_array_dump() size=[%d]", size);
    for(i = 0; i < size; i++) {
        SOCK_LOGD("  i=[%d] data=[%s]", i, Debug2MnldInterface_DebugReqStatusCategory_to_string(data[i]));
    }
}

void Debug2MnldInterface_DebugReqStatusCategory_array_init(Debug2MnldInterface_DebugReqStatusCategory output[], int max_size) {
    int i = 0;
    for(i = 0; i < max_size; i++) {
        output[i] = DEBUG2MNLD_INTERFACE_DEBUG_REQ_STATUS_CATEGORY_STOP_DEBUG;
    }
}

bool Debug2MnldInterface_DebugReqStatusCategory_is_equal(Debug2MnldInterface_DebugReqStatusCategory data1, Debug2MnldInterface_DebugReqStatusCategory data2) {
    return (data1 == data2)? true : false;
}
bool Debug2MnldInterface_DebugReqStatusCategory_array_is_equal(Debug2MnldInterface_DebugReqStatusCategory data1[], int size1, Debug2MnldInterface_DebugReqStatusCategory data2[], int size2) {
    int i = 0;
    if(size1 != size2) return false;
    for(i = 0; i < size1; i++) {
        if(data1[i] != data2[i]) return false;
    }
    return true;
}

bool Debug2MnldInterface_DebugReqStatusCategory_encode(char* buff, int* offset, Debug2MnldInterface_DebugReqStatusCategory data) {
    switch(data) {
    case DEBUG2MNLD_INTERFACE_DEBUG_REQ_STATUS_CATEGORY_STOP_DEBUG:
    case DEBUG2MNLD_INTERFACE_DEBUG_REQ_STATUS_CATEGORY_START_DEBUG:
    case DEBUG2MNLD_INTERFACE_DEBUG_REQ_STATUS_CATEGORY_END:
        break;
    default:
        SOCK_LOGE("Debug2MnldInterface_DebugReqStatusCategory_encode() unknown data=%d", data);
        return false;
    }
    mtk_socket_put_int(buff, offset, data);
    return true;
}
bool Debug2MnldInterface_DebugReqStatusCategory_array_encode(char* buff, int* offset, Debug2MnldInterface_DebugReqStatusCategory data[], int size) {
    int i = 0;
    mtk_socket_put_int(buff, offset, size);
    for(i = 0; i < size; i++) {
        if(!Debug2MnldInterface_DebugReqStatusCategory_encode(buff, offset, data[i])) {
            SOCK_LOGE("Debug2MnldInterface_DebugReqStatusCategory_array_encode() Debug2MnldInterface_DebugReqStatusCategory_encode() failed at i=%d", i);
            return false;
        }
    }
    return true;
}

void Debug2MnldInterface_DebugReqStatusCategory_decode(char* buff, int* offset, Debug2MnldInterface_DebugReqStatusCategory* output) {
    *output = mtk_socket_get_int(buff, offset);
}
int Debug2MnldInterface_DebugReqStatusCategory_array_decode(char* buff, int* offset, Debug2MnldInterface_DebugReqStatusCategory output[], int max_size) {
    int i = 0;
    int size = mtk_socket_get_int(buff, offset);
    for(i = 0; i < size; i++) {
        if(i < max_size) {
            Debug2MnldInterface_DebugReqStatusCategory_decode(buff, offset, &output[i]);
        } else {
            Debug2MnldInterface_DebugReqStatusCategory data;
            Debug2MnldInterface_DebugReqStatusCategory_decode(buff, offset, &data);
        }
    }
    return (size > max_size)? max_size : size;
}


// Sender
bool Debug2MnldInterface_debugReqMnldMsg(mtk_socket_fd* client_fd, Debug2MnldInterface_DebugReqStatusCategory status) {
    pthread_mutex_lock(&client_fd->mutex);
    if(!mtk_socket_client_connect(client_fd)) {
        SOCK_LOGE("Debug2MnldInterface_debugReqMnldMsg() mtk_socket_client_connect() failed");
        pthread_mutex_unlock(&client_fd->mutex);
        return false;
    }
    int _ret;
    char _buff[DEBUG2MNLD_INTERFACE_BUFF_SIZE] = {0};
    int _offset = 0;
    mtk_socket_put_int(_buff, &_offset, DEBUG2MNLD_INTERFACE_PROTOCOL_TYPE);
    mtk_socket_put_int(_buff, &_offset, DEBUG2MNLD_INTERFACE_DEBUG_REQ_MNLD_MSG);
    if(!Debug2MnldInterface_DebugReqStatusCategory_encode(_buff, &_offset, status)) {
        SOCK_LOGE("Debug2MnldInterface_debugReqMnldMsg() Debug2MnldInterface_DebugReqStatusCategory_encode() fail on status");
        mtk_socket_client_close(client_fd);
        pthread_mutex_unlock(&client_fd->mutex);
        return false;
    }
    _ret = mtk_socket_write(client_fd->fd, _buff, _offset);
    if(_ret == -1) {
        SOCK_LOGE("Debug2MnldInterface_debugReqMnldMsg() mtk_socket_write() failed, fd=%d err=[%s]%d",
            client_fd->fd, strerror(errno), errno);
        mtk_socket_client_close(client_fd);
        pthread_mutex_unlock(&client_fd->mutex);
        return false;
    }
    mtk_socket_client_close(client_fd);
    pthread_mutex_unlock(&client_fd->mutex);
    return true;
}

bool Debug2MnldInterface_debugMnldNeMsg(mtk_socket_fd* client_fd, bool enabled) {
    pthread_mutex_lock(&client_fd->mutex);
    if(!mtk_socket_client_connect(client_fd)) {
        SOCK_LOGE("Debug2MnldInterface_debugMnldNeMsg() mtk_socket_client_connect() failed");
        pthread_mutex_unlock(&client_fd->mutex);
        return false;
    }
    int _ret;
    char _buff[DEBUG2MNLD_INTERFACE_BUFF_SIZE] = {0};
    int _offset = 0;
    mtk_socket_put_int(_buff, &_offset, DEBUG2MNLD_INTERFACE_PROTOCOL_TYPE);
    mtk_socket_put_int(_buff, &_offset, DEBUG2MNLD_INTERFACE_DEBUG_MNLD_NE_MSG);
    mtk_socket_put_bool(_buff, &_offset, enabled);
    _ret = mtk_socket_write(client_fd->fd, _buff, _offset);
    if(_ret == -1) {
        SOCK_LOGE("Debug2MnldInterface_debugMnldNeMsg() mtk_socket_write() failed, fd=%d err=[%s]%d",
            client_fd->fd, strerror(errno), errno);
        mtk_socket_client_close(client_fd);
        pthread_mutex_unlock(&client_fd->mutex);
        return false;
    }
    mtk_socket_client_close(client_fd);
    pthread_mutex_unlock(&client_fd->mutex);
    return true;
}

bool Debug2MnldInterface_debugMnldRadioMsg(mtk_socket_fd* client_fd, const char* value) {
    pthread_mutex_lock(&client_fd->mutex);
    if(!mtk_socket_client_connect(client_fd)) {
        SOCK_LOGE("Debug2MnldInterface_debugMnldRadioMsg() mtk_socket_client_connect() failed");
        pthread_mutex_unlock(&client_fd->mutex);
        return false;
    }
    int _ret;
    char _buff[DEBUG2MNLD_INTERFACE_BUFF_SIZE] = {0};
    int _offset = 0;
    mtk_socket_put_int(_buff, &_offset, DEBUG2MNLD_INTERFACE_PROTOCOL_TYPE);
    mtk_socket_put_int(_buff, &_offset, DEBUG2MNLD_INTERFACE_DEBUG_MNLD_RADIO_MSG);
    if(strlen(value) > 10) {
        SOCK_LOGE("Debug2MnldInterface_debugMnldRadioMsg() strlen of value=[%zu] is over 10", strlen(value));
        mtk_socket_client_close(client_fd);
        pthread_mutex_unlock(&client_fd->mutex);
        return false;
    }
    mtk_socket_put_string(_buff, &_offset, value);
    _ret = mtk_socket_write(client_fd->fd, _buff, _offset);
    if(_ret == -1) {
        SOCK_LOGE("Debug2MnldInterface_debugMnldRadioMsg() mtk_socket_write() failed, fd=%d err=[%s]%d",
            client_fd->fd, strerror(errno), errno);
        mtk_socket_client_close(client_fd);
        pthread_mutex_unlock(&client_fd->mutex);
        return false;
    }
    mtk_socket_client_close(client_fd);
    pthread_mutex_unlock(&client_fd->mutex);
    return true;
}

// Receiver
bool Debug2MnldInterface_receiver_decode(char* _buff, Debug2MnldInterface_callbacks* callbacks) {
    int _ret = 0;
    int _offset = 0;
    _ret = mtk_socket_get_int(_buff, &_offset);
    if(_ret != DEBUG2MNLD_INTERFACE_PROTOCOL_TYPE) {
        SOCK_LOGE("Debug2MnldInterface_receiver_decode() protocol_type=[%d] is not equals to [%d]",
            _ret, DEBUG2MNLD_INTERFACE_PROTOCOL_TYPE);
        return false;
    }
    _ret = mtk_socket_get_int(_buff, &_offset);
    switch(_ret) {
    case DEBUG2MNLD_INTERFACE_DEBUG_REQ_MNLD_MSG: {
        if(callbacks->Debug2MnldInterface_debugReqMnldMsg_handler == NULL) {
            SOCK_LOGE("Debug2MnldInterface_receiver_decode() Debug2MnldInterface_debugReqMnldMsg_handler() is NULL");
            return false;
        }
        Debug2MnldInterface_DebugReqStatusCategory status;
        Debug2MnldInterface_DebugReqStatusCategory_decode(_buff, &_offset, &status);
        callbacks->Debug2MnldInterface_debugReqMnldMsg_handler(status);
        break;
    }
    case DEBUG2MNLD_INTERFACE_DEBUG_MNLD_NE_MSG: {
        if(callbacks->Debug2MnldInterface_debugMnldNeMsg_handler == NULL) {
            SOCK_LOGE("Debug2MnldInterface_receiver_decode() Debug2MnldInterface_debugMnldNeMsg_handler() is NULL");
            return false;
        }
        bool enabled = mtk_socket_get_bool(_buff, &_offset);
        callbacks->Debug2MnldInterface_debugMnldNeMsg_handler(enabled);
        break;
    }
    case DEBUG2MNLD_INTERFACE_DEBUG_MNLD_RADIO_MSG: {
        if(callbacks->Debug2MnldInterface_debugMnldRadioMsg_handler == NULL) {
            SOCK_LOGE("Debug2MnldInterface_receiver_decode() Debug2MnldInterface_debugMnldRadioMsg_handler() is NULL");
            return false;
        }
        char value[10];
        mtk_socket_get_string(_buff, &_offset, value, 10);
        callbacks->Debug2MnldInterface_debugMnldRadioMsg_handler(value);
        break;
    }
    default: {
        SOCK_LOGE("Debug2MnldInterface_receiver_decode() unknown msgId=[%d]", _ret);
        return false;
    }
    }
    return true;
}
bool Debug2MnldInterface_receiver_read_and_decode(int server_fd, Debug2MnldInterface_callbacks* callbacks) {
    int _ret;
    char _buff[DEBUG2MNLD_INTERFACE_BUFF_SIZE] = {0};

    _ret = mtk_socket_read(server_fd, _buff, sizeof(_buff) - 1);
    if(_ret == -1) {
        SOCK_LOGE("Debug2MnldInterface_receiver_read_and_decode() mtk_socket_read() failed, fd=%d err=[%s]%d",
            server_fd, strerror(errno), errno);
        return false;
    }
    _buff[_ret] = 0;
    return Debug2MnldInterface_receiver_decode(_buff, callbacks);
}

