#ifndef __MTK_GEOFENCE_CONTROLLER_H__
#define __MTK_GEOFENCE_CONTROLLER_H__

#include <stdint.h>
#include <stdio.h>
#include <stdlib.h>
#include <stdbool.h>
#include <time.h>
#include <sys/socket.h>
#include "mtk_gps_type.h"
#include "geofence.h"

#ifdef __cplusplus
extern "C" {
#endif

typedef struct {
    void (*mnld_gfc_hbd_gps_open)();
    void (*mnld_gfc_hbd_gps_close)();
} gfc2mnl_interface;

#define MAX_CLIENT_NUM 10

void mtk_geofence_epoll_server_hdlr(int fd, int epfd);
void mtk_geofence_epoll_control_server_hdlr(int fd, int epfd);
void mtk_geofence_epoll_client_hdlr(int fd, gfc2mnl_interface* hdlr);
void mtk_geofence_epoll_client_control_hdlr(int fd, gfc2mnl_interface* hdlr) ;
int mtk_geofence_controller_process(mtk_geofence_msg *prmsg) ;


#ifdef __cplusplus
}
#endif

#endif

