#ifndef __MTK_GEOFENCE_MAIN_H__
#define __MTK_GEOFENCE_MAIN_H__

#include <stdint.h>
#include <stdio.h>
#include <stdlib.h>
#include <stdbool.h>
#include <time.h>
#include <sys/socket.h>
#include "mtk_gps_type.h"
#include "geofence.h"

#ifdef __cplusplus
extern "C" {
#endif

#define GEOFENCE_VERSION_HEAD 'G','F','C','_','V','E','R','_'
#define GEOFENCE_MAJOR_VERSION '1','7','0','6','1','9','0','1'  // y,y,m,m,d,d,rev,rev
#define GEOFENCE_BRANCH_INFO '_','0','.','5','8','_'
#define GEOFENCE_MINER_VERSION 'N','1'
#define GEOFENCE_VER_INFO GEOFENCE_VERSION_HEAD,GEOFENCE_MAJOR_VERSION,GEOFENCE_BRANCH_INFO,GEOFENCE_MINER_VERSION

#define GEOFENCEADP_MNL_TCP_DATA      "mtk_geofenceadp_mnl_data"
#define GEOFENCEADP_MNL_TCP_CONTROL   "mtk_geofenceadp_mnl_control"

//======================================================
// GEOFENCE -> GPS/GEOFENCE HAL
//======================================================
#define MAX_GOEFENCE               100
#define MTK_ADD_GEOFENCE_SUCCESS   0
#define MTK_ADD_GEOFENCE_ERROR    -1
#define MTK_ADD_GEOFENCE_INSUFFICIENT_MEM -2
#define MTK_ADD_GEOFENCE_TOO_MANY -3

#define MTK_GEOFENCE_TRANSITION_ENTERED      0x01
#define MTK_GEOFENCE_TRANSITION_EXITED       0x02
#define MTK_GEOFENCE_TRANSITION_UNCERTAIN    0x04
#define MTK_GEOFENCE_TRANSITION_NO_CHANGE    0xff

#define GEOFENCE_BUFF_SIZE   (1 * 1024)
#define GEOFENCE_DATAPATH_SIZE   (10*1024)

#define WGS84_MAJA (6378137.00) // Semi-Major Axis [m]
#define PI           (3.1415926535898)

#define TRACKING_STATUS_CHANGE_THREASHOLD 3
typedef struct {
    int type; //MTK_GFC_COMMAND_T
    unsigned int length;
} mtk_geofence_msg;

typedef struct {
    bool geofence_support;
    int server_data_fd;
}mtk_geofence_server_init_msg;

typedef enum {
    GEOFENCE_SERVER_CAP,//geofence client capability
    EXCUTE_RESULT,
    GEOFENCE_NUM,
    GEOFENCE_RESPONSE_INFO,
    GEOFENCE_ALERT_INFO,
    GNSS_TRACKING_STATUS,
} mtk_geofence_ret_command;

typedef struct mtk_geofence_create_status {
    int createstat;//  success : 0,error : -1, insufficient_memory : -2, too many fences  : -3
    int id;
}mtk_geofence_create_status;

typedef struct {
    int cmdtype;//mtk_geofence_command
    int result; //  success : 0,error : -1
} mtk_geofence_result;

typedef struct {
    double latitude;
    double longitude;
    double radius;
    int latest_state; /*current state(mtk_geofence_status), most cases is GPS_GEOFENCE_UNCERTAIN*/
    int monitor_transition; /*bitwise or of  enter/exit*/
    int unknown_timer;/*continue positioning time limitied while positioning*/
    int last_transition;
} mtk_geofence_property_db;

typedef struct {
    mtk_geofence_property_db geofence_prop;
    bool is_used;
    int fd;
}mtk_geofence_db;

typedef struct
{
    UINT32 unknown_init_ttick;  //record the ttick of fence starting time
    int64_t unknown_elapsed_ttick;  //update the ttick elapsed time since the starting time
    int geofence_operating_mode; //[start, stop/ pause] = [0,1]
}geofence_new_alarm;

typedef struct {
    mtk_geofence_db geofence_property[MAX_GOEFENCE];
    geofence_new_alarm geofence_new_timer[MAX_GOEFENCE];
    int fence_number;
}mtk_geofence_ctx;

void mtk_geofence_init(void);
int mtk_geofence2mnl_hdlr (int fd, char *buff, int length);
int create_geofence2mnl_data_fd();
int create_geofence2mnl_control_fd();
int mtk_geofence2mnl_get_valid_fence_num();
void mtk_geofence_clear_fence(int fd) ;
int mtk_geofence_clear_geofences_by_msg(int fd);
int mtk_geofence_server_capability_send(int fd) ;
int mtk_geofence2mnl_geofence_tracking_status(int fd, int tracking_stat, mtk_geofence_position_info *pos);
void mtk_geofence_location_expire(mtk_geofence_position_info coordinate_loc);

#ifdef __cplusplus
}
#endif

#endif

