#include <string.h> //strstr
#include <dirent.h>
#include <sys/stat.h> //mkdir
#include <stdio.h>
#include <stdlib.h>
#include <errno.h>
#include <sys/time.h>
#include <time.h>
#include <stddef.h>  // offsetof
#include <stdarg.h>
#include <unistd.h>  // usleep
#include <sys/socket.h>
#include <fcntl.h>
#include <arpa/inet.h>  // inet_addr
#include <sys/un.h>  // struct sockaddr_un
#include <pthread.h>
#include <sys/epoll.h>
#include <signal.h>
#include <semaphore.h>
#include <signal.h> //struct sigevent
#include <string.h> //memset, strncpy
#include <netdb.h> //struct addrinfo
#include <sys/types.h> //gettid
#include <netinet/in.h> //struct sockaddr_in
#include <netinet/tcp.h> //TCP_KEEPIDLE, TCP_KEEPINTVL, TCP_KEEPCNT
#include <netinet/ip.h> //IPTOS_LOWDELAY
#include <sys/epoll.h> //epoll_create
#include <semaphore.h> //sem_t
#include <inttypes.h> //PRId64
#include <stdbool.h>
#include "geofence.h"
#include "mtk_geofence_main.h"
#include "mtk_geofence_controller.h"
#include "mtk_mnld_log.h"
#include "mtk_lbs_utility.h"

#define GEOFENCEADP_VERSION "2.02"

//---------------------------------- channel -------------------------------------------
client_list g_geofence_client_list;
client_list g_geofence_client_control_list;

gfc2mnl_interface* gfc2mnl_hdlr_cb;

static int mtk_geofence_hbd_open_gps()
{
    int ret;

    if (gfc2mnl_hdlr_cb != NULL && gfc2mnl_hdlr_cb->mnld_gfc_hbd_gps_open) {
        mtk_geofence_init();
        gfc2mnl_hdlr_cb->mnld_gfc_hbd_gps_open();
        ret = MTK_GFC_SUCCESS;
    } else {
        LOGE("gfc2mnl_hdlr() mnld_gfc_hbd_gps_open is NULL");
        ret = MTK_GFC_ERROR;
    }

    return ret;
}

static int mtk_geofence_hbd_close_gps()
{
    int ret;

    if (gfc2mnl_hdlr_cb != NULL && gfc2mnl_hdlr_cb->mnld_gfc_hbd_gps_close) {
        gfc2mnl_hdlr_cb->mnld_gfc_hbd_gps_close();
        ret = MTK_GFC_SUCCESS;
    } else {
        LOGE("gfc2mnl_hdlr() mnld_gfc_hbd_gps_open is NULL");
        ret = MTK_GFC_ERROR;
    }

    return ret;
}

void mtk_geofence_epoll_server_hdlr(int fd, int epfd) {
    int new_fd = socket_tcp_server_new_connect(fd);
    if(new_fd == -1) {
        LOGE("socket new client connection failure");
    } else {
        if(client_list_add(&g_geofence_client_list, new_fd)) {
            epoll_add_fd(epfd, new_fd);
            mtk_geofence_server_capability_send(new_fd);
            LOGW("socket new client connected fd=[%d] list num=[%d]", new_fd, g_geofence_client_list.num);
        } else {
            LOGE("mtk_geofence_epoll_server_hdlr() client num is reached to max");
            close(new_fd);
        }
    }
}

void mtk_geofence_epoll_control_server_hdlr(int fd, int epfd) {
    int new_fd = socket_tcp_server_new_connect(fd);
    if(new_fd == -1) {
        LOGE("socket new client connection failure");
    } else {
        if(client_list_add(&g_geofence_client_control_list, new_fd)) {
            epoll_add_fd(epfd, new_fd);
            LOGW("socket new client connected fd=[%d] list num=[%d]", new_fd, g_geofence_client_control_list.num);
        } else {
            LOGE("mtk_geofence_epoll_server_hdlr() client num is reached to max");
            close(new_fd);
        }
    }
}

void mtk_geofence_epoll_client_hdlr(int fd, gfc2mnl_interface* hdlr) {
    char buff[8192] = {0};
    int len = read(fd, buff, sizeof(buff));
    if(len == -1) {
        close(fd);
        mtk_geofence_clear_geofences_by_msg(fd);
        client_list_remove(&g_geofence_client_list, fd);
        LOGW("mtk_geofence_epoll_client_hdlr() read() fd=[%d] failed, reason=[%s]%d, list num=[%d]", fd, strerror(errno), errno, g_geofence_client_list.num);
    } else if(len == 0) {
        close(fd);
        mtk_geofence_clear_geofences_by_msg(fd);
        client_list_remove(&g_geofence_client_list, fd);
        LOGW("mtk_geofence_epoll_client_hdlr() read() fd=[%d] find the remote side has closed the session, list num=[%d]", fd, g_geofence_client_list.num);
    } else {
        //TCP packets are combined together, need to extract them
        //LOGD("fd:%d pkt_len:%d\r\n", fd, len);
        //if(hdlr != NULL) {
        //    gfc2mnl_hdlr_cb = hdlr;
        //} else {
        //    LOGE("gfc2mnl_hdlr_cb = NULL");
        //    return;
        //}
        //mtk_geofence2mnl_hdlr(fd, buff, len);
    }
}

void mtk_geofence_epoll_client_control_hdlr(int fd, gfc2mnl_interface* hdlr) {
    char buff[8192] = {0};
    int len = read(fd, buff, sizeof(buff));
    if(len == -1) {
        close(fd);
        client_list_remove(&g_geofence_client_control_list, fd);
        LOGW("mtk_geofence_epoll_client_control_hdlr() read() fd=[%d] failed, reason=[%s]%d, list num=[%d]", fd, strerror(errno), errno, g_geofence_client_list.num);
    } else if(len == 0) {
        close(fd);
        client_list_remove(&g_geofence_client_control_list, fd);
        LOGW("mtk_geofence_epoll_client_control_hdlr() read() fd=[%d] find the remote side has closed the session, list num=[%d]", fd, g_geofence_client_list.num);
    } else {
        if(hdlr != NULL) {
            gfc2mnl_hdlr_cb = hdlr;
        } else {
            LOGE("gfc2mnl_hdlr_cb = NULL");
            return;
        }
        mtk_geofence2mnl_hdlr(fd, buff, len);
    }
}

int mtk_geofence_gnss_state_process(mtk_geofence_msg *prmsg)
{
    int ret = MTK_GFC_SUCCESS;

    if(prmsg == NULL) {
        LOGE("mtk_geofence_gnss_state_process, recv prmsg is null pointer\r\n");
        return MTK_GFC_ERROR;
    }

    if (prmsg->type == ADD_GEOFENCE_AREA){
        if (mtk_geofence2mnl_get_valid_fence_num() == 0){
            ret = mtk_geofence_hbd_open_gps();
        }
    } else if (prmsg->type == REMOVE_GEOFENCE){
        if (mtk_geofence2mnl_get_valid_fence_num() == 0){
            ret = mtk_geofence_hbd_close_gps();
        }
    } else if (prmsg->type == CLEAR_GEOFENCE){
        if (mtk_geofence2mnl_get_valid_fence_num() == 0){
            ret = mtk_geofence_hbd_close_gps();
        }
    } else if (prmsg->type == QUERY_GEOFENCE_NUM){
        //Do nothing
    } else {
        LOGE("mtk_geofence_gnss_state_process, unknown action:%d\r\n", prmsg->type);
        ret = MTK_GFC_ERROR;
    }

    return ret;
}

int mtk_geofence_controller_process(mtk_geofence_msg *prmsg) {
    int ret;
    if(prmsg == NULL) {
        LOGE("mtk_gfc_controller_process, recv prmsg is null pointer\r\n");
        return MTK_GFC_ERROR;
    }

    ret = mtk_geofence_gnss_state_process(prmsg);
    return ret;
}


