#ifndef __GPS_CONTROLER_H__
#define __GPS_CONTROLER_H__

#include <stdbool.h>

#ifdef __cplusplus
extern "C" {
#endif

#define MNLD_VERSION "MTK_MNLD_6_0_0_20040301"
#define GNSS_NAME_LEN (255)

#define MNL_CFG_XML_DEFAULT_PATH                 MTK_GPS_DATA_DEFAULT_PATH
#define MNL_READ_WRITE_PATH                      MTK_GPS_DATA_PATH
#define MNLD_MGPSID              MGPSID
#define MNLD_MQZSSID             7
#define MNLD_MGLONID             24
#define MNLD_MBD2ID              63
#define MNLD_MGLEOID             36
#define MNLD_SBAS_BUN_PRN        19
#define MNLD_MNAVICID            14

#define BD2_GEO (0)
#define BD2_MEO_IGSO (1)
#define BD2_SVTYPE(SVID)  ((((SVID) >= 6) && ((SVID) <= 58)) ? BD2_MEO_IGSO : BD2_GEO)

#define SVTYPE_GPS      1
#define SVTYPE_GALILEO  4
#define SVTYPE_GLONASS  16
#define SVTYPE_BD       32

#define NUM_CH_ALL 159

int gps_control_init();

int gps_control_gps_start(int delete_aiding_data_flags);
int gps_control_gps_stop();
int gps_control_gps_reset(int delete_aiding_data_flags);
#if defined(GPS_SUSPEND_SUPPORT)
int gps_control_gps_suspend();
int gps_control_gps_suspend_to_close();
int gps_control_gps_suspend_to_close_by_rst();
#endif

void gps_control_kernel_wakelock_init();
void gps_control_kernel_wakelock_take();
void gps_control_kernel_wakelock_give();
void gps_control_kernel_wakelock_uninit();

int mnld_adc_capture_is_enabled(void);
#if defined(GPS_SUSPEND_SUPPORT)
void mnld_gps_suspend_check_capability(void);
bool mnld_gps_suspend_is_enabled();
int  mnld_gps_suspend_get_timeout_sec();
bool mnld_gps_suspend_ext_is_enabled();
bool mnld_gps_suspend_ext_is_available();
int  mnld_gps_suspend_ext_get_timeout_sec();
void mtk_gps_suspend_extention_available_set(INT32 available);
int  mnld_gps_suspend_done(void);
#endif
int mnl_init(void);
void linux_signal_handler(int signo);
int mnld_factory_test_entry(int argc, char** argv);
int linux_setup_signal_handler(void);

void gps_controller_rcv_pmtk(const char* pmtk);

void get_chip_sv_support_capability(unsigned char* sv_type);

#if ANDROID_MNLD_PROP_SUPPORT
int get_gps_cmcc_log_enabled();
#endif

void get_chip_gnss_op_mode(void);

bool mnld_timeout_ne_enabled(void);
void mnld_gps_update_name(void);

bool mnld_nfw_ctrl_nlp_enabled();
bool mnld_nfw_ctrl_gnss_enabled();

bool mtk_gps_support_l5_get();
void mtk_gps_support_l5_set(bool support_l5);

#ifdef __cplusplus
}
#endif

#endif


