#ifndef __MNL2HAL_EXT_INTERFACE_H__
#define __MNL2HAL_EXT_INTERFACE_H__

#include "hal_mnl_interface_common.h"

#ifdef __cplusplus
extern "C" {
#endif

#define DUMP_EXT_SERVER_CAP(pcap) do {\
    LOGD("[%s]:mnl_hal_ext_server_cap size:%lu, gnss_support=%d", __func__, sizeof(mnl_hal_ext_server_cap), (pcap)->support_gnss);\
} while(0)

#define DUMP_EXT_CLIENT_CAP(pcap) do {\
    LOGD("[%s]:mnl_hal_ext_client_cap size:%lu, gnss_support=%d", __func__, sizeof(mnl_hal_ext_client_cap), (pcap)->support_gnss);\
} while(0)

typedef struct {
    void (*gnss_inject_time)(int64_t time, int64_t time_reference, int uncertainty);
    void (*gnss_inject_location)(double lat, double lng, float acc);
    void (*gnss_delete_aiding_data)(int flags);
    void (*gnss_set_position_mode)(gps_pos_mode mode, gps_pos_recurrence recurrence,
    int min_interval, int preferred_acc, int preferred_time, bool lowPowerMode);

    void (*data_conn_open)(const char* apn);
    void (*data_conn_open_with_apn_ip_type)(uint64_t network_handle, const char* apn, apn_ip_type ip_type);
    void (*data_conn_closed)();
    void (*data_conn_failed)();

    void (*set_server)(agps_type type, const char* hostname, int port);
    void (*set_ref_location)(cell_type type, int mcc, int mnc, int lac, int cid);
    void (*set_id)(agps_id_type type, const char* setid);

    void (*ni_message)(const char* msg, int len);
    void (*ni_respond)(int notif_id, ni_user_response_type user_response);

    void (*update_network_state)(uint64_t networkHandle, bool isConnected,
            unsigned short capabilities, const char* apn);
    void (*update_network_availability)(int available, const char* apn);

    void (*set_gnss_full_tracking_enable)(bool enabled);
    void (*set_gnss_navigation_enable)(bool enabled);
    void (*set_vzw_debug)(bool enabled);
    void (*update_gnss_config)(const char* config_data, int length);
    void (*set_sv_blacklist)(long long* blacklist, int size);
    void (*set_correction)(measurement_corrections* corrections);
    void (*set_nfw_access)(char* proxyApps, int length);
    void (*send_pmtk)(char* msg, int len);
    void (*set_epo_enable)(epo_bitmap epo_cfg);
    void (*set_ttff_acc)(ttff_acc acc_mode);
    void (*client_capability_update)(int fd, mnl_hal_ext_client_cap *cap);
    
    void (*gnss_fix_interval)(uint32_t interval);
    void (*gnss_opmode)(uint8_t opmode);
    void (*gnss_elevation_angle)(uint8_t elevation);
    void (*gnss_l5_disable)(bool flag); 
} hal2mnl_ext_interface;

int mnl2hal_mnld_reboot();

int mnl2hal_gnss_navigation(gnss_nav_msg msg);

int mnl2hal_request_wakelock();
int mnl2hal_release_wakelock();

int mnl2hal_request_utc_time();

int mnl2hal_request_data_conn(struct sockaddr_storage addr, agps_type type);
int mnl2hal_release_data_conn(agps_type type);
int mnl2hal_request_ni_notify(int session_id, agps_ni_type ni_type, agps_notify_type type,
    const char* requestor_id, const char* client_name, ni_encoding_type requestor_id_encoding,
    ni_encoding_type client_name_encoding);
int mnl2hal_request_set_id(request_setid flags);
int mnl2hal_request_ref_loc(request_refloc flags);
int mnl2hal_vzw_debug_screen_output(const char* str);
int mnl2hal_update_gnss_name(const char* str, int len);
int mnl2hal_request_nlp(bool type, bool fgemergency);
int mnl2hal_agps_location(mnl_hal_agps_location *location);

// -1 means failure
void hal2mnl_ext_client_hdlr(int fd, hal2mnl_ext_interface* hdlr);

// -1 means failure
int create_hal2mnl_ext_fd();

int mnl2hal_nfw_notify(nfw_notification *nfw_notify);

void mnl_hal_ext_client_capability_query(int fd, mnl_hal_ext_client_cap *cap);
void mnl_hal_ext_server_capability_query(int fd, mnl_hal_ext_server_cap *cap);

#ifdef __cplusplus
}
#endif

#endif
