#include <errno.h>
#include <unistd.h>  // for close
#include <string.h>
#include <stdlib.h>
#include <fcntl.h>
#include <pthread.h>

#include "adc_capture.h"
#include "mtk_lbs_utility.h"
#include "mtk_gps_type.h"
#include "mtk_mnld_log.h"

extern UINT32 adc_emi_address;
extern int gps_emi_fd;

void *thread_adc_capture_init(void* arg) {
    int count;
    UNUSED(arg);
    LOGD("EMI ADC thread start\n");
    for (count = 1; count <= 10; count++) {
        gps_emi_fd = open("/dev/gps_emi", O_RDWR);
        if (gps_emi_fd == -1) {
            LOGW("open_port: Unable to open /dev/gps_emi, retry:%d\n", count);
            usleep(500*1000);
            continue;
        } else {
            LOGD("open gps_emi successfully\n");
            break;
        }
    }
    if (count >= 10) {
        LOGE("open gps_emi failed\n");
        return 0;
    }

    errno = 0;
    if (ioctl(gps_emi_fd, IOCTL_EMI_MEMORY_INIT, NULL) <= 0) {
        LOGE("set IOCTL_EMI_MEMORY_INIT failed,(%s)\n", strerror(errno));
    }
    errno = 0;
    if (ioctl(gps_emi_fd, IOCTL_ADC_CAPTURE_ADDR_GET, &adc_emi_address) < 0) {
        LOGE("set IOCTL_ADC_CAPTURE_ADDR_GET failed,(%s)\n", strerror(errno));
    }

    LOGD("ADC init successful and thread exit done, ADC emi address:(0x%08x)\n", adc_emi_address);
    pthread_exit(NULL);
    return 0;
}

void mnld_gps_emi_init(int type) {
    int ret = -1;
    pthread_t emi_download_thread;

    if (type == 1) {
        ret = pthread_create(&emi_download_thread, NULL, thread_adc_capture_init, NULL);
    }
    if (0 != ret) {
        LOGE("emi download thread create fail: %s\n", strerror(errno));
        exit(1);
    }
}
