#include "mnl2hal_interface.h"
#include "mtk_lbs_utility.h"
#include "data_coder.h"
#include "mpe.h"
#include "mnld.h"
#include "errno.h"
#include <inttypes.h> //PRId64

#include "gps_controller.h"
#include "mtk_mnld_log.h"

#ifdef LOG_TAG
#undef LOG_TAG
#endif

#define LOG_TAG "mnl2hal"

extern int mtk_gps_sys_strncmp(const char * str1,const char * str2);


char g_mnl_hal_basic_msg_buf[HAL_MNL_BUFF_SIZE*2] = {0};
cyclical_buffer_t g_mnl_hal_basic_cbuffer;    // io - cyclic buffer

char g_mnl_hal_ext_msg_buf[HAL_MNL_BUFF_SIZE*2] = {0};
cyclical_buffer_t g_mnl_hal_ext_cbuffer;    // io - cyclic buffer

client_list g_hal_basic_client_list;
client_list g_hal_ext_client_list;
measurement_corrections corrections;

void mnl_hal_basic_client_capability_query(int fd, mnl_hal_basic_client_cap *cap) {
    if(cap == NULL) {
        LOGE("NULL cap !!!!fd:%d", fd);
        return;
    }
    client_ctx * pclient;
    pclient = client_list_get_ctx_by_fd(&g_hal_basic_client_list, fd);
    if(pclient == NULL) {
        LOGE("Get basic context faild!!!!fd:%d", fd);
        return;
    }
    memcpy(cap, &(pclient->client_cap.basic_client_cap), sizeof(mnl_hal_basic_client_cap));
    DUMP_BASIC_CLIENT_CAP(cap);
}

void mnl_hal_basic_server_capability_query(int fd, mnl_hal_basic_server_cap *cap) {
    if(cap == NULL) {
        LOGE("NULL cap !!!!fd:%d", fd);
        return;
    }
    client_ctx * pclient;
    pclient = client_list_get_ctx_by_fd(&g_hal_basic_client_list, fd);
    if(pclient == NULL) {
        LOGE("Get basic context faild!!!!fd:%d", fd);
        return;
    }

    memcpy(cap, &(pclient->server_cap.basic_server_cap), sizeof(mnl_hal_basic_server_cap));
    DUMP_BASIC_SERVER_CAP(cap);
}

void mnl_hal_ext_client_capability_query(int fd, mnl_hal_ext_client_cap *cap) {
    if(cap == NULL) {
        LOGE("NULL cap !!!!fd:%d", fd);
        return;
    }
    client_ctx * pclient;
    pclient = client_list_get_ctx_by_fd(&g_hal_ext_client_list, fd);
    if(pclient == NULL) {
        LOGE("Get extension context faild!!!!fd:%d", fd);
        return;
    }
    memcpy(cap, &(pclient->client_cap.ext_client_cap), sizeof(mnl_hal_ext_client_cap));
    DUMP_EXT_CLIENT_CAP(cap);
}

void mnl_hal_ext_server_capability_query(int fd, mnl_hal_ext_server_cap *cap) {
    if(cap == NULL) {
        LOGE("NULL cap !!!!fd:%d", fd);
        return;
    }
    client_ctx * pclient;
    pclient = client_list_get_ctx_by_fd(&g_hal_ext_client_list, fd);
    if(pclient == NULL) {
        LOGE("Get extension context faild!!!!fd:%d", fd);
        return;
    }

    memcpy(cap, &(pclient->server_cap.ext_server_cap), sizeof(mnl_hal_ext_server_cap));
    DUMP_EXT_SERVER_CAP(cap);
}

//Tell client the support capability of mnld basic server interface
int mnl2hal_basic_server_capability_update(int fd) {
    LOGI("mnl2hal_basic_server_capability_update, fd:%d", fd);
    char buff[HAL_MNL_BUFF_SIZE] = {0};
    int offset = 0;
    client_ctx * pclient = client_list_get_ctx_by_fd(&g_hal_basic_client_list, fd);
    if(pclient == NULL) {
        LOGE("Get client context faild!!!!");
        return -1;
    }
    memset(&pclient->server_cap.basic_server_cap, 0, sizeof(mnl_hal_basic_server_cap));
    pclient->server_cap.basic_server_cap.support_gnss = 1;

    put_int(buff, &offset, HAL_MNL_INTERFACE_VERSION);
    put_int(buff, &offset, MNL2HAL_BASIC_CAP_SYNC);
    put_binary(buff, &offset, (char *)&pclient->server_cap.basic_server_cap, (int)sizeof(mnl_hal_basic_server_cap));
    return mnl2hal_basic_all(buff, offset);
}

//Tell client the support capability of mnld extension server interface
int mnl2hal_ext_server_capability_update(int fd) {
    LOGI("mnl2hal_ext_server_capability_update, fd:%d", fd);
    char buff[HAL_MNL_BUFF_SIZE] = {0};
    int offset = 0;
    client_ctx * pclient;
    pclient = client_list_get_ctx_by_fd(&g_hal_ext_client_list, fd);
    if(pclient == NULL) {
        LOGE("Get client context faild!!!!fd:%d", fd);
        return -1;
    }

    memset(&(pclient->server_cap.ext_server_cap), 0, sizeof(mnl_hal_ext_server_cap));
    pclient->server_cap.ext_server_cap.support_gnss = 1;
    put_int(buff, &offset, HAL_MNL_INTERFACE_VERSION);

    put_int(buff, &offset, MNL2HAL_EXT_CAP_SYNC);
    put_binary(buff, &offset, (char *)&(pclient->server_cap.ext_server_cap), (int)sizeof(mnl_hal_ext_server_cap));

    return mnl2hal_ext(buff, offset);
}

int mnl2hal_mnld_reboot() {
    LOGD("mnl2hal_mnld_reboot");
    char buff[HAL_MNL_BUFF_SIZE] = {0};
    int offset = 0;
    put_int(buff, &offset, HAL_MNL_INTERFACE_VERSION);

    put_int(buff, &offset, MNL2HAL_MNLD_REBOOT);

    return safe_sendto(MTK_MNL2HAL, buff, offset);
}

int mnl2hal_location(gps_location location) {
    //LOGD("mnl2hal_location");
    char buff[HAL_MNL_BUFF_SIZE] = {0};
    int offset = 0;
    put_int(buff, &offset, HAL_MNL_INTERFACE_VERSION);

    put_int(buff, &offset, MNL2HAL_LOCATION);
    put_binary(buff, &offset, (const char*)&location, sizeof(location));

    return mnl2hal_basic(buff, offset);
}

int mnl2hal_gnss_status(gps_status status) {
    LOGD("mnl2hal_gnss_status  status=%d", status);
    char buff[HAL_MNL_BUFF_SIZE] = {0};
    int offset = 0;
    put_int(buff, &offset, HAL_MNL_INTERFACE_VERSION);

    put_int(buff, &offset, MNL2HAL_GPS_STATUS);
    put_binary(buff, &offset, (const char*)&status, sizeof(status));

    return mnl2hal_basic(buff, offset);
}

int mnl2hal_gnss_status_one_client(gps_status status, int fd) {
    LOGD("mnl2hal_gnss_status  status=%d", status);
    char buff[HAL_MNL_BUFF_SIZE] = {0};
    int offset = 0;
    put_int(buff, &offset, HAL_MNL_INTERFACE_VERSION);

    put_int(buff, &offset, MNL2HAL_GPS_STATUS);
    put_binary(buff, &offset, (const char*)&status, sizeof(status));

    return socket_tcp_send(fd, buff, offset);
}

int mnl2hal_gnss_sv(gnss_sv_info *sv) {
    //LOGD("mnl2hal_gnss_sv  num=%d", sv->num_svs);
    char buff[HAL_MNL_BUFF_SIZE] = {0};
    int offset = 0;
    put_int(buff, &offset, HAL_MNL_INTERFACE_VERSION);

    put_int(buff, &offset, MNL2HAL_GPS_SV);
    put_binary(buff, &offset, (const char*)sv, sizeof(gnss_sv_info));

    return mnl2hal_basic(buff, offset);
}

int mnl2hal_nmea(int64_t timestamp, const char* nmea, int length) {
    #ifdef CONFIG_GPS_ENG_LOAD
    if ('$' == nmea[0] && (mtk_gps_sys_strncmp(&nmea[3],"RMC")==0)) {
        LOGD("timestamp=%"PRId64", len=%d, nmea=%s",timestamp, length, nmea);
    }
    #endif
    char buff[HAL_MNL_BUFF_SIZE] = {0};
    int offset = 0;
    put_int(buff, &offset, HAL_MNL_INTERFACE_VERSION);

    put_int(buff, &offset, MNL2HAL_NMEA);
    put_long(buff, &offset, timestamp);
    put_string(buff, &offset, nmea, sizeof(buff));
    put_int(buff, &offset, length);
    return mnl2hal_basic(buff, offset);
}

int mnl2hal_nmea_done(void) {
    char buff[HAL_MNL_BUFF_SIZE] = {0};
    int offset = 0;
    put_int(buff, &offset, HAL_MNL_INTERFACE_VERSION);

    put_int(buff, &offset, MNL2HAL_NMEA_DONE);
    LOGD("NMEA report done!");
    return mnl2hal_basic(buff, offset);
}

int mnl2hal_gnss_measurements(gnss_data *data) {
    LOGD_ENG("mnl2hal_gnss_measurements");
    char buff[HAL_MNL_BUFF_SIZE_SND] = {0};
    int offset = 0;

    put_int(buff, &offset, HAL_MNL_INTERFACE_VERSION);

    put_int(buff, &offset, MNL2HAL_GNSS_MEASUREMENTS);
    put_binary(buff, &offset, (const char*)data, sizeof(gnss_data));

    return mnl2hal_basic( buff, offset);
}

int mnl2hal_gnss_navigation(gnss_nav_msg msg) {
    LOGD_ENG("mnl2hal_gnss_navigation");
    char buff[HAL_MNL_BUFF_SIZE] = {0};
    int offset = 0;
    put_int(buff, &offset, HAL_MNL_INTERFACE_VERSION);

    put_int(buff, &offset, MNL2HAL_GNSS_NAVIGATION);
    put_binary(buff, &offset, (const char*)&msg, sizeof(msg));

    return mnl2hal_ext( buff, offset);
}


int mnl2hal_request_wakelock(int fd) {
    LOGD_ENG("mnl2hal_request_wakelock");
    char buff[HAL_MNL_BUFF_SIZE] = {0};
    int offset = 0;
    put_int(buff, &offset, HAL_MNL_INTERFACE_VERSION);

    put_int(buff, &offset, MNL2HAL_REQUEST_WAKELOCK);

    return mnl2hal_ext( buff, offset);
}

int mnl2hal_release_wakelock(int fd) {
    LOGD_ENG("mnl2hal_release_wakelock");
    char buff[HAL_MNL_BUFF_SIZE] = {0};
    int offset = 0;
    put_int(buff, &offset, HAL_MNL_INTERFACE_VERSION);

    put_int(buff, &offset, MNL2HAL_RELEASE_WAKELOCK);

    return mnl2hal_ext( buff, offset);
}

int mnl2hal_request_utc_time(int fd) {
    LOGD("mnl2hal_request_utc_time");
    char buff[HAL_MNL_BUFF_SIZE] = {0};
    int offset = 0;
    put_int(buff, &offset, HAL_MNL_INTERFACE_VERSION);

    put_int(buff, &offset, MNL2HAL_REQUEST_UTC_TIME);

    return mnl2hal_ext( buff, offset);
}

int mnl2hal_request_data_conn(struct sockaddr_storage addr, agps_type type) {
    LOGD("mnl2hal_request_data_conn");
    char buff[HAL_MNL_BUFF_SIZE] = {0};
    int offset = 0;
    put_int(buff, &offset, HAL_MNL_INTERFACE_VERSION);

    put_int(buff, &offset, MNL2HAL_REQUEST_DATA_CONN);
    put_binary(buff, &offset, (const char*)&addr, sizeof(addr));
    put_int(buff, &offset, type);

    return mnl2hal_ext( buff, offset);
}

int mnl2hal_release_data_conn(agps_type type) {
    LOGD("mnl2hal_release_data_conn");
    char buff[HAL_MNL_BUFF_SIZE] = {0};
    int offset = 0;
    put_int(buff, &offset, HAL_MNL_INTERFACE_VERSION);

    put_int(buff, &offset, MNL2HAL_RELEASE_DATA_CONN);
    put_int(buff, &offset, type);

    return mnl2hal_ext( buff, offset);
}

int mnl2hal_request_ni_notify(int session_id, agps_ni_type ni_type,
    agps_notify_type type, const char* requestor_id,
    const char* client_name, ni_encoding_type requestor_id_encoding,
    ni_encoding_type client_name_encoding) {
    LOGD("mnl2hal_request_ni_notify");
    char buff[HAL_MNL_BUFF_SIZE] = {0};
    int offset = 0;
    put_int(buff, &offset, HAL_MNL_INTERFACE_VERSION);

    put_int(buff, &offset, MNL2HAL_REQUEST_NI_NOTIFY);
    put_int(buff, &offset, session_id);
    put_int(buff, &offset, type);
    put_string(buff, &offset, requestor_id, sizeof(buff));
    put_string(buff, &offset, client_name, sizeof(buff));
    put_int(buff, &offset, requestor_id_encoding);
    put_int(buff, &offset, client_name_encoding);
    put_int(buff, &offset, ni_type);

    return mnl2hal_ext( buff, offset);
}

int mnl2hal_request_set_id(request_setid flags) {
    LOGD("mnl2hal_request_set_id  flag=0x%x", flags);
    char buff[HAL_MNL_BUFF_SIZE] = {0};
    int offset = 0;
    put_int(buff, &offset, HAL_MNL_INTERFACE_VERSION);

    put_int(buff, &offset, MNL2HAL_REQUEST_SET_ID);
    put_int(buff, &offset, flags);

    return mnl2hal_ext( buff, offset);
}

int mnl2hal_request_ref_loc(request_refloc flags) {
    LOGD("mnl2hal_request_ref_loc  flag=0x%x", flags);
    char buff[HAL_MNL_BUFF_SIZE] = {0};
    int offset = 0;
    put_int(buff, &offset, HAL_MNL_INTERFACE_VERSION);

    put_int(buff, &offset, MNL2HAL_REQUEST_REF_LOC);
    put_int(buff, &offset, flags);

    return mnl2hal_ext( buff, offset);
}

int mnl2hal_vzw_debug_screen_output(const char* str) {
    LOGD("mnl2hal_vzw_debug_screen_output, str=%s", str);
    char buff[HAL_MNL_BUFF_SIZE] = {0};
    int offset = 0;
    put_int(buff, &offset, HAL_MNL_INTERFACE_VERSION);

    put_int(buff, &offset, MNL2HAL_VZW_DEBUG_OUTPUT);
    put_string(buff, &offset, str, sizeof(buff));

    return mnl2hal_ext( buff, offset);
}

int mnl2hal_update_gnss_name(const char* str, int len) {
    LOGD("mnl2hal_update_gnss_name, str=%s, len=%d", str, len);
    char buff[HAL_MNL_BUFF_SIZE] = {0};
    int offset = 0;
    put_int(buff, &offset, HAL_MNL_INTERFACE_VERSION);

    put_int(buff, &offset, MNL2HAL_UPDATE_GNSS_NAME);
    put_int(buff, &offset, len);
    put_string(buff, &offset, str, sizeof(buff));

    return mnl2hal_ext( buff, offset);
}

int mnl2hal_request_nlp(bool type, bool fgemergency) {
    LOGD("mnl2hal_request_nlp, type=%d, flag=%d", type, fgemergency);
    char buff[HAL_MNL_BUFF_SIZE] = {0};
    int offset = 0;
    put_int(buff, &offset, HAL_MNL_INTERFACE_VERSION);

    put_int(buff, &offset, MNL2HAL_REQUEST_NLP);
    put_byte(buff, &offset, type);
    put_byte(buff, &offset, fgemergency);

    return mnl2hal_ext( buff, offset);
}

int mnl2hal_nfw_notify(nfw_notification *nfw_notify) {
    char buff[HAL_MNL_BUFF_SIZE] = {0};
    int offset = 0;

    if(mnld_show_icon_get() == 0) {
        LOGW("Stop to notify, AGPS forbit to show icon");
        return 0;
    }
    put_int(buff, &offset, HAL_MNL_INTERFACE_VERSION);

    put_int(buff, &offset, MNL2HAL_NFW_NOTIFY);
    put_binary(buff, &offset, (const char*)nfw_notify, sizeof(nfw_notification));

    return mnl2hal_ext( buff, offset);
}

int mnl2hal_agps_location(mnl_hal_agps_location *location) {
    //LOGD("mnl2hal_agps_location");
    char buff[HAL_MNL_BUFF_SIZE] = {0};
    int offset = 0;
    put_int(buff, &offset, HAL_MNL_INTERFACE_VERSION);

    put_int(buff, &offset, MNL2HAL_AGPS_LOCATION);
    put_binary(buff, &offset, (const char*)location, sizeof(mnl_hal_agps_location));

    return mnl2hal_ext(buff, offset);
}

// -1 means failure
int create_hal2mnl_basic_fd() {
    int fd = socket_tcp_server_bind_local_force(true, MTK_HAL2MNL_BASIC_SERVER);
    if(fd != -1) {
        socket_set_blocking(fd, 0);  //Set as non-blocking
    }
    mnld_buffer_initialize(&g_mnl_hal_basic_cbuffer, g_mnl_hal_basic_msg_buf, sizeof(g_mnl_hal_basic_msg_buf));
    memset(&g_hal_basic_client_list, 0, sizeof(g_hal_basic_client_list));
    return fd;
}

// -1 means failure
int create_hal2mnl_ext_fd() {
    int fd = socket_tcp_server_bind_local_force(true, MTK_HAL2MNL_EXT_SERVER);
    if(fd != -1) {
        socket_set_blocking(fd, 0);  //Set as non-blocking
    }
    mnld_buffer_initialize(&g_mnl_hal_ext_cbuffer, g_mnl_hal_ext_msg_buf, sizeof(g_mnl_hal_ext_msg_buf));
    memset(&g_hal_ext_client_list, 0, sizeof(g_hal_ext_client_list));
    return fd;
}

void hal2mnl_basic_server_hdlr(int fd, int epfd) {
    int new_fd = socket_tcp_server_new_connect(fd);
    if(new_fd == -1) {
        LOGE("socket basic new client connection failure");
    } else {
        socket_set_blocking(new_fd, 0);  //Set as non-blocking
        if(client_list_add(&g_hal_basic_client_list, new_fd)) {
            epoll_add_fd(epfd, new_fd);
            if(mnl2hal_basic_server_capability_update(new_fd) == -1) {  //Sync mnld basic interface's capability to server
                LOGE("mnl2hal_basic_server_capability_update fail!!!");
            }
            LOGW("socket new client connected fd=[%d] list num=[%d]", new_fd, g_hal_basic_client_list.num);
        } else {
            LOGE("gnssadp_epoll_at_server_hdlr() client num is reached to max");
            close(new_fd);
        }
    }
}

void hal2mnl_ext_server_hdlr(int fd, int epfd) {
    int new_fd = socket_tcp_server_new_connect(fd);
    if(new_fd == -1) {
        LOGE("socket ext new client connection failure");
    } else {
        socket_set_blocking(new_fd, 0);  //Set as non-blocking
        if(g_hal_basic_client_list.num > 0) {  //Connect to extension interface, only when have basic client connection
            if(client_list_add(&g_hal_ext_client_list, new_fd)) {
                epoll_add_fd(epfd, new_fd);
                mnld_gps_update_name();
                if(mnl2hal_ext_server_capability_update(new_fd) == -1) {  //Sync mnld extension interface's capability to server
                    LOGW("mnl_hal_ext_cap_sync fail!!!");
                }
                LOGD("new externsion client connected, fd=[%d] ext num=[%d], basic num=[%d]"
                    , new_fd, g_hal_ext_client_list.num, g_hal_basic_client_list.num);
                return;  //Return directly, when add client successfully
            }
        }
        LOGE("Can't connect to externsion client, fd=[%d] ext num=[%d], basic num=[%d]"
            , new_fd, g_hal_ext_client_list.num, g_hal_basic_client_list.num);
        close(new_fd);
    }
    return;
}

void hal2mnl_basic_client_hdlr(int fd, hal2mnl_basic_interface* hdlr) {
    char buff[HAL_MNL_BUFF_SIZE] = {0};
    char buff_read[HAL_MNL_BUFF_SIZE] = {0};
    int offset = 0;
    int ver;
    hal2mnl_cmd cmd;
    int read_len = 0;
    int ret = 0;
    int msg_len = 0;
    int ret_len = 0;

    read_len = read(fd, buff_read, sizeof(buff));
    if (read_len <= 0) {  //Client Closed
        hal_gnss_stop(fd);
        hal_gnss_cleanup(fd);
        hal_raw_meas_gps_stop(fd);
        client_list_remove(&g_hal_basic_client_list, fd);
        close(fd);
        LOGE("hal2mnl_basic_client_hdlr() safe_recvfrom() failed read_len=%d, client num:%d, %s", read_len, g_hal_basic_client_list.num, strerror(errno));
        return;
    }

    mnld_put_msg_to_cycle(&g_mnl_hal_basic_cbuffer, buff_read, read_len);

    while((ret_len = mnld_get_one_msg(&g_mnl_hal_basic_cbuffer, buff)) > 0) {
        offset = 0;
        msg_len = get_int(buff, &offset, sizeof(buff));  //Get message length
        LOGD("msg len:%d, get len:%d, fd:%d", msg_len, ret_len, fd);
        for(int i=0;i<ret_len;i++) {
            LOGD(" 0x%x", buff[i]);
        }
        LOGD("=========================");
        ver = get_int(buff, &offset, sizeof(buff));
        UNUSED(ver);
        cmd = get_int(buff, &offset, sizeof(buff));
        switch (cmd) {

        case HAL2MNL_GPS_INIT: {
            if (hdlr->gnss_init) {
                hdlr->gnss_init(fd);
            } else {
                LOGE("hal2mnl_basic_hdlr() gnss_init is NULL");
                ret = -1;
            }
            break;
        }
        case HAL2MNL_GPS_START: {
            if (hdlr->gnss_start) {
                hdlr->gnss_start(fd);
            } else {
                LOGE("hal2mnl_basic_hdlr() gnss_start is NULL");
                ret = -1;
            }
            break;
        }
        case HAL2MNL_GPS_STOP: {
            if (hdlr->gnss_stop) {
                hdlr->gnss_stop(fd);
            } else {
                LOGE("hal2mnl_basic_hdlr() gnss_stop is NULL");
                ret = -1;
            }
            break;
        }
        case HAL2MNL_GPS_CLEANUP: {
            if (hdlr->gnss_cleanup) {
                hdlr->gnss_cleanup(fd);
            } else {
                LOGE("hal2mnl_basic_hdlr() gnss_cleanup is NULL");
                ret = -1;
            }
            break;
        }
        case HAL2MNL_GPS_MEASUREMENT: {
            if (hdlr->set_measurement_enable) {
                bool enabled = get_int(buff, &offset, sizeof(buff));
                hdlr->set_measurement_enable(enabled, fd);
            } else {
                LOGE("hal2mnl_basic_hdlr() set_measurement_enable is NULL");
                ret = -1;
            }
            break;
        }
        case HAL2MNL_BASIC_CAP_SYNC: {
            if(hdlr->client_capability_update) {
                mnl_hal_basic_client_cap cap;
                memset(&cap, 0, sizeof(cap));
                get_binary(buff, &offset, (char *)&cap, sizeof(buff), sizeof(cap));
                hdlr->client_capability_update(fd, &cap);
            } else {
                LOGE("hal2mnl_basic_hdlr() client_capability_update is NULL");
                ret = -1;
            }
            break;
        }
        default: {
            LOGE("hal2mnl_basic_hdlr() unknown cmd=%d", cmd);
            ret = -1;
            break;
        }
        }
    }
    UNUSED(ret);
}

void hal2mnl_ext_client_hdlr(int fd, hal2mnl_ext_interface* hdlr) {
    char buff[HAL_MNL_BUFF_SIZE] = {0};
    char buff_read[HAL_MNL_BUFF_SIZE] = {0};
    int offset = 0;
    int ver;
    hal2mnl_cmd cmd;
    int read_len;
    int ret = 0;
    int ret_len = 0;
    int msg_len = 0;

    read_len = safe_recvfrom(fd, buff_read, sizeof(buff));
    if (read_len <= 0) {
        close(fd);
        client_list_remove(&g_hal_ext_client_list, fd);
        LOGE("hal2mnl_ext_client_hdlr() safe_recvfrom() failed read_len=%d, %s", read_len, strerror(errno));
        return;
    }

    mnld_put_msg_to_cycle(&g_mnl_hal_ext_cbuffer, buff_read, read_len);

    while((ret_len = mnld_get_one_msg(&g_mnl_hal_ext_cbuffer, buff)) > 0) {
        offset = 0;
        msg_len = get_int(buff, &offset, sizeof(buff));  //Get message length
        UNUSED(msg_len);
        ver = get_int(buff, &offset, sizeof(buff));
        UNUSED(ver);
        cmd = get_int(buff, &offset, sizeof(buff));
        LOGD("msg len:%d, get len:%d, fd:%d", msg_len, ret_len, fd);
        for(int i=0;i<ret_len;i++) {
            LOGD(" 0x%x", buff[i]);
        }
        LOGD("=========================");
        switch (cmd) {
        case HAL2MNL_GPS_INJECT_TIME: {
            if (hdlr->gnss_inject_time) {
                int64_t time = get_long(buff, &offset, sizeof(buff));
                int64_t time_reference = get_long(buff, &offset, sizeof(buff));
                int uncertainty = get_int(buff, &offset, sizeof(buff));
                hdlr->gnss_inject_time(time, time_reference, uncertainty);
            } else {
                LOGE("hal2mnl_ext_hdlr() gnss_inject_time is NULL");
                ret = -1;
            }
            break;
        }
        case HAL2MNL_GPS_INJECT_LOCATION: {
            if (hdlr->gnss_inject_location) {
                double lat = get_double(buff, &offset, sizeof(buff));
                double lng = get_double(buff, &offset, sizeof(buff));
                float acc = get_float(buff, &offset, sizeof(buff));
                hdlr->gnss_inject_location(lat, lng, acc);
            } else {
                LOGE("hal2mnl_ext_hdlr() gnss_inject_location is NULL");
                ret = -1;
            }
            break;
        }
        case HAL2MNL_GPS_DELETE_AIDING_DATA: {
            if (hdlr->gnss_delete_aiding_data) {
                int flags = get_int(buff, &offset, sizeof(buff));
                hdlr->gnss_delete_aiding_data(flags);
            } else {
                LOGE("hal2mnl_ext_hdlr() gnss_delete_aiding_data is NULL");
                ret = -1;
            }
            break;
        }
        case HAL2MNL_GPS_SET_POSITION_MODE: {
            if (hdlr->gnss_set_position_mode) {
                gps_pos_mode mode = get_int(buff, &offset, sizeof(buff));
                gps_pos_recurrence recurrence = get_int(buff, &offset, sizeof(buff));
                int min_interval = get_int(buff, &offset, sizeof(buff));
                int preferred_acc = get_int(buff, &offset, sizeof(buff));
                int preferred_time = get_int(buff, &offset, sizeof(buff));
                bool lowPowerMode = get_byte(buff, &offset, sizeof(buff));
                hdlr->gnss_set_position_mode(mode, recurrence, min_interval,
                    preferred_acc, preferred_time, lowPowerMode);
            } else {
                LOGE("hal2mnl_ext_hdlr() gnss_set_position_mode is NULL");
                ret = -1;
            }
            break;
        }
        case HAL2MNL_GPS_FIX_INTERVAL: {
            if (hdlr->gnss_fix_interval) {
                uint32_t interval = get_int(buff, &offset, sizeof(buff));
                hdlr->gnss_fix_interval(interval);
            } else {
                LOGE("hal2mnl_ext_hdlr() gnss_fix_interval is NULL");
                ret = -1;
            }
            break;
        }
        case HAL2MNL_GPS_OPMODE: {
            if (hdlr->gnss_opmode) {
                uint8_t opmode = get_byte(buff, &offset, sizeof(buff));
                hdlr->gnss_opmode(opmode);
            } else {
                LOGE("hal2mnl_ext_hdlr() gnss_opmode is NULL");
                ret = -1;
            }
            break;
        }
        case HAL2MNL_GPS_ELEVATION_ANGLE: {
            if (hdlr->gnss_elevation_angle) {
                uint8_t elevation = get_byte(buff, &offset, sizeof(buff));
                hdlr->gnss_elevation_angle(elevation);
            } else {
                LOGE("hal2mnl_ext_hdlr() gnss_elevation_angle is NULL");
                ret = -1;
            }
            break;
        }
        case HAL2MNL_GPS_L5_DISABLE: {
            if (hdlr->gnss_l5_disable) {
                bool flag = get_byte(buff, &offset, sizeof(buff));
                hdlr->gnss_l5_disable(flag);
            } else {
                LOGE("hal2mnl_ext_hdlr() gnss_l5_disable is NULL");
                ret = -1;
            }
            break;
        }
        case HAL2MNL_DATA_CONN_OPEN: {
            if (hdlr->data_conn_open) {
                char* apn = get_string(buff, &offset, sizeof(buff));
                hdlr->data_conn_open(apn);
            } else {
                LOGE("hal2mnl_ext_hdlr() data_conn_open is NULL");
                ret = -1;
            }
            break;
        }
        case HAL2MNL_DATA_CONN_OPEN_WITH_APN_IP_TYPE: {
            if (hdlr->data_conn_open_with_apn_ip_type) {
                uint64_t network_handle = get_long(buff, &offset, sizeof(buff));
                char* apn = get_string(buff, &offset, sizeof(buff));
                apn_ip_type ip_type = get_int(buff, &offset, sizeof(buff));
                hdlr->data_conn_open_with_apn_ip_type(network_handle, apn, ip_type);
            } else {
                LOGE("hal2mnl_ext_hdlr() data_conn_open_with_apn_ip_type is NULL");
                ret = -1;
            }
            break;
        }
        case HAL2MNL_DATA_CONN_CLOSED: {
            if (hdlr->data_conn_closed) {
                hdlr->data_conn_closed();
            } else {
                LOGE("hal2mnl_ext_hdlr() data_conn_closed is NULL");
                ret = -1;
            }
            break;
        }
        case HAL2MNL_DATA_CONN_FAILED: {
            if (hdlr->data_conn_failed) {
                hdlr->data_conn_failed();
            } else {
                LOGE("hal2mnl_ext_hdlr() data_conn_failed is NULL");
                ret = -1;
            }
            break;
        }
        case HAL2MNL_SET_SERVER: {
            if (hdlr->set_server) {
                agps_type type = get_int(buff, &offset, sizeof(buff));
                char* hostname = get_string(buff, &offset, sizeof(buff));
                int port = get_int(buff, &offset, sizeof(buff));
                hdlr->set_server(type, hostname, port);
            } else {
                LOGE("hal2mnl_ext_hdlr() set_server is NULL");
                ret = -1;
            }
            break;
        }
        case HAL2MNL_SET_REF_LOCATION: {
            if (hdlr->set_ref_location) {
                cell_type type = get_int(buff, &offset, sizeof(buff));
                int mcc = get_int(buff, &offset, sizeof(buff));
                int mnc = get_int(buff, &offset, sizeof(buff));
                int lac = get_int(buff, &offset, sizeof(buff));
                int cid = get_int(buff, &offset, sizeof(buff));
                hdlr->set_ref_location(type, mcc, mnc, lac, cid);
            } else {
                LOGE("hal2mnl_ext_hdlr() set_ref_location is NULL");
                ret = -1;
            }
            break;
        }
        case HAL2MNL_SET_ID: {
            if (hdlr->set_id) {
                agps_id_type type = get_int(buff, &offset, sizeof(buff));
                char* setid = get_string(buff, &offset, sizeof(buff));
                hdlr->set_id(type, setid);
            } else {
                LOGE("hal2mnl_ext_hdlr() set_id is NULL");
                ret = -1;
            }
            break;
        }
        case HAL2MNL_NI_MESSAGE: {
            if (hdlr->ni_message) {
                char msg[1024] = {0};
                int len = get_binary(buff, &offset, msg, sizeof(buff), sizeof(msg));
                hdlr->ni_message(msg, len);
            } else {
                LOGE("hal2mnl_ext_hdlr() ni_message is NULL");
                ret = -1;
            }
            break;
        }
        case HAL2MNL_NI_RESPOND: {
            if (hdlr->ni_respond) {
                int notif_id = get_int(buff, &offset, sizeof(buff));
                ni_user_response_type user_response  = get_int(buff, &offset, sizeof(buff));
                hdlr->ni_respond(notif_id, user_response);
            } else {
                LOGE("hal2mnl_ext_hdlr() ni_respond is NULL");
                ret = -1;
            }
            break;
        }
        case HAL2MNL_UPDATE_NETWORK_STATE: {
            if (hdlr->update_network_state) {
                uint64_t network_handle = get_long(buff, &offset, sizeof(buff));
                bool is_connected = get_byte(buff, &offset, sizeof(buff));
                unsigned short capabilities  = get_short(buff, &offset, sizeof(buff));
                char* apn = get_string(buff, &offset, sizeof(buff));
                //hdlr->update_network_state(connected, type, roaming, extra_info);  //Before HIDL 2.0
                LOGD("hal2mnl_ext_hdlr() network_state  network_handle=%"PRId64" is_connected=%d capabilities=%d apn=%s",
                     network_handle, is_connected, capabilities, apn);
                hdlr->update_network_state(network_handle, is_connected, capabilities, apn);
            } else {
                LOGE("hal2mnl_ext_hdlr() update_network_state is NULL");
                ret = -1;
            }
            break;
        }
        case HAL2MNL_UPDATE_NETWORK_AVAILABILITY: {
            if (hdlr->update_network_availability) {
                int available = get_int(buff, &offset, sizeof(buff));
                char* apn = get_string(buff, &offset, sizeof(buff));
                hdlr->update_network_availability(available, apn);
            } else {
                LOGE("hal2mnl_ext_hdlr() update_network_availability is NULL");
                ret = -1;
            }
            break;
        }
        case HAL2MNL_FULL_TRACKING: {
            if (hdlr->set_gnss_full_tracking_enable) {
                bool enabled = get_int(buff, &offset, sizeof(buff));
                hdlr->set_gnss_full_tracking_enable(enabled);
            } else {
                LOGE("hal2mnl_ext_hdlr() set_gnss_full_tracking_enable is NULL");
                ret = -1;
            }
            break;
        }
        case HAL2MNL_GPS_NAVIGATION: {
            if (hdlr->set_gnss_navigation_enable) {
                bool enabled = get_int(buff, &offset, sizeof(buff));
                hdlr->set_gnss_navigation_enable(enabled);
            } else {
                LOGE("hal2mnl_ext_hdlr() set_gnss_navigation_enable is NULL");
                ret = -1;
            }
            break;
        }
        case HAL2MNL_VZW_DEBUG: {
            if (hdlr->set_vzw_debug) {
                bool enabled = get_int(buff, &offset, sizeof(buff));
                hdlr->set_vzw_debug(enabled);
            } else {
                LOGE("hal2mnl_ext_hdlr() set_vzw_debug is NULL");
                ret = -1;
            }
            break;
        }
        case HAL2MNL_GNSS_CONFIG: {
            if (hdlr->update_gnss_config) {
                int length = get_int(buff, &offset, sizeof(buff));
                char* config_data = get_string(buff, &offset, sizeof(buff));
                hdlr->update_gnss_config(config_data, length);
            } else {
                LOGE("hal2mnl_ext_hdlr() update_gnss_config is NULL");
                ret = -1;
            }
            break;
        }
        case HAL2MNL_SV_BLACKLIST: {
            if (hdlr->set_sv_blacklist) {
                long long blacklist[8];
                memset(blacklist, 0x00, sizeof(long long));
                int size = get_int(buff, &offset, sizeof(buff));
                size = size < 8 ? size : 8;
                get_binary(buff, &offset, (char*)blacklist, sizeof(buff),
                        sizeof(long long) * size);
                hdlr->set_sv_blacklist(blacklist, size);
            } else {
                LOGE("hal2mnl_ext_hdlr() set_sv_blacklist is NULL");
                ret = -1;
            }
            break;
        }
        case HAL2MNL_CORRECTION: {
            if (hdlr->set_correction) {
                memset(&corrections, 0x00, sizeof(corrections));
                get_binary(buff, &offset, (char*)&corrections, sizeof(buff), sizeof(measurement_corrections));
                hdlr->set_correction(&corrections);
            } else {
                LOGE("hal2mnl_ext_hdlr() set_correction is NULL");
                ret = -1;
            }
            break;
        }
        case HAL2MNL_NFW_ACCESS: {
            if (hdlr->set_nfw_access) {
                int length = get_int(buff, &offset, sizeof(buff));
                char* proxyApps = get_string(buff, &offset, sizeof(buff));
                hdlr->set_nfw_access(proxyApps, length);
            } else {
                LOGE("hal2mnl_ext_hdlr() nfw_access is NULL");
                ret = -1;
            }
            break;
        }
        case HAL2MNL_SEND_PMTK: {
            if (hdlr->send_pmtk) {
                char pmtk[256];
                get_binary(buff, &offset, pmtk, sizeof(buff), sizeof(pmtk));
                hdlr->send_pmtk(pmtk, offset);
            } else {
                LOGE("hal2mnl_ext_hdlr() send_pmtk is NULL");
                ret = -1;
            }
            break;
        }
        case HAL2MNL_EPO_ENABLE: {
            if (hdlr->set_epo_enable) {
                epo_bitmap epo_cfg = get_int(buff, &offset, sizeof(buff));
                hdlr->set_epo_enable(epo_cfg);
            } else {
                LOGE("hal2mnl_ext_hdlr() set_epo_enable is NULL");
                ret = -1;
            }
            break;
        }
        case HAL2MNL_SET_TTFF_ACC: {
            if (hdlr->set_ttff_acc) {
                ttff_acc acc_mode = get_int(buff, &offset, sizeof(buff));
                hdlr->set_ttff_acc(acc_mode);
            } else {
                LOGE("hal2mnl_ext_hdlr() set_ttff_acc is NULL");
                ret = -1;
            }
            break;
        }
        case HAL2MNL_EXT_CAP_SYNC: {
            if(hdlr->client_capability_update) {
                mnl_hal_ext_client_cap cap;
                memset(&cap, 0, sizeof(cap));
                get_binary(buff, &offset, (char *)&cap, sizeof(buff), sizeof(cap));
                hdlr->client_capability_update(fd, &cap);
            } else {
                LOGE("hal2mnl_ext_hdlr() client_capability_update is NULL");
                ret = -1;
            }
            break;
        }
        default: {
            LOGE("hal2mnl_ext_hdlr() unknown cmd=%d", cmd);
            ret = -1;
            break;
        }
        }
    }
    UNUSED(ret);
}
