#ifndef __MTK_LBS_UTILITY_H__
#define __MTK_LBS_UTILITY_H__

#include <time.h>
#include <sys/time.h>
#include <stdint.h>
#include <pthread.h>
#include <unistd.h>
#include <stdbool.h>   /* Standard bool true/false definitions */

#include "gnss_atci_log.h"

#ifdef __cplusplus
extern "C" {
#endif

/*************************************************
* Basic Utilities
**************************************************/
#ifndef UNUSED
#define UNUSED(x) (x)=(x)
#endif

#define DUMP_BYTES_PER_LINE 16
#define DUMP_MAX_PRINT_LINE 10

#define GPSLOG_DUMP_MEM(addr, len) do{\
    int i = 0, j = 0;\
    char print_buf[DUMP_BYTES_PER_LINE*5+1] = {0};\
    unsigned int print_len = len;\
    if(len > DUMP_MAX_PRINT_LINE*DUMP_BYTES_PER_LINE) {\
        print_len = DUMP_MAX_PRINT_LINE*DUMP_BYTES_PER_LINE;\
    }\
    LOGD(">>>>>DUMP_START(addr:%p, len:%d, print_len:%ud)<<<<<", addr, len,print_len);\
    for(i = 0; i < print_len; i+=DUMP_BYTES_PER_LINE) {\
        memset(print_buf, 0, sizeof(print_buf));\
        for(j=0;j<DUMP_BYTES_PER_LINE;j++) {\
            sprintf(&print_buf[j*5], "0x%02x ", ((char *)addr)[i*DUMP_BYTES_PER_LINE+j]);\
            print_buf[DUMP_BYTES_PER_LINE*5] = '\0';\
        }\
        LOGD("[%3d]:%s", i/DUMP_BYTES_PER_LINE, print_buf);\
    }\
    LOGD("<<<<<DUMP_STOP>>>>>");\
}while(0)


#define MNLD_STRNCPY(dst,src,size) do{\
                                       strncpy((char *)(dst), (src), (size - 1));\
                                      (dst)[size - 1] = '\0';\
                                     }while(0)

// -1 means failure
int gnss_atci_block_here();

//exit block_here() and process will exit and restart
void gnss_atci_block_exit(void);

/*************************************************
* Epoll
**************************************************/
// -1 means failure
int gnss_atci_epoll_add_fd(int epfd, int fd);


/*************************************************
* string operation
**************************************************/
char *safe_strncpy(char *dest, const char *src, size_t n);

#ifdef __cplusplus
}
#endif

#endif
