#include<pthread.h>
#include<stdio.h>
#include<unistd.h>
#include<errno.h>
#include<string.h>
#include<inttypes.h>
#include <time.h>

#include"mnld_test.h"
#include"mtk_lbs_utility.h"
#include "mnldinf_log.h"
#include "include/lynq_systime.h"
#include "include/lynq_uci.h"

extern struct timespec mnld_test_gnss_open_tm;
extern int mnld_test_ttff;
extern int mnld_test_session_end;
GpsLocation_ext location_rslt;
mnld_test_result mnld_test_result_body;
extern char mnld_test_mnl_ver[MNL_VER_LEN];
extern int raw_dbg;

#define MNLD_TEST_CB_DBG 0

#if MNLD_TEST_CB_DBG
#define CB_DBG LOGD
#else
//empty
#define CB_DBG(...) do {} while(0)
#endif
void mnld_test_gps_location_callback(GpsLocation_ext* location)
{
    if(location->legacyLocation.size == sizeof(GpsLocation_ext))
    {
        CB_DBG("===============Update Location Info==================");
        CB_DBG("flags:0x%x", location->legacyLocation.flags);
        CB_DBG("latitude:%.10lf", location->legacyLocation.latitude);
        CB_DBG("longitude:%.10lf", location->legacyLocation.longitude);
        CB_DBG("altitude:%.10lf", location->legacyLocation.altitude);
        CB_DBG("speed:%f", location->legacyLocation.speed);
        CB_DBG("bearing:%f", location->legacyLocation.bearing);
        CB_DBG("timestamp:%ld", location->legacyLocation.timestamp);
        CB_DBG("horizontalAccuracyMeters:%f", location->horizontalAccuracyMeters);
        CB_DBG("verticalAccuracyMeters:%f", location->verticalAccuracyMeters);
        CB_DBG("speedAccuracyMetersPerSecond:%f", location->speedAccuracyMetersPerSecond);
        CB_DBG("bearingAccuracyDegrees:%f", location->bearingAccuracyDegrees);
        memset(&(mnld_test_result_body.location), 0, sizeof(GpsLocation_ext));
        memcpy(&(mnld_test_result_body.location), location, sizeof(GpsLocation_ext));
    }else {
        LOGE("GpsLocation_ext size is wrong");
    }
}

void mnld_test_gps_status_callback(GpsStatus* status)
{
    if(status->size == sizeof(GpsStatus))
    {
        CB_DBG("GPS Status:%d", status->status);
        if(status->status == GPS_STATUS_SESSION_BEGIN)
        {
            mnld_test_ttff = 0;
            mnld_test_session_end = 0;
//          usleep(500000);
            mnld_test_get_mnl_ver();
        #ifdef MNLD_TEST_TTFF_SESSION_BEGIN
            if(clock_gettime(CLOCK_BOOTTIME,&mnld_test_gnss_open_tm) == -1)
            {
                LOGE("Fail to get time(%s).", strerror(errno));
            }
        #endif
        }

        if(status->status == GPS_STATUS_SESSION_END)
        {
            mnld_test_session_end = 1;
        }
    }else{
        LOGE("size error!");
    }
}

void mnld_test_gps_sv_status_callback(GpsSvStatus* sv_info)
{
    CB_DBG("gps sv status");
}

#define NMEA_GGA "GGA"
#define NMEA_GSA "GSA"
#define NMEA_ACC "ACCURACY"
extern int valid_ttff_cnt;
extern int valid_ttff_sum;

#if 0
int gnss_set_time_flag=0;

int update_gnss_time(GpsUtcTime sec)  
{  
	time_t t;  
	t = sec/1000; 
	stime(&t);
	return 0;  
} 
#endif

void mnld_test_gps_nmea_callback(GpsUtcTime timestamp, const char* nmea, int length)
{
#if 0
	char gnss_sync_enable[24] = "";
	CB_DBG("NMEA report at %ld",timestamp);
	lynq_get_value("lynq_uci", "lynq_sync_time", "lynq_gnss_sync_time_enable" , gnss_sync_enable);
	if (1 == atoi(gnss_sync_enable)) {
		if ((mnld_test_result_body.fix_type == 3)  && (gnss_set_time_flag == 0)) {
			update_gnss_time(timestamp);
			gnss_set_time_flag = 1 ;
		}
	}
#endif
    //$GPGSA,A,3,...
    if( strncmp(nmea+3,NMEA_GSA,strlen(NMEA_GSA)) == 0 )
    {
        mnld_test_result_body.fix_type = *(nmea+9) - '0';
        if(mnld_test_result_body.fix_type == 1)
        {
            mnld_test_result_body.fix_type = 0;
        }

        if((mnld_test_ttff == 0) && mnld_test_result_body.fix_type != 0)
        {
            struct timespec fix_tm;

            if(clock_gettime(CLOCK_BOOTTIME,&fix_tm) == -1)
            {
                mnld_test_result_body.ttff[CURR] = 0;
                LOGE("[%s]Fail to get time(%s)\r\n",__func__,strerror(errno));
            }else{
               // CB_DBG("Flags:0x%x,start time:%ds,%dns; ttff time:%ds,%dns\r\n",mnld_test_result_body.location.flags,mnld_test_gnss_open_tm.tv_sec,mnld_test_gnss_open_tm.tv_nsec,fix_tm.tv_sec,fix_tm.tv_nsec);
                mnld_test_ttff = (fix_tm.tv_sec-mnld_test_gnss_open_tm.tv_sec)*1000+((fix_tm.tv_nsec-mnld_test_gnss_open_tm.tv_nsec)/1000000);
                mnld_test_result_body.ttff[CURR] = mnld_test_ttff;
                valid_ttff_cnt++;
                valid_ttff_sum+=mnld_test_result_body.ttff[CURR];

                mnld_test_result_body.ttff[MEAN] = valid_ttff_sum/valid_ttff_cnt;
                //Find the MIN TTFF
                if((mnld_test_result_body.ttff[MIN] == 0 ) || (mnld_test_result_body.ttff[MIN] > mnld_test_result_body.ttff[CURR]))
                {
                    mnld_test_result_body.ttff[MIN] = mnld_test_result_body.ttff[CURR];
                }
                // Find the MAX TTFF
                if(mnld_test_result_body.ttff[MAX] < mnld_test_result_body.ttff[CURR])
                {
                    mnld_test_result_body.ttff[MAX] = mnld_test_result_body.ttff[CURR];
                }
                CB_DBG("TTFF:%dms",mnld_test_ttff);
            }

        }else{
            mnld_test_result_body.ttff[CURR] = mnld_test_ttff;
        }
    }

    if(mnld_test_result_body.fix_type != 0)
    {
        //GNGGA,hhmmss.mss,...
        if(strncmp(nmea+3,NMEA_GGA,strlen(NMEA_GGA)) == 0)
        {
            strncpy(mnld_test_result_body.utc_time, nmea+7, MNL_UTC_TIME_LEN);
            mnld_test_result_body.utc_time[MNL_UTC_TIME_LEN-1] = '\0';
        }
    }else{
        memset(mnld_test_result_body.utc_time, 0, MNL_UTC_TIME_LEN);
        mnld_test_result_body.utc_time[0] = '-';
    }

    if(strncmp(nmea+3,NMEA_ACC,strlen(NMEA_ACC)) == 0)
    {
        mnld_test_result_body.location.legacyLocation.timestamp = timestamp;
        mnld_test_show_test_result(&mnld_test_result_body);
    }

}

void mnld_test_gps_set_capabilities(uint32_t capabilities)
{

    CB_DBG("gps set capabilities");
}

void mnld_test_gps_acquire_wakelock(void)
{

    CB_DBG("gps acquire wakelock");
}

void mnld_test_gps_release_wakelock(void)
{

    CB_DBG("gps release wakelock");
}

void mnld_test_gps_request_utc_time(void)
{

    CB_DBG("gps request utc time");
}

void mnld_test_set_system_info_cb(const GnssSystemInfo* info)
{
    CB_DBG("set system info");
}

void mnld_test_gnss_sv_status_cb(GnssSvStatus_ext* sv_info)
{
    CB_DBG("gnss sv status");
}

pthread_t mnld_test_gps_create_thread(const char* name, void (*start)(void *), void* arg)
{
    pthread_t ntid = 0;
    int ret = 0;

    ret = pthread_create(&ntid, NULL, (void *(*)(void *))start, arg);

    if(ret != 0)
    {
        LOGE("thread %s create fail(%s)!", name, strerror(errno));
        ntid = 0;
    }else{
        CB_DBG("tread %s create success!", name);
    }

    return ntid;
}

void mnld_test_gnss_set_name_cb(const char* name, int length)
{
    char *mnl_ver_addr = NULL;

    if(name != NULL && strlen(name) <= length //Have valid input
        && strlen(mnld_test_mnl_ver) <= strlen("MNL_VER_default")) { //Haven't got mnld_test_mnl_ver
        mnl_ver_addr = strstr(name, "MNL_VER");
        CB_DBG("gnss set name:%s", name);
        if(mnl_ver_addr != NULL) {
            MNLD_STRNCPY(mnld_test_mnl_ver, mnl_ver_addr, sizeof(mnld_test_mnl_ver));
            CB_DBG("[%s]", mnld_test_mnl_ver);
        } else {
            CB_DBG("Don't find MNL version!!!");
        }
    } else {
        LOGW("error param:%p, %d", name, length);
    }
}

void mnld_test_gnss_request_location_cb(bool independentFromGnss, bool isUserEmergency)
{
    CB_DBG("gnss request location");
}

void mnld_test_agnss_location_callback(GpsLocation_ext* location) {
    CB_DBG("Get agps location");
}

GpsCallbacks_ext mnld_test_gps_callbacks = {
    .size = sizeof(GpsCallbacks_ext),
    .location_cb = mnld_test_gps_location_callback,
    .status_cb = mnld_test_gps_status_callback,
    .sv_status_cb = mnld_test_gps_sv_status_callback,
    .nmea_cb = mnld_test_gps_nmea_callback,
    .set_capabilities_cb = mnld_test_gps_set_capabilities,
    .acquire_wakelock_cb = mnld_test_gps_acquire_wakelock,
    .release_wakelock_cb = mnld_test_gps_release_wakelock,
    .create_thread_cb = mnld_test_gps_create_thread,
    .request_utc_time_cb = mnld_test_gps_request_utc_time,
    .set_system_info_cb = mnld_test_set_system_info_cb,
    .gnss_sv_status_cb = mnld_test_gnss_sv_status_cb,
    .set_name_cb = mnld_test_gnss_set_name_cb,
    .request_location_cb = mnld_test_gnss_request_location_cb,
    .agps_location_cb = mnld_test_agnss_location_callback,
};

GpsCallbacks_ext* mnld_test__get_gps_callbacks(void)
{
    return &mnld_test_gps_callbacks;
}

void mnld_test_gnss_measurement_callback(GnssData_ext* data) {
    int i;
    int meas_cnt;
    GnssMeasurement_ext* raw_meas;
    GnssClock_ext* clk;
    ElapsedRealtime* elap_realtime;

#ifdef LOG_TAG
#undef LOG_TAG
#define LOG_TAG "raw_meas"
#endif

    if (data == NULL) {
        LOGE("param error");
        return;
    }

    meas_cnt = data->measurement_count;
    if (raw_dbg == 1) {
        LOGD("==================== print_gnss_measurement ====================");
    }
    LOGD("measurement count is: %d", meas_cnt);

    if (raw_dbg == 1) {
        for (i = 0; i < meas_cnt; i++) {
            raw_meas = &(data->measurements[i]);
            LOGD("********* measurement message %d *********", i+1);
            LOGD("flags=0x%x", raw_meas->legacyMeasurement.flags);
            LOGD("svid=%d", raw_meas->legacyMeasurement.svid);
            LOGD("constellation=0x%x", raw_meas->legacyMeasurement.constellation);
            LOGD("time_offset_ns=%f", raw_meas->legacyMeasurement.time_offset_ns);
            LOGD("state=0x%x", raw_meas->legacyMeasurement.state);
            LOGD("received_gps_tow_ns=%"PRId64, raw_meas->legacyMeasurement.received_sv_time_in_ns);
            LOGD("received_gps_tow_uncertainty_ns=%"PRId64, raw_meas->legacyMeasurement.received_sv_time_uncertainty_in_ns);
            LOGD("c_n0_dbhz=%f", raw_meas->legacyMeasurement.c_n0_dbhz);
            LOGD("pseudorange_rate_mps=%f", raw_meas->legacyMeasurement.pseudorange_rate_mps);
            LOGD("pseudorange_rate_uncertainty_mps=%f", raw_meas->legacyMeasurement.pseudorange_rate_uncertainty_mps);
            LOGD("accumulated_delta_range_state=0x%x", raw_meas->legacyMeasurement.accumulated_delta_range_state);
            LOGD("accumulated_delta_range_m=%f", raw_meas->legacyMeasurement.accumulated_delta_range_m);
            LOGD("accumulated_delta_range_uncertainty_m=%f", raw_meas->legacyMeasurement.accumulated_delta_range_uncertainty_m);
            LOGD("carrier_frequency_hz=%f", raw_meas->legacyMeasurement.carrier_frequency_hz);
            LOGD("carrier_cycles=%"PRId64, raw_meas->legacyMeasurement.carrier_cycles);
            LOGD("carrier_phase=%f", raw_meas->legacyMeasurement.carrier_phase);
            LOGD("carrier_phase_uncertainty=%f", raw_meas->legacyMeasurement.carrier_phase_uncertainty);
            LOGD("multipath_indicator=%d", raw_meas->legacyMeasurement.multipath_indicator);
            LOGD("snr_db=%f", raw_meas->legacyMeasurement.snr_db);
        
            LOGD("agc_level_db=%f", raw_meas->agc_level_db);
            LOGD("codeType=%s", raw_meas->codeType);
            LOGD("fullInterSignalBiasNs=%f", raw_meas->fullInterSignalBiasNs);
            LOGD("fullInterSignalBiasUncertaintyNs=%f", raw_meas->fullInterSignalBiasUncertaintyNs);
            LOGD("satelliteInterSignalBiasNs=%f", raw_meas->satelliteInterSignalBiasNs);
            LOGD("satelliteInterSignalBiasUncertaintyNs=%f", raw_meas->satelliteInterSignalBiasUncertaintyNs);
            LOGD("basebandCN0DbHz=%f", raw_meas->basebandCN0DbHz);
        }
        
        clk = &(data->clock);
        LOGD("======================= print_gnss_clock =======================");
        LOGD("flags=0x%x", clk->legacyClock.flags);
        LOGD("leap_second=%d", clk->legacyClock.leap_second);
        LOGD("time_ns=%"PRId64, clk->legacyClock.time_ns);
        LOGD("time_uncertainty_ns=%f", clk->legacyClock.time_uncertainty_ns);
        LOGD("full_bias_ns=%"PRId64, clk->legacyClock.full_bias_ns);
        LOGD("bias_ns=%f", clk->legacyClock.bias_ns);
        LOGD("bias_uncertainty_ns=%f", clk->legacyClock.bias_uncertainty_ns);
        LOGD("drift_nsps=%f", clk->legacyClock.drift_nsps);
        LOGD("drift_uncertainty_nsps=%f", clk->legacyClock.drift_uncertainty_nsps);
        LOGD("hw_clock_discontinuity_count=%d", clk->legacyClock.hw_clock_discontinuity_count);
        LOGD("constellation=%d", clk->referenceSignalTypeForIsb.constellation);
        LOGD("carrierFrequencyHz=%f", clk->referenceSignalTypeForIsb.carrierFrequencyHz);
        LOGD("codeType=%s", clk->referenceSignalTypeForIsb.codeType);

        elap_realtime = &(data->elapsedRealtime);
        LOGD("================= print_gnss_elapsed_real_time =================");
        LOGD("flags=0x%x", elap_realtime->flags);
        LOGD("timestampNs=%"PRId64, elap_realtime->timestampNs);
        LOGD("timeUncertaintyNs=%"PRId64, elap_realtime->timeUncertaintyNs);
    }

    return;
}

GpsMeasurementCallbacks_ext mnld_test_raw_callbacks = {
    .size = sizeof(GpsMeasurementCallbacks_ext),
    .measurement_callback = NULL,
    .gnss_measurement_callback = mnld_test_gnss_measurement_callback,
};

GpsMeasurementCallbacks_ext* mnld_test_get_raw_callbacks(void) {
    return &mnld_test_raw_callbacks;
}

void mnld_test_gnss_navimsg_callback(GnssNavigationMessage* msg) {

    int i = 0;
    unsigned char data[MAX_NAV_DATA_LEN] = {0};
    int data_length = 0;

#ifdef LOG_TAG
#undef LOG_TAG
#define LOG_TAG "raw_meas"
#endif

    if (msg == NULL) {
        LOGE("param error");
        return;
    }

    if (raw_dbg == 1) {
        LOGD("==================== print gnss navigation msg ====================");
        LOGD("[navi_msg] svid=%d", msg->svid);
        LOGD("[navi_msg] type=%d", msg->type);
        LOGD("[navi_msg] status=0x%x", msg->status);
        LOGD("[navi_msg] message_id=%d", msg->message_id);
        LOGD("[navi_msg] submessage_id=%d", msg->submessage_id);
        LOGD("[navi_msg] data_length=%zu", msg->data_length);
    }

    data_length = msg->data_length;
    if (data_length > MAX_NAV_DATA_LEN) {
        data_length = MAX_NAV_DATA_LEN;
    }

    memcpy(data, msg->data, data_length);

    if (raw_dbg == 1) {
        for (i = 0; i < data_length; i++) {
            LOGD("[navi_msg] gnss navigation data[%d] = %x", i, data[i]);
        }
    }

    return;
}

GpsNavigationMessageCallbacks mnld_test_gnss_navimsg_callbacks = {
    .size = sizeof(GpsNavigationMessageCallbacks),
    .navigation_message_callback = NULL,
    .gnss_navigation_message_callback = mnld_test_gnss_navimsg_callback,
};

GpsNavigationMessageCallbacks* mnld_test_get_gnss_navimsg_callbacks(void) {
    return &mnld_test_gnss_navimsg_callbacks;
}


