#ifndef __GEOFENCE_H__
#define __GEOFENCE_H__

// Ex.GNSS Adaptor --> MNLD Message
//-------------------------------------------------------
//|Message Type(int)  | Message Length(int) | Message Structure |
//-------------------------------------------------------
// Case 1 - Message Type: ADD_GEOFENCE_AREA    Message Structure:mtk_geofence_property
//              [Return Msg Type]:GEOFENCE_RESPONSE_INFO
//              Corresponding ATCMD(IN):Ex,AT+EGEOADDCIRCLE=3,0,24.123456,121.012345,200.000000,10000\r\n

// Case 2 - Message Type: REMOVE_GEOFENCE       Message Structure:Id(int)
//              [Return Msg Type]:EXCUTE_RESULT
//              Corresponding ATCMD(IN):Ex,AT+EGEODEL,1\r\n

// Case 3 - Message Type: CLEAR_GEOFENCE          Message Structure:NONE
//              [Return Msg Type]:EXCUTE_RESULT
//              Corresponding ATCMD(IN):Ex,AT+EGEODELALL=\r\n

// Case 4 - Message Type: QUERY_GEOFENCE_NUM Message Structure:NONE
//              [Return Msg Type]:GEOFENCE_NUM
//              Corresponding ATCMD(IN):Ex,AT+EGEOMAX?\r\n

// MNLD Message --> GNSS Adaptor
//-------------------------------------------------------
//|Message Type(int)  | Message Length(int) | Message Structure |
//-------------------------------------------------------
// Message Type: EXCUTE_RESULT                   Message Structure:mtk_geofence_result
// Corresponding ATCMD(OUT):Ex,OK\r\n or ERROR\r\n

// Message Type: GEOFENCE_NUM                   Message Structure:Number(int)
// Corresponding ATCMD(OUT):Ex,+EGEOMAX: 100\r\n

// Message Type: GEOFENCE_RESPONSE_INFO   Message Structure:mtk_geofence_create_status
// Corresponding ATCMD(OUT):Ex,+EGEOADD: 0,1\r\n

// Message Type: GEOFENCE_ALERT_INFO         Message Structure:mtk_geofence_alert
// Corresponding ATCMD(OUT):Ex,+EGEORESP: 1,1,24.125465,121.365496,100.23,1.23,3.54,3,6,2,6,3,2.52,1.32,2.12\r\n

// Message Type: GNSS_TRACKING_STATUS       Message Structure:mtk_gnss_tracking_status
// Corresponding ATCMD(OUT):Ex,+EGEOTRACK: 0,"2019/12/1,21:06:23"\r\n

#pragma pack(push)
#pragma pack(4)

typedef struct {
    bool geofence_support;
}mtk_geofence_client_capability;

typedef struct {
    bool geofence_support;
}mtk_geofence_server_capability;

typedef enum {
    GEOFENCE_CLIENT_CAP,//geofence client capability
    INIT_GEOFENCE,//Reserved
    ADD_GEOFENCE_AREA,
    PAUSE_GEOFENCE,//Reserved
    RESUME_GEOFENCE,//Reserved
    REMOVE_GEOFENCE,
    RECOVER_GEOFENCE,//Reserved
    CLEAR_GEOFENCE,
    QUERY_GEOFENCE_NUM
} mtk_geofence_command;

typedef enum {
    GEOFENCE_UNKNOWN = 0,
    GEOFENCE_ENTERED = 1,
    GEOFENCE_EXITED = 2,
} mtk_geofence_status;

typedef int mtk_monitor_transition;
#define MTK_GEOFENCE_ENTER       0x01
#define MTK_GEOFENCE_EXIT        0x02
#define MTK_GEOFENCE_UNCERTAIN   0x04//Reserved

typedef struct mtk_geofence_area {
    double latitude;
    double longitude;
    double radius;
    int latest_state; /*current state(mtk_geofence_status), most cases is GEOFENCE_UNKNOWN*/
    mtk_monitor_transition monitor_transition; /*bitwise , MTK_GEOFENCE_EXIT/MTK_GEOFENCE_ENTER/MTK_GEOFENCE_UNCERTAIN*/
    int unknown_timer;/*The time limit after which the UNCERTAIN transition should be triggered. This paramter is defined in milliseconds.*/
} mtk_geofence_property;

typedef struct mtk_geofence_alert {
    int id;
    int alert_state;//mtk_geofence_status
    double latitude;
    double longitude;
    double altitude;
    double speed;
    double heading;
    int h_acc;
    int h_err_majoraxis;
    int h_err_minoraxis;
    int h_err_angle;
    int hor_conf;
    double pdop;
    double hdop;
    double vdop;
}mtk_geofence_alert;

typedef struct mtk_gnss_tracking_status {
    int status; //GNSS service tracking OK       = 0,GNSS service tracking failure  = -1
    int year;
    int month;
    int day;
    int hour;
    int minute;
    int second;
}mtk_gnss_tracking_status;

#define MTK_GFC_SUCCESS     (0)
#define MTK_GFC_ERROR       (-1)
#pragma pack(pop)

#endif
