#ifndef __Meta2Mnld_logctrl_Interface_H__
#define __Meta2Mnld_logctrl_Interface_H__

#include "Meta2MnldInterface.h"

typedef enum {
    ATM_WIFI_MODE = 0,
    ATM_USB_MODE
} ATM_ONLINE_MODE;

#define META2MNLD_INTERFACE_PROTOCOL_TYPE 303
#define META2MNLD_INTERFACE_BUFF_SIZE 12
#define META2MNLD_LOGCTRL_INTERFACE_BUFF_SIZE 1024

#define GPSLOG_START               "meta_gpslog_start"
#define GPSLOG_STOP                "meta_gpslog_stop"
#define GPSLOG_PULL_START          "pull_gpslog_start"
#define GPSLOG_PULL_STOP           "pull_gpslog_stop"

extern ATM_ONLINE_MODE transfer_mode;

extern int pull_stop_flag;

void mnld2pc_log_closeUSBPort();

bool mnld2pc_log_openUSBPort();

bool mnld_sendLogDataToPC(const char *data, unsigned int len);

int mnld_checkConnectType();

bool mnld_TransferFile(char* logPath, const char* fileName);

signed int mnld2pc_wifi_createSocket();

void mnld2pc_wifi_disconnect();

int mnld2pc_connect_wifi();

void mnld2pc_wifi_socketClose();

void mnld2pc_wifi_WaitConnect();
bool mnld2pc_log_sendSourceFile(char* folder_path,ATM_ONLINE_MODE mode);
int Meta2Mnld_logctrl_hdlr(int fd, Meta2MnldLogctrlInterface_callbacks* hdlr);
int mtk_socket_tcp_startListening(const char* path, mtk_socket_namespace sock_namespace);


#endif
