#ifndef __MTK_LBS_UTILITY_H__
#define __MTK_LBS_UTILITY_H__

#include <time.h>
#include <sys/time.h>
#include <stdint.h>
#include <pthread.h>
#include <unistd.h>

#include "gps_dbg_log.h"

#include "mtk_mnld_log.h"

#include "hal_mnl_interface_common.h"

#ifdef __cplusplus
extern "C" {
#endif

/*************************************************
* Basic Utilities
**************************************************/
#ifndef UNUSED
#define UNUSED(x) (x)=(x)
#endif

#define CRASH_TO_DEBUG() \
{\
    int* crash = 0;\
    gps_dbg_log_exit_flush(0);\
    *crash = 100;\
}

#define DUMP_BYTES_PER_LINE 16
#define DUMP_MAX_PRINT_LINE 10

#define INVALID_TIMERID ((timer_t)-1)

#define MNLD_DUMP_MEM(addr, len) do{\
    int i = 0, j = 0;\
    char print_buf[DUMP_BYTES_PER_LINE*5+1] = {0};\
    unsigned int print_len = len;\
    if(len > DUMP_MAX_PRINT_LINE*DUMP_BYTES_PER_LINE) {\
        print_len = DUMP_MAX_PRINT_LINE*DUMP_BYTES_PER_LINE;\
    }\
    LOGD(">>>>>DUMP_START(addr:%p, len:%d, print_len:%ud)<<<<<", addr, len,print_len);\
    for(i = 0; i < print_len; i+=DUMP_BYTES_PER_LINE) {\
        memset(print_buf, 0, sizeof(print_buf));\
        for(j=0;j<DUMP_BYTES_PER_LINE;j++) {\
            sprintf(&print_buf[j*5], "0x%02x ", ((char *)addr)[i*DUMP_BYTES_PER_LINE+j]);\
            print_buf[DUMP_BYTES_PER_LINE*5] = '\0';\
        }\
        LOGD("[%3d]:%s", i/DUMP_BYTES_PER_LINE, print_buf);\
    }\
    LOGD("<<<<<DUMP_STOP>>>>>");\
}while(0)

#if defined(__ANDROID_OS__)
#define  ANDROID_MNLD_PROP_SUPPORT 1
#define  MTK_GPS_NVRAM  1
#elif defined(__LINUX_OS__)
#define  ANDROID_MNLD_PROP_SUPPORT 0
#define  MTK_GPS_NVRAM  0

/**
 * connect to peer named "name"
 * returns fd or -1 on error
 */
int socket_local_client(const char *name, int type);
/** Open a server-side UNIX domain datagram socket in the Linux non-filesystem
 *  namespace
 *
 *  Returns fd on success, -1 on fail
 */
int socket_local_server(const char *name, int type);
#endif


#define MNLD_STRNCPY(dst,src,size) do{\
                                       strncpy((char *)(dst), (char *)(src), (size - 1));\
                                      (dst)[size - 1] = '\0';\
                                     }while(0)

#define MNLD_SPRINTF(buf,fmt,...)  do{\
                                       if(sprintf((char *)(buf), fmt,##__VA_ARGS__) < 0){\
                                           LOGE("sprintf error occurred");\
                                       }\
                                     }while(0)

#define MNLD_SNPRINTF(buf,len,fmt,...) do{\
                                       if(snprintf((char *)(buf), len, fmt,##__VA_ARGS__) < 0){\
                                           LOGE("snprintf error occurred");\
                                       }\
                                     }while(0)

#define MNLD_VSNPRINTF(buf,len,fmt,...) do{\
                                       if(vsnprintf((char *)(buf), len, fmt,##__VA_ARGS__) < 0){\
                                           LOGE("vsnprintf error occurred");\
                                       }\
                                     }while(0)

#define MNLD_FRINTF(buf,fmt,...) do{\
                                       if(fprintf(buf, fmt,##__VA_ARGS__) < 0){\
                                           LOGE("fprintf error occurred");\
                                       }\
                                     }while(0)

#define MNLD_FCLOSE(fd) do{ \
    if(fclose(fd) != 0) { \
        LOGE("FUNC[%s], Line[%d], fclose fail, %s(%d)", __func__, __LINE__, strerror(errno), errno); \
    } \
}while(0)

typedef struct sync_lock {
    pthread_mutex_t mutx;
    pthread_cond_t con;
    int condtion;
    int index;
}SYNC_LOCK_T;

void msleep(int interval);

// in millisecond
time_t get_tick();

// in millisecond
UINT64 get_time_in_millisecond();

// -1 means failure
int block_here();

//exit block_here() and process will exit and restart
void mnld_block_exit(void);

/*************************************************
* Timer
**************************************************/
typedef void (* timer_callback)();

// -1 means failure
timer_t init_timer_id(timer_callback cb, int id);

// -1 means failure
timer_t init_timer(timer_callback cb);

// -1 means failure
int start_timer(timer_t timerid, int milliseconds);

// -1 means failure
int stop_timer(timer_t timerid);

// -1 means failure
int deinit_timer(timer_t timerid);
/*************************************************
* Timer Alarm
**************************************************/
// -1 means failure
int init_timer_alarm();

// -1 means failure
int init_timer_id_alarm(int id);

// -1 means failure
int stop_timer_alarm(int timerid);

// -1 means failure
int start_timer_alarm(int timerfd, int milliseconds);

/*************************************************
* Epoll
**************************************************/
// -1 means failure
int epoll_add_fd(int epfd, int fd);

// -1 failed
int epoll_add_fd2(int epfd, int fd, uint32_t events);

// -1 failed
int epoll_del_fd(int epfd, int fd);

int epoll_mod_fd(int epfd, int fd, uint32_t events);

/*************************************************
* Local UDP Socket
**************************************************/
// -1 means failure
int socket_bind_udp(const char* path);

int mnld_flp_to_mnld_fd_init(const char* path);

int mnld_sendto_flp(const void* dest, const char* buf, int size);

// -1 means failure
int socket_set_blocking(int fd, int blocking);

// -1 means failure
int safe_sendto(const char* path, const char* buff, int len);

// -1 means failure
int safe_recvfrom(int fd, char* buff, int len);

int socket_tcp_server_bind_local(bool abstract, const char* name);

int socket_tcp_server_new_connect(int serverfd);

int socket_tcp_client_connect_local(bool abstract, const char* name);



/*************************************************
* File
**************************************************/
// 0 not exist, 1 exist
int is_file_exist(const char* path);

// -1 means failure
int get_file_size(const char* path);

// -1 failure
int delete_file(const char* file_path);

// -1 means failure
int write_msg2file(const char* dest, const char* msg, ...);

int asc_str_to_usc2_str(char* output, const char* input);

void raw_data_to_hex_string(char* output, const char* input, int input_len);

void init_condition(SYNC_LOCK_T *lock);

void get_condition(SYNC_LOCK_T *lock);

void release_condition(SYNC_LOCK_T *lock);

void mnld_dump_exit(void);

//--------------------------------------------------------------------------------------------------------
#define MAX_CLIENT_NUM 10

typedef struct {
    int fd;

    //state
    bool gnss_started;
    bool gnss_inited;
    bool meas_started;
    union {
        mnl_hal_basic_client_cap basic_client_cap;
        mnl_hal_ext_client_cap ext_client_cap;
    } client_cap;
    union {
        mnl_hal_basic_server_cap basic_server_cap;
        mnl_hal_ext_server_cap ext_server_cap;
    } server_cap;
} client_ctx;

typedef struct {
    int num;
    client_ctx clients[MAX_CLIENT_NUM];
} client_list;

void client_list_dump(client_list* list);

bool client_list_add(client_list* list, int fd);

bool client_list_remove(client_list* list, int fd);

bool client_list_contains(client_list* list, int fd);

client_ctx* client_list_get_ctx_by_fd(client_list* list, int fd);

bool client_list_is_all_gnss_stop(client_list* list);

bool client_list_is_all_gnss_cleanup(client_list* list);

bool client_list_is_all_meas_stop(client_list* list);

bool client_list_is_geofence_ongoing(client_list* list, int fd);

int socket_tcp_send(int fd, const char* buff, int len);

int client_send_to_all(client_list* list, const char* buff, int len);

int mnl2hal_basic(const char* buff, int len);

int mnl2hal_ext(const char* buff, int len);

int mnl2hal_basic_all(const char* buff, int len);

//Cycle buffer
typedef struct cyclical_buffer     // Cyclical buffer
{
    char *next_write;     // next position to write to
    char *next_read;      // next position to read from
    char *start_buffer;   // start of buffer
    char *end_buffer;     // end of buffer + 1
    int buffer_size;
} cyclical_buffer_t;

int mnld_get_one_msg(cyclical_buffer_t *cyc_buffer, char *buff);
int mnld_put_msg_to_cycle(cyclical_buffer_t *cyc_buffer, char *buff, int len);
void mnld_buffer_initialize(cyclical_buffer_t *buffer, char *buffer_body, unsigned int buffer_size);

//------------------------------------------------------
//Linux wake lock

#define MNLD_WAKE_LOCK_ID "mnld_wakelock"
//delay to do wake_unlock to ensure the msg can be deliveried to other process
#define MNLD_WAKE_LOCK_TIMEOUT (5 * 1000)
//Timer refresh latency, to protect timer update too often in short time
#define MNLD_WAKE_LOCK_LATENCY (1 * 1000)

typedef struct {
    bool wake_lock_acquired;
    timer_t unlock_timer;
    pthread_mutex_t mutex;
    UINT64 time_last_refresh;
} wake_lock_ctx;

void mnld_wake_lock_init();
void mnld_wake_lock_deinit();
void mnld_wake_lock_take();
void mnld_wake_lock_give();

void set_signal_ignore(int signo);

int socket_bind_udp_force(const char* path);

int socket_tcp_server_bind_local_force(bool abstract, const char* name);

#ifdef __cplusplus
}
#endif

#endif
