#ifndef __TRANSPORT_PCIE__H
#define __TRANSPORT_PCIE__H

#include "fdevent.h"
#include "adb.h"
#include "sysdeps.h"

struct pcie_info {
	unsigned short device;
	unsigned short vendor;
	unsigned int class;
};

struct pcie_handle {
	int fd;
	struct pcie_info *info;

	adb_cond_t notify;
	adb_mutex_t lock;

	int (*write)(struct pcie_handle *h, const void *data, int len);
	int (*read)(struct pcie_handle *h, void *data, int len);
	void (*kick)(struct pcie_handle *h);
};

#endif
