/* SPDX-License-Identifier: GPL-2.0 */
/*
 * Copyright (c) 2019 MediaTek Inc.
 */

#ifndef _MIPS_PMU_NAME_H_
#define _MIPS_PMU_NAME_H_

/* MIPS 1004K */
#define MIPS_MAX_HWEVENTS		(4)

#define PMU_1004K_MAX_HW_REGS	(128)
struct pmu_desc mips_1004k_pmu_desc[][PMU_1004K_MAX_HW_REGS] = {
	/* COUNT 0 */
	{
	 {0, "CPU_CYCLES"},
	 {1, "CPU_INST"},
	 {2, "BRANCH_INSNS"},
	 {3, "JR_31_INSNS"},
	 {4, "JR_NON_31_INSNS"},
	 {5, "ITLB_ACCESSES"},
	 {6, "DTLB_ACCESSES"},
	 {7, "JTLB_INSN_ACCESSES"},
	 {8, "JTLB_DATA_ACCESSES"},
	 {9, "ICACHE_ACCESSES"},
	 {10, "DCACHE_ACCESSES"},
	 {11, "DCACHE_MISSES"},
	 {12, "RESERVED"},
	 {13, "STORE_MISS_INSNS"},
	 {14, "INTEGER_INSNS"},
	 {15, "LOAD_INSNS"},
	 {16, "J_JAL_INSNS"},
	 {17, "NO_OPS_INSNS"},
	 {18, "ALL_STALLS"},
	 {19, "SC_INSNS"},
	 {20, "PREFETCH_INSNS"},
	 {21, "L2_CACHE_WRITEBACKS"},
	 {22, "L2_CACHE_MISSES"},
	 {23, "EXCEPTIONS_TAKEN"},
	 {24, "CACHE_FIXUP_CYCLES"},
	 {25, "IFU_STALLS"},
	 {26, "DSP_INSNS"},
	 {27, "RESERVED"},
	 {28, "POLICY_EVENTS"},
	 {29, "ISPRAM_EVENTS"},
	 {30, "COREEXTEND_EVENTS"},
	 {31, "YIELD_EVENTS"},
	 {32, "ITC_LOADS"},
	 {33, "UNCACHED_LOAD_INSNS"},
	 {34, "FORK_INSNS"},
	 {35, "CP2_ARITH_INSNS"},
	 {36, "INTERVENTION_STALLS"},
	 {37, "ICACHE_MISS_STALLS"},
	 {38, "RESERVED"},
	 {39, "DCACHE_MISS_CYCLES"},
	 {40, "UNCACHED_STALLS"},
	 {41, "MDU_STALLS"},
	 {42, "CP2_STALLS"},
	 {43, "ISPRAM_STALLS"},
	 {44, "CACHE_INSN_STALLS"},
	 {45, "LOAD_USE_STALLS"},
	 {46, "INTERLOCK_STALLS"},
	 {47, "RELAX_STALLS"},
	 {48, "IFU_FB_FULL_REFETCHES"},
	 {49, "EJTAG_INSN_TRIGGERS"},
	 {50, "FSB_LESS_25_FULL"},
	 {51, "FSB_OVER_50_FULL"},
	 {52, "LDQ_LESS_25_FULL"},
	 {53, "LDQ_OVER_50_FULL"},
	 {54, "WBB_LESS_25_FULL"},
	 {55, "WBB_OVER_50_FULL"},
	 {56, "INTERVENTION_HIT_COUNT"},
	 {57, "INVALIDATE_INTERVENTION_COUNT"},
	 {58, "EVICTION_COUNT"},
	 {59, "MESI_INVAL_COUNT"},
	 {60, "MESI_MODIFIED_COUNT"},
	 {61, "SELF_INTERVENTION_LATENCY"},
	 {62, "READ_RESPONSE_LATENCY"},
	 {63, "RESERVED"},
	 {64, "SI_PCEVENT1"},
	 {65, "SI_PCEVENT3"},
	 {66, "SI_PCEVENT5"},
	 {67, "SI_PCEVENT7"},
	 {-1, "RESERVED"},
	 /* 68 - 127 for Reserved */
	 },
	/* COUNT 1 */
	{
	 {0, "CPU_CYCLES"},
	 {1, "CPU_INST"},
	 {2, "MISPREDICTED_BRANCH_INSNS"},
	 {3, "JR_31_MISPREDICTIONS"},
	 {4, "JR_31_NO_PREDICTIONS"},
	 {5, "ITLB_MISSES"},
	 {6, "DTLB_MISSES"},
	 {7, "JTLB_INSN_MISSES"},
	 {8, "JTLB_DATA_MISSES"},
	 {9, "ICACHE_MISSES"},
	 {10, "DCACHE_WRITEBACKS"},
	 {11, "DCACHE_MISSES"},
	 {12, "RESERVED"},
	 {13, "LOAD_MISS_INSNS"},
	 {14, "FPU_INSNS"},
	 {15, "STORE_INSNS"},
	 {16, "MIPS16_INSNS"},
	 {17, "INT_MUL_DIV_INSNS"},
	 {18, "REPLAYED_INSNS"},
	 {19, "SC_INSNS_FAILED"},
	 {20, "CACHE_HIT_PREFETCH_INSNS"},
	 {21, "L2_CACHE_ACCESSES"},
	 {22, "L2_CACHE_SINGLE_BIT_ERRORS"},
	 {23, "SINGLE_THREADED_CYCLES"},
	 {24, "REFETCHED_INSNS"},
	 {25, "ALU_STALLS"},
	 {26, "ALU_DSP_SATURATION_INSNS"},
	 {27, "MDU_DSP_SATURATION_INSNS"},
	 {28, "CP2_EVENTS"},
	 {29, "DSPRAM_EVENTS"},
	 {30, "RESERVED"},
	 {31, "ITC_EVENT"},
	 {33, "UNCACHED_STORE_INSNS"},
	 {34, "YIELD_IN_COMP"},
	 {35, "CP2_TO_FROM_INSNS"},
	 {36, "INTERVENTION_MISS_STALLS"},
	 {37, "DCACHE_MISS_STALLS"},
	 {38, "RESERVED"},
	 /* 38 was listed in OPROFILE web page, but not listed 1004k mips spec */
	 /* {38, "FSB_INDEX_CONFLICT_STALLS"}, */
	 {39, "L2_CACHE_MISS_CYCLES"},
	 {40, "ITC_STALLS"},
	 {41, "FPU_STALLS"},
	 {42, "COREEXTEND_STALLS"},
	 {43, "DSPRAM_STALLS"},
	 {45, "ALU_TO_AGEN_STALLS"},
	 {46, "MISPREDICTION_STALLS"},
	 {47, "RESERVED"},
	 {48, "FB_ENTRY_ALLOCATED_CYCLES"},
	 {49, "EJTAG_DATA_TRIGGERS"},
	 {50, "FSB_25_50_FULL"},
	 {51, "FSB_FULL_STALLS"},
	 {52, "LDQ_25_50_FULL"},
	 {53, "LDQ_FULL_STALLS"},
	 {54, "WBB_25_50_FULL"},
	 {55, "WBB_FULL_STALLS"},
	 {56, "INTERVENTION_COUNT"},
	 {57, "INVALID_INTERVENT_HIT_CNT"},
	 {58, "WRITEBACK_COUNT"},
	 {59, "MESI_EXCLUSIVE_COUNT"},
	 {60, "MESI_SHARED_COUNT"},
	 {61, "SELF_INTERVENTION_COUNT"},
	 {62, "READ_RESPONSE_COUNT"},
	 {63, "RESERVED"},
	 {64, "SI_PCEVENT0"},
	 {65, "SI_PCEVENT2"},
	 {66, "SI_PCEVENT4"},
	 {67, "SI_PCEVENT6"},
	 {-1, "RESERVED"},
	 },
};

#define MIPS_1004K_PMU_DESC_SIZE (sizeof(mips_1004k_pmu_desc[0]))
#define MIPS_1004K_PMU_DESC_COUNT (sizeof(mips_1004k_pmu_desc) / MIPS_1004K_PMU_DESC_SIZE)

#endif				/* _V8_PMU_NAME_H_ */
