import binascii
import Crypto.Random.OSRNG.posix as RNG
from Crypto.Cipher import AES
from Crypto.Hash import MD5
from Crypto.Hash import SHA
from Crypto.Hash import SHA224
from Crypto.Hash import SHA256
from Crypto.Hash import SHA384
from Crypto.Hash import SHA512
from Crypto.Hash import HMAC
from Crypto.Util import Counter
import CryptoPlus
from CryptoPlus.Cipher import python_AES as CP_python_AES
import ecdsa
from ecdsa import SigningKey, VerifyingKey
from ecdsa.curves import NIST192p, NIST224p, NIST256p, NIST384p, NIST521p
from ecdsa.util import sigencode_string
from hashlib import sha1, sha224, sha256, sha384, sha512

#from pycrypto_lib.SelfTest.Signature import test_pkcs1_15_mytest as rsa_mytest
#from pycrypto_lib.SelfTest.Signature import test_pkcs1_pss_mytest as rsa_pss_mytest
import test_pkcs1_15_mytest as rsa_mytest
import test_pkcs1_pss_mytest as rsa_pss_mytest

''' Select ECDSA Curve '''
__CURVE = 'prime256v1'

AUTH_ECDSA_NISTP256 = 0
AUTH_ECDSA_NISTP384 = 1
AUTH_ECDSA_NISTP521 = 2
AUTH_RSA2048 = 3
AUTH_RSA3072 = 4
AUTH_RSA4096 = 5

AUTH_AES_CMAC = 12
AUTH_HMAC_SHA256 = 13

AUTH_ECDSA_NISTP192 = 10
AUTH_ECDSA_NISTP224 = 11


''' Select ECDSA module '''

''' Select Key Mode '''
__K_STRING = 0
__K_PEM = 1
__K_DER = 2


def crypto_pad_to_align(x, align):
    if(align == 0):
        return x
    else:
        size = len(x)
        #print("size 0x%x" %size)
        pad_size = (align - size % align) % align
        for i in range(0, pad_size, 1):
            x += b'\x00'
        #cryptoSB.dump(x)
        return x


# This module is python-ecdsa (warner/python-ecdsa)
class pythonECDSA:
	def __init__(self, priv=None, pub=None, curve=None):
		#print("pure-python ECDSA init")
                None
	def sign_string(self, privk, msg, sbc_auth_alg, sbc_auth_alg_hash):
		if(sbc_auth_alg == AUTH_ECDSA_NISTP256):
			if(sbc_auth_alg_hash == 0):
				sk = SigningKey.from_string(privk, curve=NIST256p, hashfunc=sha256)
				signature_str = sk.sign(msg, hashfunc=sha256, sigencode=sigencode_string)
			elif(sbc_auth_alg_hash == 1):
				sk = SigningKey.from_string(privk, curve=NIST256p, hashfunc=sha384)
				signature_str = sk.sign(msg, hashfunc=sha384, sigencode=sigencode_string)
			elif(sbc_auth_alg_hash == 2):
				sk = SigningKey.from_string(privk, curve=NIST256p, hashfunc=sha512)
				signature_str = sk.sign(msg, hashfunc=sha512, sigencode=sigencode_string)
		elif(sbc_auth_alg == AUTH_ECDSA_NISTP384):
			if(sbc_auth_alg_hash == 0):
				sk = SigningKey.from_string(privk, curve=NIST384p, hashfunc=sha256)
				signature_str = sk.sign(msg, hashfunc=sha256, sigencode=sigencode_string)
			elif(sbc_auth_alg_hash == 1):
				sk = SigningKey.from_string(privk, curve=NIST384p, hashfunc=sha384)
				signature_str = sk.sign(msg, hashfunc=sha384, sigencode=sigencode_string)
			elif(sbc_auth_alg_hash == 2):
				sk = SigningKey.from_string(privk, curve=NIST384p, hashfunc=sha512)
				signature_str = sk.sign(msg, hashfunc=sha512, sigencode=sigencode_string)
		elif(sbc_auth_alg == AUTH_ECDSA_NISTP521):
			if(sbc_auth_alg_hash == 0):
				sk = SigningKey.from_string(privk, curve=NIST521p, hashfunc=sha256)
				signature_str = sk.sign(msg, hashfunc=sha256, sigencode=sigencode_string)
			elif(sbc_auth_alg_hash == 1):
				sk = SigningKey.from_string(privk, curve=NIST521p, hashfunc=sha384)
				signature_str = sk.sign(msg, hashfunc=sha384, sigencode=sigencode_string)
			elif(sbc_auth_alg_hash == 2):
				sk = SigningKey.from_string(privk, curve=NIST521p, hashfunc=sha512)
				signature_str = sk.sign(msg, hashfunc=sha512, sigencode=sigencode_string)
		elif(sbc_auth_alg == AUTH_ECDSA_NISTP192):
			sk = SigningKey.from_string(privk, curve=NIST192p, hashfunc=sha256)
			signature_str = sk.sign(msg, hashfunc=sha256, sigencode=sigencode_string)
		elif(sbc_auth_alg == AUTH_ECDSA_NISTP224):
			sk = SigningKey.from_string(privk, curve=NIST224p, hashfunc=sha256)
			signature_str = sk.sign(msg, hashfunc=sha256, sigencode=sigencode_string)
		return signature_str
	def sign_pem(self, privk, msg, sbc_auth_alg):
		#print("    run sign pem")
		if(sbc_auth_alg == AUTH_ECDSA_NISTP256):
			sk = SigningKey.from_pem(privk, hashfunc=sha256)
			signature_pem = sk.sign(msg, hashfunc=sha256)

		elif(sbc_auth_alg == AUTH_ECDSA_NISTP384):
			sk = SigningKey.from_pem(privk, hashfunc=sha384)
			signature_pem = sk.sign(msg, hashfunc=sha384)

		elif(sbc_auth_alg == AUTH_ECDSA_NISTP192):
			sk = SigningKey.from_pem(privk, hashfunc=sha1)
			signature_pem = sk.sign(msg, hashfunc=sha1)

		elif(sbc_auth_alg == AUTH_ECDSA_NISTP224):
			sk = SigningKey.from_pem(privk, hashfunc=sha224)
			signature_pem = sk.sign(msg, hashfunc=sha224)

		return signature_pem
	def sign_der(self, privk, msg, sbc_auth_alg):
		#print("    run sign der")
		if(sbc_auth_alg == AUTH_ECDSA_NISTP256):
			sk = SigningKey.from_der(privk, hashfunc=sha256)
			signature_der = sk.sign(msg, hashfunc=sha256)

		elif(sbc_auth_alg == AUTH_ECDSA_NISTP384):
			sk = SigningKey.from_der(privk, hashfunc=sha384)
			signature_der = sk.sign(msg, hashfunc=sha384)

		elif(sbc_auth_alg == AUTH_ECDSA_NISTP192):
			sk = SigningKey.from_der(privk, hashfunc=sha1)
			signature_der = sk.sign(msg, hashfunc=sha1)

		elif(sbc_auth_alg == AUTH_ECDSA_NISTP224):
			sk = SigningKey.from_der(privk, hashfunc=sha224)
			signature_der = sk.sign(msg, hashfunc=sha224)


		return signature_der
	def verify_string(self, pubk, signature_str, msg, sbc_auth_alg):
		if(sbc_auth_alg == AUTH_ECDSA_NISTP256):
			vk = VerifyingKey.from_string(pubk, curve=NIST256p, hashfunc=sha256)
			ret = vk.verify(signature_str, msg)
		elif(sbc_auth_alg == AUTH_ECDSA_NISTP384):
			vk = VerifyingKey.from_string(pubk, curve=NIST384p, hashfunc=sha384)
			ret = vk.verify(signature_str, msg)
		elif(sbc_auth_alg == AUTH_ECDSA_NISTP192):
			vk = VerifyingKey.from_string(pubk, curve=NIST192p, hashfunc=sha1)
			ret = vk.verify(signature_str, msg)
		elif(sbc_auth_alg == AUTH_ECDSA_NISTP224):
			vk = VerifyingKey.from_string(pubk, curve=NIST224p, hashfunc=sha224)
			ret = vk.verify(signature_str, msg)
		return ret
	def verify_pem(self, pubk, signature_pem, msg, sbc_auth_alg):
		#print("    run verify pem")
		if(sbc_auth_alg == AUTH_ECDSA_NISTP256):
			vk = VerifyingKey.from_pem(pubk)
			ret = vk.verify(signature_pem, msg, hashfunc=sha256)

		elif(sbc_auth_alg == AUTH_ECDSA_NISTP384):
			vk = VerifyingKey.from_pem(pubk)
			ret = vk.verify(signature_pem, msg, hashfunc=sha384)

		elif(sbc_auth_alg == AUTH_ECDSA_NISTP192):
			vk = VerifyingKey.from_pem(pubk)
			ret = vk.verify(signature_pem, msg, hashfunc=sha1)

		elif(sbc_auth_alg == AUTH_ECDSA_NISTP224):
			vk = VerifyingKey.from_pem(pubk)
			ret = vk.verify(signature_pem, msg, hashfunc=sha224)
		return ret
	def verify_der(self, pubk, signature_der, msg, sbc_auth_alg):
		#print("    run verify der")
		if(sbc_auth_alg == AUTH_ECDSA_NISTP256):
			vk = VerifyingKey.from_der(pubk)
			ret = vk.verify(signature_der, msg, hashfunc=sha256)

		elif(sbc_auth_alg == AUTH_ECDSA_NISTP384):
			vk = VerifyingKey.from_der(pubk)
			ret = vk.verify(signature_der, msg, hashfunc=sha384)

		elif(sbc_auth_alg == AUTH_ECDSA_NISTP192):
			vk = VerifyingKey.from_der(pubk)
			ret = vk.verify(signature_der, msg, hashfunc=sha1)

		elif(sbc_auth_alg == AUTH_ECDSA_NISTP224):
			vk = VerifyingKey.from_der(pubk)
			ret = vk.verify(signature_der, msg, hashfunc=sha224)
		return ret
	def gen_key_string(self, sbc_auth_alg):
		if(sbc_auth_alg == AUTH_ECDSA_NISTP256):
			sk = SigningKey.generate(curve=NIST256p, hashfunc=sha256)
			vk = sk.get_verifying_key()
		elif(sbc_auth_alg == AUTH_ECDSA_NISTP384):
			sk = SigningKey.generate(curve=NIST384p, hashfunc=sha384)
			vk = sk.get_verifying_key()
		elif(sbc_auth_alg == AUTH_ECDSA_NISTP192):
			sk = SigningKey.generate(curve=NIST192p, hashfunc=sha1)
			vk = sk.get_verifying_key()
		elif(sbc_auth_alg == AUTH_ECDSA_NISTP224):
			sk = SigningKey.generate(curve=NIST224p, hashfunc=sha224)
			vk = sk.get_verifying_key()
		privk_str = sk.to_string()
		pubk_str = vk.to_string()
		return privk_str, pubk_str
	def gen_key_pem(self, sbc_auth_alg):
		if(sbc_auth_alg == AUTH_ECDSA_NISTP256):
			sk = SigningKey.generate(curve=NIST256p, hashfunc=sha256)
			vk = sk.get_verifying_key()
		elif(sbc_auth_alg == AUTH_ECDSA_NISTP384):
			sk = SigningKey.generate(curve=NIST384p, hashfunc=sha384)
			vk = sk.get_verifying_key()
		elif(sbc_auth_alg == AUTH_ECDSA_NISTP192):
			sk = SigningKey.generate(curve=NIST192p, hashfunc=sha1)
			vk = sk.get_verifying_key()
		elif(sbc_auth_alg == AUTH_ECDSA_NISTP224):
			sk = SigningKey.generate(curve=NIST224p, hashfunc=sha224)
			vk = sk.get_verifying_key()
		privk_pem = sk.to_pem()
		pubk_pem = vk.to_pem()
		return privk_pem, pubk_pem
	def gen_key_der(self, sbc_auth_alg):
		if(sbc_auth_alg == AUTH_ECDSA_NISTP256):
			sk = SigningKey.generate(curve=NIST256p, hashfunc=sha256)
			vk = sk.get_verifying_key()
		elif(sbc_auth_alg == AUTH_ECDSA_NISTP384):
			sk = SigningKey.generate(curve=NIST384p, hashfunc=sha384)
			vk = sk.get_verifying_key()
		elif(sbc_auth_alg == AUTH_ECDSA_NISTP384):
			sk = SigningKey.generate(curve=NIST192p, hashfunc=sha1)
			vk = sk.get_verifying_key()
		elif(sbc_auth_alg == AUTH_ECDSA_NISTP224):
			sk = SigningKey.generate(curve=NIST224p, hashfunc=sha224)
			vk = sk.get_verifying_key()
		privk_der = sk.to_der()
		pubk_der = vk.to_der()
		return privk_der, pubk_der

class AESCipher:
	def __init__(self, key, blk_sz):
		#self.key = md5(key.encode('utf8')).hexdigest()
		self.key = key
		self.blk_sz = blk_sz
		keylen = len(key)
		if(keylen != blk_sz):
		    print("ERROR: key length fail:")
		    return 0

	def aes_encrypt(self, data):
		#data = pad(data)
		#print(":".join("{:02x}".format(ord(e)) for e in data))
		cryptor = AES.new(self.key, AES.MODE_ECB)
		return cryptor.encrypt(data)

	def aes_decrypt(self, data):
		#data = pad(data)
		#print(":".join("{:02x}".format(ord(e)) for e in data))
		cryptor = AES.new(self.key, AES.MODE_ECB)
		return cryptor.decrypt(data)

	def aes_cbc_encrypt(self, data, iv):
		cryptor = AES.new(self.key, AES.MODE_CBC, iv)
		return cryptor.encrypt(data)

	def aes_cbc_decrypt(self, data, iv):
		cryptor = AES.new(self.key, AES.MODE_CBC, iv)
		return cryptor.decrypt(data)

	def aes_ctr_encrypt_only_counter(self, data, prefix_const, init_counter):
		#ctr_e = Counter.new(64, prefix = prefix_const)
		#cryptor = AES.new(self.key, AES.MODE_CTR, counter=lambda: init_counter)

		ctr_e = Counter.new(128, initial_value=long(init_counter.encode('hex'), 16), allow_wraparound=True)
		cryptor = AES.new(self.key, AES.MODE_CTR, counter=ctr_e)

		return cryptor.encrypt(data)

	def aes_ctr_decrypt_only_counter(self, data, prefix_const, init_counter):
		#ctr_d = Counter.new(128, prefix = prefix_const)
		#cryptor = AES.new(self.key, AES.MODE_CTR, counter=lambda: init_counter)

		ctr_d = Counter.new(128, initial_value=long(init_counter.encode('hex'), 16), allow_wraparound=True)
		cryptor = AES.new(self.key, AES.MODE_CTR, counter=ctr_d)
		return cryptor.decrypt(data)

	def aes_ctr_encrypt(self, data, prefix_str, initvalue):
		#print("0x%x" %long(initvalue.encode('hex'), 16))
		#print(len(prefix_str))
		nbits = (128 - (len(prefix_str)*8))
		ctr_e = Counter.new(nbits, prefix = prefix_str, initial_value=long(initvalue.encode('hex'), 16), allow_wraparound=True)
		cryptor = AES.new(self.key, AES.MODE_CTR, counter=ctr_e)

		return cryptor.encrypt(data)

	def aes_ctr_decrypt(self, data, prefix_str, initvalue):
		nbits = (128 - (len(prefix_str)*8))
		ctr_d = Counter.new(nbits, prefix = prefix_str, initial_value=long(initvalue.encode('hex'), 16), allow_wraparound=True)
		cryptor = AES.new(self.key, AES.MODE_CTR, counter=ctr_d)

		return cryptor.decrypt(data)


def strip_key(key):
    #src_key = key.lstrip("x").rstrip("L")
    src_key = key[2:].rstrip("L")
    key_byte = binascii.a2b_hex(src_key)
    return key_byte

def my_a2b_hex(key):
    key_byte = binascii.a2b_hex(key)
    return key_byte

def my_img_enc(data, key, iv, img_enc_alg, align=None):
    #dump(data)

    #align
    bin = crypto_pad_to_align(data, align)

    if(img_enc_alg == 0):
        # AES 128 ECB
        aes = AESCipher(key, 16)
        encmsg = aes.aes_encrypt(bin)
        #print("AES 128 ECB image result:")
        #dump(encmsg)
    elif(img_enc_alg == 1):
        # AES 128 CBC
        aes = AESCipher(key, 16)
        encmsg = aes.aes_cbc_encrypt(bin, iv)
        #print("AES 128 CBC image result:")
        #dump(encmsg)
    elif(img_enc_alg == 2):
        # AES 256 ECB
        aes = AESCipher(key, 32)
        encmsg = aes.aes_encrypt(bin)
        #print("AES 256 ECB image result:")
        #dump(encmsg)
    elif(img_enc_alg == 3):
        # AES 256 CBC
        aes = AESCipher(key, 32)
        encmsg = aes.aes_cbc_encrypt(bin, iv)
        #print("AES 256 CBC image result:")
        #dump(encmsg)

    return encmsg

# dump str to bytes
def dump(data):
	for i in range(0, len(data)):
		print ("0x%02x,"%ord(data[i])),
		if(((i+1)%16) == 0):
			print("")

class HASH:
	def __init__(self):
		#print("//class HASH init")
                None

	def hash_sha1(self, data):
		#print("SHA1:")
		hash = SHA.new()
		hash.update(data)
		digest = hash.digest()
		return digest
	def hash_sha224(self, data):
		#print("SHA224:")
		hash = SHA224.new()
		hash.update(data)
		digest = hash.digest()
		return digest
	def hash_sha256(self, data):
		#print("SHA256:")
		hash = SHA256.new()
		hash.update(data)
		digest = hash.digest()
		return digest
	def hash_sha384(self, data):
		#print("SHA384:")
		hash = SHA384.new()
		hash.update(data)
		digest = hash.digest()
		return digest

	def hash_sha512(self, data):
		#print("SHA512:")
		hash = SHA512.new()
		hash.update(data)
		digest = hash.digest()
		return digest
	def hash_md5(self, data):
		#print("MD5:")
		hash = MD5.new()
		hash.update(data)
		digest = hash.digest()
		return digest

'''
def sb_hash(data, sbc_auth_alg):
    #print("run my_hash:")

    #myhash = HASH()

    if((sbc_auth_alg == 1) or (sbc_auth_alg == 5) ):
        sbhash = HASH()
        digest = sbhash.hash_sha384(data)
        return digest
    elif(sbc_auth_alg == 0) or (sbc_auth_alg == 2) or (sbc_auth_alg == 3) or (sbc_auth_alg == 4):
        sbhash = HASH()
        digest = sbhash.hash_sha256(data)
        return digest
    elif((sbc_auth_alg == 6)):
        sbhash = HASH()
        digest = sbhash.hash_sha512(data)
        return digest
    else:
        print("ERROR: run sb_hash fail")
'''
def sb_hash(data, sbc_auth_alg_hash):
    #print("run my_hash:")

    #myhash = HASH()

    if(sbc_auth_alg_hash == 0):
        sbhash = HASH()
        digest = sbhash.hash_sha256(data)
        return digest
    elif(sbc_auth_alg_hash == 1):
        sbhash = HASH()
        digest = sbhash.hash_sha384(data)
        return digest
    elif(sbc_auth_alg_hash == 2):
        sbhash = HASH()
        digest = sbhash.hash_sha512(data)
        return digest
    else:
        print("ERROR: run sb_hash fail")


def hmac_sha256(key, bdata):

    b = HMAC.new(key, digestmod=SHA256)
    b.update(bdata)
    digest = b.digest()
    #digest = b.hexdigest()
    #dump(digest)

    return digest

def aescmac(key, msg):
    #print("AES CMAC: ")
    cipher = CP_python_AES.new(key, CP_python_AES.MODE_CMAC)
    out = cipher.encrypt(msg)

    #outhex = cipher.encrypt(msg).encode('hex')
    #out = outhex.decode('hex')
    return out

def ecdsa_sign_nistp256_string(privk, msg, sbc_auth_alg_hash):
	ecdsa = pythonECDSA()
	signature = ecdsa.sign_string(privk, msg, AUTH_ECDSA_NISTP256, sbc_auth_alg_hash)

	return signature

def ecdsa_sign_nistp256_pem(privk, msg):
	ecdsa = pythonECDSA()
	signature = ecdsa.sign_pem(privk, msg, AUTH_ECDSA_NISTP256)
	return signature

def ecdsa_sign_nistp256_der(privk, msg):
	ecdsa = pythonECDSA()
	signature = ecdsa.sign_der(privk, msg, AUTH_ECDSA_NISTP256)

	return signature

def ecdsa_sign_nistp384_string(privk, msg, sbc_auth_alg_hash):
	ecdsa = pythonECDSA()
	signature = ecdsa.sign_string(privk, msg, AUTH_ECDSA_NISTP384, sbc_auth_alg_hash)
	return signature

def ecdsa_sign_nistp384_pem(privk, msg):
	ecdsa = pythonECDSA()
	signature = ecdsa.sign_pem(privk, msg, AUTH_ECDSA_NISTP384)

	return signature

def ecdsa_sign_nistp384_der(privk, msg):
	ecdsa = pythonECDSA()
	signature = ecdsa.sign_der(privk, msg, AUTH_ECDSA_NISTP384)

	return signature

def ecdsa_sign_nistp521_string(privk, msg, sbc_auth_alg_hash):
	ecdsa = pythonECDSA()
	signature = ecdsa.sign_string(privk, msg, AUTH_ECDSA_NISTP521, sbc_auth_alg_hash)
	return signature

def pubkey_string(pubk, sbc_auth_alg):
	sk = VerifyingKey.from_pem(pubk)
	return sk.to_string()
def privkey_string(privk, sbc_auth_alg):
	if(sbc_auth_alg == AUTH_ECDSA_NISTP256):
		sk = SigningKey.from_pem(privk, hashfunc=sha256)
		return sk.to_string()
	else:
		sk = SigningKey.from_pem(privk, hashfunc=sha384)
		return sk.to_string()

def sb_sign(privk, pubk, msg, sbc_auth_alg, sbc_auth_alg_hash, rsa_parse, sbc_rsa_pad_sel, key_mode=__K_STRING):
    print("Start sb_sign:")

    if(sbc_auth_alg == AUTH_ECDSA_NISTP256):
        #pyelliptic ECDSA NIST p256
        if(key_mode == __K_STRING):
            signature = ecdsa_sign_nistp256_string(privk, msg, sbc_auth_alg_hash)
            #another use
            #ecdsa = pythonECDSA()
	    #signature = ecdsa.sign_string(privk, msg, AUTH_ECDSA_NISTP256)

        elif(key_mode == __K_PEM):
            signature = ecdsa_sign_nistp256_pem(privk, msg)

        elif(key_mode == __K_DER):
            signature = ecdsa_sign_nistp256_der(privk, msg)
        return signature

    elif(sbc_auth_alg == AUTH_ECDSA_NISTP384):
        #pyelliptic ECDSA_NIST_p384
        if(key_mode == __K_STRING):
            signature = ecdsa_sign_nistp384_string(privk, msg, sbc_auth_alg_hash)

        elif(key_mode == __K_PEM):
            signature = ecdsa_sign_nistp384_pem(privk, msg)

        elif(key_mode == __K_DER):
            signature = ecdsa_sign_nistp384_der(privk, msg)

        return signature

    elif(sbc_auth_alg == AUTH_ECDSA_NISTP521):
        #pyelliptic ECDSA_NIST_p521
        if(key_mode == __K_STRING):
            signature = ecdsa_sign_nistp521_string(privk, msg, sbc_auth_alg_hash)
        return signature	
    elif(sbc_auth_alg == AUTH_RSA2048):
        if(sbc_rsa_pad_sel == 0):
            print("auth rsa2048 pkcs1_v15 padding")
            myrsa = rsa_mytest.sbc_rsa_sign1_mytest(rsa_parse, msg)
            print("mytest rsa pkcs1_15 sign:")
            signature = myrsa.sbc_rsa_sign1_json()
            print("mytest rsa pkcs1_15 verify:")
            myrsa.sbc_rsa_verify1()
        elif(sbc_rsa_pad_sel == 1):
            print("auth rsa2048 pkcs1_pss padding")
            myrsa = rsa_pss_mytest.testSign1_mytest(rsa_parse, msg)
            print("mytest rsa pkcs1_pss sign:")
            signature = myrsa.sbc_rsa_sign1_json()
            print("mytest rsa pkcs1_pss verify:")
            myrsa.verify1_mytest()
        else:
            print("ERROR: padding selection fail")
        return signature

    elif(sbc_auth_alg == AUTH_RSA3072):
        if(sbc_rsa_pad_sel == 0):
            print("auth rsa3072 pkcs1_v15 padding")
            myrsa = rsa_mytest.sbc_rsa_sign1_mytest(rsa_parse, msg)
            print("mytest rsa pkcs1_15 sign:")
            signature = myrsa.sbc_rsa_sign1_json()
            print("mytest rsa pkcs1_15 verify:")
            myrsa.sbc_rsa_verify1()
        elif(sbc_rsa_pad_sel == 1):
            print("auth rsa3072 pkcs1_pss padding")
            myrsa = rsa_pss_mytest.testSign1_mytest(rsa_parse, msg)
            print("mytest rsa pkcs1_pss sign:")
            signature = myrsa.sbc_rsa_sign1_json()
            print("mytest rsa pkcs1_pss verify:")
            myrsa.verify1_mytest()
        else:
            print("ERROR: padding selection fail")
        return signature

    elif(sbc_auth_alg == AUTH_RSA4096):
        if(sbc_rsa_pad_sel == 0):
            print("auth rsa4096 pkcs1_v15 padding")
            myrsa = rsa_mytest.sbc_rsa_sign1_mytest(rsa_parse, msg)
            print("mytest rsa pkcs1_15 sign:")
            signature = myrsa.sbc_rsa_sign1_json()
            print("mytest rsa pkcs1_15 verify:")
            myrsa.sbc_rsa_verify1()
        elif(sbc_rsa_pad_sel == 1):
            print("auth rsa4096 pkcs1_pss padding")
            myrsa = rsa_pss_mytest.testSign1_mytest(rsa_parse, msg)
            print("mytest rsa pkcs1_pss sign:")
            signature = myrsa.sbc_rsa_sign1_json()
            print("mytest rsa pkcs1_pss verify:")
            myrsa.verify1_mytest()
        else:
            print("ERROR: padding selection fail")
        return signature

    elif(sbc_auth_alg == AUTH_AES_CMAC):
        #AES128_CMAC
        signature = aescmac(privk, msg)
        return signature
    elif(sbc_auth_alg == AUTH_HMAC_SHA256):
        #HMAC-SHA256
        signature = hmac_sha256(privk, msg)
        return signature
    else:
        print("ERROR: wrong authentication algorithm!!")

