// SPDX-License-Identifier: GPL-2.0

/*

 * Copyright (c) 2019 MediaTek Inc.

 */


#include <linux/clk-provider.h>
#include <linux/platform_device.h>

#include "clk-mtk.h"
#include "clk-gate.h"

#include <dt-bindings/clock/mt6880-clk.h>

#define MT_CLKMGR_MODULE_INIT	0

#define MT_CCF_BRINGUP		1

#define INV_OFS			-1



static const struct mtk_gate_regs mm_cg_regs = {
	.set_ofs = 0x104,
	.clr_ofs = 0x108,
	.sta_ofs = 0x100,
};

#define GATE_MM(_id, _name, _parent, _shift) {	\
		.id = _id,				\
		.name = _name,				\
		.parent_name = _parent,			\
		.regs = &mm_cg_regs,			\
		.shift = _shift,			\
		.ops = &mtk_clk_gate_ops_setclr,	\
	}

static const struct mtk_gate mm_clks[] = {
	GATE_MM(CLK_MMSYS_MUTEX0, "mmsys_mutex0",
			"mm_ck"/* parent */, 0),
	GATE_MM(CLK_MMSYS_APB_BUS, "mmsys_apb_bus",
			"mm_ck"/* parent */, 1),
	GATE_MM(CLK_MM_MDP_RSZ0, "mm_mdp_rsz0",
			"mm_ck"/* parent */, 2),
	GATE_MM(CLK_MM_DISP_GAMMA0, "mm_disp_gamma0",
			"mm_ck"/* parent */, 3),
	GATE_MM(CLK_MM_MDP_WROT0, "mm_mdp_wrot0",
			"mm_ck"/* parent */, 4),
	GATE_MM(CLK_MM_DISP_COLOR0, "mm_disp_color0",
			"mm_ck"/* parent */, 5),
	GATE_MM(CLK_MM_DISP_CCORR0, "mm_disp_ccorr0",
			"mm_ck"/* parent */, 6),
	GATE_MM(CLK_MM_DISP_AAL0, "mm_disp_aal0",
			"mm_ck"/* parent */, 7),
	GATE_MM(CLK_MM_DISP_RDMA0, "mm_disp_rdma0",
			"mm_ck"/* parent */, 8),
	GATE_MM(CLK_MM_MDP_RDMA0, "mm_mdp_rdma0",
			"mm_ck"/* parent */, 9),
	GATE_MM(CLK_MMSYS_FAKE_ENG0, "mmsys_fake_eng0",
			"mm_ck"/* parent */, 10),
	GATE_MM(CLK_MM_DISP_DITHER0, "mm_disp_dither0",
			"mm_ck"/* parent */, 11),
	GATE_MM(CLK_MM_DISP_WDMA0, "mm_disp_wdma0",
			"mm_ck"/* parent */, 12),
	GATE_MM(CLK_MM_MDP_TDSHP0, "mm_mdp_tdshp0",
			"mm_ck"/* parent */, 13),
	GATE_MM(CLK_MM_DISP_OVL0, "mm_disp_ovl0",
			"mm_ck"/* parent */, 14),
	GATE_MM(CLK_MM_DBPI0, "mm_dbpi0",
			"mm_ck"/* parent */, 15),
	GATE_MM(CLK_MM_DISP_DSI0, "mm_disp_dsi0",
			"mm_ck"/* parent */, 16),
	GATE_MM(CLK_MMSYS_SMI_COMMON, "mmsys_smi_common",
			"mm_ck"/* parent */, 17),
};

static int clk_mt6880_mm_probe(struct platform_device *pdev)
{
	struct clk_onecell_data *clk_data;
	int r;
	struct device_node *node = pdev->dev.of_node;

#if MT_CCF_BRINGUP
	pr_notice("%s init begin\n", __func__);
#endif

	clk_data = mtk_alloc_clk_data(CLK_MM_NR_CLK);

	mtk_clk_register_gates(node, mm_clks, ARRAY_SIZE(mm_clks),
			clk_data);

	r = of_clk_add_provider(node, of_clk_src_onecell_get, clk_data);

	if (r)
		pr_err("%s(): could not register clock provider: %d\n",
			__func__, r);

#if MT_CCF_BRINGUP
	pr_notice("%s init end\n", __func__);
#endif

	return r;
}

static const struct of_device_id of_match_clk_mt6880_mm[] = {
	{ .compatible = "mediatek,mt6880-mmsys_config", },
	{}
};

#if MT_CLKMGR_MODULE_INIT

static struct platform_driver clk_mt6880_mm_drv = {
	.probe = clk_mt6880_mm_probe,
	.driver = {
		.name = "clk-mt6880-mm",
		.of_match_table = of_match_clk_mt6880_mm,
	},
};

builtin_platform_driver(clk_mt6880_mm_drv);

#else

static struct platform_driver clk_mt6880_mm_drv = {
	.probe = clk_mt6880_mm_probe,
	.driver = {
		.name = "clk-mt6880-mm",
		.of_match_table = of_match_clk_mt6880_mm,
	},
};
static int __init clk_mt6880_mm_platform_init(void)
{
	return platform_driver_register(&clk_mt6880_mm_drv);
}
arch_initcall(clk_mt6880_mm_platform_init);

#endif	/* MT_CLKMGR_MODULE_INIT */
