/* SPDX-License-Identifier: GPL-2.0 */
/*
 * Copyright (C) 2015 MediaTek Inc.
 */

#ifndef __CCCI_PLATFORM_H__
#define __CCCI_PLATFORM_H__

//#include <mt-plat/sync_write.h>
#include "ccci_config.h"
#include "modem_sys.h"

#define INVALID_ADDR (0xF0000000)	/* the last EMI bank, properly not used */
#define KERN_EMI_BASE (0x40000000)	/* Bank4 */

/* - AP side, using mcu config base */
/* -- AP Bank4 */
#define AP_BANK4_MAP0 (0)	/* ((volatile unsigned int*)(MCUSYS_CFGREG_BASE+0x200)) */
#define AP_BANK4_MAP1 (0)	/* ((volatile unsigned int*)(MCUSYS_CFGREG_BASE+0x204)) */

/* - MD side, using infra config base */
#define DBG_FLAG_DEBUG		(1<<0)
#define DBG_FLAG_JTAG		(1<<1)
#define MD_DBG_JTAG_BIT		(1<<0)

#define ccci_write32(b, a, v)  \
do { \
	writel(v, (b) + (a)); \
	mb(); /* make sure register access in order */ \
} while (0)


#define ccci_write16(b, a, v)  \
do { \
	writew(v, (b) + (a)); \
	mb(); /* make sure register access in order */ \
} while (0)


#define ccci_write8(b, a, v)  \
do { \
	writeb(v, (b) + (a)); \
	mb(); /* make sure register access in order */ \
} while (0)

#define ccci_read32(b, a)               ioread32((void __iomem *)((b)+(a)))
#define ccci_read16(b, a)               ioread16((void __iomem *)((b)+(a)))
#define ccci_read8(b, a)                ioread8((void __iomem *)((b)+(a)))

/* INFRA */
#define INFRA_RST0_REG_PD (0x0150)/* rgu reset reg */
#define INFRA_RST1_REG_PD (0x0154)/* rgu clear reset reg */

#define INFRA_AP2MD_DUMMY_REG	(0x370)
#define INFRA_AP2MD_DUMMY_BIT	0
#define	INFRA_MD2PERI_PROT_EN	(0x250)
#define	INFRA_MD2PERI_PROT_RDY	(0x258)
#define	INFRA_MD2PERI_PROT_BIT	6

#define	INFRA_PERI2MD_PROT_EN	(0x220)
#define	INFRA_PERI2MD_PROT_RDY	(0x228)
#define	INFRA_PERI2MD_PROT_BIT	7

#define INFRA_AO_MD_SRCCLKENA    (0xF0C) /* SRC CLK ENA */


#ifdef SET_EMI_STEP_BY_STAGE
void ccci_set_mem_access_protection_1st_stage(struct ccci_modem *md);
void ccci_set_mem_access_protection_second_stage(int md_id);
#endif

unsigned int ccci_get_md_debug_mode(struct ccci_modem *md);
void ccci_get_platform_version(char *ver);

extern void *vmap_reserved_mem(phys_addr_t start, phys_addr_t size, pgprot_t prot);
int ccci_plat_common_init(void);
int ccci_platform_init(struct ccci_modem *md);
void ccci_reset_ccif_hw(unsigned char md_id,
			int ccif_id, void __iomem *baseA, void __iomem *baseB);
void ccci_set_clk_cg(struct ccci_modem *md, unsigned int is_on);
#ifdef ENABLE_DRAM_API
extern phys_addr_t get_max_DRAM_size(void);
extern unsigned int get_phys_offset(void);
#endif
int Is_MD_EMI_voilation(void);
#define MD_IN_DEBUG(md) (0)/* ((ccci_get_md_debug_mode(md)&(DBG_FLAG_JTAG|DBG_FLAG_DEBUG)) != 0) */
#endif	/* __CCCI_PLATFORM_H__ */
