/* SPDX-License-Identifier: GPL-2.0 */
/*
 * Copyright (c) 2019 MediaTek Inc.
 * Author Wy Chuang<wy.chuang@mediatek.com>
 */

#ifndef _MTK_BATTERY_TABLE_H
#define _MTK_BATTERY_TABLE_H

#include "mtk_battery.h"
/* ============================================================
 * define
 * ============================================================
 */

/* customize */
#define DIFFERENCE_FULLOCV_ITH	200	/* mA */
#define MTK_CHR_EXIST			1
#define KEEP_100_PERCENT		1
#define R_FG_VALUE				5	/* mOhm */
#define EMBEDDED_SEL			0
#define PMIC_SHUTDOWN_CURRENT	20	/* 0.01 mA */
#define FG_METER_RESISTANCE		100
#define CAR_TUNE_VALUE			100 /*1.00 */
#define NO_BAT_TEMP_COMPENSATE	0
/* NO_BAT_TEMP_COMPENSATE 1 = don't need bat_temper compensate, */
/* but fg_meter_resistance still use for SWOCV */

/* enable that soc = 0 , shutdown */
#define SHUTDOWN_GAUGE0			1

/* enable that uisoc = 1 and wait xmins then shutdown */
#define SHUTDOWN_GAUGE1_XMINS	1
/* define Xmins to shutdown*/
#define SHUTDOWN_1_TIME			5

#define SHUTDOWN_GAUGE1_VBAT_EN	0
#define SHUTDOWN_GAUGE1_VBAT	34000

#define SHUTDOWN_GAUGE0_VOLTAGE	34000

#define POWERON_SYSTEM_IBOOT	500	/* mA */

/*
 * LOW_TEMP_MODE = 0
 *	disable LOW_TEMP_MODE
 * LOW_TEMP_MODE = 1
 *	if battery temperautre < LOW_TEMP_MODE_TEMP
 *	when bootup , force C mode
 * LOW_TEMP_MODE = 2
 *	if battery temperautre < LOW_TEMP_MODE_TEMP
 *	force C mode
 */
#define LOW_TEMP_MODE			0
#define LOW_TEMP_MODE_TEMP		0

#define D0_SEL					0	/* not implement */
#define AGING_SEL				0	/* not implement */
#define DLPT_UI_REMAP_EN		0

/* ADC resistor  */
#define R_BAT_SENSE				4
#define R_I_SENSE				4
#define R_CHARGER_1				330
#define R_CHARGER_2				39

#define QMAX_SEL				1
#define IBOOT_SEL				0
#define SHUTDOWN_SYSTEM_IBOOT	15000	/* 0.1mA */
#define PMIC_MIN_VOL			33500

/*ui_soc related */
#define DIFFERENCE_FULL_CV		1000 /*0.01%*/
#define PSEUDO1_EN				1
#define PSEUDO100_EN			1
#define PSEUDO100_EN_DIS		1

#define DIFF_SOC_SETTING				100	/* 0.01% */
#define DIFF_BAT_TEMP_SETTING			1
#define DIFF_BAT_TEMP_SETTING_C			10
#define DISCHARGE_TRACKING_TIME			10
#define CHARGE_TRACKING_TIME			60
#define DIFFERENCE_FULLOCV_VTH			1000/* 0.1mV */
#define CHARGE_PSEUDO_FULL_LEVEL		8000
#define FULL_TRACKING_BAT_INT2_MULTIPLY 6

/* pre tracking */
#define FG_PRE_TRACKING_EN	1
#define VBAT2_DET_TIME		5
#define VBAT2_DET_COUNTER	6
#define VBAT2_DET_VOLTAGE1	34500
#define VBAT2_DET_VOLTAGE2	32000
#define VBAT2_DET_VOLTAGE3	35000

/* PCB setting */
#define CALIBRATE_CAR_TUNE_VALUE_BY_META_TOOL
#define CALI_CAR_TUNE_AVG_NUM	60

/* Aging Compensation 1*/
#define AGING_FACTOR_MIN			10
#define AGING_FACTOR_DIFF			90
#define DIFFERENCE_VOLTAGE_UPDATE	50
#define AGING_ONE_EN				1
#define AGING1_UPDATE_SOC			30
#define AGING1_LOAD_SOC				70
#define AGING_TEMP_DIFF				10
#define AGING_100_EN				1

/* Aging Compensation 2*/
#define AGING_TWO_EN				1

/* Aging Compensation 3*/
#define AGING_THIRD_EN				1

/* threshold */
#define HWOCV_SWOCV_DIFF			300
#define HWOCV_SWOCV_DIFF_LT			1500
#define HWOCV_SWOCV_DIFF_LT_TEMP	5
#define HWOCV_OLDOCV_DIFF			300
#define HWOCV_OLDOCV_DIFF_CHR		800
#define SWOCV_OLDOCV_DIFF			300
#define SWOCV_OLDOCV_DIFF_CHR		800
#define VBAT_OLDOCV_DIFF			1000
#define SWOCV_OLDOCV_DIFF_EMB		1000	/* 100mV */

#define VIR_OLDOCV_DIFF_EMB			10000	/* 1000mV */
#define VIR_OLDOCV_DIFF_EMB_LT		10000	/* 1000mV */
#define VIR_OLDOCV_DIFF_EMB_TMP		5

#define TNEW_TOLD_PON_DIFF			5
#define TNEW_TOLD_PON_DIFF2			15
#define PMIC_SHUTDOWN_TIME			30
#define BAT_PLUG_OUT_TIME			32
#define EXT_HWOCV_SWOCV				300
#define EXT_HWOCV_SWOCV_LT			1500
#define EXT_HWOCV_SWOCV_LT_TEMP		5

/* fgc & fgv threshold */
#define DIFFERENCE_FGC_FGV_TH1		300
#define DIFFERENCE_FGC_FGV_TH2		500
#define DIFFERENCE_FGC_FGV_TH3		300
#define DIFFERENCE_FGC_FGV_TH_SOC1	7000
#define DIFFERENCE_FGC_FGV_TH_SOC2	3000
#define NAFG_TIME_SETTING			10
#define NAFG_RATIO					100
#define NAFG_RATIO_EN				0
#define NAFG_RATIO_TMP_THR			1
#define NAFG_RESISTANCE				1500

#define PMIC_SHUTDOWN_SW_EN			1
/* 0: mix, 1:Coulomb, 2:voltage */
#define FORCE_VC_MODE				0

#define LOADING_1_EN				0
#define LOADING_2_EN				2
#define DIFF_IAVG_TH				3000

/* ZCV INTR */
#define ZCV_SUSPEND_TIME			3
#define SLEEP_CURRENT_AVG			200 /*0.1mA*/
#define ZCV_CAR_GAP_PERCENTAGE		5

/* Additional battery table */
#define ADDITIONAL_BATTERY_TABLE_EN 1

#define DC_RATIO_SEL				5
/* if set 0, dcr_start will not be 1*/
#define DC_R_CNT					1000

#define BAT_PAR_I					4000
#define PSEUDO1_SEL					2

#define FG_TRACKING_CURRENT				30000
#define FG_TRACKING_CURRENT_IBOOT_EN	0
#define UI_FAST_TRACKING_EN				0
#define UI_FAST_TRACKING_GAP			300
#define KEEP_100_PERCENT_MINSOC			9000


#define SHUTDOWN_CONDITION_LOW_BAT_VOLT
#define LOW_TEMP_DISABLE_LOW_BAT_SHUTDOWN	1
#define LOW_TEMP_THRESHOLD					5

#define BATTERY_TMP_TO_DISABLE_GM30				-50
#define BATTERY_TMP_TO_DISABLE_NAFG				-35
#define DEFAULT_BATTERY_TMP_WHEN_DISABLE_NAFG	25
#define BATTERY_TMP_TO_ENABLE_NAFG				-20
/* #define GM30_DISABLE_NAFG */

#define POWER_ON_CAR_CHR		5
#define POWER_ON_CAR_NOCHR		-35

#define SHUTDOWN_CAR_RATIO		1


/* different temp using different gauge 0% */
#define MULTI_TEMP_GAUGE0		1

#define OVER_DISCHARGE_LEVEL	-1500

#define UISOC_UPDATE_TYPE		0
/*
 *	uisoc_update_type:
 *	0: only ui_soc interrupt update ui_soc
 *	1: coulomb/nafg will update ui_soc if delta car > ht/lt_gap /2
 *	2: coulomb/nafg will update ui_soc
 */

/* using current to limit uisoc in 100% case*/
/* UI_FULL_LIMIT_ITH0 3000 means 300ma */
#define UI_FULL_LIMIT_EN	0
#define UI_FULL_LIMIT_SOC0	9900
#define UI_FULL_LIMIT_ITH0	2200

#define UI_FULL_LIMIT_SOC1	9900
#define UI_FULL_LIMIT_ITH1	2200

#define UI_FULL_LIMIT_SOC2	9900
#define UI_FULL_LIMIT_ITH2	2200

#define UI_FULL_LIMIT_SOC3	9900
#define UI_FULL_LIMIT_ITH3	2200

#define UI_FULL_LIMIT_SOC4	9900
#define UI_FULL_LIMIT_ITH4	2200

#define UI_FULL_LIMIT_TIME	99999


/* using voltage to limit uisoc in 1% case */
/* UI_LOW_LIMIT_VTH0=36000 means 3.6v */
#define UI_LOW_LIMIT_EN		0
#define UI_LOW_LIMIT_SOC0	200
#define UI_LOW_LIMIT_VTH0	34500
#define UI_LOW_LIMIT_SOC1	200
#define UI_LOW_LIMIT_VTH1	34500
#define UI_LOW_LIMIT_SOC2	200
#define UI_LOW_LIMIT_VTH2	34500
#define UI_LOW_LIMIT_SOC3	200
#define UI_LOW_LIMIT_VTH3	34500
#define UI_LOW_LIMIT_SOC4	200
#define UI_LOW_LIMIT_VTH4	34500
#define UI_LOW_LIMIT_TIME	99999

/* Qmax for battery  */
#define Q_MAX_L_CURRENT		0
#define Q_MAX_H_CURRENT		10000

/* multiple battery profile compile options */
/*#define MTK_GET_BATTERY_ID_BY_AUXADC*/


/* if ACTIVE_TABLE == 0 && MULTI_BATTERY == 0
 * load g_FG_PSEUDO100_Tx from dtsi
 */
#define MULTI_BATTERY			0
#define BATTERY_ID_CHANNEL_NUM	1
#define BATTERY_PROFILE_ID		0
#define TOTAL_BATTERY_NUMBER	4

/*
 * if ACTIVE_TABLE == 0 , use DTSI table
 * if ACTIVE_TABLE == x , use .h table
 * ACTIVE_TABLE <= MAX_TABLE
 */
#define ACTIVE_TABLE			0

/*#define MTK_GET_BATTERY_ID_BY_GPIO*/

/* Qmax for battery  */
int g_Q_MAX[MAX_TABLE][TOTAL_BATTERY_NUMBER] = {
	/*bat1,   bat2,   bat3,    bat4*/
	{ 2946, 2712, 2490, 1965},/*T0*/
	{ 2796, 2851, 2468, 1984},/*T1*/
	{ 2718, 2432, 2310, 1946},/*T2*/
	{ 2535, 1991, 1858, 1873},/*T3*/
	{ 2523, 1960, 1843, 1851},/*T4*/
	{ 2211, 1652, 1533, 1541},/*T5*/
	{ 2201, 1642, 1523, 1531},/*T6*/
	{ 2191, 1632, 1513, 1521},/*T7*/
	{ 2181, 1622, 1503, 1511},/*T8*/
	{ 2171, 1612, 1493, 1501} /*T9*/
};

int g_Q_MAX_H_CURRENT[MAX_TABLE][TOTAL_BATTERY_NUMBER] = {
	/*bat1,   bat2,   bat3,    bat4*/
	{ 2646, 2412, 2190, 1665},/*T0*/
	{ 2496, 2551, 2168, 1684},/*T1*/
	{ 2418, 2132, 2010, 1646},/*T2*/
	{ 2235, 1691, 1558, 1573},/*T3*/
	{ 2223, 1660, 1543, 1551},/*T4*/
	{ 2210, 1650, 1533, 1541},/*T5*/
	{ 2200, 1640, 1523, 1531},/*T6*/
	{ 2190, 1630, 1513, 1521},/*T7*/
	{ 2180, 1620, 1503, 1511},/*T8*/
	{ 2170, 1610, 1493, 1501} /*T9*/
};

int g_Q_MAX_SYS_VOLTAGE[TOTAL_BATTERY_NUMBER] = { 3400, 3400, 3400, 3400};

/* 0~0.5V for battery 0, 0.5~1V for battery 1*/
/* 1~1.5V for battery 2, -1 for the last one (battery 3) */
int g_battery_id_voltage[TOTAL_BATTERY_NUMBER] = {
	500000, 1000000, 1500000, -1};

int g_FG_PSEUDO1[MAX_TABLE][TOTAL_BATTERY_NUMBER] = {
	/*bat1,   bat2,   bat3,    bat4*/
	{ 5, 6, 7, 8},/*T0*/
	{ 9, 10, 11, 12},/*T1*/
	{ 13, 14, 15, 16},/*T2*/
	{ 17, 18, 19, 20},/*T3*/
	{ 21, 22, 23, 24},/*T4*/
	{ 23, 22, 21, 20},/*T5*/
	{ 19, 18, 17, 16},/*T6*/
	{ 15, 14, 13, 12},/*T7*/
	{ 11, 10, 11, 12},/*T8*/
	{ 13, 14, 15, 16} /*T9*/
};

int g_FG_PSEUDO100[MAX_TABLE][TOTAL_BATTERY_NUMBER] = {
	/*bat1,   bat2,   bat3,    bat4*/
	{ 100, 100, 100, 100},/*T0*/
	{ 100, 100, 100, 100},/*T1*/
	{ 100, 100, 100, 100},/*T2*/
	{ 100, 100, 100, 100},/*T3*/
	{ 100, 100, 100, 100},/*T4*/
	{ 100, 100, 100, 100},/*T5*/
	{ 100, 100, 100, 100},/*T6*/
	{ 100, 100, 100, 100},/*T7*/
	{ 100, 100, 100, 100},/*T8*/
	{ 100, 100, 100, 100} /*T9*/
};

/* shutdown_hl_zcv */
int g_SHUTDOWN_HL_ZCV[MAX_TABLE][TOTAL_BATTERY_NUMBER] = {
	/*bat1,   bat2,   bat3,    bat4*/
	{3400, 3410, 3420, 3430},/*T0*/
	{3450, 3460, 3470, 3480},/*T1*/
	{3500, 3510, 3520, 3530},/*T2*/
	{3550, 3460, 3470, 3480},/*T3*/
	{3600, 3610, 3620, 3630},/*T4*/
	{3601, 3611, 3621, 3631},/*T5*/
	{3602, 3612, 3622, 3632},/*T6*/
	{3603, 3613, 3623, 3633},/*T7*/
	{3604, 3614, 3624, 3634},/*T8*/
	{3605, 3615, 3625, 3635} /*T9*/
};

/* g_FG_PSEUDO1_OFFSET */
int g_FG_PSEUDO1_OFFSET[TOTAL_BATTERY_NUMBER] = {0, 0, 0, 0};

/* pmic_min_vol by temp ,control by MULTI_TEMP_GAUGE0=1, 34000=3.4v */
int g_PMIC_MIN_VOL[MAX_TABLE][TOTAL_BATTERY_NUMBER] = {
	/*bat1,   bat2,   bat3,    bat4*/
	{33500, 33500, 33500, 33500},/*T0*/
	{33500, 33500, 33500, 33500},/*T1*/
	{33500, 33500, 33500, 33500},/*T2*/
	{32200, 32200, 32200, 32200},/*T3*/
	{31000, 31000, 31000, 31000},/*T4*/
	{33001, 33006, 33009, 33004},/*T5*/
	{33002, 33007, 33008, 33003},/*T6*/
	{33003, 33008, 33007, 33002},/*T7*/
	{33004, 33009, 33006, 33001},/*T8*/
	{33005, 33010, 33005, 33000} /*T9*/
};

/* POWERON_SYSTEM_IBOOT by temp ,control by MULTI_TEMP_GAUGE0=1 ,5000 = 500ma*/
int g_PON_SYS_IBOOT[MAX_TABLE][TOTAL_BATTERY_NUMBER] = {
	/*bat1,   bat2,   bat3,    bat4*/
	{5000, 5000, 5000, 5000},/*T0*/
	{5000, 5000, 5000, 5000},/*T1*/
	{5000, 5000, 5000, 5000},/*T2*/
	{5000, 5000, 5000, 5000},/*T3*/
	{5000, 5000, 5000, 5000},/*T4*/
	{5000, 5000, 5000, 5000},/*T5*/
	{5000, 5000, 5000, 5000},/*T6*/
	{5000, 5000, 5000, 5000},/*T7*/
	{5000, 5000, 5000, 5000},/*T8*/
	{5000, 5000, 5000, 5000} /*T9*/
};

/* Q_MAX_SYS_VOLTAGE by temp ,control by MULTI_TEMP_GAUGE0=1, */
int g_QMAX_SYS_VOL[MAX_TABLE][TOTAL_BATTERY_NUMBER] = {
	/*bat1,   bat2,   bat3,    bat4*/
	{33500, 33500, 33500, 33500},/*T0*/
	{33500, 33500, 33500, 33500},/*T1*/
	{33500, 33500, 33500, 33500},/*T2*/
	{32900, 32900, 32900, 32900},/*T3*/
	{32800, 32800, 32800, 32800},/*T4*/
	{33500, 33500, 33500, 33500},/*T5*/
	{33500, 33500, 33500, 33500},/*T6*/
	{33500, 33500, 33500, 33500},/*T7*/
	{33500, 33500, 33500, 33500},/*T8*/
	{33500, 33500, 33500, 33500} /*T9*/
};


#define TEMPERATURE_TB0	255
#define TEMPERATURE_TB1	254

int g_temperature[MAX_TABLE] = {
	50,/*TEMPERATURE_T0*/
	25,/*TEMPERATURE_T1*/
	10,/*TEMPERATURE_T2*/
	0,/*TEMPERATURE_T3*/
	-10,/*TEMPERATURE_T4*/
	-25,/*TEMPERATURE_T5*/
	-30,/*TEMPERATURE_T6*/
	-35,/*TEMPERATURE_T7*/
	-40,/*TEMPERATURE_T8*/
	-45/*TEMPERATURE_T9*/
};


#define BAT_NTC_10 1
#define BAT_NTC_47 0

#if (BAT_NTC_10 == 1)
#define RBAT_PULL_UP_R             24000
#endif

#if (BAT_NTC_47 == 1)
#define RBAT_PULL_UP_R             61900
#endif

#define RBAT_PULL_UP_VOLT          2800

#define BIF_NTC_R 16000

#if (BAT_NTC_10 == 1)
struct fuelgauge_temperature Fg_Temperature_Table[21] = {
		{-40, 195652},
		{-35, 148171},
		{-30, 113347},
		{-25, 87559},
		{-20, 68237},
		{-15, 53650},
		{-10, 42506},
		{-5, 33892},
		{0, 27219},
		{5, 22021},
		{10, 17926},
		{15, 14674},
		{20, 12081},
		{25, 10000},
		{30, 8315},
		{35, 6948},
		{40, 5834},
		{45, 4917},
		{50, 4161},
		{55, 3535},
		{60, 3014}
};
#endif

#if (BAT_NTC_47 == 1)
struct fuelgauge_temperature Fg_Temperature_Table[21] = {
		{-40, 1747920},
		{-35, 1245428},
		{-30, 898485},
		{-25, 655802},
		{-20, 483954},
		{-15, 360850},
		{-10, 271697},
		{-5, 206463},
		{0, 158214},
		{5, 122259},
		{10, 95227},
		{15, 74730},
		{20, 59065},
		{25, 47000},
		{30, 37643},
		{35, 30334},
		{40, 24591},
		{45, 20048},
		{50, 16433},
		{55, 13539},
		{60, 11210}
};
#endif



/* ============================================================
 * <DOD, Battery_Voltage> Table
 * ============================================================
 */



/* T0 */
struct fuelgauge_profile_struct fg_profile_t0[TOTAL_BATTERY_NUMBER][100] = {
	{
		{0,	     43280, 975 },
		{301,	   43170, 975 },
		{601,	   43050, 1025},
		{902,	   42929, 1000},
		{1202,	 42819, 975 },
		{1503,	 42689, 950 },
		{1804,	 42579, 976 },
		{2104,	 42478, 1049},
		{2405,	 42348, 976 },
		{2705,	 42248, 1025},
		{3006,	 42148, 1050},
		{3307,	 42037, 1049},
		{3607,	 41917, 1026},
		{3908,	 41807, 1050},
		{4208,	 41707, 1050},
		{4509,	 41587, 1050},
		{4810,	 41483, 1052},
		{5110,	 41374, 1075},
		{5411,	 41282, 1075},
		{5712,	 41172, 1075},
		{6012,	 41063, 1073},
		{6313,	 40963, 1052},
		{6613,	 40871, 1075},
		{6914,	 40751, 1073},
		{7215,	 40643, 1060},
		{7515,	 40563, 1177},
		{7816,	 40482, 1196},
		{8116,	 40391, 1150},
		{8417,	 40292, 1146},
		{8718,	 40203, 1107},
		{9018,	 40122, 1175},
		{9319,	 40040, 1173},
		{9619,	 39942, 1152},
		{9920,	 39862, 1175},
		{10221,  39782, 1183},
		{10521,  39701, 1245},
		{10822,  39612, 1205},
		{11122,  39530, 1250},
		{11423,  39436, 1242},
		{11724,  39308, 1172},
		{12024,  39196, 1144},
		{12325,  39077, 1094},
		{12625,  38972, 1053},
		{12926,  38899, 1066},
		{13227,  38814, 1003},
		{13527,  38761, 1025},
		{13828,  38691, 1022},
		{14128,  38625, 1007},
		{14429,  38580, 1042},
		{14730,  38523, 1008},
		{15030,  38483, 1054},
		{15331,  38440, 1071},
		{15632,  38381, 1046},
		{15932,  38335, 1034},
		{16233,  38299, 1097},
		{16533,  38243, 1169},
		{16834,  38205, 1029},
		{17135,  38175, 1059},
		{17435,  38143, 1095},
		{17736,  38103, 1084},
		{18036,  38059, 1111},
		{18337,  38008, 1093},
		{18638,  37996, 1256},
		{18938,  37968, 1156},
		{19239,  37920, 1095},
		{19539,  37910, 1165},
		{19840,  37864, 1125},
		{20141,  37832, 1130},
		{20441,  37786, 1135},
		{20742,  37714, 1065},
		{21042,  37638, 1025},
		{21343,  37582, 1030},
		{21644,  37539, 1050},
		{21944,  37489, 1039},
		{22245,  37441, 1011},
		{22545,  37401, 1077},
		{22846,  37361, 1142},
		{23147,  37323, 1025},
		{23447,  37295, 1037},
		{23748,  37264, 1069},
		{24048,  37202, 1043},
		{24349,  37129, 1018},
		{24650,  37062, 1060},
		{24950,  37029, 1185},
		{25251,  36968, 1075},
		{25552,  36866, 1068},
		{25852,  36822, 1029},
		{26153,  36797, 989 },
		{26453,  36793, 1025},
		{26754,  36797, 1039},
		{27055,  36787, 1096},
		{27355,  36774, 1178},
		{27656,  36737, 1236},
		{27956,  36608, 1178},
		{28257,  36305, 1118},
		{28558,  35848, 1115},
		{28858,  35271, 1150},
		{29159,  34459, 1187},
		{29459,  33091, 1536},
		{29760,  29420, 8600}
	},
	{
		{0,	     43280, 975 },
		{301,	   43170, 975 },
		{601,	   43050, 1025},
		{902,	   42929, 1000},
		{1202,	 42819, 975 },
		{1503,	 42689, 950 },
		{1804,	 42579, 976 },
		{2104,	 42478, 1049},
		{2405,	 42348, 976 },
		{2705,	 42248, 1025},
		{3006,	 42148, 1050},
		{3307,	 42037, 1049},
		{3607,	 41917, 1026},
		{3908,	 41807, 1050},
		{4208,	 41707, 1050},
		{4509,	 41587, 1050},
		{4810,	 41483, 1052},
		{5110,	 41374, 1075},
		{5411,	 41282, 1075},
		{5712,	 41172, 1075},
		{6012,	 41063, 1073},
		{6313,	 40963, 1052},
		{6613,	 40871, 1075},
		{6914,	 40751, 1073},
		{7215,	 40643, 1060},
		{7515,	 40563, 1177},
		{7816,	 40482, 1196},
		{8116,	 40391, 1150},
		{8417,	 40292, 1146},
		{8718,	 40203, 1107},
		{9018,	 40122, 1175},
		{9319,	 40040, 1173},
		{9619,	 39942, 1152},
		{9920,	 39862, 1175},
		{10221,  39782, 1183},
		{10521,  39701, 1245},
		{10822,  39612, 1205},
		{11122,  39530, 1250},
		{11423,  39436, 1242},
		{11724,  39308, 1172},
		{12024,  39196, 1144},
		{12325,  39077, 1094},
		{12625,  38972, 1053},
		{12926,  38899, 1066},
		{13227,  38814, 1003},
		{13527,  38761, 1025},
		{13828,  38691, 1022},
		{14128,  38625, 1007},
		{14429,  38580, 1042},
		{14730,  38523, 1008},
		{15030,  38483, 1054},
		{15331,  38440, 1071},
		{15632,  38381, 1046},
		{15932,  38335, 1034},
		{16233,  38299, 1097},
		{16533,  38243, 1169},
		{16834,  38205, 1029},
		{17135,  38175, 1059},
		{17435,  38143, 1095},
		{17736,  38103, 1084},
		{18036,  38059, 1111},
		{18337,  38008, 1093},
		{18638,  37996, 1256},
		{18938,  37968, 1156},
		{19239,  37920, 1095},
		{19539,  37910, 1165},
		{19840,  37864, 1125},
		{20141,  37832, 1130},
		{20441,  37786, 1135},
		{20742,  37714, 1065},
		{21042,  37638, 1025},
		{21343,  37582, 1030},
		{21644,  37539, 1050},
		{21944,  37489, 1039},
		{22245,  37441, 1011},
		{22545,  37401, 1077},
		{22846,  37361, 1142},
		{23147,  37323, 1025},
		{23447,  37295, 1037},
		{23748,  37264, 1069},
		{24048,  37202, 1043},
		{24349,  37129, 1018},
		{24650,  37062, 1060},
		{24950,  37029, 1185},
		{25251,  36968, 1075},
		{25552,  36866, 1068},
		{25852,  36822, 1029},
		{26153,  36797, 989 },
		{26453,  36793, 1025},
		{26754,  36797, 1039},
		{27055,  36787, 1096},
		{27355,  36774, 1178},
		{27656,  36737, 1236},
		{27956,  36608, 1178},
		{28257,  36305, 1118},
		{28558,  35848, 1115},
		{28858,  35271, 1150},
		{29159,  34459, 1187},
		{29459,  33091, 1536},
		{29760,  29420, 8600}
	},
	{
		{0,	     43280, 975 },
		{301,	   43170, 975 },
		{601,	   43050, 1025},
		{902,	   42929, 1000},
		{1202,	 42819, 975 },
		{1503,	 42689, 950 },
		{1804,	 42579, 976 },
		{2104,	 42478, 1049},
		{2405,	 42348, 976 },
		{2705,	 42248, 1025},
		{3006,	 42148, 1050},
		{3307,	 42037, 1049},
		{3607,	 41917, 1026},
		{3908,	 41807, 1050},
		{4208,	 41707, 1050},
		{4509,	 41587, 1050},
		{4810,	 41483, 1052},
		{5110,	 41374, 1075},
		{5411,	 41282, 1075},
		{5712,	 41172, 1075},
		{6012,	 41063, 1073},
		{6313,	 40963, 1052},
		{6613,	 40871, 1075},
		{6914,	 40751, 1073},
		{7215,	 40643, 1060},
		{7515,	 40563, 1177},
		{7816,	 40482, 1196},
		{8116,	 40391, 1150},
		{8417,	 40292, 1146},
		{8718,	 40203, 1107},
		{9018,	 40122, 1175},
		{9319,	 40040, 1173},
		{9619,	 39942, 1152},
		{9920,	 39862, 1175},
		{10221,  39782, 1183},
		{10521,  39701, 1245},
		{10822,  39612, 1205},
		{11122,  39530, 1250},
		{11423,  39436, 1242},
		{11724,  39308, 1172},
		{12024,  39196, 1144},
		{12325,  39077, 1094},
		{12625,  38972, 1053},
		{12926,  38899, 1066},
		{13227,  38814, 1003},
		{13527,  38761, 1025},
		{13828,  38691, 1022},
		{14128,  38625, 1007},
		{14429,  38580, 1042},
		{14730,  38523, 1008},
		{15030,  38483, 1054},
		{15331,  38440, 1071},
		{15632,  38381, 1046},
		{15932,  38335, 1034},
		{16233,  38299, 1097},
		{16533,  38243, 1169},
		{16834,  38205, 1029},
		{17135,  38175, 1059},
		{17435,  38143, 1095},
		{17736,  38103, 1084},
		{18036,  38059, 1111},
		{18337,  38008, 1093},
		{18638,  37996, 1256},
		{18938,  37968, 1156},
		{19239,  37920, 1095},
		{19539,  37910, 1165},
		{19840,  37864, 1125},
		{20141,  37832, 1130},
		{20441,  37786, 1135},
		{20742,  37714, 1065},
		{21042,  37638, 1025},
		{21343,  37582, 1030},
		{21644,  37539, 1050},
		{21944,  37489, 1039},
		{22245,  37441, 1011},
		{22545,  37401, 1077},
		{22846,  37361, 1142},
		{23147,  37323, 1025},
		{23447,  37295, 1037},
		{23748,  37264, 1069},
		{24048,  37202, 1043},
		{24349,  37129, 1018},
		{24650,  37062, 1060},
		{24950,  37029, 1185},
		{25251,  36968, 1075},
		{25552,  36866, 1068},
		{25852,  36822, 1029},
		{26153,  36797, 989 },
		{26453,  36793, 1025},
		{26754,  36797, 1039},
		{27055,  36787, 1096},
		{27355,  36774, 1178},
		{27656,  36737, 1236},
		{27956,  36608, 1178},
		{28257,  36305, 1118},
		{28558,  35848, 1115},
		{28858,  35271, 1150},
		{29159,  34459, 1187},
		{29459,  33091, 1536},
		{29760,  29420, 8600}
	},
	{
		{0,	     43280, 975 },
		{301,	   43170, 975 },
		{601,	   43050, 1025},
		{902,	   42929, 1000},
		{1202,	 42819, 975 },
		{1503,	 42689, 950 },
		{1804,	 42579, 976 },
		{2104,	 42478, 1049},
		{2405,	 42348, 976 },
		{2705,	 42248, 1025},
		{3006,	 42148, 1050},
		{3307,	 42037, 1049},
		{3607,	 41917, 1026},
		{3908,	 41807, 1050},
		{4208,	 41707, 1050},
		{4509,	 41587, 1050},
		{4810,	 41483, 1052},
		{5110,	 41374, 1075},
		{5411,	 41282, 1075},
		{5712,	 41172, 1075},
		{6012,	 41063, 1073},
		{6313,	 40963, 1052},
		{6613,	 40871, 1075},
		{6914,	 40751, 1073},
		{7215,	 40643, 1060},
		{7515,	 40563, 1177},
		{7816,	 40482, 1196},
		{8116,	 40391, 1150},
		{8417,	 40292, 1146},
		{8718,	 40203, 1107},
		{9018,	 40122, 1175},
		{9319,	 40040, 1173},
		{9619,	 39942, 1152},
		{9920,	 39862, 1175},
		{10221,  39782, 1183},
		{10521,  39701, 1245},
		{10822,  39612, 1205},
		{11122,  39530, 1250},
		{11423,  39436, 1242},
		{11724,  39308, 1172},
		{12024,  39196, 1144},
		{12325,  39077, 1094},
		{12625,  38972, 1053},
		{12926,  38899, 1066},
		{13227,  38814, 1003},
		{13527,  38761, 1025},
		{13828,  38691, 1022},
		{14128,  38625, 1007},
		{14429,  38580, 1042},
		{14730,  38523, 1008},
		{15030,  38483, 1054},
		{15331,  38440, 1071},
		{15632,  38381, 1046},
		{15932,  38335, 1034},
		{16233,  38299, 1097},
		{16533,  38243, 1169},
		{16834,  38205, 1029},
		{17135,  38175, 1059},
		{17435,  38143, 1095},
		{17736,  38103, 1084},
		{18036,  38059, 1111},
		{18337,  38008, 1093},
		{18638,  37996, 1256},
		{18938,  37968, 1156},
		{19239,  37920, 1095},
		{19539,  37910, 1165},
		{19840,  37864, 1125},
		{20141,  37832, 1130},
		{20441,  37786, 1135},
		{20742,  37714, 1065},
		{21042,  37638, 1025},
		{21343,  37582, 1030},
		{21644,  37539, 1050},
		{21944,  37489, 1039},
		{22245,  37441, 1011},
		{22545,  37401, 1077},
		{22846,  37361, 1142},
		{23147,  37323, 1025},
		{23447,  37295, 1037},
		{23748,  37264, 1069},
		{24048,  37202, 1043},
		{24349,  37129, 1018},
		{24650,  37062, 1060},
		{24950,  37029, 1185},
		{25251,  36968, 1075},
		{25552,  36866, 1068},
		{25852,  36822, 1029},
		{26153,  36797, 989 },
		{26453,  36793, 1025},
		{26754,  36797, 1039},
		{27055,  36787, 1096},
		{27355,  36774, 1178},
		{27656,  36737, 1236},
		{27956,  36608, 1178},
		{28257,  36305, 1118},
		{28558,  35848, 1115},
		{28858,  35271, 1150},
		{29159,  34459, 1187},
		{29459,  33091, 1536},
		{29760,  29420, 8600}
	}

};

/* T1 */
struct fuelgauge_profile_struct fg_profile_t1[TOTAL_BATTERY_NUMBER][100] = {
		{
		{0,	     43200, 1050},
		{301,	   43080, 1300},
		{601,	   42960, 1350},
		{902,	   42839, 1300},
		{1202,	 42719, 1325},
		{1503,	 42619, 1350},
		{1804,	 42509, 1375},
		{2104,	 42388, 1401},
		{2405,	 42278, 1450},
		{2705,	 42168, 1450},
		{3006,	 42067, 1474},
		{3307,	 41938, 1449},
		{3607,	 41837, 1424},
		{3908,	 41727, 1400},
		{4208,	 41617, 1401},
		{4509,	 41527, 1450},
		{4810,	 41413, 1448},
		{5110,	 41313, 1425},
		{5411,	 41212, 1427},
		{5712,	 41093, 1448},
		{6012,	 40993, 1429},
		{6313,	 40893, 1475},
		{6613,	 40803, 1475},
		{6914,	 40716, 1481},
		{7215,	 40665, 1550},
		{7515,	 40599, 1550},
		{7816,	 40465, 1541},
		{8116,	 40289, 1454},
		{8417,	 40159, 1502},
		{8718,	 40043, 1525},
		{9018,	 39964, 1530},
		{9319,	 39905, 1589},
		{9619,	 39854, 1720},
		{9920,	 39792, 1670},
		{10221,  39712, 1625},
		{10521,  39628, 1617},
		{10822,  39509, 1550},
		{11122,  39408, 1545},
		{11423,  39297, 1497},
		{11724,  39177, 1472},
		{12024,  39060, 1447},
		{12325,  38970, 1419},
		{12625,  38884, 1381},
		{12926,  38830, 1413},
		{13227,  38754, 1328},
		{13527,  38703, 1350},
		{13828,  38644, 1350},
		{14128,  38591, 1340},
		{14429,  38523, 1279},
		{14730,  38483, 1308},
		{15030,  38438, 1342},
		{15331,  38377, 1313},
		{15632,  38355, 1371},
		{15932,  38321, 1354},
		{16233,  38271, 1371},
		{16533,  38225, 1354},
		{16834,  38193, 1366},
		{17135,  38155, 1334},
		{17435,  38124, 1380},
		{17736,  38094, 1405},
		{18036,  38062, 1425},
		{18337,  38022, 1416},
		{18638,  37988, 1389},
		{18938,  37972, 1450},
		{19239,  37934, 1450},
		{19539,  37904, 1450},
		{19840,  37870, 1440},
		{20141,  37824, 1390},
		{20441,  37792, 1355},
		{20742,  37752, 1375},
		{21042,  37712, 1380},
		{21343,  37672, 1400},
		{21644,  37629, 1400},
		{21944,  37584, 1395},
		{22245,  37554, 1386},
		{22545,  37523, 1425},
		{22846,  37491, 1419},
		{23147,  37453, 1406},
		{23447,  37418, 1413},
		{23748,  37364, 1381},
		{24048,  37304, 1387},
		{24349,  37239, 1337},
		{24650,  37172, 1320},
		{24950,  37129, 1368},
		{25251,  37048, 1343},
		{25552,  36982, 1318},
		{25852,  36960, 1321},
		{26153,  36957, 1382},
		{26453,  36942, 1393},
		{26754,  36920, 1396},
		{27055,  36909, 1450},
		{27355,  36863, 1471},
		{27656,  36743, 1504},
		{27956,  36423, 1457},
		{28257,  35951, 1497},
		{28558,  35341, 1579},
		{28858,  34475, 1731},
		{29159,  32837, 5201},
		{29459,  28212, 5733},
		{29760,  28180, 5625}
	},
	{
		{0,	     43200, 1050},
		{301,	   43080, 1300},
		{601,	   42960, 1350},
		{902,	   42839, 1300},
		{1202,	 42719, 1325},
		{1503,	 42619, 1350},
		{1804,	 42509, 1375},
		{2104,	 42388, 1401},
		{2405,	 42278, 1450},
		{2705,	 42168, 1450},
		{3006,	 42067, 1474},
		{3307,	 41938, 1449},
		{3607,	 41837, 1424},
		{3908,	 41727, 1400},
		{4208,	 41617, 1401},
		{4509,	 41527, 1450},
		{4810,	 41413, 1448},
		{5110,	 41313, 1425},
		{5411,	 41212, 1427},
		{5712,	 41093, 1448},
		{6012,	 40993, 1429},
		{6313,	 40893, 1475},
		{6613,	 40803, 1475},
		{6914,	 40716, 1481},
		{7215,	 40665, 1550},
		{7515,	 40599, 1550},
		{7816,	 40465, 1541},
		{8116,	 40289, 1454},
		{8417,	 40159, 1502},
		{8718,	 40043, 1525},
		{9018,	 39964, 1530},
		{9319,	 39905, 1589},
		{9619,	 39854, 1720},
		{9920,	 39792, 1670},
		{10221,  39712, 1625},
		{10521,  39628, 1617},
		{10822,  39509, 1550},
		{11122,  39408, 1545},
		{11423,  39297, 1497},
		{11724,  39177, 1472},
		{12024,  39060, 1447},
		{12325,  38970, 1419},
		{12625,  38884, 1381},
		{12926,  38830, 1413},
		{13227,  38754, 1328},
		{13527,  38703, 1350},
		{13828,  38644, 1350},
		{14128,  38591, 1340},
		{14429,  38523, 1279},
		{14730,  38483, 1308},
		{15030,  38438, 1342},
		{15331,  38377, 1313},
		{15632,  38355, 1371},
		{15932,  38321, 1354},
		{16233,  38271, 1371},
		{16533,  38225, 1354},
		{16834,  38193, 1366},
		{17135,  38155, 1334},
		{17435,  38124, 1380},
		{17736,  38094, 1405},
		{18036,  38062, 1425},
		{18337,  38022, 1416},
		{18638,  37988, 1389},
		{18938,  37972, 1450},
		{19239,  37934, 1450},
		{19539,  37904, 1450},
		{19840,  37870, 1440},
		{20141,  37824, 1390},
		{20441,  37792, 1355},
		{20742,  37752, 1375},
		{21042,  37712, 1380},
		{21343,  37672, 1400},
		{21644,  37629, 1400},
		{21944,  37584, 1395},
		{22245,  37554, 1386},
		{22545,  37523, 1425},
		{22846,  37491, 1419},
		{23147,  37453, 1406},
		{23447,  37418, 1413},
		{23748,  37364, 1381},
		{24048,  37304, 1387},
		{24349,  37239, 1337},
		{24650,  37172, 1320},
		{24950,  37129, 1368},
		{25251,  37048, 1343},
		{25552,  36982, 1318},
		{25852,  36960, 1321},
		{26153,  36957, 1382},
		{26453,  36942, 1393},
		{26754,  36920, 1396},
		{27055,  36909, 1450},
		{27355,  36863, 1471},
		{27656,  36743, 1504},
		{27956,  36423, 1457},
		{28257,  35951, 1497},
		{28558,  35341, 1579},
		{28858,  34475, 1731},
		{29159,  32837, 5201},
		{29459,  28212, 5733},
		{29760,  28180, 5625}
	},
	{
		{0,	     43200, 1050},
		{301,	   43080, 1300},
		{601,	   42960, 1350},
		{902,	   42839, 1300},
		{1202,	 42719, 1325},
		{1503,	 42619, 1350},
		{1804,	 42509, 1375},
		{2104,	 42388, 1401},
		{2405,	 42278, 1450},
		{2705,	 42168, 1450},
		{3006,	 42067, 1474},
		{3307,	 41938, 1449},
		{3607,	 41837, 1424},
		{3908,	 41727, 1400},
		{4208,	 41617, 1401},
		{4509,	 41527, 1450},
		{4810,	 41413, 1448},
		{5110,	 41313, 1425},
		{5411,	 41212, 1427},
		{5712,	 41093, 1448},
		{6012,	 40993, 1429},
		{6313,	 40893, 1475},
		{6613,	 40803, 1475},
		{6914,	 40716, 1481},
		{7215,	 40665, 1550},
		{7515,	 40599, 1550},
		{7816,	 40465, 1541},
		{8116,	 40289, 1454},
		{8417,	 40159, 1502},
		{8718,	 40043, 1525},
		{9018,	 39964, 1530},
		{9319,	 39905, 1589},
		{9619,	 39854, 1720},
		{9920,	 39792, 1670},
		{10221,  39712, 1625},
		{10521,  39628, 1617},
		{10822,  39509, 1550},
		{11122,  39408, 1545},
		{11423,  39297, 1497},
		{11724,  39177, 1472},
		{12024,  39060, 1447},
		{12325,  38970, 1419},
		{12625,  38884, 1381},
		{12926,  38830, 1413},
		{13227,  38754, 1328},
		{13527,  38703, 1350},
		{13828,  38644, 1350},
		{14128,  38591, 1340},
		{14429,  38523, 1279},
		{14730,  38483, 1308},
		{15030,  38438, 1342},
		{15331,  38377, 1313},
		{15632,  38355, 1371},
		{15932,  38321, 1354},
		{16233,  38271, 1371},
		{16533,  38225, 1354},
		{16834,  38193, 1366},
		{17135,  38155, 1334},
		{17435,  38124, 1380},
		{17736,  38094, 1405},
		{18036,  38062, 1425},
		{18337,  38022, 1416},
		{18638,  37988, 1389},
		{18938,  37972, 1450},
		{19239,  37934, 1450},
		{19539,  37904, 1450},
		{19840,  37870, 1440},
		{20141,  37824, 1390},
		{20441,  37792, 1355},
		{20742,  37752, 1375},
		{21042,  37712, 1380},
		{21343,  37672, 1400},
		{21644,  37629, 1400},
		{21944,  37584, 1395},
		{22245,  37554, 1386},
		{22545,  37523, 1425},
		{22846,  37491, 1419},
		{23147,  37453, 1406},
		{23447,  37418, 1413},
		{23748,  37364, 1381},
		{24048,  37304, 1387},
		{24349,  37239, 1337},
		{24650,  37172, 1320},
		{24950,  37129, 1368},
		{25251,  37048, 1343},
		{25552,  36982, 1318},
		{25852,  36960, 1321},
		{26153,  36957, 1382},
		{26453,  36942, 1393},
		{26754,  36920, 1396},
		{27055,  36909, 1450},
		{27355,  36863, 1471},
		{27656,  36743, 1504},
		{27956,  36423, 1457},
		{28257,  35951, 1497},
		{28558,  35341, 1579},
		{28858,  34475, 1731},
		{29159,  32837, 5201},
		{29459,  28212, 5733},
		{29760,  28180, 5625}
	},
	{
		{0,	     43200, 1050},
		{301,	   43080, 1300},
		{601,	   42960, 1350},
		{902,	   42839, 1300},
		{1202,	 42719, 1325},
		{1503,	 42619, 1350},
		{1804,	 42509, 1375},
		{2104,	 42388, 1401},
		{2405,	 42278, 1450},
		{2705,	 42168, 1450},
		{3006,	 42067, 1474},
		{3307,	 41938, 1449},
		{3607,	 41837, 1424},
		{3908,	 41727, 1400},
		{4208,	 41617, 1401},
		{4509,	 41527, 1450},
		{4810,	 41413, 1448},
		{5110,	 41313, 1425},
		{5411,	 41212, 1427},
		{5712,	 41093, 1448},
		{6012,	 40993, 1429},
		{6313,	 40893, 1475},
		{6613,	 40803, 1475},
		{6914,	 40716, 1481},
		{7215,	 40665, 1550},
		{7515,	 40599, 1550},
		{7816,	 40465, 1541},
		{8116,	 40289, 1454},
		{8417,	 40159, 1502},
		{8718,	 40043, 1525},
		{9018,	 39964, 1530},
		{9319,	 39905, 1589},
		{9619,	 39854, 1720},
		{9920,	 39792, 1670},
		{10221,  39712, 1625},
		{10521,  39628, 1617},
		{10822,  39509, 1550},
		{11122,  39408, 1545},
		{11423,  39297, 1497},
		{11724,  39177, 1472},
		{12024,  39060, 1447},
		{12325,  38970, 1419},
		{12625,  38884, 1381},
		{12926,  38830, 1413},
		{13227,  38754, 1328},
		{13527,  38703, 1350},
		{13828,  38644, 1350},
		{14128,  38591, 1340},
		{14429,  38523, 1279},
		{14730,  38483, 1308},
		{15030,  38438, 1342},
		{15331,  38377, 1313},
		{15632,  38355, 1371},
		{15932,  38321, 1354},
		{16233,  38271, 1371},
		{16533,  38225, 1354},
		{16834,  38193, 1366},
		{17135,  38155, 1334},
		{17435,  38124, 1380},
		{17736,  38094, 1405},
		{18036,  38062, 1425},
		{18337,  38022, 1416},
		{18638,  37988, 1389},
		{18938,  37972, 1450},
		{19239,  37934, 1450},
		{19539,  37904, 1450},
		{19840,  37870, 1440},
		{20141,  37824, 1390},
		{20441,  37792, 1355},
		{20742,  37752, 1375},
		{21042,  37712, 1380},
		{21343,  37672, 1400},
		{21644,  37629, 1400},
		{21944,  37584, 1395},
		{22245,  37554, 1386},
		{22545,  37523, 1425},
		{22846,  37491, 1419},
		{23147,  37453, 1406},
		{23447,  37418, 1413},
		{23748,  37364, 1381},
		{24048,  37304, 1387},
		{24349,  37239, 1337},
		{24650,  37172, 1320},
		{24950,  37129, 1368},
		{25251,  37048, 1343},
		{25552,  36982, 1318},
		{25852,  36960, 1321},
		{26153,  36957, 1382},
		{26453,  36942, 1393},
		{26754,  36920, 1396},
		{27055,  36909, 1450},
		{27355,  36863, 1471},
		{27656,  36743, 1504},
		{27956,  36423, 1457},
		{28257,  35951, 1497},
		{28558,  35341, 1579},
		{28858,  34475, 1731},
		{29159,  32837, 5201},
		{29459,  28212, 5733},
		{29760,  28180, 5625}
	}

};

/* T2 */
struct fuelgauge_profile_struct fg_profile_t2[TOTAL_BATTERY_NUMBER][100] = {
	{
		{0,	     43030, 1900 },
		{301,    42880, 2100 },
		{601,	   42770, 2200 },
		{902,	   42649, 2225 },
		{1202,	 42519, 2200 },
		{1503,	 42409, 2225 },
		{1804,	 42299, 2225 },
		{2104,	 42179, 2225 },
		{2405,	 42078, 2250 },
		{2705,	 41978, 2250 },
		{3006,	 41868, 2275 },
		{3307,	 41748, 2276 },
		{3607,	 41648, 2301 },
		{3908,	 41557, 2325 },
		{4208,	 41447, 2326 },
		{4509,	 41337, 2351 },
		{4810,	 41233, 2375 },
		{5110,	 41123, 2375 },
		{5411,	 41023, 2375 },
		{5712,	 40925, 2377 },
		{6012,	 40856, 2404 },
		{6313,	 40796, 2458 },
		{6613,	 40742, 2550 },
		{6914,	 40639, 2546 },
		{7215,	 40494, 2498 },
		{7515,	 40307, 2475 },
		{7816,	 40150, 2479 },
		{8116,	 40029, 2523 },
		{8417,	 39913, 2504 },
		{8718,	 39835, 2555 },
		{9018,	 39785, 2598 },
		{9319,	 39733, 2577 },
		{9619,	 39665, 2600 },
		{9920,	 39610, 2598 },
		{10221,  39510, 2567 },
		{10521,  39408, 2492 },
		{10822,  39287, 2414 },
		{11122,  39168, 2320 },
		{11423,  39060, 2272 },
		{11724,  38972, 2253 },
		{12024,  38900, 2266 },
		{12325,  38813, 2203 },
		{12625,  38754, 2228 },
		{12926,  38700, 2241 },
		{13227,  38625, 2181 },
		{13527,  38583, 2225 },
		{13828,  38525, 2231 },
		{14128,  38485, 2278 },
		{14429,  38442, 2292 },
		{14730,  38392, 2242 },
		{15030,  38345, 2217 },
		{15331,  38313, 2300 },
		{15632,  38270, 2291 },
		{15932,  38215, 2259 },
		{16233,  38186, 2309 },
		{16533,  38163, 2346 },
		{16834,  38125, 2325 },
		{17135,  38093, 2325 },
		{17435,  38054, 2330 },
		{17736,  38024, 2345 },
		{18036,  37994, 2334 },
		{18337,  37966, 2375 },
		{18638,  37942, 2380 },
		{18938,  37906, 2395 },
		{19239,  37884, 2375 },
		{19539,  37858, 2385 },
		{19840,  37840, 2410 },
		{20141,  37798, 2355 },
		{20441,  37784, 2385 },
		{20742,  37754, 2415 },
		{21042,  37720, 2375 },
		{21343,  37676, 2375 },
		{21644,  37652, 2375 },
		{21944,  37611, 2370 },
		{22245,  37576, 2366 },
		{22545,  37549, 2420 },
		{22846,  37499, 2400 },
		{23147,  37449, 2411 },
		{23447,  37398, 2444 },
		{23748,  37347, 2444 },
		{24048,  37292, 2480 },
		{24349,  37222, 2432 },
		{24650,  37149, 2450 },
		{24950,  37077, 2463 },
		{25251,  37032, 2493 },
		{25552,  37013, 2509 },
		{25852,  37012, 2593 },
		{26153,  36990, 2616 },
		{26453,  36982, 2732 },
		{26754,  36949, 2806 },
		{27055,  36869, 2943 },
		{27355,  36626, 2918 },
		{27656,  36188, 2943 },
		{27956,  35608, 3108 },
		{28257,  34814, 3337 },
		{28558,  33483, 4112 },
		{28858,  30540, 11925},
		{29159,  30540, 11925},
		{29459,  30540, 11925},
		{29760,  30540, 11925}
	},
	{
		{0,	     43030, 1900 },
		{301,    42880, 2100 },
		{601,	   42770, 2200 },
		{902,	   42649, 2225 },
		{1202,	 42519, 2200 },
		{1503,	 42409, 2225 },
		{1804,	 42299, 2225 },
		{2104,	 42179, 2225 },
		{2405,	 42078, 2250 },
		{2705,	 41978, 2250 },
		{3006,	 41868, 2275 },
		{3307,	 41748, 2276 },
		{3607,	 41648, 2301 },
		{3908,	 41557, 2325 },
		{4208,	 41447, 2326 },
		{4509,	 41337, 2351 },
		{4810,	 41233, 2375 },
		{5110,	 41123, 2375 },
		{5411,	 41023, 2375 },
		{5712,	 40925, 2377 },
		{6012,	 40856, 2404 },
		{6313,	 40796, 2458 },
		{6613,	 40742, 2550 },
		{6914,	 40639, 2546 },
		{7215,	 40494, 2498 },
		{7515,	 40307, 2475 },
		{7816,	 40150, 2479 },
		{8116,	 40029, 2523 },
		{8417,	 39913, 2504 },
		{8718,	 39835, 2555 },
		{9018,	 39785, 2598 },
		{9319,	 39733, 2577 },
		{9619,	 39665, 2600 },
		{9920,	 39610, 2598 },
		{10221,  39510, 2567 },
		{10521,  39408, 2492 },
		{10822,  39287, 2414 },
		{11122,  39168, 2320 },
		{11423,  39060, 2272 },
		{11724,  38972, 2253 },
		{12024,  38900, 2266 },
		{12325,  38813, 2203 },
		{12625,  38754, 2228 },
		{12926,  38700, 2241 },
		{13227,  38625, 2181 },
		{13527,  38583, 2225 },
		{13828,  38525, 2231 },
		{14128,  38485, 2278 },
		{14429,  38442, 2292 },
		{14730,  38392, 2242 },
		{15030,  38345, 2217 },
		{15331,  38313, 2300 },
		{15632,  38270, 2291 },
		{15932,  38215, 2259 },
		{16233,  38186, 2309 },
		{16533,  38163, 2346 },
		{16834,  38125, 2325 },
		{17135,  38093, 2325 },
		{17435,  38054, 2330 },
		{17736,  38024, 2345 },
		{18036,  37994, 2334 },
		{18337,  37966, 2375 },
		{18638,  37942, 2380 },
		{18938,  37906, 2395 },
		{19239,  37884, 2375 },
		{19539,  37858, 2385 },
		{19840,  37840, 2410 },
		{20141,  37798, 2355 },
		{20441,  37784, 2385 },
		{20742,  37754, 2415 },
		{21042,  37720, 2375 },
		{21343,  37676, 2375 },
		{21644,  37652, 2375 },
		{21944,  37611, 2370 },
		{22245,  37576, 2366 },
		{22545,  37549, 2420 },
		{22846,  37499, 2400 },
		{23147,  37449, 2411 },
		{23447,  37398, 2444 },
		{23748,  37347, 2444 },
		{24048,  37292, 2480 },
		{24349,  37222, 2432 },
		{24650,  37149, 2450 },
		{24950,  37077, 2463 },
		{25251,  37032, 2493 },
		{25552,  37013, 2509 },
		{25852,  37012, 2593 },
		{26153,  36990, 2616 },
		{26453,  36982, 2732 },
		{26754,  36949, 2806 },
		{27055,  36869, 2943 },
		{27355,  36626, 2918 },
		{27656,  36188, 2943 },
		{27956,  35608, 3108 },
		{28257,  34814, 3337 },
		{28558,  33483, 4112 },
		{28858,  30540, 11925},
		{29159,  30540, 11925},
		{29459,  30540, 11925},
		{29760,  30540, 11925}
	},
	{
		{0,	     43030, 1900 },
		{301,    42880, 2100 },
		{601,	   42770, 2200 },
		{902,	   42649, 2225 },
		{1202,	 42519, 2200 },
		{1503,	 42409, 2225 },
		{1804,	 42299, 2225 },
		{2104,	 42179, 2225 },
		{2405,	 42078, 2250 },
		{2705,	 41978, 2250 },
		{3006,	 41868, 2275 },
		{3307,	 41748, 2276 },
		{3607,	 41648, 2301 },
		{3908,	 41557, 2325 },
		{4208,	 41447, 2326 },
		{4509,	 41337, 2351 },
		{4810,	 41233, 2375 },
		{5110,	 41123, 2375 },
		{5411,	 41023, 2375 },
		{5712,	 40925, 2377 },
		{6012,	 40856, 2404 },
		{6313,	 40796, 2458 },
		{6613,	 40742, 2550 },
		{6914,	 40639, 2546 },
		{7215,	 40494, 2498 },
		{7515,	 40307, 2475 },
		{7816,	 40150, 2479 },
		{8116,	 40029, 2523 },
		{8417,	 39913, 2504 },
		{8718,	 39835, 2555 },
		{9018,	 39785, 2598 },
		{9319,	 39733, 2577 },
		{9619,	 39665, 2600 },
		{9920,	 39610, 2598 },
		{10221,  39510, 2567 },
		{10521,  39408, 2492 },
		{10822,  39287, 2414 },
		{11122,  39168, 2320 },
		{11423,  39060, 2272 },
		{11724,  38972, 2253 },
		{12024,  38900, 2266 },
		{12325,  38813, 2203 },
		{12625,  38754, 2228 },
		{12926,  38700, 2241 },
		{13227,  38625, 2181 },
		{13527,  38583, 2225 },
		{13828,  38525, 2231 },
		{14128,  38485, 2278 },
		{14429,  38442, 2292 },
		{14730,  38392, 2242 },
		{15030,  38345, 2217 },
		{15331,  38313, 2300 },
		{15632,  38270, 2291 },
		{15932,  38215, 2259 },
		{16233,  38186, 2309 },
		{16533,  38163, 2346 },
		{16834,  38125, 2325 },
		{17135,  38093, 2325 },
		{17435,  38054, 2330 },
		{17736,  38024, 2345 },
		{18036,  37994, 2334 },
		{18337,  37966, 2375 },
		{18638,  37942, 2380 },
		{18938,  37906, 2395 },
		{19239,  37884, 2375 },
		{19539,  37858, 2385 },
		{19840,  37840, 2410 },
		{20141,  37798, 2355 },
		{20441,  37784, 2385 },
		{20742,  37754, 2415 },
		{21042,  37720, 2375 },
		{21343,  37676, 2375 },
		{21644,  37652, 2375 },
		{21944,  37611, 2370 },
		{22245,  37576, 2366 },
		{22545,  37549, 2420 },
		{22846,  37499, 2400 },
		{23147,  37449, 2411 },
		{23447,  37398, 2444 },
		{23748,  37347, 2444 },
		{24048,  37292, 2480 },
		{24349,  37222, 2432 },
		{24650,  37149, 2450 },
		{24950,  37077, 2463 },
		{25251,  37032, 2493 },
		{25552,  37013, 2509 },
		{25852,  37012, 2593 },
		{26153,  36990, 2616 },
		{26453,  36982, 2732 },
		{26754,  36949, 2806 },
		{27055,  36869, 2943 },
		{27355,  36626, 2918 },
		{27656,  36188, 2943 },
		{27956,  35608, 3108 },
		{28257,  34814, 3337 },
		{28558,  33483, 4112 },
		{28858,  30540, 11925},
		{29159,  30540, 11925},
		{29459,  30540, 11925},
		{29760,  30540, 11925}
	},
	{
		{0,	     43030, 1900 },
		{301,    42880, 2100 },
		{601,	   42770, 2200 },
		{902,	   42649, 2225 },
		{1202,	 42519, 2200 },
		{1503,	 42409, 2225 },
		{1804,	 42299, 2225 },
		{2104,	 42179, 2225 },
		{2405,	 42078, 2250 },
		{2705,	 41978, 2250 },
		{3006,	 41868, 2275 },
		{3307,	 41748, 2276 },
		{3607,	 41648, 2301 },
		{3908,	 41557, 2325 },
		{4208,	 41447, 2326 },
		{4509,	 41337, 2351 },
		{4810,	 41233, 2375 },
		{5110,	 41123, 2375 },
		{5411,	 41023, 2375 },
		{5712,	 40925, 2377 },
		{6012,	 40856, 2404 },
		{6313,	 40796, 2458 },
		{6613,	 40742, 2550 },
		{6914,	 40639, 2546 },
		{7215,	 40494, 2498 },
		{7515,	 40307, 2475 },
		{7816,	 40150, 2479 },
		{8116,	 40029, 2523 },
		{8417,	 39913, 2504 },
		{8718,	 39835, 2555 },
		{9018,	 39785, 2598 },
		{9319,	 39733, 2577 },
		{9619,	 39665, 2600 },
		{9920,	 39610, 2598 },
		{10221,  39510, 2567 },
		{10521,  39408, 2492 },
		{10822,  39287, 2414 },
		{11122,  39168, 2320 },
		{11423,  39060, 2272 },
		{11724,  38972, 2253 },
		{12024,  38900, 2266 },
		{12325,  38813, 2203 },
		{12625,  38754, 2228 },
		{12926,  38700, 2241 },
		{13227,  38625, 2181 },
		{13527,  38583, 2225 },
		{13828,  38525, 2231 },
		{14128,  38485, 2278 },
		{14429,  38442, 2292 },
		{14730,  38392, 2242 },
		{15030,  38345, 2217 },
		{15331,  38313, 2300 },
		{15632,  38270, 2291 },
		{15932,  38215, 2259 },
		{16233,  38186, 2309 },
		{16533,  38163, 2346 },
		{16834,  38125, 2325 },
		{17135,  38093, 2325 },
		{17435,  38054, 2330 },
		{17736,  38024, 2345 },
		{18036,  37994, 2334 },
		{18337,  37966, 2375 },
		{18638,  37942, 2380 },
		{18938,  37906, 2395 },
		{19239,  37884, 2375 },
		{19539,  37858, 2385 },
		{19840,  37840, 2410 },
		{20141,  37798, 2355 },
		{20441,  37784, 2385 },
		{20742,  37754, 2415 },
		{21042,  37720, 2375 },
		{21343,  37676, 2375 },
		{21644,  37652, 2375 },
		{21944,  37611, 2370 },
		{22245,  37576, 2366 },
		{22545,  37549, 2420 },
		{22846,  37499, 2400 },
		{23147,  37449, 2411 },
		{23447,  37398, 2444 },
		{23748,  37347, 2444 },
		{24048,  37292, 2480 },
		{24349,  37222, 2432 },
		{24650,  37149, 2450 },
		{24950,  37077, 2463 },
		{25251,  37032, 2493 },
		{25552,  37013, 2509 },
		{25852,  37012, 2593 },
		{26153,  36990, 2616 },
		{26453,  36982, 2732 },
		{26754,  36949, 2806 },
		{27055,  36869, 2943 },
		{27355,  36626, 2918 },
		{27656,  36188, 2943 },
		{27956,  35608, 3108 },
		{28257,  34814, 3337 },
		{28558,  33483, 4112 },
		{28858,  30540, 11925},
		{29159,  30540, 11925},
		{29459,  30540, 11925},
		{29760,  30540, 11925}
	}

};

/* T3 */
struct fuelgauge_profile_struct fg_profile_t3[TOTAL_BATTERY_NUMBER][100] = {
	{
		{0,	     42730, 2575 },
		{301,	   42550, 3300 },
		{601,	   42409, 3375 },
		{902,	   42269, 3475 },
		{1202,	 42159, 3526 },
		{1503,	 42059, 3600 },
		{1804,	 41949, 3601 },
		{2104,	 41848, 3675 },
		{2405,	 41738, 3700 },
		{2705,	 41638, 3725 },
		{3006,	 41538, 3750 },
		{3307,	 41418, 3751 },
		{3607,	 41318, 3801 },
		{3908,	 41217, 3825 },
		{4208,	 41107, 3826 },
		{4509,	 41017, 3851 },
		{4810,	 40926, 3875 },
		{5110,	 40868, 3885 },
		{5411,	 40834, 4028 },
		{5712,	 40749, 4070 },
		{6012,	 40587, 4002 },
		{6313,	 40414, 4021 },
		{6613,	 40208, 3975 },
		{6914,	 40060, 3973 },
		{7215,	 39932, 3954 },
		{7515,	 39833, 4002 },
		{7816,	 39753, 4025 },
		{8116,	 39676, 4027 },
		{8417,	 39624, 4050 },
		{8718,	 39554, 4048 },
		{9018,	 39490, 4018 },
		{9319,	 39381, 3948 },
		{9619,	 39289, 3918 },
		{9920,	 39179, 3840 },
		{10221,  39072, 3750 },
		{10521,  38991, 3747 },
		{10822,  38903, 3725 },
		{11122,  38832, 3714 },
		{11423,  38763, 3633 },
		{11724,  38706, 3706 },
		{12024,  38663, 3750 },
		{12325,  38604, 3747 },
		{12625,  38554, 3728 },
		{12926,  38503, 3753 },
		{13227,  38445, 3778 },
		{13527,  38405, 3803 },
		{13828,  38364, 3819 },
		{14128,  38316, 3785 },
		{14429,  38282, 3850 },
		{14730,  38235, 3858 },
		{15030,  38203, 3896 },
		{15331,  38165, 3883 },
		{15632,  38133, 3929 },
		{15932,  38095, 3950 },
		{16233,  38065, 3959 },
		{16533,  38033, 3991 },
		{16834,  37996, 3959 },
		{17135,  37975, 4005 },
		{17435,  37946, 4030 },
		{17736,  37924, 4050 },
		{18036,  37896, 4059 },
		{18337,  37876, 4109 },
		{18638,  37852, 4140 },
		{18938,  37818, 4105 },
		{19239,  37804, 4120 },
		{19539,  37776, 4105 },
		{19840,  37752, 4125 },
		{20141,  37714, 4120 },
		{20441,  37684, 4110 },
		{20742,  37658, 4155 },
		{21042,  37642, 4170 },
		{21343,  37599, 4150 },
		{21644,  37554, 4166 },
		{21944,  37517, 4225 },
		{22245,  37457, 4236 },
		{22545,  37397, 4275 },
		{22846,  37339, 4292 },
		{23147,  37284, 4350 },
		{23447,  37211, 4356 },
		{23748,  37134, 4381 },
		{24048,  37087, 4433 },
		{24349,  37075, 4538 },
		{24650,  37055, 4615 },
		{24950,  37037, 4772 },
		{25251,  37022, 4934 },
		{25552,  36984, 5079 },
		{25852,  36896, 5266 },
		{26153,  36678, 5396 },
		{26453,  36268, 5526 },
		{26754,  35713, 5844 },
		{27055,  34954, 6319 },
		{27355,  33750, 7523 },
		{27656,  31528, 13715},
		{27956,  29540, 9925 },
		{28257,  29540, 9925 },
		{28558,  29540, 9925 },
		{28858,  29540, 9925 },
		{29159,  29540, 9925 },
		{29459,  29540, 9925 },
		{29760,  29540, 9925 }
	},
	{
		{0,	     42730, 2575 },
		{301,	   42550, 3300 },
		{601,	   42409, 3375 },
		{902,	   42269, 3475 },
		{1202,	 42159, 3526 },
		{1503,	 42059, 3600 },
		{1804,	 41949, 3601 },
		{2104,	 41848, 3675 },
		{2405,	 41738, 3700 },
		{2705,	 41638, 3725 },
		{3006,	 41538, 3750 },
		{3307,	 41418, 3751 },
		{3607,	 41318, 3801 },
		{3908,	 41217, 3825 },
		{4208,	 41107, 3826 },
		{4509,	 41017, 3851 },
		{4810,	 40926, 3875 },
		{5110,	 40868, 3885 },
		{5411,	 40834, 4028 },
		{5712,	 40749, 4070 },
		{6012,	 40587, 4002 },
		{6313,	 40414, 4021 },
		{6613,	 40208, 3975 },
		{6914,	 40060, 3973 },
		{7215,	 39932, 3954 },
		{7515,	 39833, 4002 },
		{7816,	 39753, 4025 },
		{8116,	 39676, 4027 },
		{8417,	 39624, 4050 },
		{8718,	 39554, 4048 },
		{9018,	 39490, 4018 },
		{9319,	 39381, 3948 },
		{9619,	 39289, 3918 },
		{9920,	 39179, 3840 },
		{10221,  39072, 3750 },
		{10521,  38991, 3747 },
		{10822,  38903, 3725 },
		{11122,  38832, 3714 },
		{11423,  38763, 3633 },
		{11724,  38706, 3706 },
		{12024,  38663, 3750 },
		{12325,  38604, 3747 },
		{12625,  38554, 3728 },
		{12926,  38503, 3753 },
		{13227,  38445, 3778 },
		{13527,  38405, 3803 },
		{13828,  38364, 3819 },
		{14128,  38316, 3785 },
		{14429,  38282, 3850 },
		{14730,  38235, 3858 },
		{15030,  38203, 3896 },
		{15331,  38165, 3883 },
		{15632,  38133, 3929 },
		{15932,  38095, 3950 },
		{16233,  38065, 3959 },
		{16533,  38033, 3991 },
		{16834,  37996, 3959 },
		{17135,  37975, 4005 },
		{17435,  37946, 4030 },
		{17736,  37924, 4050 },
		{18036,  37896, 4059 },
		{18337,  37876, 4109 },
		{18638,  37852, 4140 },
		{18938,  37818, 4105 },
		{19239,  37804, 4120 },
		{19539,  37776, 4105 },
		{19840,  37752, 4125 },
		{20141,  37714, 4120 },
		{20441,  37684, 4110 },
		{20742,  37658, 4155 },
		{21042,  37642, 4170 },
		{21343,  37599, 4150 },
		{21644,  37554, 4166 },
		{21944,  37517, 4225 },
		{22245,  37457, 4236 },
		{22545,  37397, 4275 },
		{22846,  37339, 4292 },
		{23147,  37284, 4350 },
		{23447,  37211, 4356 },
		{23748,  37134, 4381 },
		{24048,  37087, 4433 },
		{24349,  37075, 4538 },
		{24650,  37055, 4615 },
		{24950,  37037, 4772 },
		{25251,  37022, 4934 },
		{25552,  36984, 5079 },
		{25852,  36896, 5266 },
		{26153,  36678, 5396 },
		{26453,  36268, 5526 },
		{26754,  35713, 5844 },
		{27055,  34954, 6319 },
		{27355,  33750, 7523 },
		{27656,  31528, 13715},
		{27956,  29540, 9925 },
		{28257,  29540, 9925 },
		{28558,  29540, 9925 },
		{28858,  29540, 9925 },
		{29159,  29540, 9925 },
		{29459,  29540, 9925 },
		{29760,  29540, 9925 }
	},
	{
		{0,	     42730, 2575 },
		{301,	   42550, 3300 },
		{601,	   42409, 3375 },
		{902,	   42269, 3475 },
		{1202,	 42159, 3526 },
		{1503,	 42059, 3600 },
		{1804,	 41949, 3601 },
		{2104,	 41848, 3675 },
		{2405,	 41738, 3700 },
		{2705,	 41638, 3725 },
		{3006,	 41538, 3750 },
		{3307,	 41418, 3751 },
		{3607,	 41318, 3801 },
		{3908,	 41217, 3825 },
		{4208,	 41107, 3826 },
		{4509,	 41017, 3851 },
		{4810,	 40926, 3875 },
		{5110,	 40868, 3885 },
		{5411,	 40834, 4028 },
		{5712,	 40749, 4070 },
		{6012,	 40587, 4002 },
		{6313,	 40414, 4021 },
		{6613,	 40208, 3975 },
		{6914,	 40060, 3973 },
		{7215,	 39932, 3954 },
		{7515,	 39833, 4002 },
		{7816,	 39753, 4025 },
		{8116,	 39676, 4027 },
		{8417,	 39624, 4050 },
		{8718,	 39554, 4048 },
		{9018,	 39490, 4018 },
		{9319,	 39381, 3948 },
		{9619,	 39289, 3918 },
		{9920,	 39179, 3840 },
		{10221,  39072, 3750 },
		{10521,  38991, 3747 },
		{10822,  38903, 3725 },
		{11122,  38832, 3714 },
		{11423,  38763, 3633 },
		{11724,  38706, 3706 },
		{12024,  38663, 3750 },
		{12325,  38604, 3747 },
		{12625,  38554, 3728 },
		{12926,  38503, 3753 },
		{13227,  38445, 3778 },
		{13527,  38405, 3803 },
		{13828,  38364, 3819 },
		{14128,  38316, 3785 },
		{14429,  38282, 3850 },
		{14730,  38235, 3858 },
		{15030,  38203, 3896 },
		{15331,  38165, 3883 },
		{15632,  38133, 3929 },
		{15932,  38095, 3950 },
		{16233,  38065, 3959 },
		{16533,  38033, 3991 },
		{16834,  37996, 3959 },
		{17135,  37975, 4005 },
		{17435,  37946, 4030 },
		{17736,  37924, 4050 },
		{18036,  37896, 4059 },
		{18337,  37876, 4109 },
		{18638,  37852, 4140 },
		{18938,  37818, 4105 },
		{19239,  37804, 4120 },
		{19539,  37776, 4105 },
		{19840,  37752, 4125 },
		{20141,  37714, 4120 },
		{20441,  37684, 4110 },
		{20742,  37658, 4155 },
		{21042,  37642, 4170 },
		{21343,  37599, 4150 },
		{21644,  37554, 4166 },
		{21944,  37517, 4225 },
		{22245,  37457, 4236 },
		{22545,  37397, 4275 },
		{22846,  37339, 4292 },
		{23147,  37284, 4350 },
		{23447,  37211, 4356 },
		{23748,  37134, 4381 },
		{24048,  37087, 4433 },
		{24349,  37075, 4538 },
		{24650,  37055, 4615 },
		{24950,  37037, 4772 },
		{25251,  37022, 4934 },
		{25552,  36984, 5079 },
		{25852,  36896, 5266 },
		{26153,  36678, 5396 },
		{26453,  36268, 5526 },
		{26754,  35713, 5844 },
		{27055,  34954, 6319 },
		{27355,  33750, 7523 },
		{27656,  31528, 13715},
		{27956,  29540, 9925 },
		{28257,  29540, 9925 },
		{28558,  29540, 9925 },
		{28858,  29540, 9925 },
		{29159,  29540, 9925 },
		{29459,  29540, 9925 },
		{29760,  29540, 9925 }
	},
	{
		{0,	     42730, 2575 },
		{301,	   42550, 3300 },
		{601,	   42409, 3375 },
		{902,	   42269, 3475 },
		{1202,	 42159, 3526 },
		{1503,	 42059, 3600 },
		{1804,	 41949, 3601 },
		{2104,	 41848, 3675 },
		{2405,	 41738, 3700 },
		{2705,	 41638, 3725 },
		{3006,	 41538, 3750 },
		{3307,	 41418, 3751 },
		{3607,	 41318, 3801 },
		{3908,	 41217, 3825 },
		{4208,	 41107, 3826 },
		{4509,	 41017, 3851 },
		{4810,	 40926, 3875 },
		{5110,	 40868, 3885 },
		{5411,	 40834, 4028 },
		{5712,	 40749, 4070 },
		{6012,	 40587, 4002 },
		{6313,	 40414, 4021 },
		{6613,	 40208, 3975 },
		{6914,	 40060, 3973 },
		{7215,	 39932, 3954 },
		{7515,	 39833, 4002 },
		{7816,	 39753, 4025 },
		{8116,	 39676, 4027 },
		{8417,	 39624, 4050 },
		{8718,	 39554, 4048 },
		{9018,	 39490, 4018 },
		{9319,	 39381, 3948 },
		{9619,	 39289, 3918 },
		{9920,	 39179, 3840 },
		{10221,  39072, 3750 },
		{10521,  38991, 3747 },
		{10822,  38903, 3725 },
		{11122,  38832, 3714 },
		{11423,  38763, 3633 },
		{11724,  38706, 3706 },
		{12024,  38663, 3750 },
		{12325,  38604, 3747 },
		{12625,  38554, 3728 },
		{12926,  38503, 3753 },
		{13227,  38445, 3778 },
		{13527,  38405, 3803 },
		{13828,  38364, 3819 },
		{14128,  38316, 3785 },
		{14429,  38282, 3850 },
		{14730,  38235, 3858 },
		{15030,  38203, 3896 },
		{15331,  38165, 3883 },
		{15632,  38133, 3929 },
		{15932,  38095, 3950 },
		{16233,  38065, 3959 },
		{16533,  38033, 3991 },
		{16834,  37996, 3959 },
		{17135,  37975, 4005 },
		{17435,  37946, 4030 },
		{17736,  37924, 4050 },
		{18036,  37896, 4059 },
		{18337,  37876, 4109 },
		{18638,  37852, 4140 },
		{18938,  37818, 4105 },
		{19239,  37804, 4120 },
		{19539,  37776, 4105 },
		{19840,  37752, 4125 },
		{20141,  37714, 4120 },
		{20441,  37684, 4110 },
		{20742,  37658, 4155 },
		{21042,  37642, 4170 },
		{21343,  37599, 4150 },
		{21644,  37554, 4166 },
		{21944,  37517, 4225 },
		{22245,  37457, 4236 },
		{22545,  37397, 4275 },
		{22846,  37339, 4292 },
		{23147,  37284, 4350 },
		{23447,  37211, 4356 },
		{23748,  37134, 4381 },
		{24048,  37087, 4433 },
		{24349,  37075, 4538 },
		{24650,  37055, 4615 },
		{24950,  37037, 4772 },
		{25251,  37022, 4934 },
		{25552,  36984, 5079 },
		{25852,  36896, 5266 },
		{26153,  36678, 5396 },
		{26453,  36268, 5526 },
		{26754,  35713, 5844 },
		{27055,  34954, 6319 },
		{27355,  33750, 7523 },
		{27656,  31528, 13715},
		{27956,  29540, 9925 },
		{28257,  29540, 9925 },
		{28558,  29540, 9925 },
		{28858,  29540, 9925 },
		{29159,  29540, 9925 },
		{29459,  29540, 9925 },
		{29760,  29540, 9925 }
	}

};

/* T4 */
struct fuelgauge_profile_struct fg_profile_t4[TOTAL_BATTERY_NUMBER][100] = {
	{
		{0,	     42420, 9500 },
		{301,	   42210, 5801 },
		{601,	   41979, 6176 },
		{902,	   41699, 6529 },
		{1202,	 41529, 7252 },
		{1503,	 41379, 7451 },
		{1804,	 41259, 7577 },
		{2104,	 41139, 7749 },
		{2405,	 41039, 7702 },
		{2705,	 40969, 7851 },
		{3006,	 40899, 7927 },
		{3307,	 40838, 8002 },
		{3607,	 40746, 8100 },
		{3908,	 40595, 8099 },
		{4208,	 40404, 8075 },
		{4509,	 40204, 8073 },
		{4810,	 40021, 8025 },
		{5110,	 39893, 8028 },
		{5411,	 39783, 8078 },
		{5712,	 39684, 8120 },
		{6012,	 39604, 8056 },
		{6313,	 39525, 8127 },
		{6613,	 39455, 8156 },
		{6914,	 39394, 8221 },
		{7215,	 39313, 8169 },
		{7515,	 39222, 8100 },
		{7816,	 39122, 8094 },
		{8116,	 39034, 8023 },
		{8417,	 38962, 7998 },
		{8718,	 38874, 7975 },
		{9018,	 38803, 7973 },
		{9319,	 38735, 7960 },
		{9619,	 38685, 8052 },
		{9920,	 38634, 8078 },
		{10221,  38574, 8085 },
		{10521,  38516, 7963 },
		{10822,  38474, 8080 },
		{11122,  38415, 8136 },
		{11423,  38366, 8225 },
		{11724,  38328, 8228 },
		{12024,  38304, 8253 },
		{12325,  38254, 8281 },
		{12625,  38205, 8322 },
		{12926,  38168, 8312 },
		{13227,  38145, 8403 },
		{13527,  38106, 8419 },
		{13828,  38075, 8381 },
		{14128,  38035, 8425 },
		{14429,  37997, 8433 },
		{14730,  37977, 8487 },
		{15030,  37957, 8554 },
		{15331,  37933, 8579 },
		{15632,  37898, 8600 },
		{15932,  37887, 8617 },
		{16233,  37865, 8696 },
		{16533,  37840, 8688 },
		{16834,  37835, 8759 },
		{17135,  37805, 8805 },
		{17435,  37774, 8825 },
		{17736,  37748, 8839 },
		{18036,  37734, 8919 },
		{18337,  37702, 9019 },
		{18638,  37664, 9100 },
		{18938,  37632, 9124 },
		{19239,  37590, 9240 },
		{19539,  37540, 9305 },
		{19840,  37490, 9340 },
		{20141,  37440, 9425 },
		{20441,  37386, 9551 },
		{20742,  37320, 9676 },
		{21042,  37265, 9822 },
		{21343,  37202, 10032},
		{21644,  37159, 10177},
		{21944,  37111, 10329},
		{22245,  37074, 10595},
		{22545,  37048, 10926},
		{22846,  37031, 11277},
		{23147,  36982, 11672},
		{23447,  36894, 12228},
		{23748,  36743, 12780},
		{24048,  36440, 13300},
		{24349,  35974, 13929},
		{24650,  35322, 14812},
		{24950,  34380, 16210},
		{25251,  32952, 17130},
		{25552,  31174, 13277},
		{25852,  30950, 13150},
		{26153,  30950, 13150},
		{26453,  30950, 13150},
		{26754,  30950, 13150},
		{27055,  30950, 13150},
		{27355,  30950, 13150},
		{27656,  30950, 13150},
		{27956,  30950, 13150},
		{28257,  30950, 13150},
		{28558,  30950, 13150},
		{28858,  30950, 13150},
		{29159,  30950, 13150},
		{29459,  30950, 13150},
		{29760,  30950, 13150}
	},
	{
		{0,	     42420, 9500 },
		{301,	   42210, 5801 },
		{601,	   41979, 6176 },
		{902,	   41699, 6529 },
		{1202,	 41529, 7252 },
		{1503,	 41379, 7451 },
		{1804,	 41259, 7577 },
		{2104,	 41139, 7749 },
		{2405,	 41039, 7702 },
		{2705,	 40969, 7851 },
		{3006,	 40899, 7927 },
		{3307,	 40838, 8002 },
		{3607,	 40746, 8100 },
		{3908,	 40595, 8099 },
		{4208,	 40404, 8075 },
		{4509,	 40204, 8073 },
		{4810,	 40021, 8025 },
		{5110,	 39893, 8028 },
		{5411,	 39783, 8078 },
		{5712,	 39684, 8120 },
		{6012,	 39604, 8056 },
		{6313,	 39525, 8127 },
		{6613,	 39455, 8156 },
		{6914,	 39394, 8221 },
		{7215,	 39313, 8169 },
		{7515,	 39222, 8100 },
		{7816,	 39122, 8094 },
		{8116,	 39034, 8023 },
		{8417,	 38962, 7998 },
		{8718,	 38874, 7975 },
		{9018,	 38803, 7973 },
		{9319,	 38735, 7960 },
		{9619,	 38685, 8052 },
		{9920,	 38634, 8078 },
		{10221,  38574, 8085 },
		{10521,  38516, 7963 },
		{10822,  38474, 8080 },
		{11122,  38415, 8136 },
		{11423,  38366, 8225 },
		{11724,  38328, 8228 },
		{12024,  38304, 8253 },
		{12325,  38254, 8281 },
		{12625,  38205, 8322 },
		{12926,  38168, 8312 },
		{13227,  38145, 8403 },
		{13527,  38106, 8419 },
		{13828,  38075, 8381 },
		{14128,  38035, 8425 },
		{14429,  37997, 8433 },
		{14730,  37977, 8487 },
		{15030,  37957, 8554 },
		{15331,  37933, 8579 },
		{15632,  37898, 8600 },
		{15932,  37887, 8617 },
		{16233,  37865, 8696 },
		{16533,  37840, 8688 },
		{16834,  37835, 8759 },
		{17135,  37805, 8805 },
		{17435,  37774, 8825 },
		{17736,  37748, 8839 },
		{18036,  37734, 8919 },
		{18337,  37702, 9019 },
		{18638,  37664, 9100 },
		{18938,  37632, 9124 },
		{19239,  37590, 9240 },
		{19539,  37540, 9305 },
		{19840,  37490, 9340 },
		{20141,  37440, 9425 },
		{20441,  37386, 9551 },
		{20742,  37320, 9676 },
		{21042,  37265, 9822 },
		{21343,  37202, 10032},
		{21644,  37159, 10177},
		{21944,  37111, 10329},
		{22245,  37074, 10595},
		{22545,  37048, 10926},
		{22846,  37031, 11277},
		{23147,  36982, 11672},
		{23447,  36894, 12228},
		{23748,  36743, 12780},
		{24048,  36440, 13300},
		{24349,  35974, 13929},
		{24650,  35322, 14812},
		{24950,  34380, 16210},
		{25251,  32952, 17130},
		{25552,  31174, 13277},
		{25852,  30950, 13150},
		{26153,  30950, 13150},
		{26453,  30950, 13150},
		{26754,  30950, 13150},
		{27055,  30950, 13150},
		{27355,  30950, 13150},
		{27656,  30950, 13150},
		{27956,  30950, 13150},
		{28257,  30950, 13150},
		{28558,  30950, 13150},
		{28858,  30950, 13150},
		{29159,  30950, 13150},
		{29459,  30950, 13150},
		{29760,  30950, 13150}
	},
	{
		{0,	     42420, 9500 },
		{301,	   42210, 5801 },
		{601,	   41979, 6176 },
		{902,	   41699, 6529 },
		{1202,	 41529, 7252 },
		{1503,	 41379, 7451 },
		{1804,	 41259, 7577 },
		{2104,	 41139, 7749 },
		{2405,	 41039, 7702 },
		{2705,	 40969, 7851 },
		{3006,	 40899, 7927 },
		{3307,	 40838, 8002 },
		{3607,	 40746, 8100 },
		{3908,	 40595, 8099 },
		{4208,	 40404, 8075 },
		{4509,	 40204, 8073 },
		{4810,	 40021, 8025 },
		{5110,	 39893, 8028 },
		{5411,	 39783, 8078 },
		{5712,	 39684, 8120 },
		{6012,	 39604, 8056 },
		{6313,	 39525, 8127 },
		{6613,	 39455, 8156 },
		{6914,	 39394, 8221 },
		{7215,	 39313, 8169 },
		{7515,	 39222, 8100 },
		{7816,	 39122, 8094 },
		{8116,	 39034, 8023 },
		{8417,	 38962, 7998 },
		{8718,	 38874, 7975 },
		{9018,	 38803, 7973 },
		{9319,	 38735, 7960 },
		{9619,	 38685, 8052 },
		{9920,	 38634, 8078 },
		{10221,  38574, 8085 },
		{10521,  38516, 7963 },
		{10822,  38474, 8080 },
		{11122,  38415, 8136 },
		{11423,  38366, 8225 },
		{11724,  38328, 8228 },
		{12024,  38304, 8253 },
		{12325,  38254, 8281 },
		{12625,  38205, 8322 },
		{12926,  38168, 8312 },
		{13227,  38145, 8403 },
		{13527,  38106, 8419 },
		{13828,  38075, 8381 },
		{14128,  38035, 8425 },
		{14429,  37997, 8433 },
		{14730,  37977, 8487 },
		{15030,  37957, 8554 },
		{15331,  37933, 8579 },
		{15632,  37898, 8600 },
		{15932,  37887, 8617 },
		{16233,  37865, 8696 },
		{16533,  37840, 8688 },
		{16834,  37835, 8759 },
		{17135,  37805, 8805 },
		{17435,  37774, 8825 },
		{17736,  37748, 8839 },
		{18036,  37734, 8919 },
		{18337,  37702, 9019 },
		{18638,  37664, 9100 },
		{18938,  37632, 9124 },
		{19239,  37590, 9240 },
		{19539,  37540, 9305 },
		{19840,  37490, 9340 },
		{20141,  37440, 9425 },
		{20441,  37386, 9551 },
		{20742,  37320, 9676 },
		{21042,  37265, 9822 },
		{21343,  37202, 10032},
		{21644,  37159, 10177},
		{21944,  37111, 10329},
		{22245,  37074, 10595},
		{22545,  37048, 10926},
		{22846,  37031, 11277},
		{23147,  36982, 11672},
		{23447,  36894, 12228},
		{23748,  36743, 12780},
		{24048,  36440, 13300},
		{24349,  35974, 13929},
		{24650,  35322, 14812},
		{24950,  34380, 16210},
		{25251,  32952, 17130},
		{25552,  31174, 13277},
		{25852,  30950, 13150},
		{26153,  30950, 13150},
		{26453,  30950, 13150},
		{26754,  30950, 13150},
		{27055,  30950, 13150},
		{27355,  30950, 13150},
		{27656,  30950, 13150},
		{27956,  30950, 13150},
		{28257,  30950, 13150},
		{28558,  30950, 13150},
		{28858,  30950, 13150},
		{29159,  30950, 13150},
		{29459,  30950, 13150},
		{29760,  30950, 13150}
	},
	{
		{0,	     42420, 9500 },
		{301,	   42210, 5801 },
		{601,	   41979, 6176 },
		{902,	   41699, 6529 },
		{1202,	 41529, 7252 },
		{1503,	 41379, 7451 },
		{1804,	 41259, 7577 },
		{2104,	 41139, 7749 },
		{2405,	 41039, 7702 },
		{2705,	 40969, 7851 },
		{3006,	 40899, 7927 },
		{3307,	 40838, 8002 },
		{3607,	 40746, 8100 },
		{3908,	 40595, 8099 },
		{4208,	 40404, 8075 },
		{4509,	 40204, 8073 },
		{4810,	 40021, 8025 },
		{5110,	 39893, 8028 },
		{5411,	 39783, 8078 },
		{5712,	 39684, 8120 },
		{6012,	 39604, 8056 },
		{6313,	 39525, 8127 },
		{6613,	 39455, 8156 },
		{6914,	 39394, 8221 },
		{7215,	 39313, 8169 },
		{7515,	 39222, 8100 },
		{7816,	 39122, 8094 },
		{8116,	 39034, 8023 },
		{8417,	 38962, 7998 },
		{8718,	 38874, 7975 },
		{9018,	 38803, 7973 },
		{9319,	 38735, 7960 },
		{9619,	 38685, 8052 },
		{9920,	 38634, 8078 },
		{10221,  38574, 8085 },
		{10521,  38516, 7963 },
		{10822,  38474, 8080 },
		{11122,  38415, 8136 },
		{11423,  38366, 8225 },
		{11724,  38328, 8228 },
		{12024,  38304, 8253 },
		{12325,  38254, 8281 },
		{12625,  38205, 8322 },
		{12926,  38168, 8312 },
		{13227,  38145, 8403 },
		{13527,  38106, 8419 },
		{13828,  38075, 8381 },
		{14128,  38035, 8425 },
		{14429,  37997, 8433 },
		{14730,  37977, 8487 },
		{15030,  37957, 8554 },
		{15331,  37933, 8579 },
		{15632,  37898, 8600 },
		{15932,  37887, 8617 },
		{16233,  37865, 8696 },
		{16533,  37840, 8688 },
		{16834,  37835, 8759 },
		{17135,  37805, 8805 },
		{17435,  37774, 8825 },
		{17736,  37748, 8839 },
		{18036,  37734, 8919 },
		{18337,  37702, 9019 },
		{18638,  37664, 9100 },
		{18938,  37632, 9124 },
		{19239,  37590, 9240 },
		{19539,  37540, 9305 },
		{19840,  37490, 9340 },
		{20141,  37440, 9425 },
		{20441,  37386, 9551 },
		{20742,  37320, 9676 },
		{21042,  37265, 9822 },
		{21343,  37202, 10032},
		{21644,  37159, 10177},
		{21944,  37111, 10329},
		{22245,  37074, 10595},
		{22545,  37048, 10926},
		{22846,  37031, 11277},
		{23147,  36982, 11672},
		{23447,  36894, 12228},
		{23748,  36743, 12780},
		{24048,  36440, 13300},
		{24349,  35974, 13929},
		{24650,  35322, 14812},
		{24950,  34380, 16210},
		{25251,  32952, 17130},
		{25552,  31174, 13277},
		{25852,  30950, 13150},
		{26153,  30950, 13150},
		{26453,  30950, 13150},
		{26754,  30950, 13150},
		{27055,  30950, 13150},
		{27355,  30950, 13150},
		{27656,  30950, 13150},
		{27956,  30950, 13150},
		{28257,  30950, 13150},
		{28558,  30950, 13150},
		{28858,  30950, 13150},
		{29159,  30950, 13150},
		{29459,  30950, 13150},
		{29760,  30950, 13150}
	}

};

/* T5 */
struct fuelgauge_profile_struct fg_profile_t5[TOTAL_BATTERY_NUMBER][90] = {
	{
		{0, 42980, 5305},
		{336, 42832, 5300},
		{673, 42691, 5331},
		{1009, 42556, 5398},
		{1346, 42415, 5485},
		{1682, 42266, 5548},
		{2018, 42112, 5595},
		{2355, 41957, 5682},
		{2691, 41794, 5832},
		{3028, 41626, 6033},
		{3364, 41462, 6278},
		{3700, 41282, 6561},
		{4037, 41093, 6884},
		{4373, 40898, 7298},
		{4710, 40742, 7686},
		{5046, 40606, 8046},
		{5382, 40465, 8353},
		{5719, 40292, 8598},
		{6055, 40111, 8792},
		{6392, 39963, 8879},
		{6728, 39844, 9029},
		{7064, 39739, 9179},
		{7401, 39645, 9246},
		{7737, 39566, 9311},
		{8074, 39487, 9387},
		{8410, 39392, 9497},
		{8747, 39303, 9489},
		{9083, 39210, 9482},
		{9419, 39103, 9569},
		{9756, 38984, 9502},
		{10092, 38869, 9452},
		{10429, 38766, 9541},
		{10765, 38687, 9629},
		{11101, 38611, 9693},
		{11438, 38530, 9715},
		{11774, 38467, 9814},
		{12111, 38406, 9923},
		{12447, 38346, 10032},
		{12783, 38285, 10122},
		{13120, 38230, 10245},
		{13456, 38183, 10420},
		{13793, 38149, 10574},
		{14129, 38109, 10719},
		{14465, 38062, 10850},
		{14802, 38028, 11085},
		{15138, 37991, 11315},
		{15475, 37951, 11534},
		{15811, 37924, 11666},
		{16147, 37893, 11830},
		{16484, 37860, 12028},
		{16820, 37833, 12290},
		{17157, 37798, 12509},
		{17493, 37757, 12691},
		{17829, 37717, 12909},
		{18166, 37680, 13178},
		{18502, 37644, 13475},
		{18839, 37576, 13671},
		{19175, 37517, 13920},
		{19511, 37462, 14186},
		{19848, 37394, 14317},
		{20184, 37323, 14533},
		{20521, 37250, 14798},
		{20857, 37183, 15083},
		{21193, 37124, 15425},
		{21530, 37069, 15800},
		{21866, 37009, 16194},
		{22203, 36962, 16860},
		{22539, 36916, 17637},
		{22876, 36849, 18381},
		{23212, 36719, 19140},
		{23548, 36517, 19837},
		{23885, 36160, 20305},
		{24221, 35626, 20732},
		{24558, 35047, 21203},
		{24894, 34524, 21399},
		{25230, 34044, 19815},
		{25567, 32822, 15920},
		{25903, 31200, 11603},
		{26240, 31200, 11603},
		{26576, 31200, 11603},
		{26912, 31200, 11603},
		{27249, 31200, 11603},
		{27585, 31200, 11603},
		{27922, 31200, 11603},
		{28258, 31200, 11603},
		{28594, 31200, 11603},
		{28931, 31200, 11603},
		{29267, 31200, 11603},
		{29604, 31200, 11603},
		{29940, 31200, 11605}
	},
	{
		{0, 41760, 6890},
		{327, 41633, 5860},
		{653, 41533, 5925},
		{980, 41435, 5883},
		{1307, 41163, 5795},
		{1633, 40827, 6028},
		{1960, 40570, 6370},
		{2286, 40372, 6738},
		{2613, 40157, 7366},
		{2940, 39901, 8336},
		{3266, 39716, 9253},
		{3593, 39559, 9684},
		{3920, 39448, 9911},
		{4246, 39368, 9926},
		{4573, 39283, 10000},
		{4899, 39188, 9902},
		{5226, 39111, 10114},
		{5553, 39047, 10228},
		{5879, 38928, 10045},
		{6206, 38840, 10114},
		{6533, 38745, 10152},
		{6859, 38677, 10156},
		{7186, 38591, 10208},
		{7512, 38535, 10322},
		{7839, 38459, 10370},
		{8166, 38426, 10413},
		{8492, 38363, 10407},
		{8819, 38329, 10461},
		{9146, 38274, 10400},
		{9472, 38206, 10312},
		{9799, 38160, 10482},
		{10126, 38144, 10695},
		{10452, 38078, 10595},
		{10779, 38043, 10687},
		{11105, 38008, 10806},
		{11432, 37982, 10881},
		{11759, 37919, 14515},
		{12085, 37898, 14333},
		{12412, 37874, 15022},
		{12739, 37827, 15669},
		{13065, 37788, 15301},
		{13392, 37753, 11592},
		{13718, 37717, 11216},
		{14045, 37665, 11331},
		{14372, 37618, 11388},
		{14698, 37547, 11671},
		{15025, 37515, 12263},
		{15352, 37426, 12441},
		{15678, 37355, 12574},
		{16005, 37297, 12571},
		{16331, 37230, 12657},
		{16658, 37172, 12987},
		{16985, 37129, 13394},
		{17311, 37064, 13607},
		{17638, 37044, 13702},
		{17965, 36985, 14008},
		{18291, 36927, 13577},
		{18618, 36762, 12896},
		{18944, 36491, 13454},
		{19271, 36057, 13614},
		{19598, 35452, 16709},
		{19924, 34375, 13547},
		{20251, 32882, 16132},
		{20578, 31935, 13264},
		{20904, 30830, 12903},
		{21231, 30830, 12903},
		{21558, 30830, 12903},
		{21884, 30830, 12903},
		{22211, 30830, 12903},
		{22537, 30830, 12903},
		{22864, 30830, 12903},
		{23191, 30830, 12903},
		{23517, 30830, 12903},
		{23844, 30830, 12903},
		{24171, 30830, 12903},
		{24497, 30830, 12903},
		{24824, 30830, 12903},
		{25150, 30830, 12903},
		{25477, 30830, 12903},
		{25804, 30830, 12903},
		{26130, 30830, 12903},
		{26457, 30830, 12903},
		{26784, 30830, 12903},
		{27110, 30830, 12903},
		{27437, 30830, 12903},
		{27763, 30830, 12903},
		{28090, 30830, 12903},
		{28417, 30830, 12903},
		{28743, 30830, 12903},
		{29070, 30830, 12903}
	},
	{
		{0, 42950, 9653},
		{283, 42752, 9653},
		{567, 42580, 9941},
		{850, 42393, 10140},
		{1134, 42191, 10278},
		{1417, 41976, 10500},
		{1701, 41765, 10837},
		{1984, 41570, 11205},
		{2268, 41405, 11535},
		{2551, 41259, 11755},
		{2835, 41125, 11878},
		{3118, 41009, 11987},
		{3402, 40905, 12084},
		{3685, 40805, 12191},
		{3969, 40704, 12366},
		{4252, 40581, 12496},
		{4536, 40425, 12563},
		{4819, 40246, 12661},
		{5103, 40074, 12793},
		{5386, 39933, 12971},
		{5670, 39810, 13033},
		{5953, 39725, 13217},
		{6237, 39622, 13285},
		{6520, 39543, 13400},
		{6804, 39441, 13423},
		{7087, 39352, 13521},
		{7371, 39253, 13553},
		{7654, 39155, 13573},
		{7938, 39055, 13605},
		{8221, 38951, 13670},
		{8504, 38852, 13746},
		{8788, 38756, 13809},
		{9071, 38668, 13897},
		{9355, 38592, 14009},
		{9638, 38516, 14101},
		{9922, 38446, 14201},
		{10205, 38389, 14323},
		{10489, 38332, 14447},
		{10772, 38276, 14581},
		{11056, 38237, 14762},
		{11339, 38180, 14885},
		{11623, 38133, 15007},
		{11906, 38086, 15159},
		{12190, 38047, 15313},
		{12473, 38017, 15517},
		{12757, 37973, 15592},
		{13040, 37939, 15737},
		{13324, 37911, 15963},
		{13607, 37882, 16132},
		{13891, 37859, 16342},
		{14174, 37840, 16618},
		{14458, 37821, 16913},
		{14741, 37802, 17226},
		{15025, 37783, 17521},
		{15308, 37764, 17807},
		{15592, 37743, 18116},
		{15875, 37716, 18424},
		{16159, 37696, 18675},
		{16442, 37676, 18623},
		{16726, 37653, 18538},
		{17009, 37623, 18469},
		{17292, 37590, 18330},
		{17576, 37568, 18257},
		{17859, 37525, 18135},
		{18143, 37474, 17984},
		{18426, 37378, 17648},
		{18710, 33950, 6565},
		{18993, 33950, 6565},
		{19277, 33950, 6565},
		{19560, 33950, 6565},
		{19844, 33950, 6565},
		{20127, 33950, 6565},
		{20411, 33950, 6565},
		{20694, 33950, 6565},
		{20978, 33950, 6565},
		{21261, 33950, 6565},
		{21545, 33950, 6565},
		{21828, 33950, 6565},
		{22112, 33950, 6565},
		{22395, 33950, 6565},
		{22679, 33950, 6565},
		{22962, 33950, 6565},
		{23246, 33950, 6565},
		{23529, 33950, 6565},
		{23813, 33950, 6565},
		{24096, 33950, 6565},
		{24380, 33950, 6565},
		{24663, 33950, 6565},
		{24947, 33950, 6565},
		{25230, 33950, 6565}
	},
	{
		{0, 41600, 4323},
		{226, 41397, 4323},
		{451, 41219, 4503},
		{677, 41066, 4722},
		{903, 40939, 4844},
		{1129, 40841, 4917},
		{1354, 40743, 4957},
		{1580, 40640, 4989},
		{1806, 40527, 5039},
		{2032, 40402, 5090},
		{2257, 40286, 5139},
		{2483, 40177, 5197},
		{2709, 40072, 5265},
		{2934, 39974, 5265},
		{3160, 39888, 5301},
		{3386, 39814, 5351},
		{3612, 39753, 5398},
		{3837, 39686, 5422},
		{4063, 39618, 5446},
		{4289, 39554, 5481},
		{4515, 39491, 5528},
		{4740, 39408, 5552},
		{4966, 39343, 5595},
		{5192, 39276, 5600},
		{5418, 39200, 5558},
		{5643, 39114, 5558},
		{5869, 39031, 5558},
		{6095, 38940, 5495},
		{6320, 38842, 5378},
		{6546, 38745, 5279},
		{6772, 38660, 5203},
		{6998, 38585, 5181},
		{7223, 38516, 5195},
		{7449, 38440, 5171},
		{7675, 38378, 5104},
		{7901, 38322, 5083},
		{8126, 38272, 5108},
		{8352, 38235, 5132},
		{8578, 38197, 5156},
		{8803, 38151, 5168},
		{9029, 38102, 5168},
		{9255, 38064, 5168},
		{9481, 38033, 5210},
		{9706, 38003, 5261},
		{9932, 37976, 5311},
		{10158, 37961, 5360},
		{10384, 37932, 5386},
		{10609, 37911, 5425},
		{10835, 37891, 5460},
		{11061, 37861, 5460},
		{11287, 37838, 5483},
		{11512, 37825, 5508},
		{11738, 37813, 5525},
		{11964, 37791, 5525},
		{12189, 37783, 5573},
		{12415, 37775, 5637},
		{12641, 37768, 5695},
		{12867, 37760, 5720},
		{13092, 37753, 5793},
		{13318, 37735, 5802},
		{13544, 37710, 5801},
		{13770, 37680, 5850},
		{13995, 37649, 5850},
		{14221, 37613, 5885},
		{14447, 37573, 5924},
		{14672, 37526, 5950},
		{14898, 37459, 6000},
		{15124, 37391, 6031},
		{15350, 37320, 6054},
		{15575, 37244, 6079},
		{15801, 37162, 6104},
		{16027, 37107, 6146},
		{16253, 37065, 6235},
		{16478, 37027, 6380},
		{16704, 36989, 6503},
		{16930, 36969, 6735},
		{17156, 36950, 7086},
		{17381, 36923, 7565},
		{17607, 36845, 8172},
		{17833, 36629, 8783},
		{18058, 36254, 9699},
		{18284, 35714, 10777},
		{18510, 34970, 9881},
		{18736, 33949, 6565},
		{18961, 33940, 6565},
		{19187, 33940, 6565},
		{19413, 33940, 6565},
		{19639, 33940, 6565},
		{19864, 33940, 6565},
		{20090, 33940, 6565}
	}

};

/* T6 */
struct fuelgauge_profile_struct fg_profile_t6[TOTAL_BATTERY_NUMBER][90] = {
	{
		{0, 42980, 5306},
		{336, 42832, 5300},
		{673, 42691, 5331},
		{1009, 42556, 5398},
		{1346, 42415, 5485},
		{1682, 42266, 5548},
		{2018, 42112, 5595},
		{2355, 41957, 5682},
		{2691, 41794, 5832},
		{3028, 41626, 6033},
		{3364, 41462, 6278},
		{3700, 41282, 6561},
		{4037, 41093, 6884},
		{4373, 40898, 7298},
		{4710, 40742, 7686},
		{5046, 40606, 8046},
		{5382, 40465, 8353},
		{5719, 40292, 8598},
		{6055, 40111, 8792},
		{6392, 39963, 8879},
		{6728, 39844, 9029},
		{7064, 39739, 9179},
		{7401, 39645, 9246},
		{7737, 39566, 9311},
		{8074, 39487, 9387},
		{8410, 39392, 9497},
		{8747, 39303, 9489},
		{9083, 39210, 9482},
		{9419, 39103, 9569},
		{9756, 38984, 9502},
		{10092, 38869, 9452},
		{10429, 38766, 9541},
		{10765, 38687, 9629},
		{11101, 38611, 9693},
		{11438, 38530, 9715},
		{11774, 38467, 9814},
		{12111, 38406, 9923},
		{12447, 38346, 10032},
		{12783, 38285, 10122},
		{13120, 38230, 10245},
		{13456, 38183, 10420},
		{13793, 38149, 10574},
		{14129, 38109, 10719},
		{14465, 38062, 10850},
		{14802, 38028, 11085},
		{15138, 37991, 11315},
		{15475, 37951, 11534},
		{15811, 37924, 11666},
		{16147, 37893, 11830},
		{16484, 37860, 12028},
		{16820, 37833, 12290},
		{17157, 37798, 12509},
		{17493, 37757, 12691},
		{17829, 37717, 12909},
		{18166, 37680, 13178},
		{18502, 37644, 13475},
		{18839, 37576, 13671},
		{19175, 37517, 13920},
		{19511, 37462, 14186},
		{19848, 37394, 14317},
		{20184, 37323, 14533},
		{20521, 37250, 14798},
		{20857, 37183, 15083},
		{21193, 37124, 15425},
		{21530, 37069, 15800},
		{21866, 37009, 16194},
		{22203, 36962, 16860},
		{22539, 36916, 17637},
		{22876, 36849, 18381},
		{23212, 36719, 19140},
		{23548, 36517, 19837},
		{23885, 36160, 20305},
		{24221, 35626, 20732},
		{24558, 35047, 21203},
		{24894, 34524, 21399},
		{25230, 34044, 19815},
		{25567, 32822, 15920},
		{25903, 31200, 11603},
		{26240, 31200, 11603},
		{26576, 31200, 11603},
		{26912, 31200, 11603},
		{27249, 31200, 11603},
		{27585, 31200, 11603},
		{27922, 31200, 11603},
		{28258, 31200, 11603},
		{28594, 31200, 11603},
		{28931, 31200, 11603},
		{29267, 31200, 11603},
		{29604, 31200, 11603},
		{29940, 31200, 11606}
	},
	{
		{0, 41760, 6890},
		{327, 41633, 5860},
		{653, 41533, 5925},
		{980, 41435, 5883},
		{1307, 41163, 5795},
		{1633, 40827, 6028},
		{1960, 40570, 6370},
		{2286, 40372, 6738},
		{2613, 40157, 7366},
		{2940, 39901, 8336},
		{3266, 39716, 9253},
		{3593, 39559, 9684},
		{3920, 39448, 9911},
		{4246, 39368, 9926},
		{4573, 39283, 10000},
		{4899, 39188, 9902},
		{5226, 39111, 10114},
		{5553, 39047, 10228},
		{5879, 38928, 10045},
		{6206, 38840, 10114},
		{6533, 38745, 10152},
		{6859, 38677, 10156},
		{7186, 38591, 10208},
		{7512, 38535, 10322},
		{7839, 38459, 10370},
		{8166, 38426, 10413},
		{8492, 38363, 10407},
		{8819, 38329, 10461},
		{9146, 38274, 10400},
		{9472, 38206, 10312},
		{9799, 38160, 10482},
		{10126, 38144, 10695},
		{10452, 38078, 10595},
		{10779, 38043, 10687},
		{11105, 38008, 10806},
		{11432, 37982, 10881},
		{11759, 37919, 14515},
		{12085, 37898, 14333},
		{12412, 37874, 15022},
		{12739, 37827, 15669},
		{13065, 37788, 15301},
		{13392, 37753, 11592},
		{13718, 37717, 11216},
		{14045, 37665, 11331},
		{14372, 37618, 11388},
		{14698, 37547, 11671},
		{15025, 37515, 12263},
		{15352, 37426, 12441},
		{15678, 37355, 12574},
		{16005, 37297, 12571},
		{16331, 37230, 12657},
		{16658, 37172, 12987},
		{16985, 37129, 13394},
		{17311, 37064, 13607},
		{17638, 37044, 13702},
		{17965, 36985, 14008},
		{18291, 36927, 13577},
		{18618, 36762, 12896},
		{18944, 36491, 13454},
		{19271, 36057, 13614},
		{19598, 35452, 16709},
		{19924, 34375, 13547},
		{20251, 32882, 16132},
		{20578, 31935, 13264},
		{20904, 30830, 12903},
		{21231, 30830, 12903},
		{21558, 30830, 12903},
		{21884, 30830, 12903},
		{22211, 30830, 12903},
		{22537, 30830, 12903},
		{22864, 30830, 12903},
		{23191, 30830, 12903},
		{23517, 30830, 12903},
		{23844, 30830, 12903},
		{24171, 30830, 12903},
		{24497, 30830, 12903},
		{24824, 30830, 12903},
		{25150, 30830, 12903},
		{25477, 30830, 12903},
		{25804, 30830, 12903},
		{26130, 30830, 12903},
		{26457, 30830, 12903},
		{26784, 30830, 12903},
		{27110, 30830, 12903},
		{27437, 30830, 12903},
		{27763, 30830, 12903},
		{28090, 30830, 12903},
		{28417, 30830, 12903},
		{28743, 30830, 12903},
		{29070, 30830, 12903}
	},
	{
		{0, 42950, 9653},
		{283, 42752, 9653},
		{567, 42580, 9941},
		{850, 42393, 10140},
		{1134, 42191, 10278},
		{1417, 41976, 10500},
		{1701, 41765, 10837},
		{1984, 41570, 11205},
		{2268, 41405, 11535},
		{2551, 41259, 11755},
		{2835, 41125, 11878},
		{3118, 41009, 11987},
		{3402, 40905, 12084},
		{3685, 40805, 12191},
		{3969, 40704, 12366},
		{4252, 40581, 12496},
		{4536, 40425, 12563},
		{4819, 40246, 12661},
		{5103, 40074, 12793},
		{5386, 39933, 12971},
		{5670, 39810, 13033},
		{5953, 39725, 13217},
		{6237, 39622, 13285},
		{6520, 39543, 13400},
		{6804, 39441, 13423},
		{7087, 39352, 13521},
		{7371, 39253, 13553},
		{7654, 39155, 13573},
		{7938, 39055, 13605},
		{8221, 38951, 13670},
		{8504, 38852, 13746},
		{8788, 38756, 13809},
		{9071, 38668, 13897},
		{9355, 38592, 14009},
		{9638, 38516, 14101},
		{9922, 38446, 14201},
		{10205, 38389, 14323},
		{10489, 38332, 14447},
		{10772, 38276, 14581},
		{11056, 38237, 14762},
		{11339, 38180, 14885},
		{11623, 38133, 15007},
		{11906, 38086, 15159},
		{12190, 38047, 15313},
		{12473, 38017, 15517},
		{12757, 37973, 15592},
		{13040, 37939, 15737},
		{13324, 37911, 15963},
		{13607, 37882, 16132},
		{13891, 37859, 16342},
		{14174, 37840, 16618},
		{14458, 37821, 16913},
		{14741, 37802, 17226},
		{15025, 37783, 17521},
		{15308, 37764, 17807},
		{15592, 37743, 18116},
		{15875, 37716, 18424},
		{16159, 37696, 18675},
		{16442, 37676, 18623},
		{16726, 37653, 18538},
		{17009, 37623, 18469},
		{17292, 37590, 18330},
		{17576, 37568, 18257},
		{17859, 37525, 18135},
		{18143, 37474, 17984},
		{18426, 37378, 17648},
		{18710, 33950, 6565},
		{18993, 33950, 6565},
		{19277, 33950, 6565},
		{19560, 33950, 6565},
		{19844, 33950, 6565},
		{20127, 33950, 6565},
		{20411, 33950, 6565},
		{20694, 33950, 6565},
		{20978, 33950, 6565},
		{21261, 33950, 6565},
		{21545, 33950, 6565},
		{21828, 33950, 6565},
		{22112, 33950, 6565},
		{22395, 33950, 6565},
		{22679, 33950, 6565},
		{22962, 33950, 6565},
		{23246, 33950, 6565},
		{23529, 33950, 6565},
		{23813, 33950, 6565},
		{24096, 33950, 6565},
		{24380, 33950, 6565},
		{24663, 33950, 6565},
		{24947, 33950, 6565},
		{25230, 33950, 6565}
	},
	{
		{0, 41600, 4323},
		{226, 41397, 4323},
		{451, 41219, 4503},
		{677, 41066, 4722},
		{903, 40939, 4844},
		{1129, 40841, 4917},
		{1354, 40743, 4957},
		{1580, 40640, 4989},
		{1806, 40527, 5039},
		{2032, 40402, 5090},
		{2257, 40286, 5139},
		{2483, 40177, 5197},
		{2709, 40072, 5265},
		{2934, 39974, 5265},
		{3160, 39888, 5301},
		{3386, 39814, 5351},
		{3612, 39753, 5398},
		{3837, 39686, 5422},
		{4063, 39618, 5446},
		{4289, 39554, 5481},
		{4515, 39491, 5528},
		{4740, 39408, 5552},
		{4966, 39343, 5595},
		{5192, 39276, 5600},
		{5418, 39200, 5558},
		{5643, 39114, 5558},
		{5869, 39031, 5558},
		{6095, 38940, 5495},
		{6320, 38842, 5378},
		{6546, 38745, 5279},
		{6772, 38660, 5203},
		{6998, 38585, 5181},
		{7223, 38516, 5195},
		{7449, 38440, 5171},
		{7675, 38378, 5104},
		{7901, 38322, 5083},
		{8126, 38272, 5108},
		{8352, 38235, 5132},
		{8578, 38197, 5156},
		{8803, 38151, 5168},
		{9029, 38102, 5168},
		{9255, 38064, 5168},
		{9481, 38033, 5210},
		{9706, 38003, 5261},
		{9932, 37976, 5311},
		{10158, 37961, 5360},
		{10384, 37932, 5386},
		{10609, 37911, 5425},
		{10835, 37891, 5460},
		{11061, 37861, 5460},
		{11287, 37838, 5483},
		{11512, 37825, 5508},
		{11738, 37813, 5525},
		{11964, 37791, 5525},
		{12189, 37783, 5573},
		{12415, 37775, 5637},
		{12641, 37768, 5695},
		{12867, 37760, 5720},
		{13092, 37753, 5793},
		{13318, 37735, 5802},
		{13544, 37710, 5801},
		{13770, 37680, 5850},
		{13995, 37649, 5850},
		{14221, 37613, 5885},
		{14447, 37573, 5924},
		{14672, 37526, 5950},
		{14898, 37459, 6000},
		{15124, 37391, 6031},
		{15350, 37320, 6054},
		{15575, 37244, 6079},
		{15801, 37162, 6104},
		{16027, 37107, 6146},
		{16253, 37065, 6235},
		{16478, 37027, 6380},
		{16704, 36989, 6503},
		{16930, 36969, 6735},
		{17156, 36950, 7086},
		{17381, 36923, 7565},
		{17607, 36845, 8172},
		{17833, 36629, 8783},
		{18058, 36254, 9699},
		{18284, 35714, 10777},
		{18510, 34970, 9881},
		{18736, 33949, 6565},
		{18961, 33940, 6565},
		{19187, 33940, 6565},
		{19413, 33940, 6565},
		{19639, 33940, 6565},
		{19864, 33940, 6565},
		{20090, 33940, 6565}
	}
};

/* T7 */
struct fuelgauge_profile_struct fg_profile_t7[TOTAL_BATTERY_NUMBER][90] = {
	{
		{0, 42980, 5307},
		{336, 42832, 5300},
		{673, 42691, 5331},
		{1009, 42556, 5398},
		{1346, 42415, 5485},
		{1682, 42266, 5548},
		{2018, 42112, 5595},
		{2355, 41957, 5682},
		{2691, 41794, 5832},
		{3028, 41626, 6033},
		{3364, 41462, 6278},
		{3700, 41282, 6561},
		{4037, 41093, 6884},
		{4373, 40898, 7298},
		{4710, 40742, 7686},
		{5046, 40606, 8046},
		{5382, 40465, 8353},
		{5719, 40292, 8598},
		{6055, 40111, 8792},
		{6392, 39963, 8879},
		{6728, 39844, 9029},
		{7064, 39739, 9179},
		{7401, 39645, 9246},
		{7737, 39566, 9311},
		{8074, 39487, 9387},
		{8410, 39392, 9497},
		{8747, 39303, 9489},
		{9083, 39210, 9482},
		{9419, 39103, 9569},
		{9756, 38984, 9502},
		{10092, 38869, 9452},
		{10429, 38766, 9541},
		{10765, 38687, 9629},
		{11101, 38611, 9693},
		{11438, 38530, 9715},
		{11774, 38467, 9814},
		{12111, 38406, 9923},
		{12447, 38346, 10032},
		{12783, 38285, 10122},
		{13120, 38230, 10245},
		{13456, 38183, 10420},
		{13793, 38149, 10574},
		{14129, 38109, 10719},
		{14465, 38062, 10850},
		{14802, 38028, 11085},
		{15138, 37991, 11315},
		{15475, 37951, 11534},
		{15811, 37924, 11666},
		{16147, 37893, 11830},
		{16484, 37860, 12028},
		{16820, 37833, 12290},
		{17157, 37798, 12509},
		{17493, 37757, 12691},
		{17829, 37717, 12909},
		{18166, 37680, 13178},
		{18502, 37644, 13475},
		{18839, 37576, 13671},
		{19175, 37517, 13920},
		{19511, 37462, 14186},
		{19848, 37394, 14317},
		{20184, 37323, 14533},
		{20521, 37250, 14798},
		{20857, 37183, 15083},
		{21193, 37124, 15425},
		{21530, 37069, 15800},
		{21866, 37009, 16194},
		{22203, 36962, 16860},
		{22539, 36916, 17637},
		{22876, 36849, 18381},
		{23212, 36719, 19140},
		{23548, 36517, 19837},
		{23885, 36160, 20305},
		{24221, 35626, 20732},
		{24558, 35047, 21203},
		{24894, 34524, 21399},
		{25230, 34044, 19815},
		{25567, 32822, 15920},
		{25903, 31200, 11603},
		{26240, 31200, 11603},
		{26576, 31200, 11603},
		{26912, 31200, 11603},
		{27249, 31200, 11603},
		{27585, 31200, 11603},
		{27922, 31200, 11603},
		{28258, 31200, 11603},
		{28594, 31200, 11603},
		{28931, 31200, 11603},
		{29267, 31200, 11603},
		{29604, 31200, 11603},
		{29940, 31200, 11607}
	},
	{
		{0, 41760, 6890},
		{327, 41633, 5860},
		{653, 41533, 5925},
		{980, 41435, 5883},
		{1307, 41163, 5795},
		{1633, 40827, 6028},
		{1960, 40570, 6370},
		{2286, 40372, 6738},
		{2613, 40157, 7366},
		{2940, 39901, 8336},
		{3266, 39716, 9253},
		{3593, 39559, 9684},
		{3920, 39448, 9911},
		{4246, 39368, 9926},
		{4573, 39283, 10000},
		{4899, 39188, 9902},
		{5226, 39111, 10114},
		{5553, 39047, 10228},
		{5879, 38928, 10045},
		{6206, 38840, 10114},
		{6533, 38745, 10152},
		{6859, 38677, 10156},
		{7186, 38591, 10208},
		{7512, 38535, 10322},
		{7839, 38459, 10370},
		{8166, 38426, 10413},
		{8492, 38363, 10407},
		{8819, 38329, 10461},
		{9146, 38274, 10400},
		{9472, 38206, 10312},
		{9799, 38160, 10482},
		{10126, 38144, 10695},
		{10452, 38078, 10595},
		{10779, 38043, 10687},
		{11105, 38008, 10806},
		{11432, 37982, 10881},
		{11759, 37919, 14515},
		{12085, 37898, 14333},
		{12412, 37874, 15022},
		{12739, 37827, 15669},
		{13065, 37788, 15301},
		{13392, 37753, 11592},
		{13718, 37717, 11216},
		{14045, 37665, 11331},
		{14372, 37618, 11388},
		{14698, 37547, 11671},
		{15025, 37515, 12263},
		{15352, 37426, 12441},
		{15678, 37355, 12574},
		{16005, 37297, 12571},
		{16331, 37230, 12657},
		{16658, 37172, 12987},
		{16985, 37129, 13394},
		{17311, 37064, 13607},
		{17638, 37044, 13702},
		{17965, 36985, 14008},
		{18291, 36927, 13577},
		{18618, 36762, 12896},
		{18944, 36491, 13454},
		{19271, 36057, 13614},
		{19598, 35452, 16709},
		{19924, 34375, 13547},
		{20251, 32882, 16132},
		{20578, 31935, 13264},
		{20904, 30830, 12903},
		{21231, 30830, 12903},
		{21558, 30830, 12903},
		{21884, 30830, 12903},
		{22211, 30830, 12903},
		{22537, 30830, 12903},
		{22864, 30830, 12903},
		{23191, 30830, 12903},
		{23517, 30830, 12903},
		{23844, 30830, 12903},
		{24171, 30830, 12903},
		{24497, 30830, 12903},
		{24824, 30830, 12903},
		{25150, 30830, 12903},
		{25477, 30830, 12903},
		{25804, 30830, 12903},
		{26130, 30830, 12903},
		{26457, 30830, 12903},
		{26784, 30830, 12903},
		{27110, 30830, 12903},
		{27437, 30830, 12903},
		{27763, 30830, 12903},
		{28090, 30830, 12903},
		{28417, 30830, 12903},
		{28743, 30830, 12903},
		{29070, 30830, 12903}
	},
	{
		{0, 42950, 9653},
		{283, 42752, 9653},
		{567, 42580, 9941},
		{850, 42393, 10140},
		{1134, 42191, 10278},
		{1417, 41976, 10500},
		{1701, 41765, 10837},
		{1984, 41570, 11205},
		{2268, 41405, 11535},
		{2551, 41259, 11755},
		{2835, 41125, 11878},
		{3118, 41009, 11987},
		{3402, 40905, 12084},
		{3685, 40805, 12191},
		{3969, 40704, 12366},
		{4252, 40581, 12496},
		{4536, 40425, 12563},
		{4819, 40246, 12661},
		{5103, 40074, 12793},
		{5386, 39933, 12971},
		{5670, 39810, 13033},
		{5953, 39725, 13217},
		{6237, 39622, 13285},
		{6520, 39543, 13400},
		{6804, 39441, 13423},
		{7087, 39352, 13521},
		{7371, 39253, 13553},
		{7654, 39155, 13573},
		{7938, 39055, 13605},
		{8221, 38951, 13670},
		{8504, 38852, 13746},
		{8788, 38756, 13809},
		{9071, 38668, 13897},
		{9355, 38592, 14009},
		{9638, 38516, 14101},
		{9922, 38446, 14201},
		{10205, 38389, 14323},
		{10489, 38332, 14447},
		{10772, 38276, 14581},
		{11056, 38237, 14762},
		{11339, 38180, 14885},
		{11623, 38133, 15007},
		{11906, 38086, 15159},
		{12190, 38047, 15313},
		{12473, 38017, 15517},
		{12757, 37973, 15592},
		{13040, 37939, 15737},
		{13324, 37911, 15963},
		{13607, 37882, 16132},
		{13891, 37859, 16342},
		{14174, 37840, 16618},
		{14458, 37821, 16913},
		{14741, 37802, 17226},
		{15025, 37783, 17521},
		{15308, 37764, 17807},
		{15592, 37743, 18116},
		{15875, 37716, 18424},
		{16159, 37696, 18675},
		{16442, 37676, 18623},
		{16726, 37653, 18538},
		{17009, 37623, 18469},
		{17292, 37590, 18330},
		{17576, 37568, 18257},
		{17859, 37525, 18135},
		{18143, 37474, 17984},
		{18426, 37378, 17648},
		{18710, 33950, 6565},
		{18993, 33950, 6565},
		{19277, 33950, 6565},
		{19560, 33950, 6565},
		{19844, 33950, 6565},
		{20127, 33950, 6565},
		{20411, 33950, 6565},
		{20694, 33950, 6565},
		{20978, 33950, 6565},
		{21261, 33950, 6565},
		{21545, 33950, 6565},
		{21828, 33950, 6565},
		{22112, 33950, 6565},
		{22395, 33950, 6565},
		{22679, 33950, 6565},
		{22962, 33950, 6565},
		{23246, 33950, 6565},
		{23529, 33950, 6565},
		{23813, 33950, 6565},
		{24096, 33950, 6565},
		{24380, 33950, 6565},
		{24663, 33950, 6565},
		{24947, 33950, 6565},
		{25230, 33950, 6565}
	},
	{
		{0, 41600, 4323},
		{226, 41397, 4323},
		{451, 41219, 4503},
		{677, 41066, 4722},
		{903, 40939, 4844},
		{1129, 40841, 4917},
		{1354, 40743, 4957},
		{1580, 40640, 4989},
		{1806, 40527, 5039},
		{2032, 40402, 5090},
		{2257, 40286, 5139},
		{2483, 40177, 5197},
		{2709, 40072, 5265},
		{2934, 39974, 5265},
		{3160, 39888, 5301},
		{3386, 39814, 5351},
		{3612, 39753, 5398},
		{3837, 39686, 5422},
		{4063, 39618, 5446},
		{4289, 39554, 5481},
		{4515, 39491, 5528},
		{4740, 39408, 5552},
		{4966, 39343, 5595},
		{5192, 39276, 5600},
		{5418, 39200, 5558},
		{5643, 39114, 5558},
		{5869, 39031, 5558},
		{6095, 38940, 5495},
		{6320, 38842, 5378},
		{6546, 38745, 5279},
		{6772, 38660, 5203},
		{6998, 38585, 5181},
		{7223, 38516, 5195},
		{7449, 38440, 5171},
		{7675, 38378, 5104},
		{7901, 38322, 5083},
		{8126, 38272, 5108},
		{8352, 38235, 5132},
		{8578, 38197, 5156},
		{8803, 38151, 5168},
		{9029, 38102, 5168},
		{9255, 38064, 5168},
		{9481, 38033, 5210},
		{9706, 38003, 5261},
		{9932, 37976, 5311},
		{10158, 37961, 5360},
		{10384, 37932, 5386},
		{10609, 37911, 5425},
		{10835, 37891, 5460},
		{11061, 37861, 5460},
		{11287, 37838, 5483},
		{11512, 37825, 5508},
		{11738, 37813, 5525},
		{11964, 37791, 5525},
		{12189, 37783, 5573},
		{12415, 37775, 5637},
		{12641, 37768, 5695},
		{12867, 37760, 5720},
		{13092, 37753, 5793},
		{13318, 37735, 5802},
		{13544, 37710, 5801},
		{13770, 37680, 5850},
		{13995, 37649, 5850},
		{14221, 37613, 5885},
		{14447, 37573, 5924},
		{14672, 37526, 5950},
		{14898, 37459, 6000},
		{15124, 37391, 6031},
		{15350, 37320, 6054},
		{15575, 37244, 6079},
		{15801, 37162, 6104},
		{16027, 37107, 6146},
		{16253, 37065, 6235},
		{16478, 37027, 6380},
		{16704, 36989, 6503},
		{16930, 36969, 6735},
		{17156, 36950, 7086},
		{17381, 36923, 7565},
		{17607, 36845, 8172},
		{17833, 36629, 8783},
		{18058, 36254, 9699},
		{18284, 35714, 10777},
		{18510, 34970, 9881},
		{18736, 33949, 6565},
		{18961, 33940, 6565},
		{19187, 33940, 6565},
		{19413, 33940, 6565},
		{19639, 33940, 6565},
		{19864, 33940, 6565},
		{20090, 33940, 6565}
	}
};

/* T8 */
struct fuelgauge_profile_struct fg_profile_t8[TOTAL_BATTERY_NUMBER][90] = {
	{
		{0, 42980, 5308},
		{336, 42832, 5300},
		{673, 42691, 5331},
		{1009, 42556, 5398},
		{1346, 42415, 5485},
		{1682, 42266, 5548},
		{2018, 42112, 5595},
		{2355, 41957, 5682},
		{2691, 41794, 5832},
		{3028, 41626, 6033},
		{3364, 41462, 6278},
		{3700, 41282, 6561},
		{4037, 41093, 6884},
		{4373, 40898, 7298},
		{4710, 40742, 7686},
		{5046, 40606, 8046},
		{5382, 40465, 8353},
		{5719, 40292, 8598},
		{6055, 40111, 8792},
		{6392, 39963, 8879},
		{6728, 39844, 9029},
		{7064, 39739, 9179},
		{7401, 39645, 9246},
		{7737, 39566, 9311},
		{8074, 39487, 9387},
		{8410, 39392, 9497},
		{8747, 39303, 9489},
		{9083, 39210, 9482},
		{9419, 39103, 9569},
		{9756, 38984, 9502},
		{10092, 38869, 9452},
		{10429, 38766, 9541},
		{10765, 38687, 9629},
		{11101, 38611, 9693},
		{11438, 38530, 9715},
		{11774, 38467, 9814},
		{12111, 38406, 9923},
		{12447, 38346, 10032},
		{12783, 38285, 10122},
		{13120, 38230, 10245},
		{13456, 38183, 10420},
		{13793, 38149, 10574},
		{14129, 38109, 10719},
		{14465, 38062, 10850},
		{14802, 38028, 11085},
		{15138, 37991, 11315},
		{15475, 37951, 11534},
		{15811, 37924, 11666},
		{16147, 37893, 11830},
		{16484, 37860, 12028},
		{16820, 37833, 12290},
		{17157, 37798, 12509},
		{17493, 37757, 12691},
		{17829, 37717, 12909},
		{18166, 37680, 13178},
		{18502, 37644, 13475},
		{18839, 37576, 13671},
		{19175, 37517, 13920},
		{19511, 37462, 14186},
		{19848, 37394, 14317},
		{20184, 37323, 14533},
		{20521, 37250, 14798},
		{20857, 37183, 15083},
		{21193, 37124, 15425},
		{21530, 37069, 15800},
		{21866, 37009, 16194},
		{22203, 36962, 16860},
		{22539, 36916, 17637},
		{22876, 36849, 18381},
		{23212, 36719, 19140},
		{23548, 36517, 19837},
		{23885, 36160, 20305},
		{24221, 35626, 20732},
		{24558, 35047, 21203},
		{24894, 34524, 21399},
		{25230, 34044, 19815},
		{25567, 32822, 15920},
		{25903, 31200, 11603},
		{26240, 31200, 11603},
		{26576, 31200, 11603},
		{26912, 31200, 11603},
		{27249, 31200, 11603},
		{27585, 31200, 11603},
		{27922, 31200, 11603},
		{28258, 31200, 11603},
		{28594, 31200, 11603},
		{28931, 31200, 11603},
		{29267, 31200, 11603},
		{29604, 31200, 11603},
		{29940, 31200, 11608}
	},
	{
		{0, 41760, 6890},
		{327, 41633, 5860},
		{653, 41533, 5925},
		{980, 41435, 5883},
		{1307, 41163, 5795},
		{1633, 40827, 6028},
		{1960, 40570, 6370},
		{2286, 40372, 6738},
		{2613, 40157, 7366},
		{2940, 39901, 8336},
		{3266, 39716, 9253},
		{3593, 39559, 9684},
		{3920, 39448, 9911},
		{4246, 39368, 9926},
		{4573, 39283, 10000},
		{4899, 39188, 9902},
		{5226, 39111, 10114},
		{5553, 39047, 10228},
		{5879, 38928, 10045},
		{6206, 38840, 10114},
		{6533, 38745, 10152},
		{6859, 38677, 10156},
		{7186, 38591, 10208},
		{7512, 38535, 10322},
		{7839, 38459, 10370},
		{8166, 38426, 10413},
		{8492, 38363, 10407},
		{8819, 38329, 10461},
		{9146, 38274, 10400},
		{9472, 38206, 10312},
		{9799, 38160, 10482},
		{10126, 38144, 10695},
		{10452, 38078, 10595},
		{10779, 38043, 10687},
		{11105, 38008, 10806},
		{11432, 37982, 10881},
		{11759, 37919, 14515},
		{12085, 37898, 14333},
		{12412, 37874, 15022},
		{12739, 37827, 15669},
		{13065, 37788, 15301},
		{13392, 37753, 11592},
		{13718, 37717, 11216},
		{14045, 37665, 11331},
		{14372, 37618, 11388},
		{14698, 37547, 11671},
		{15025, 37515, 12263},
		{15352, 37426, 12441},
		{15678, 37355, 12574},
		{16005, 37297, 12571},
		{16331, 37230, 12657},
		{16658, 37172, 12987},
		{16985, 37129, 13394},
		{17311, 37064, 13607},
		{17638, 37044, 13702},
		{17965, 36985, 14008},
		{18291, 36927, 13577},
		{18618, 36762, 12896},
		{18944, 36491, 13454},
		{19271, 36057, 13614},
		{19598, 35452, 16709},
		{19924, 34375, 13547},
		{20251, 32882, 16132},
		{20578, 31935, 13264},
		{20904, 30830, 12903},
		{21231, 30830, 12903},
		{21558, 30830, 12903},
		{21884, 30830, 12903},
		{22211, 30830, 12903},
		{22537, 30830, 12903},
		{22864, 30830, 12903},
		{23191, 30830, 12903},
		{23517, 30830, 12903},
		{23844, 30830, 12903},
		{24171, 30830, 12903},
		{24497, 30830, 12903},
		{24824, 30830, 12903},
		{25150, 30830, 12903},
		{25477, 30830, 12903},
		{25804, 30830, 12903},
		{26130, 30830, 12903},
		{26457, 30830, 12903},
		{26784, 30830, 12903},
		{27110, 30830, 12903},
		{27437, 30830, 12903},
		{27763, 30830, 12903},
		{28090, 30830, 12903},
		{28417, 30830, 12903},
		{28743, 30830, 12903},
		{29070, 30830, 12903}
	},
	{
		{0, 42950, 9653},
		{283, 42752, 9653},
		{567, 42580, 9941},
		{850, 42393, 10140},
		{1134, 42191, 10278},
		{1417, 41976, 10500},
		{1701, 41765, 10837},
		{1984, 41570, 11205},
		{2268, 41405, 11535},
		{2551, 41259, 11755},
		{2835, 41125, 11878},
		{3118, 41009, 11987},
		{3402, 40905, 12084},
		{3685, 40805, 12191},
		{3969, 40704, 12366},
		{4252, 40581, 12496},
		{4536, 40425, 12563},
		{4819, 40246, 12661},
		{5103, 40074, 12793},
		{5386, 39933, 12971},
		{5670, 39810, 13033},
		{5953, 39725, 13217},
		{6237, 39622, 13285},
		{6520, 39543, 13400},
		{6804, 39441, 13423},
		{7087, 39352, 13521},
		{7371, 39253, 13553},
		{7654, 39155, 13573},
		{7938, 39055, 13605},
		{8221, 38951, 13670},
		{8504, 38852, 13746},
		{8788, 38756, 13809},
		{9071, 38668, 13897},
		{9355, 38592, 14009},
		{9638, 38516, 14101},
		{9922, 38446, 14201},
		{10205, 38389, 14323},
		{10489, 38332, 14447},
		{10772, 38276, 14581},
		{11056, 38237, 14762},
		{11339, 38180, 14885},
		{11623, 38133, 15007},
		{11906, 38086, 15159},
		{12190, 38047, 15313},
		{12473, 38017, 15517},
		{12757, 37973, 15592},
		{13040, 37939, 15737},
		{13324, 37911, 15963},
		{13607, 37882, 16132},
		{13891, 37859, 16342},
		{14174, 37840, 16618},
		{14458, 37821, 16913},
		{14741, 37802, 17226},
		{15025, 37783, 17521},
		{15308, 37764, 17807},
		{15592, 37743, 18116},
		{15875, 37716, 18424},
		{16159, 37696, 18675},
		{16442, 37676, 18623},
		{16726, 37653, 18538},
		{17009, 37623, 18469},
		{17292, 37590, 18330},
		{17576, 37568, 18257},
		{17859, 37525, 18135},
		{18143, 37474, 17984},
		{18426, 37378, 17648},
		{18710, 33950, 6565},
		{18993, 33950, 6565},
		{19277, 33950, 6565},
		{19560, 33950, 6565},
		{19844, 33950, 6565},
		{20127, 33950, 6565},
		{20411, 33950, 6565},
		{20694, 33950, 6565},
		{20978, 33950, 6565},
		{21261, 33950, 6565},
		{21545, 33950, 6565},
		{21828, 33950, 6565},
		{22112, 33950, 6565},
		{22395, 33950, 6565},
		{22679, 33950, 6565},
		{22962, 33950, 6565},
		{23246, 33950, 6565},
		{23529, 33950, 6565},
		{23813, 33950, 6565},
		{24096, 33950, 6565},
		{24380, 33950, 6565},
		{24663, 33950, 6565},
		{24947, 33950, 6565},
		{25230, 33950, 6565}
	},
	{
		{0, 41600, 4323},
		{226, 41397, 4323},
		{451, 41219, 4503},
		{677, 41066, 4722},
		{903, 40939, 4844},
		{1129, 40841, 4917},
		{1354, 40743, 4957},
		{1580, 40640, 4989},
		{1806, 40527, 5039},
		{2032, 40402, 5090},
		{2257, 40286, 5139},
		{2483, 40177, 5197},
		{2709, 40072, 5265},
		{2934, 39974, 5265},
		{3160, 39888, 5301},
		{3386, 39814, 5351},
		{3612, 39753, 5398},
		{3837, 39686, 5422},
		{4063, 39618, 5446},
		{4289, 39554, 5481},
		{4515, 39491, 5528},
		{4740, 39408, 5552},
		{4966, 39343, 5595},
		{5192, 39276, 5600},
		{5418, 39200, 5558},
		{5643, 39114, 5558},
		{5869, 39031, 5558},
		{6095, 38940, 5495},
		{6320, 38842, 5378},
		{6546, 38745, 5279},
		{6772, 38660, 5203},
		{6998, 38585, 5181},
		{7223, 38516, 5195},
		{7449, 38440, 5171},
		{7675, 38378, 5104},
		{7901, 38322, 5083},
		{8126, 38272, 5108},
		{8352, 38235, 5132},
		{8578, 38197, 5156},
		{8803, 38151, 5168},
		{9029, 38102, 5168},
		{9255, 38064, 5168},
		{9481, 38033, 5210},
		{9706, 38003, 5261},
		{9932, 37976, 5311},
		{10158, 37961, 5360},
		{10384, 37932, 5386},
		{10609, 37911, 5425},
		{10835, 37891, 5460},
		{11061, 37861, 5460},
		{11287, 37838, 5483},
		{11512, 37825, 5508},
		{11738, 37813, 5525},
		{11964, 37791, 5525},
		{12189, 37783, 5573},
		{12415, 37775, 5637},
		{12641, 37768, 5695},
		{12867, 37760, 5720},
		{13092, 37753, 5793},
		{13318, 37735, 5802},
		{13544, 37710, 5801},
		{13770, 37680, 5850},
		{13995, 37649, 5850},
		{14221, 37613, 5885},
		{14447, 37573, 5924},
		{14672, 37526, 5950},
		{14898, 37459, 6000},
		{15124, 37391, 6031},
		{15350, 37320, 6054},
		{15575, 37244, 6079},
		{15801, 37162, 6104},
		{16027, 37107, 6146},
		{16253, 37065, 6235},
		{16478, 37027, 6380},
		{16704, 36989, 6503},
		{16930, 36969, 6735},
		{17156, 36950, 7086},
		{17381, 36923, 7565},
		{17607, 36845, 8172},
		{17833, 36629, 8783},
		{18058, 36254, 9699},
		{18284, 35714, 10777},
		{18510, 34970, 9881},
		{18736, 33949, 6565},
		{18961, 33940, 6565},
		{19187, 33940, 6565},
		{19413, 33940, 6565},
		{19639, 33940, 6565},
		{19864, 33940, 6565},
		{20090, 33940, 6565}
	}
};

/* T9 */
struct fuelgauge_profile_struct fg_profile_t9[TOTAL_BATTERY_NUMBER][90] = {
	{
		{0, 42980, 5309},
		{336, 42832, 5300},
		{673, 42691, 5331},
		{1009, 42556, 5398},
		{1346, 42415, 5485},
		{1682, 42266, 5548},
		{2018, 42112, 5595},
		{2355, 41957, 5682},
		{2691, 41794, 5832},
		{3028, 41626, 6033},
		{3364, 41462, 6278},
		{3700, 41282, 6561},
		{4037, 41093, 6884},
		{4373, 40898, 7298},
		{4710, 40742, 7686},
		{5046, 40606, 8046},
		{5382, 40465, 8353},
		{5719, 40292, 8598},
		{6055, 40111, 8792},
		{6392, 39963, 8879},
		{6728, 39844, 9029},
		{7064, 39739, 9179},
		{7401, 39645, 9246},
		{7737, 39566, 9311},
		{8074, 39487, 9387},
		{8410, 39392, 9497},
		{8747, 39303, 9489},
		{9083, 39210, 9482},
		{9419, 39103, 9569},
		{9756, 38984, 9502},
		{10092, 38869, 9452},
		{10429, 38766, 9541},
		{10765, 38687, 9629},
		{11101, 38611, 9693},
		{11438, 38530, 9715},
		{11774, 38467, 9814},
		{12111, 38406, 9923},
		{12447, 38346, 10032},
		{12783, 38285, 10122},
		{13120, 38230, 10245},
		{13456, 38183, 10420},
		{13793, 38149, 10574},
		{14129, 38109, 10719},
		{14465, 38062, 10850},
		{14802, 38028, 11085},
		{15138, 37991, 11315},
		{15475, 37951, 11534},
		{15811, 37924, 11666},
		{16147, 37893, 11830},
		{16484, 37860, 12028},
		{16820, 37833, 12290},
		{17157, 37798, 12509},
		{17493, 37757, 12691},
		{17829, 37717, 12909},
		{18166, 37680, 13178},
		{18502, 37644, 13475},
		{18839, 37576, 13671},
		{19175, 37517, 13920},
		{19511, 37462, 14186},
		{19848, 37394, 14317},
		{20184, 37323, 14533},
		{20521, 37250, 14798},
		{20857, 37183, 15083},
		{21193, 37124, 15425},
		{21530, 37069, 15800},
		{21866, 37009, 16194},
		{22203, 36962, 16860},
		{22539, 36916, 17637},
		{22876, 36849, 18381},
		{23212, 36719, 19140},
		{23548, 36517, 19837},
		{23885, 36160, 20305},
		{24221, 35626, 20732},
		{24558, 35047, 21203},
		{24894, 34524, 21399},
		{25230, 34044, 19815},
		{25567, 32822, 15920},
		{25903, 31200, 11603},
		{26240, 31200, 11603},
		{26576, 31200, 11603},
		{26912, 31200, 11603},
		{27249, 31200, 11603},
		{27585, 31200, 11603},
		{27922, 31200, 11603},
		{28258, 31200, 11603},
		{28594, 31200, 11603},
		{28931, 31200, 11603},
		{29267, 31200, 11603},
		{29604, 31200, 11603},
		{29940, 31200, 11609}
	},
	{
		{0, 41760, 6890},
		{327, 41633, 5860},
		{653, 41533, 5925},
		{980, 41435, 5883},
		{1307, 41163, 5795},
		{1633, 40827, 6028},
		{1960, 40570, 6370},
		{2286, 40372, 6738},
		{2613, 40157, 7366},
		{2940, 39901, 8336},
		{3266, 39716, 9253},
		{3593, 39559, 9684},
		{3920, 39448, 9911},
		{4246, 39368, 9926},
		{4573, 39283, 10000},
		{4899, 39188, 9902},
		{5226, 39111, 10114},
		{5553, 39047, 10228},
		{5879, 38928, 10045},
		{6206, 38840, 10114},
		{6533, 38745, 10152},
		{6859, 38677, 10156},
		{7186, 38591, 10208},
		{7512, 38535, 10322},
		{7839, 38459, 10370},
		{8166, 38426, 10413},
		{8492, 38363, 10407},
		{8819, 38329, 10461},
		{9146, 38274, 10400},
		{9472, 38206, 10312},
		{9799, 38160, 10482},
		{10126, 38144, 10695},
		{10452, 38078, 10595},
		{10779, 38043, 10687},
		{11105, 38008, 10806},
		{11432, 37982, 10881},
		{11759, 37919, 14515},
		{12085, 37898, 14333},
		{12412, 37874, 15022},
		{12739, 37827, 15669},
		{13065, 37788, 15301},
		{13392, 37753, 11592},
		{13718, 37717, 11216},
		{14045, 37665, 11331},
		{14372, 37618, 11388},
		{14698, 37547, 11671},
		{15025, 37515, 12263},
		{15352, 37426, 12441},
		{15678, 37355, 12574},
		{16005, 37297, 12571},
		{16331, 37230, 12657},
		{16658, 37172, 12987},
		{16985, 37129, 13394},
		{17311, 37064, 13607},
		{17638, 37044, 13702},
		{17965, 36985, 14008},
		{18291, 36927, 13577},
		{18618, 36762, 12896},
		{18944, 36491, 13454},
		{19271, 36057, 13614},
		{19598, 35452, 16709},
		{19924, 34375, 13547},
		{20251, 32882, 16132},
		{20578, 31935, 13264},
		{20904, 30830, 12903},
		{21231, 30830, 12903},
		{21558, 30830, 12903},
		{21884, 30830, 12903},
		{22211, 30830, 12903},
		{22537, 30830, 12903},
		{22864, 30830, 12903},
		{23191, 30830, 12903},
		{23517, 30830, 12903},
		{23844, 30830, 12903},
		{24171, 30830, 12903},
		{24497, 30830, 12903},
		{24824, 30830, 12903},
		{25150, 30830, 12903},
		{25477, 30830, 12903},
		{25804, 30830, 12903},
		{26130, 30830, 12903},
		{26457, 30830, 12903},
		{26784, 30830, 12903},
		{27110, 30830, 12903},
		{27437, 30830, 12903},
		{27763, 30830, 12903},
		{28090, 30830, 12903},
		{28417, 30830, 12903},
		{28743, 30830, 12903},
		{29070, 30830, 12903}
	},
	{
		{0, 42950, 9653},
		{283, 42752, 9653},
		{567, 42580, 9941},
		{850, 42393, 10140},
		{1134, 42191, 10278},
		{1417, 41976, 10500},
		{1701, 41765, 10837},
		{1984, 41570, 11205},
		{2268, 41405, 11535},
		{2551, 41259, 11755},
		{2835, 41125, 11878},
		{3118, 41009, 11987},
		{3402, 40905, 12084},
		{3685, 40805, 12191},
		{3969, 40704, 12366},
		{4252, 40581, 12496},
		{4536, 40425, 12563},
		{4819, 40246, 12661},
		{5103, 40074, 12793},
		{5386, 39933, 12971},
		{5670, 39810, 13033},
		{5953, 39725, 13217},
		{6237, 39622, 13285},
		{6520, 39543, 13400},
		{6804, 39441, 13423},
		{7087, 39352, 13521},
		{7371, 39253, 13553},
		{7654, 39155, 13573},
		{7938, 39055, 13605},
		{8221, 38951, 13670},
		{8504, 38852, 13746},
		{8788, 38756, 13809},
		{9071, 38668, 13897},
		{9355, 38592, 14009},
		{9638, 38516, 14101},
		{9922, 38446, 14201},
		{10205, 38389, 14323},
		{10489, 38332, 14447},
		{10772, 38276, 14581},
		{11056, 38237, 14762},
		{11339, 38180, 14885},
		{11623, 38133, 15007},
		{11906, 38086, 15159},
		{12190, 38047, 15313},
		{12473, 38017, 15517},
		{12757, 37973, 15592},
		{13040, 37939, 15737},
		{13324, 37911, 15963},
		{13607, 37882, 16132},
		{13891, 37859, 16342},
		{14174, 37840, 16618},
		{14458, 37821, 16913},
		{14741, 37802, 17226},
		{15025, 37783, 17521},
		{15308, 37764, 17807},
		{15592, 37743, 18116},
		{15875, 37716, 18424},
		{16159, 37696, 18675},
		{16442, 37676, 18623},
		{16726, 37653, 18538},
		{17009, 37623, 18469},
		{17292, 37590, 18330},
		{17576, 37568, 18257},
		{17859, 37525, 18135},
		{18143, 37474, 17984},
		{18426, 37378, 17648},
		{18710, 33950, 6565},
		{18993, 33950, 6565},
		{19277, 33950, 6565},
		{19560, 33950, 6565},
		{19844, 33950, 6565},
		{20127, 33950, 6565},
		{20411, 33950, 6565},
		{20694, 33950, 6565},
		{20978, 33950, 6565},
		{21261, 33950, 6565},
		{21545, 33950, 6565},
		{21828, 33950, 6565},
		{22112, 33950, 6565},
		{22395, 33950, 6565},
		{22679, 33950, 6565},
		{22962, 33950, 6565},
		{23246, 33950, 6565},
		{23529, 33950, 6565},
		{23813, 33950, 6565},
		{24096, 33950, 6565},
		{24380, 33950, 6565},
		{24663, 33950, 6565},
		{24947, 33950, 6565},
		{25230, 33950, 6565}
	},
	{
		{0, 41600, 4323},
		{226, 41397, 4323},
		{451, 41219, 4503},
		{677, 41066, 4722},
		{903, 40939, 4844},
		{1129, 40841, 4917},
		{1354, 40743, 4957},
		{1580, 40640, 4989},
		{1806, 40527, 5039},
		{2032, 40402, 5090},
		{2257, 40286, 5139},
		{2483, 40177, 5197},
		{2709, 40072, 5265},
		{2934, 39974, 5265},
		{3160, 39888, 5301},
		{3386, 39814, 5351},
		{3612, 39753, 5398},
		{3837, 39686, 5422},
		{4063, 39618, 5446},
		{4289, 39554, 5481},
		{4515, 39491, 5528},
		{4740, 39408, 5552},
		{4966, 39343, 5595},
		{5192, 39276, 5600},
		{5418, 39200, 5558},
		{5643, 39114, 5558},
		{5869, 39031, 5558},
		{6095, 38940, 5495},
		{6320, 38842, 5378},
		{6546, 38745, 5279},
		{6772, 38660, 5203},
		{6998, 38585, 5181},
		{7223, 38516, 5195},
		{7449, 38440, 5171},
		{7675, 38378, 5104},
		{7901, 38322, 5083},
		{8126, 38272, 5108},
		{8352, 38235, 5132},
		{8578, 38197, 5156},
		{8803, 38151, 5168},
		{9029, 38102, 5168},
		{9255, 38064, 5168},
		{9481, 38033, 5210},
		{9706, 38003, 5261},
		{9932, 37976, 5311},
		{10158, 37961, 5360},
		{10384, 37932, 5386},
		{10609, 37911, 5425},
		{10835, 37891, 5460},
		{11061, 37861, 5460},
		{11287, 37838, 5483},
		{11512, 37825, 5508},
		{11738, 37813, 5525},
		{11964, 37791, 5525},
		{12189, 37783, 5573},
		{12415, 37775, 5637},
		{12641, 37768, 5695},
		{12867, 37760, 5720},
		{13092, 37753, 5793},
		{13318, 37735, 5802},
		{13544, 37710, 5801},
		{13770, 37680, 5850},
		{13995, 37649, 5850},
		{14221, 37613, 5885},
		{14447, 37573, 5924},
		{14672, 37526, 5950},
		{14898, 37459, 6000},
		{15124, 37391, 6031},
		{15350, 37320, 6054},
		{15575, 37244, 6079},
		{15801, 37162, 6104},
		{16027, 37107, 6146},
		{16253, 37065, 6235},
		{16478, 37027, 6380},
		{16704, 36989, 6503},
		{16930, 36969, 6735},
		{17156, 36950, 7086},
		{17381, 36923, 7565},
		{17607, 36845, 8172},
		{17833, 36629, 8783},
		{18058, 36254, 9699},
		{18284, 35714, 10777},
		{18510, 34970, 9881},
		{18736, 33949, 6565},
		{18961, 33940, 6565},
		{19187, 33940, 6565},
		{19413, 33940, 6565},
		{19639, 33940, 6565},
		{19864, 33940, 6565},
		{20090, 33940, 6565}
	}
};
#endif
