/*
 * Copyright (C) 2016 MediaTek Inc.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 2 as
 * published by the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See http://www.gnu.org/licenses/gpl-2.0.html for more details.
 */
/*! \file
*    \brief  Declaration of library functions
*
*    Any definitions in this file will be shared among GLUE Layer and internal Driver Stack.
*/

#define pr_fmt(fmt) KBUILD_MODNAME "@(%s:%d) " fmt, __func__, __LINE__

#include "consys_hw.h"
#include "emi_mng.h"
#include "mt6880_pos.h"

/*******************************************************************************
*                            P U B L I C   D A T A
********************************************************************************
*/

struct consys_platform_emi_ops g_consys_platform_emi_ops_mt6880 = {
	.consys_ic_emi_mpu_set_region_protection = NULL,
	.consys_ic_emi_set_remapping_reg = consys_emi_set_remapping_reg,
	.consys_ic_emi_get_md_shared_emi = NULL,
	.consys_ic_emi_get_fw_emi_size = NULL,
};

