/*
 * Copyright (C) 2016 MediaTek Inc.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 2 as
 * published by the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See http://www.gnu.org/licenses/gpl-2.0.html for more details.
 */
/*! \file
*    \brief  Declaration of library functions
*
*    Any definitions in this file will be shared among GLUE Layer and internal Driver Stack.
*/

#define pr_fmt(fmt) KBUILD_MODNAME "@(%s:%d) " fmt, __func__, __LINE__

#include <connectivity_build_in_adapter.h>
#include <linux/memblock.h>
#include <linux/platform_device.h>
#include <linux/of_reserved_mem.h>
#include <linux/regulator/consumer.h>
#include <linux/notifier.h>

#include "consys_hw.h"
#include "consys_reg_util.h"
#include "osal.h"
#include "mt6880_pmic.h"
#include "mt6880_pos.h"
#include "mt6880_consys_reg.h"
#include "mt6880_consys_reg_offset.h"

/*******************************************************************************
*                         C O M P I L E R   F L A G S
********************************************************************************
*/

/*******************************************************************************
*                                 M A C R O S
********************************************************************************
*/


/*******************************************************************************
*                    E X T E R N A L   R E F E R E N C E S
********************************************************************************
*/

/*******************************************************************************
*                              C O N S T A N T S
********************************************************************************
*/

/*******************************************************************************
*                             D A T A   T Y P E S
********************************************************************************
*/

/*******************************************************************************
*                  F U N C T I O N   D E C L A R A T I O N S
********************************************************************************
*/

static int consys_plt_pmic_get_from_dts(struct platform_device *pdev, struct conninfra_dev_cb* dev_cb);

static int consys_plt_pmic_common_power_ctrl(unsigned int enable);
static int consys_plt_pmic_gps_power_ctrl(unsigned int enable);

/*******************************************************************************
*                            P U B L I C   D A T A
********************************************************************************
*/

const struct consys_platform_pmic_ops g_consys_platform_pmic_ops_mt6880 = {
	.consys_pmic_get_from_dts = consys_plt_pmic_get_from_dts,
	.consys_pmic_common_power_ctrl = consys_plt_pmic_common_power_ctrl,
	.consys_pmic_wifi_power_ctrl = NULL,
	.consys_pmic_bt_power_ctrl = NULL,
	.consys_pmic_gps_power_ctrl = consys_plt_pmic_gps_power_ctrl,
	.consys_pmic_fm_power_ctrl = NULL,
	.consys_pmic_event_notifier = NULL,
};

#if CFG_CONNINFRA_PMIC_SUPPORT
struct regulator *reg_VCN18;
#endif

static struct conninfra_dev_cb* g_dev_cb;

/*******************************************************************************
*                           P R I V A T E   D A T A
********************************************************************************
*/

/*******************************************************************************
*                              F U N C T I O N S
********************************************************************************
*/

int consys_plt_pmic_get_from_dts(struct platform_device *pdev, struct conninfra_dev_cb* dev_cb)
{

	g_dev_cb = dev_cb;
#if CFG_CONNINFRA_PMIC_SUPPORT
	reg_VCN18 = regulator_get(&pdev->dev, "vcn18");
	if (!reg_VCN18)
		pr_err("Regulator_get VCN_18 fail\n");
#endif /* CFG_CONNINFRA_PMIC_SUPPORT */
	return 0;
}

int consys_plt_pmic_common_power_ctrl(unsigned int enable)
{
#if CFG_CONNINFRA_PMIC_SUPPORT
	int ret;

	/* Only support legacy mode */
	if (enable) {
		/* Set PMIC VCN18 LDO SW_OP_EN =1, SW_EN = 1, SW_LP =0
		 * (sw enable & into normal mode)
		 */
		/* SW_LP=0, default is 0 */
		/* Setup voltage */
		regulator_set_voltage(reg_VCN18, 1800000, 1800000);
		/* SW_EN=1 */
		ret = regulator_enable(reg_VCN18);
		if (ret)
			pr_err("[%s] regulator_enable return error %d", __func__, ret);
	} else {
		/* Set PMIC VCN18 LDO SW_OP_EN =0, SW_EN = 0, SW_LP =0 (sw disable)
		 */
		regulator_disable(reg_VCN18);
	}
#endif /* CFG_CONNINFRA_PMIC_SUPPORT */
	return 0;
}

int consys_plt_pmic_gps_power_ctrl(unsigned int enable)
{
	return 0;
}


