/*
 * Copyright (C) 2019 MediaTek Inc.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 2 as
 * published by the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See http://www.gnu.org/licenses/gpl-2.0.html for more details.
 */
#ifndef _GPS_DL_LINUX_PLAT_DRV_H
#define _GPS_DL_LINUX_PLAT_DRV_H

#include <linux/regulator/consumer.h>
#include "gps_dl_config.h"

#if GPS_DL_HAS_PLAT_DRV
#include <linux/io.h>
struct gps_dl_iomem_addr_map_entry {
	void __iomem *host_virt_addr;
	unsigned int host_phys_addr;
	unsigned int length;
};
#endif


#define GPS_DL_VCORE_ALWAYS_ON	(0x1<<0)
#define GPS_DL_VCORE_ALWAYS_OFF	(0x1<<1)
#define GPS_DL_VCORE_STATUS_SETED	(0x1<<2)
#define GPS_DL_VCORE_PROCFS_MASK	(~(GPS_DL_VCORE_ALWAYS_ON|GPS_DL_VCORE_ALWAYS_OFF))

#define GPS_DL_VCORE_HOLD_ON(flag)	((flag) & GPS_DL_VCORE_STATUS_SETED)
#define GPS_DL_VCORE_CAN_NOT_RELEASE(flag, forced)	\
	(((flag) & GPS_DL_VCORE_ALWAYS_ON) && !(forced))
#define GPS_DL_VCORE_CAN_NOT_REQUIRE(flag)	((flag) & GPS_DL_VCORE_ALWAYS_OFF)

#define GPS_DL_VCORE_REQUIRE_SUCCESS (0)
#define GPS_DL_VCORE_REQUIRE_FORBIDDEN (-1)
#define GPS_DL_VCORE_REQUIRE_FAIL (-2)

#define GPS_DL_VCORE_RELEASE_SUCCESS (0)
#define GPS_DL_VCORE_RELEASE_FORBIDDEN (-1)
#define GPS_DL_VCORE_RELEASE_FAIL (-2)


struct gps_dl_vcore_context {
	struct regulator *p_regulator;
	unsigned int flag;
};

#if GPS_DL_HAS_PLAT_DRV
bool gps_dl_read_pmic_efuse_reg(unsigned int reg, unsigned int *val);
int gps_dl_linux_plat_drv_register(void);
int gps_dl_linux_plat_drv_unregister(void);
void __iomem *gps_dl_host_addr_to_virt(unsigned int host_addr);
void gps_dl_update_status_for_md_blanking(bool gps_is_on);
void gps_dl_tia_gps_ctrl(bool gps_is_on);
void gps_dl_lna_pin_ctrl(enum gps_dl_link_id_enum link_id, bool dsp_is_on, bool force_en);
void gps_dl_reserved_mem_show_info(void);
void gps_dl_wake_lock_init(void);
void gps_dl_wake_lock_deinit(void);
void gps_dl_wake_lock_hold(bool hold);


extern struct gps_dl_vcore_context g_gps_dl_vcore_context;
extern enum gps_dl_procfs_vcore_enum gps_dl_procfs_vcore_action;
#endif

#endif /* _GPS_DL_LINUX_PLAT_DRV_H */

