#ifndef _AUDIO_CTRL_SERVICE_INNER_API_H_
#define _AUDIO_CTRL_SERVICE_INNER_API_H_

#define ACS_IPC_FOR_UPPER_SEND "/tmp/audio_ctrl_service/speech_flow_upper_send"
#define ACS_IPC_FOR_UPPER_RCV "/tmp/audio_ctrl_service/speech_flow_upper_rcv"

#define ACS_IPC_FOR_LOWER_SEND "/tmp/audio_ctrl_service/speech_flow_lower_send"
#define ACS_IPC_FOR_LOWER_RCV "/tmp/audio_ctrl_service/speech_flow_lower_rcv"

#define FUNC_AUDIO_CTRL_SERVICE_SPEECH_ON 0
#define FUNC_AUDIO_CTRL_SERVICE_SET_DL_VOLUME 1
#define FUNC_AUDIO_CTRL_INCALL_SERVICE_RECORD_DATA_CB 2
#define FUNC_AUDIO_CTRL_INCALL_RECORD_START 3
#define FUNC_AUDIO_CTRL_INCALL_RECORD_STOP 4
#define FUNC_AUDIO_CTRL_INCALL_RECORD_POINTER 5
#define FUNC_AUDIO_CTRL_INCALL_RECORD_GET_WATERMARK 6
#define FUNC_AUDIO_CTRL_INCALL_RECORD_GET_DATA 7
#define FUNC_AUDIO_CTRL_INCALL_PLAYBACK_START 8
#define FUNC_AUDIO_CTRL_INCALL_PLAYBACK_STOP 9
#define FUNC_AUDIO_CTRL_INCALL_PLAYBACK_SEND_DATA 10
#define FUNC_AUDIO_CTRL_SERVICE_IS_SPEECH_ON 11
#define FUNC_AUDIO_CTRL_SERVICE_GET_DL_GAIN 12

#define FUNC_AUDIO_CTRL_SERVICE_GET_RECORD_PERIOD_SIZE 13
#define FUNC_AUDIO_CTRL_SERVICE_GET_PLAYBACK_PERIOD_SIZE 14
#define FUNC_AUDIO_CTRL_SERVICE_GET_RECORD_MAX_BUFFER_SIZE 15
#define FUNC_AUDIO_CTRL_SERVICE_GET_PLAYBACK_MAX_BUFFER_SIZE 16

#define FUNC_AUDIO_CTRL_SERVICE_VMLOG_ON 17
#define FUNC_AUDIO_CTRL_SERVICE_GET_VMLOG_ON 18

#define FUNC_AUDIO_CTRL_SERVICE_BT_SPEECH_ON 19
#define FUNC_AUDIO_CTRL_SERVICE_IS_BT_SPEECH_ON 20

#define FUNC_AUDIO_CTRL_SERVICE_SET_BT_WBS 21
#define FUNC_AUDIO_CTRL_SERVICE_GET_BT_WBS 22

#define FUNC_AUDIO_CTRL_SERVICE_SET_BT_DL_GAIN 23
#define FUNC_AUDIO_CTRL_SERVICE_GET_BT_DL_GAIN 24

#define FUNC_AUDIO_CTRL_SERVICE_SET_BT_CLIENT_HAS_ECNR 25
#define FUNC_AUDIO_CTRL_SERVICE_GET_BT_CLIENT_HAS_ECNR 26

#define FUNC_AUDIO_CTRL_SERVICE_SET_USE_BT_IN_CALL 27
#define FUNC_AUDIO_CTRL_SERVICE_GET_USE_BT_IN_CALL 28

#define FUNC_AUDIO_CTRL_SERVICE_RESET_INNER 29
#define FUNC_AUDIO_CTRL_SERVICE_SET_SPEAKER_TYPE 30

#define FUNC_AUDIO_CTRL_SERVICE_SET_DL_MUTE 31
#define FUNC_AUDIO_CTRL_SERVICE_SET_UL_MUTE 32
#define FUNC_AUDIO_CTRL_SERVICE_GET_MUTE 33
#define FUNC_AUDIO_CTRL_INCALL_PLAYBACK_SIMULATION 34
#define FUNC_AUDIO_CTRL_M2M_CALL_ON 35
#define FUNC_AUDIO_CTRL_ECALL_ON 36


#define IPC_DATA_SIZE_MAX 2048
#define RECORD_PERIOD_SIZE 640
#define RECORD_MAX_BUFFER_SIZE 1920
#define PHONECALL_SAMPLE_RATE 32000
#define PLAYBACK_PERIOD_SIZE \
    ((2 * 1 * PHONECALL_SAMPLE_RATE * 20) / 1000)
#define PLAYBACK_BUF_SIZE 2048
#define PLAYBACK_MAX_BUFFER_SIZE PLAYBACK_PERIOD_SIZE * 2
enum {
    SPEECH_DL,
    SPEECH_UL,
};

/* APIs for speech */
int audio_ctrl_service_speech_on_inner(int enable, int output_device);
int audio_ctrl_service_is_speech_on_inner(int output_device);
int audio_ctrl_service_set_volume_index_inner(int volumeIdx);
int audio_ctrl_service_get_volume_index_inner();
int audio_ctrl_service_set_speaker_type_inner(int type);
int audio_ctrl_service_M2M_Call_on_inner(int enable);
int audio_ctrl_service_ECall_on_inner(int enable);


/* API for libspeech_drv inCall record callback*/
int audio_ctrl_service_inCall_record_data_cb_inner(int data_size, char* data);

/* APIs for ioplugin record*/
int audio_ctrl_service_inCall_record_start_inner(int buf_size);
int audio_ctrl_service_inCall_record_stop_inner();
int audio_ctrl_service_inCall_record_pointer_inner();
int audio_ctrl_service_inCall_record_get_watermark_inner();
int audio_ctrl_service_inCall_record_get_data_inner(int data_size, char* dest);

/* APIs for ioplugin playback*/
int audio_ctrl_service_inCall_playback_start_inner();
int audio_ctrl_service_inCall_playback_stop_inner();
int audio_ctrl_service_inCall_playback_send_data_inner(int data_size, void* data_buf);
int audio_ctrl_service_inCall_playback_simulation(int data_ms);

/* APIs for parameters get */
int audio_ctrl_service_get_record_period_size_inner();
int audio_ctrl_service_get_playback_period_size_inner();
int audio_ctrl_service_get_record_max_buffer_size_inner();
int audio_ctrl_service_get_playback_max_buffer_size_inner();

/* APIs for vmlog */
int audio_ctrl_service_vmlog_on_inner(int vmlog_on);
int audio_ctrl_service_get_vmlog_on_inner();

/* APIs for BT ctrl */
int audio_ctrl_service_set_bt_wbs_inner(int bt_wbs_on);
int audio_ctrl_service_get_bt_wbs_inner();
 int audio_ctrl_service_set_bt_client_has_ecnr_inner(int bt_client_ecnr_on);
int audio_ctrl_service_get_bt_client_has_ecnr_inner();
int audio_ctrl_service_set_use_bt_in_call_inner(int trun_on_bt_in_call);
int audio_ctrl_service_get_use_bt_in_call_inner();

/* APIs for reset call */
int audio_ctrl_service_reset_inner();

/* API for set DL/UL mute */
int audio_ctrl_service_set_mute_inner(int path, int is_mute);
int audio_ctrl_service_get_mute_inner(int path);

#endif

