#ifndef _DTMF_H_
#define _DTMF_H_

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <assert.h>
#include <unistd.h>
#include <errno.h>
#include <getopt.h>
#include <pthread.h>

//#include <glib.h>
#include <gst/gst.h>

#define DTMF_MIN_LENGTH 150    //unit: millisecond

typedef void *DTMF_HANDLE;

typedef struct {
	gint output;	//0-pulsesink; 1-filesink
	char *path;		//only used while output is filesink
} DTMF_EXTRA;

/**
 * dtmf_start:
 * @num: the event number, [0, 15]
 * @time_ms: the length of time of the dtmf tone, must be "==0" or ">=150" (unit: millisecond)
 * @volume: the power level of the dtmf tone, [0, 36] indicate 0~-36 dBm0
 * @extra_info: set the extra info for dtmf library, refer to DTMF_EXTRA
 *
 * Start to generate DTMF tone packet and output to pulse audio.
 * If time_ms==0; dtmf tone will not stop until dtmf_stop() API being called
 * If time_ms>0; dtmf tone will stop automatically when the time is up.
 *
 * Returns: the dtmf handle
 *
 */
DTMF_HANDLE dtmf_start(gint num, gint time_ms, gint volume, DTMF_EXTRA *extra);

/**
 * dtmf_stop:
 * @handle: the dtmf handle which is got from dtmf_start() API
 *
 * Stop generating DTMF tone packet.
 *
 * Returns: N/A
 *
 */
int dtmf_stop(DTMF_HANDLE handle);

#endif
