// SPDX-License-Identifier: MediaTekProprietary
#ifndef _AUDIO_CTRL_SERVICE_API_H_
#define _AUDIO_CTRL_SERVICE_API_H_

int audio_ctrl_service_speech_on(int speech_on);
int audio_ctrl_service_set_dl_volume(int Db);

/* API for M2M speech on */
int audio_ctrl_service_M2M_speech_on(int speech_on);

/* API for ecall speech on */
int audio_ctrl_service_ecall_speech_on(int speech_on);


/* API for BT speech on */
int audio_ctrl_service_bt_speech_on(int speech_on);

/* API for libspeech_drv inCall record callback*/
int audio_ctrl_service_inCall_record_data_cb(int data_size, const char* data);

/* APIs for ioplugin record */
int audio_ctrl_service_inCall_record_start(int buf_size);
int audio_ctrl_service_inCall_record_stop();
int audio_ctrl_service_inCall_record_pointer();
int audio_ctrl_service_inCall_record_get_watermark();
int audio_ctrl_service_inCall_record_get_data(int data_size, char* dest);

/* APIs for ioplugin playback */
int audio_ctrl_service_inCall_playback_start();
int audio_ctrl_service_inCall_playback_stop();
int audio_ctrl_service_inCall_playback_send_data(int data_size, const char* data_buf);

/* APIs for state check */
int audio_ctrl_service_is_speech_on(int device);
int audio_ctrl_service_is_bt_speech_on();
int audio_ctrl_service_get_dl_gain();

/* APIs for parameters get */
int audio_ctrl_service_get_record_period_size();
int audio_ctrl_service_get_playback_period_size();
int audio_ctrl_service_get_record_max_buffer_size();
int audio_ctrl_service_get_playback_max_buffer_size();

/* APIs for vm log enable/disable */
int audio_ctrl_service_vmlog_on(int vmlog_on);
int audio_ctrl_service_get_vmlog_on();

/* APIs for bt setting */
int audio_ctrl_service_get_bt_wbs();
int audio_ctrl_service_set_bt_wbs(int bt_wbs_on);
int audio_ctrl_service_get_bt_dl_gain();
int audio_ctrl_service_set_bt_dl_gain(int vol);
int audio_ctrl_service_set_bt_client_has_ecnr(int bt_client_ecnr_on);
int audio_ctrl_service_get_bt_client_has_ecnr();
int audio_ctrl_service_set_use_bt_in_call(int trun_on_bt_in_call);
int audio_ctrl_service_get_use_bt_in_call();

/* APIs for reset call */
int audio_ctrl_service_reset();

/* APIs for mute call */
int audio_ctrl_service_set_mute(int path, int is_mute);
int audio_ctrl_service_get_mute(int path);

#endif
