#ifndef _XML_PARSER_DEF_H_
#define _XML_PARSER_DEF_H_
#include "mixer_ctrl.h"

#define SPEECH_PARA "speech_mode_para"
#define FIR_IN_PARA "sph_in_fir"
#define FIR_OUT_PARA "sph_out_fir"
#define DL_GAIN_IDX_PARA "dl_gain"
#define UL_GAIN_IDX_PARA "ul_gain"
#define SWAGC_GAIN_MAP_PARA "swagc_gain_map"
#define UL_PGA_GAIN_MAP_PARA "ul_pga_gain_map"
#define DL_ANALOG_GAIN_MAP_PARA "dl_analog_gain"
#define DL_DIGITAL_GAIN_MAP_PARA "dl_digital_gain"

#define XML_TYPE_SPEECH_STR "Speech"
#define XML_TYPE_SPEECHVOL_STR "SpeechVol"
#define XML_TYPE_VOLUME_STR "Volume"
#define XML_TYPE_VOLUMEGAINMAP_STR "VolumeGainMap"

enum {
    BAND_NB,
    BAND_WB,
    BAND_NUM,
};

enum {
    PROFILE_NORMAL,
    PROFILE_ECALL,
    PROFILE_BT,
    PROFILE_NUM,
};

struct Param_data {
    int id;
    char const * xml_type_name;
    char const * param_name;
    int param_type;
    void (*update_xml_callback)(AppHandle *appHandle);
};

enum {
    PARAM_SPEECH,
    PARAM_FIR_IN,
    PARAM_FIR_OUT,
    PARAM_UL_GAIN_IDX,
    PARAM_UL_SWAGC_GAIN_MAP,
    PARAM_UL_PGA_GAIN_MAP,
    PARAM_DL_ANALOG_GAIN_MAP,
    PARAM_DL_DIGITAL_GAIN_MAP,
    PARAM_NUM,
};

enum {
    PARAM_TYPE_INT,
    PARAM_TYPE_USHORT_ARRAY,
    PARAM_TYPE_SHORT_ARRAY,
    PARAM_TYPE_NUM,
};
#endif