// SPDX-License-Identifier: MediaTekProprietary
#ifndef ANDROID_SPEECH_MODEM_CONTROLLER_H
#define ANDROID_SPEECH_MODEM_CONTROLLER_H

#include "SpeechType.h"
#include "SpeechBGSPlayer.h"
#include "AudioVolumeInterface.h"

#include "AudioLock.h"

namespace android {

class SpeechDriverFactory;

class SpeechModemController {
public:
    virtual ~SpeechModemController();

    static SpeechModemController *getInstance();

    virtual int        initialize();

    virtual int        phoneCallOpen(const audio_devices_t input_device, const audio_devices_t output_devices);
    virtual int        phoneCallClose();
    virtual int        phoneCallRouting(const audio_devices_t input_device, const audio_devices_t output_devices);

    virtual int        configVm(const uint8_t vmConfig);
    virtual int        setUlDigitalGain(const int16_t gain);
    virtual int        setDlDigitalGain(const int16_t gain);
    virtual int        setSpeakerType(const int type);
    virtual int        getUlAnalogGain();
    virtual int        getDlAnalogGain();
    virtual int        setVolumeIndex(const int index);
    virtual int        setUplinkMute(const bool mute);
    virtual int        setDownlinkMute(const bool mute);
    virtual bool       getUplinkMute();
    virtual bool       getDownlinkMute();
    virtual int        setBtMode(const int mode);
    virtual int        setBtNrec(const bool enbale);
    virtual int        setBtVgs(const bool support);

    /** ecall */
    virtual int eCallIvsSwitch(bool enable);
    virtual int eCallIvsSend() ;
    virtual int eCallPsapSwitch(bool enable);
    virtual int eCallPsapSend();
    virtual int eCallCtrlSeqSwitch(bool enable);
    virtual int eCallMsd(void *data, uint16_t len);
    virtual int eCallTxCtrlParam(void *data, uint16_t len);

    virtual int bgsOpen(uint32_t sampleRate);
    virtual int bgsClose();
    virtual uint32_t bgsWrite(void *buf, uint32_t bytes);

protected:
    SpeechModemController();

    inline uint32_t         calculateSampleRate(const bool bt_device_on) {
#if defined(SPH_SR32K)
        return (bt_device_on == false) ? 32000 : (mBtMode == 0) ? 8000 : 16000;
#elif defined(SPH_SR48K)
        return (bt_device_on == false) ? 48000 : (mBtMode == 0) ? 8000 : 16000;
#else
        return (bt_device_on == false) ? 16000 : (mBtMode == 0) ? 8000 : 16000;
#endif
    }

    SpeechDriverFactory    *mSpeechDriverFactory;
    AudioVolumeInterface    *mAudioALSAVolumeController;

    AudioLock               mLock;
    AudioLock               mCheckOpenLock;
    AudioLock               mUlMuteLock;
    AudioLock               mDlMuteLock;

    bool                    mSpeechOn;

    bool                    mUlMute;
    bool                    mDlMute;

    int                      mBtMode; // BT mode; 0:NB, 1:WB
    bool                     mBtNrec; // NR/EC for BT voice call; 0:off, 1:on
    bool                     mBtVgs; // VGS support by BT; 0:off, 1:on
    audio_devices_t mCurrentOutputDevice;
    audio_devices_t mCurrentInputDevice;
    BGSPlayBuffer* mBGSPlayBuffer;
    bool                    mIsEcallIvsOn;
    bool                    mIsEcallPsapOn;
    bool                    mIsEcallCtrlSeqOn;
    unsigned int mVolumeIndex;
    int mSpkType;
private:
    static SpeechModemController *mSpeechModemController; // singleton

};

} // end namespace android

#endif // end of ANDROID_AUDIO_ALSA_SPEECH_PHONE_CALL_CONTROLLER_H
