// SPDX-License-Identifier: MediaTekProprietary
#ifndef _SPEECH_DRV_H_
#define _SPEECH_DRV_H_
#include <stdbool.h>
#include <system/audio.h>


#define CLIENT_SOCK_FILE "/tmp/client-sphdrv"
#define SERVER_SOCK_FILE "/tmp/socket-sphdrv"

//Error code for users
#define SPH_REQ_SEND_FAIL   -200
#define SPH_BUF_BYTES   2048

enum {
    SET_SPEECH_ON = 1,
    CHANGE_SPEECH_ROUTING,
    ECALL_SPEECH_ON,
    SET_SPK_TYPE,
    DL_VOL_IDX,
    GET_UL_ANA_GAIN,
    GET_DL_ANA_GAIN,
    SET_UL_MUTE,
    SET_DL_MUTE,
    GET_UL_MUTE,
    GET_DL_MUTE,
    IVS_SWITCH,
    IVS_SEND,
    PSAP_SWITCH,
    PSAP_SEND,
    ECALL_MSD,
    ECALL_TESTSEQ,
    ECALL_TESTSEQ_SWITCH,
    VMLOG_RECORD,
    PCM_RECORD_ON,
    PCM_RECORD_OFF,
    PCM_TYPE,
    VOICE_RECORD_ON,
    VOICE_RECORD_OFF,
    PCM_SAMPLERATE,
    PCM_CHANNELNUM,
    BGS_OPEN,
    BGS_CLOSE,
    BGS_WRITE,
    SET_BT_WBS,
    SET_BT_NREC,
    SET_BT_VGS,
};

/*Request Package*/
typedef struct _SPH_REQ_ {
    int id;
    bool speechOn;
    bool muteOn;
    int speakerType;
    unsigned int volumeIdx;
    bool switchOn;
    int inputDevice;
    int outputDevice;
    uint32_t sampleRate;
    char dataBuf[SPH_BUF_BYTES];
    uint32_t dataSize;
    uint8_t vmConfig;
    int btWbsOn;
    bool btNrecOn;
    bool btVgsOn;
} SPH_REQ;

typedef struct _SPH_MSG_ {
    SPH_REQ req;
    char cmd[64];
    int result;
} SPH_MSG;

enum {
    AUDIO_SPK_INVALID = -1,
    AUDIO_SPK_INTAMP,
    AUDIO_SPK_EXTAMP_LO,
    AUDIO_SPK_EXTAMP_HP,
    AUDIO_SPK_2_IN_1,
    AUDIO_SPK_3_IN_1,
};


/* For normal call setting API */
int speechdrv_set_speech_on(bool enable, int inputDevice, int outputDevice);
int speechdrv_change_speech_device(int inputDevice, int outputDevice);
int speechdrv_get_ul_analog_gain();
int speechdrv_get_dl_analog_gain();
int speechdrv_set_speaker_type(unsigned int type);
int speechdrv_set_volume_index(unsigned int index, int outputDevice);
int speechdrv_set_vm_on(uint8_t config);
int speechdrv_set_ul_mute(bool enable);
int speechdrv_set_dl_mute(bool enable);
int speechdrv_get_ul_mute_status(void);
int speechdrv_get_dl_mute_status(void);
int speechdrv_set_bt_wbs(int enable);
int speechdrv_set_bt_nrec(bool enable);
int speechdrv_set_bt_vgs(bool support);

/* For eCall API */
int speechdrv_set_ecall_speech_on(bool enable);
int speechdrv_set_ivs_switch(bool enable);
int speechdrv_set_ivs_send(void);
int speechdrv_set_psap_switch(bool enable);
int speechdrv_set_psap_send(void);
int speechdrv_set_ecall_msd(void *buf, uint32_t bytes);
int speechdrv_set_ecall_testseq_switch(bool enable);
int speechdrv_set_ecall_testseq(void *buf, uint32_t len);

/* For BGS API */
int speechdrv_bgs_open(uint32_t sampleRate);
int speechdrv_bgs_close();
int speechdrv_bgs_write(void *buf, uint32_t bytes);


#endif
