// SPDX-License-Identifier: MediaTekProprietary
#ifndef YOCTO_FM_H
#define YOCTO_FM_H

typedef signed int fm_s32;

typedef struct fm_i2s_info
{
    fm_s32 status; /*0:FM_I2S_ON, 1:FM_I2S_OFF,2:error*/
    fm_s32 mode;   /*0:FM_I2S_MASTER, 1:FM_I2S_SLAVE,2:error*/
    fm_s32 rate;   /*0:FM_I2S_32K:32000,1:FM_I2S_44K:44100,2:FM_I2S_48K:48000,3:error*/
} fm_i2s_info_t;

typedef enum
{
    FM_AUD_ANALOG = 0,
    FM_AUD_I2S = 1,
    FM_AUD_MRGIF = 2,
    FM_AUD_ERR
}fm_audio_path_e;

typedef enum
{
    FM_I2S_PAD_CONN = 0, //sco fm chip: e.g.6627
    FM_I2S_PAD_IO = 1,   //combo fm chip: e.g.6628
    FM_I2S_PAD_ERR
}fm_i2s_pad_sel_e;

typedef struct fm_audio_info
{
    fm_audio_path_e aud_path;
    fm_i2s_info_t i2s_info;
    fm_i2s_pad_sel_e i2s_pad;
} fm_audio_info_t;

#endif /* end of YOCTO_FM_H */

