// SPDX-License-Identifier: MediaTekProprietary
/*
 * Copyright (C) 2011 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

#ifndef YOCTO_AUDIO_PRIMITIVES_H
#define YOCTO_AUDIO_PRIMITIVES_H

#include <math.h>
#include <stdint.h>
#include <stdlib.h>
/**
 * Clamp (aka hard limit or clip) a signed 32-bit sample to 16-bit range.
 */
#ifdef __cplusplus
namespace android {
#endif
inline int16_t clamp16(int32_t sample)
{
    if ((sample>>15) ^ (sample>>31))
        sample = 0x7FFF ^ (sample>>31);
    return sample;
}
#ifdef __cplusplus
} // end namespace android
#endif
#endif  // YOCTO_AUDIO_PRIMITIVES_H
