// SPDX-License-Identifier: MediaTekProprietary
#ifndef ANDROID_AUDIO_ALSA_PLAYBACK_HANDLER_VOICEMIXER_H
#define ANDROID_AUDIO_ALSA_PLAYBACK_HANDLER_VOICEMIXER_H

#include "AudioALSAPlaybackHandlerBase.h"

namespace android {

/*
 * =============================================================================
 *                     ref struct
 * =============================================================================
 */
class VoiceMixerPlayer;
class VoiceMixerPlayBuffer;
class SpeechDriverInterface;


/*
 * =============================================================================
 *                     class
 * =============================================================================
 */
class AudioALSAPlaybackHandlerVoiceMixer : public AudioALSAPlaybackHandlerBase {
public:
    AudioALSAPlaybackHandlerVoiceMixer(const stream_attribute_t *stream_attribute_source);
    virtual ~AudioALSAPlaybackHandlerVoiceMixer() {}

    /**
     * open/close audio hardware
     */
    virtual status_t open();
    virtual status_t close();
    virtual status_t routing(const audio_devices_t output_devices);

    /**
     * write data to audio hardware
     */
    virtual ssize_t write(const void *buffer, size_t bytes);

    virtual status_t setVolume(uint32_t vol __unused) { return NO_ERROR; }
    /**
     * get hardware buffer info (framecount)
     */
    virtual status_t getHardwareBufferInfo(time_info_struct_t *HWBuffer_Time_Info __unused) {
        return INVALID_OPERATION;
    }

    uint32_t chooseTargetSampleRate(uint32_t sampleRate);
    int configMixType(const uint8_t mixType);


private:
    SpeechDriverInterface *mSpeechDriver;
    VoiceMixerPlayer *mVoiceMixerPlayer;
    VoiceMixerPlayBuffer *mVoiceMixerPlayBuffer;

    struct timespec mOpenTime, mCurTime;
    uint64_t mWriteCnt;

    uint64_t mLatencyUs;

    struct timespec mNewtimeLatency, mOldtimeLatency;
    uint64_t mLatencyTimeMs[3];

    bool mBypassVoiceMixerSleep;

};

} // end namespace android

#endif // end of ANDROID_AUDIO_ALSA_PLAYBACK_HANDLER_VOICEMIXER_H
