// SPDX-License-Identifier: MediaTekProprietary
#ifndef ANDROID_AUDIO_MTK_HARDWARE_COMMAND_H
#define ANDROID_AUDIO_MTK_HARDWARE_COMMAND_H

enum AudioCommand {
    AUDIOCOMMAND_NONE = 0,
    OUTPUTFIRINDEX = 0x1,
    MEDDATA = 0x3,
    GETAUDIOCUSTOMDATASIZE = 0x5,
    AUDIOCUSTOMDATA = 0x6,
    VOIP_PARAMETER = 0x7,
    HFP_PARAMETER = 0x8,
    HD_RECORD_PARAMETER = 0x9,
    HD_RECORD_SCENE_TABLE = 0xA,

    // use for MED output FIR
    NORMALOUTPUTFIRINDEX = 0x20,
    HEADSETOUTPUTFIRINDEX = 0x21,
    SPEAKEROUTPUTFIRINDEX = 0x22,

    DUAL_MIC_PARAMETER = 0x31,

    WB_SPEECH_PARAMETER = 0x41,
    NB_SPEECH_LPBK_PARAMETER = 0x42,
    NB_SPEECH_PARAMETER = 0x43,

    LOAD_VOLUME_SETTING  = 0x50,
    DUMP_AUDIO_AEE_CHECK  = 0x5E,
    // used for Speech Logger
    SPEECH_VM_ENABLE = 0x60,
    // used for Audio Logger
    DUMP_AUDIO_DEBUG_INFO = 0x62,
    DUMP_AUDIO_STREAM_OUT = 0x63,
    DUMP_AUDIO_MIXER_BUF = 0x65,
    DUMP_AUDIO_TRACK_BUF = 0x67,
    DUMP_A2DP_STREAM_OUT = 0x69,
    DUMP_AUDIO_STREAM_IN = 0x6B,
    DUMP_IDLE_VM_RECORD = 0x6D,
    // for audio taste tool
    AUD_TASTE_TUNING = 0x70,
    HOOK_FM_DEVICE_CALLBACK = 0x71,
    UNHOOK_FM_DEVICE_CALLBACK = 0x72,
    HOOK_BESLOUDNESS_CONTROL_CALLBACK    = 0x73,
    UNHOOK_BESLOUDNESS_CONTROL_CALLBACK  = 0x74,
    //AP side Speech logger
    DUMP_AP_SPEECH_EPL = 0xA0,
    MagiASR_TEST_ENABLE = 0xA2,
    AECREC_TEST_ENABLE = 0xA4,
    SPEECH_MAGICON_PARAMETER = 0xC1,
    SPEECH_HAC_PARAMETER = 0xD1,

    // volume
    AUDIO_VER1_DATA = 0x101,
    GET_AUDIO_POLICY_VOL_FROM_VER1_DATA = 0x102,
    GET_AUDIO_SCENE_GAIN_TABLE = 0x103,
    GET_AUDIO_NON_SCENE_GAIN_TABLE = 0x104,
    // used for voice ui and unlock
    VOICE_RECOG_CUST_PARAM = 0x200,
    VOICE_RECOG_FIR_COEF = 0x201,
    VOICE_RECOG_GAIN = 0x202,

    // used for vibration spk calibration
    CURRENT_SENSOR_ENABLE = 0x210,
    CURRENT_SENSOR_RESET = 0x211,

    // used for spk monitor temperature control
    SPEAKER_MONITOR_TEMP_UPPER_BOUND = 0x220,
    SPEAKER_MONITOR_TEMP_LOWER_BOUND = 0x221,

    // used for drc parameters
    AUDIO_DRC_MUSIC_PARAMETER = 0x230,
    AUDIO_DRC_RINGTONE_PARAMETER = 0x231,

    GET_TC1_DISP = 0x500,
    GET_BT_NREC_DISP = 0x501,
    TEST_AUDIODATA = 0x502
};
#endif
