// SPDX-License-Identifier: MediaTekProprietary
#include "AudioALSADriverUtility.h"
#include <cutils/properties.h>
#include <AudioLock.h>
#include <stdint.h>
#include <sys/types.h>
#include <stdlib.h>

#ifdef LOG_TAG
#undef LOG_TAG
#endif
#define LOG_TAG "AudioALSADriverUtility"

namespace android {

AudioALSADriverUtility *AudioALSADriverUtility::mAudioALSADriverUtility = NULL;
AudioALSADriverUtility *AudioALSADriverUtility::getInstance() {
    static AudioLock mGetInstanceLock;
    AL_AUTOLOCK(mGetInstanceLock);

    if (mAudioALSADriverUtility == NULL) {
        mAudioALSADriverUtility = new AudioALSADriverUtility();
    }
    return mAudioALSADriverUtility;
}

int AudioALSADriverUtility::GetPropertyValue(const char *ProPerty_Key) {
    int result = 0;
    char value[PROPERTY_VALUE_MAX];
    property_get(ProPerty_Key, value, "0");
    result = atoi(value);
    return result;
}

int AudioALSADriverUtility::setPropertyValue(const char *ProPerty_Key, int value) {
    int result;
    char valuestring[PROPERTY_VALUE_MAX];

    sprintf(valuestring, "%d", value);
    property_set(ProPerty_Key, valuestring);

    return 0;
}

AudioALSADriverUtility::AudioALSADriverUtility() :
    mMixer(NULL) {
}

struct mixer_ctl *AudioALSADriverUtility::getMixerCtrlByName(struct mixer *mixer, const char *name) {
    (void) mixer;
    (void) name;

    return NULL;
}

int AudioALSADriverUtility::mixerCtrlGetValue(struct mixer_ctl *ctl, unsigned int id) {
    (void) ctl;
    (void) id;
    return 0;
}

int AudioALSADriverUtility::mixerCtrlSetValue(struct mixer_ctl *ctl, unsigned int id, int value) {
    (void) ctl;
    (void) id;
    (void) value;
    return 0;
}

AudioALSADriverUtility::~AudioALSADriverUtility() {
    mMixer = NULL;
}


} // end of namespace android
