// SPDX-License-Identifier: MediaTekProprietary
#include "AudioALSAHardwareResourceManager.h"


#include "AudioType.h"
#include <AudioLock.h>
#include "AudioAssert.h"

#ifdef MTK_AUDIO_HIERARCHICAL_PARAM_SUPPORT
#include "AudioParamParser.h"
#endif

#include "AudioSmartPaController.h"

#ifdef MTK_USB_PHONECALL
#include "AudioUSBPhoneCallController.h"
#endif

#ifdef USING_EXTAMP_HP
#include "AudioALSACodecDeviceOutExtSpeakerAmp.h"
#endif

#ifdef HAVING_RCV_SPK_SWITCH
#include "AudioALSACodecDeviceOutReceiverSpeakerSwitch.h"
#endif

#include "WCNChipController.h"

#ifdef MTK_ANC_SUPPORT
#include "AudioALSAANCController.h"
#endif
#if defined(MTK_HYBRID_NLE_SUPPORT)
#include "AudioALSANLEController.h"
#endif

#ifdef LOG_TAG
#undef LOG_TAG
#endif
#define LOG_TAG "AudioALSAHardwareResourceManager"

static const char *PROPERTY_KEY_EXTDAC = "vendor.audiohal.resource.extdac.support";

#define A2DP_DEFAULT_LANTENCY (100)

namespace android {

static const char *SIDEGEN[] = {
    "I0I1",   "I2",     "I3I4",   "I5I6",
    "I7I8",   "I9",     "I10I11", "I12I13",
    "I14",    "I15I16", "I17I18", "I19I20",
    "I21I22", "O0O1",   "O2",     "O3O4",
    "O5O6",   "O7O8",   "O9O10",  "O11",
    "O12",    "O13O14", "O15O16", "O17O18",
    "O19O20", "O21O22", "O23O24", "OFF",
    "O3",     "O4",     "I25I26", "O25",
    "O28O29", "I23I24", "O32O33", "I34I35"
};

static const char *SIDEGEN_SAMEPLRATE[] = {
    "8K", "11K", "12K", "16K",
    "22K", "24K", "32K", "44K",
    "48K", "88k", "96k", "176k",
    "192k"
};

static AudioLock mGetInstanceLock;
AudioALSAHardwareResourceManager *AudioALSAHardwareResourceManager::mAudioALSAHardwareResourceManager = NULL;
AudioALSAHardwareResourceManager *AudioALSAHardwareResourceManager::getInstance() {
    AL_AUTOLOCK(mGetInstanceLock);

    if (mAudioALSAHardwareResourceManager == NULL) {
        mAudioALSAHardwareResourceManager = new AudioALSAHardwareResourceManager();
    }
    ASSERT(mAudioALSAHardwareResourceManager != NULL);
    return mAudioALSAHardwareResourceManager;
}

status_t AudioALSAHardwareResourceManager::ResetDevice(void) {
    return NO_ERROR;
}

AudioALSAHardwareResourceManager::AudioALSAHardwareResourceManager() :
    mMixer(NULL),
    mPcmDL(NULL),
    mDeviceConfigManager(NULL),
    mOutputDevices(AUDIO_DEVICE_NONE),
    mInputDevice(AUDIO_DEVICE_NONE),
    mOutputDeviceSampleRate(44100),
    mInputDeviceSampleRate(48000),
    mIsChangingInputDevice(false),
    mStartOutputDevicesCount(0),
    mStartInputDeviceCount(0),
    mSpeakerStatusChangeCb(NULL),
#if defined(MTK_AUDIO_MIC_INVERSE) || defined(DEN_PHONE_MIC_INVERSE)
    mMicInverse(true),  // if defined MTK_AUDIO_MIC_INVERSE, default invert main & ref mic
#else
    mMicInverse(false),
#endif
    mBuiltInMicSpecificType(BUILTIN_MIC_DEFAULT),
#ifdef MTK_HIFIAUDIO_SUPPORT
    mHiFiState(false),
    mHiFiDACStatusCount(0),
#endif
    mNumHSPole(4),
    mHeadchange(false),
    mSmartPaController(NULL),
    mSpkPcmOut(NULL),
    mA2dpDeviceLatency(A2DP_DEFAULT_LANTENCY),
    mA2dpFwLatency(0) {
    ALOGD("%s()", __FUNCTION__);

#ifdef CONFIG_MT_ENG_BUILD
    mLogEnable = 1;
#else
    mLogEnable = __android_log_is_loggable(ANDROID_LOG_DEBUG, LOG_TAG, ANDROID_LOG_INFO);
#endif
    mStartInputDeviceSeqeunce.clear();

    mNumPhoneMicSupport = 1;

#ifdef MTK_HIFIAUDIO_SUPPORT
    mHiFiState = false;
#endif

}


AudioALSAHardwareResourceManager::~AudioALSAHardwareResourceManager() {
    ALOGD("%s()", __FUNCTION__);
    AL_AUTOLOCK(mGetInstanceLock);
    mAudioALSAHardwareResourceManager = NULL;
}

/**
 * output devices
 */
status_t AudioALSAHardwareResourceManager::setOutputDevice(const audio_devices_t new_devices, const uint32_t sample_rate) {
    return NO_ERROR;
}

status_t AudioALSAHardwareResourceManager::startOutputDevice(const audio_devices_t new_devices, const uint32_t SampleRate) {
    return NO_ERROR;
}


status_t AudioALSAHardwareResourceManager::stopOutputDevice() {
    return NO_ERROR;
}


status_t AudioALSAHardwareResourceManager::changeOutputDevice(const audio_devices_t new_devices) {
    return NO_ERROR;
}


status_t AudioALSAHardwareResourceManager::startOutputDevice_l(const audio_devices_t new_devices, const uint32_t SampleRate) {
    return NO_ERROR;
}


status_t AudioALSAHardwareResourceManager::stopOutputDevice_l() {
    return NO_ERROR;
}


status_t AudioALSAHardwareResourceManager::changeOutputDevice_l(const audio_devices_t new_devices, const uint32_t SampleRate) {
    return NO_ERROR;
}

bool AudioALSAHardwareResourceManager::isSharedOutDevice(audio_devices_t device) {
    return true;
}

/**
 * input devices
 */
status_t AudioALSAHardwareResourceManager::setInputDevice(const audio_devices_t new_devices) {
    return NO_ERROR;
}

void AudioALSAHardwareResourceManager::setMIC1Mode(bool isHeadsetMic) {
    return;
}

void AudioALSAHardwareResourceManager::setMIC2Mode(bool isHeadsetMic) {
    return;
}

void AudioALSAHardwareResourceManager::setMIC3Mode(bool isHeadsetMic) {
    return;
}

static void setSingleDmicLoopbackType(builtin_mic_specific_type mBuiltInMicSpecificType,
                                      bool mMicInverse, bool enable) {
    return;
}

status_t AudioALSAHardwareResourceManager::startInputDevice(const audio_devices_t new_device) {
    return NO_ERROR;
}


status_t AudioALSAHardwareResourceManager::stopInputDevice(const audio_devices_t stop_device) {
    return NO_ERROR;
}


status_t AudioALSAHardwareResourceManager::changeInputDevice(const audio_devices_t new_device) {
    return NO_ERROR;
}



status_t AudioALSAHardwareResourceManager::setHWGain2DigitalGain(const uint32_t gain) {
    return NO_ERROR;
}



status_t AudioALSAHardwareResourceManager::setInterruptRate(const audio_output_flags_t flag,
                                                            const uint32_t rate) {
    return NO_ERROR;
}

status_t AudioALSAHardwareResourceManager::setInterruptRate2(const uint32_t rate) {
    return NO_ERROR;
}

status_t AudioALSAHardwareResourceManager::setULInterruptRate(const uint32_t rate) {
    return NO_ERROR;
}

status_t AudioALSAHardwareResourceManager::openAddaOutput(const uint32_t sample_rate) {
    return NO_ERROR;
}


status_t AudioALSAHardwareResourceManager::closeAddaOutput() {
    return NO_ERROR;
}


status_t AudioALSAHardwareResourceManager::setSgenMode(const sgen_mode_t sgen_mode) {
    return NO_ERROR;
}

status_t AudioALSAHardwareResourceManager::setSgenSampleRate(const sgen_mode_samplerate_t sample_rate) {
    return NO_ERROR;
}

status_t AudioALSAHardwareResourceManager::setSgenMute(int channel, bool mute) {
    return NO_ERROR;
}

status_t AudioALSAHardwareResourceManager::setSgenFreqDiv(int channel, int freqDiv) {
    return NO_ERROR;
}

status_t AudioALSAHardwareResourceManager::EnableSideToneFilter(const bool enable) {
    return NO_ERROR;
}

bool AudioALSAHardwareResourceManager::GetExtDacPropertyEnable() {
    return false;
}

status_t AudioALSAHardwareResourceManager::SetExtDacGpioEnable(bool bEnable) {
    return NO_ERROR;
}


status_t AudioALSAHardwareResourceManager::setMicType(void) {
    return NO_ERROR;
}


status_t AudioALSAHardwareResourceManager::setSPKCurrentSensor(bool bSwitch) {
    return NO_ERROR;
}

status_t AudioALSAHardwareResourceManager::setSPKCurrentSensorPeakDetectorReset(bool bSwitch) {
    return NO_ERROR;
}

uint32_t AudioALSAHardwareResourceManager::updatePhoneMicMode() {
    return 0;
}

bool AudioALSAHardwareResourceManager::setSpeakerStatusChangeCb(SpeakerStatusChangeCb cb) {
    mSpeakerStatusChangeCb = cb;
    return true;
}

bool AudioALSAHardwareResourceManager::notifyOutputDeviceStatusChange(const audio_devices_t device, const DeviceStatus status) {
    return true;
}

audio_devices_t AudioALSAHardwareResourceManager::getOutputDevice() {
    return mOutputDevices;
}

audio_devices_t AudioALSAHardwareResourceManager::getInputDevice() {
    return mInputDevice;
}


status_t AudioALSAHardwareResourceManager::setMicInverse(bool bMicInverse) {
    return NO_ERROR;
}

void AudioALSAHardwareResourceManager::EnableAudBufClk(bool bEanble) {
    return;
}


bool AudioALSAHardwareResourceManager::getMicInverse(void) {
#if defined(MTK_AUDIO_MIC_INVERSE) || defined(DEN_PHONE_MIC_INVERSE)
    ALOGD("%s(), mMicInverse = %d", __FUNCTION__, !mMicInverse);
    return !mMicInverse;
#else
    ALOGD("%s(), mMicInverse = %d", __FUNCTION__, mMicInverse);
    return mMicInverse;
#endif
}


void AudioALSAHardwareResourceManager::setAudioDebug(const bool enable) {
    return;
}

int AudioALSAHardwareResourceManager::setNonSmartPAType() {
    return 0;
}

int AudioALSAHardwareResourceManager::getNonSmartPAType() {
    return AUDIO_SPK_EXTAMP_LO;
}

status_t AudioALSAHardwareResourceManager::OpenReceiverPath(const uint32_t SampleRate __unused) {
    return NO_ERROR;
}

status_t AudioALSAHardwareResourceManager::CloseReceiverPath() {
    return NO_ERROR;
}

status_t AudioALSAHardwareResourceManager::OpenHeadphonePath(const uint32_t SampleRate __unused) {
    return NO_ERROR;
}

status_t AudioALSAHardwareResourceManager::CloseHeadphonePath() {
    return NO_ERROR;
}


status_t AudioALSAHardwareResourceManager::OpenSpeakerPath(const uint32_t SampleRate) {
    return NO_ERROR;
}

status_t  AudioALSAHardwareResourceManager::CloseSpeakerPath() {
    return NO_ERROR;
}

status_t  AudioALSAHardwareResourceManager::OpenHeadphoneSpeakerPath(const uint32_t SampleRate) {
    return NO_ERROR;
}

status_t  AudioALSAHardwareResourceManager::CloseHeadphoneSpeakerPath() {
    return NO_ERROR;
}

status_t  AudioALSAHardwareResourceManager::OpenBuiltInMicPath() {
    return NO_ERROR;
}

status_t  AudioALSAHardwareResourceManager::CloseBuiltInMicPath() {
    return NO_ERROR;
}

status_t  AudioALSAHardwareResourceManager::OpenBackMicPath() {
    return NO_ERROR;
}

status_t  AudioALSAHardwareResourceManager::CloseBackMicPath() {
    return NO_ERROR;
}

status_t  AudioALSAHardwareResourceManager::OpenWiredHeadsetMicPath() {
    return NO_ERROR;
}

status_t  AudioALSAHardwareResourceManager::CloseWiredHeadsetMicPath() {
    return NO_ERROR;
}

void AudioALSAHardwareResourceManager::HpImpeDanceDetect(void) {
    return;
}

void AudioALSAHardwareResourceManager::setDPDModule(bool enable) {
    return;
}

void AudioALSAHardwareResourceManager::setHeadphoneLowPowerMode(bool enable) {
    return;
}

void AudioALSAHardwareResourceManager::setCodecSampleRate(const uint32_t sample_rate) {
    return;
}

void AudioALSAHardwareResourceManager::resetA2dpDeviceLatency(void) {
    mA2dpDeviceLatency = A2DP_DEFAULT_LANTENCY;
}

} // end of namespace android
