#include <vendor-ril/telephony/ril.h>
#include <string.h>
#include <log/log.h>

#include "ATCI.h"
#include "atci_util.h"
#include "atci_at_util.h"
#include "atci_cc_cmd.h"
#include "atci_common.h"

#undef LOG_TAG
#define LOG_TAG "MULTI_USER_ATCI_CC"

atci_cmd_type_t atci_cc_cmd_table[] = {
//cmd_name      target_type        handler
    { "at%dial", TARGET_TELEPHONY, atci_cc_dial_hdlr },
    { "at%mute", TARGET_TELEPHONY, atci_cc_mute_hdlr },
    { "at%conference", TARGET_TELEPHONY, atci_cc_conference_hdlr },
    { NULL, TARGET_UNKNOWN, NULL }
};

int atci_cc_init(void *arg) {
  int ret;
  ret = atci_cmd_register(atci_cc_cmd_table);
  return ret;
}

int atci_cc_mute_hdlr(char *cmd, int op_mode, int target, char *response) {
  int ret;
  switch (op_mode) {
  case AT_SET_MODE:
  case AT_READ_MODE:
  case AT_ACTIVE_MODE:
  case AT_TEST_MODE: {
    //paser parameter
    //send to target handle
    //ex: at%dial=int,string
    RLOGD("input cmd[%s]", cmd);

    if (SYS_FAIL == atci_at_to_equal(&cmd)) {
      //input error
      return SYS_FAIL;
      break;
    }

    RLOGD("reamin data is[%s]", cmd);
    // get isMute(int)

    int isMute;

    if (SYS_FAIL == atci_at_get_nexthexint(&cmd, &isMute)) {
      return SYS_FAIL;
      break;
    }

    RLOGD("isMute value is %d", isMute);

    //wrire data to target
    atci_data_req_t req;
    req.request_id = RIL_REQUEST_SET_MUTE;
    req.data_len = sizeof(int);
    req.data = &isMute;
    RLOGD("input req data");

    char parser_buf[SOCKET_BUF_SIZE] = { 0 };
    char reqStr[RIL_REQUEST_STRING_LENGTH] = {0};
    memcpy(reqStr, request2RILStr(req.request_id),
        strlen(request2RILStr(req.request_id)) + 1);
    RLOGD("request is %s", reqStr);
    char* argv[2] = { 0 };
    argv[0] = reqStr;
    argv[1] = parser_buf;
    sprintf(argv[1], "%d", isMute);
    int argc = 2;
    RLOGD("RIL_REQUEST_SET_MUTE (%d) ",argv[1]);
    sendAtciRequest(req.request_id, reqStr, argc, argv);
    break;
  }
  default: {
    RLOGD("set mute error");
    break;
  }
  }
  return SYS_SUCC;
}

int atci_cc_conference_hdlr(char *cmd, int op_mode, int target,
    char *response) {
  int ret;
  int op = -1;

  switch (op_mode) {
  case AT_SET_MODE:
  case AT_READ_MODE:
  case AT_ACTIVE_MODE:
  case AT_TEST_MODE: {
    //paser parameter
    //send to target handle
    //ex: at%dial=int,string
    RLOGD("input cmd[%s]", cmd);

    if (SYS_FAIL == atci_at_to_equal(&cmd)) {
      //input error
      return SYS_FAIL;
      break;
    }

    RLOGD("remain data is[%s]", cmd);

    if (SYS_FAIL == atci_at_get_nexthexint(&cmd, &op)) {
      return SYS_FAIL;
      break;
    }

    if (op > 2 || op < 0) {
      RLOGD("data op code %d is wrong!", op);
      return SYS_FAIL;
      break;
    }

    //wrire data to target
    atci_data_req_t req;
    if (op == 0) {
      req.request_id = RIL_REQUEST_CONFERENCE;
      RLOGD("request id is RIL_REQUEST_CONFERENCE!\n");

      char reqStr[RIL_REQUEST_STRING_LENGTH] = {0};
      memcpy(reqStr, request2RILStr(req.request_id),
          strlen(request2RILStr(req.request_id)) + 1);
      RLOGD("request is %s", reqStr);
      char* argv[1] = { 0 };
      argv[0] = reqStr;
      int argc = 1;
      sendAtciRequest(req.request_id, reqStr, argc, argv);
    }
//TBD
    else {
      req.request_id = RIL_REQUEST_CONFERENCE_DIAL;
      RLOGD("request id is RIL_REQUEST_CONFERENCE_DIAL");
      int argc = 1;
      char* cPoint;
      char parser_buf[SOCKET_BUF_SIZE] = { 0 };
      char reqStr[RIL_REQUEST_STRING_LENGTH] = {0};
      cPoint = parser_buf;
      memcpy(reqStr, request2RILStr(req.request_id),
          strlen(request2RILStr(req.request_id)) + 1);
      char* argv[4] = { 0 };
      argv[0] = reqStr;

      //cmd parameter sequence: DialMethod, ParticipantsNumber, addresses, clir;
      argv[1] = cPoint;  //DialMethod
      sprintf(argv[1], "%d", 0);
      cPoint += sizeof(int);

      argv[2] = cPoint;  //ParticipantsNumber
      sprintf(argv[2], "%d", 0);
      cPoint += sizeof(int);
      //no address
      argv[3] = cPoint;  //CLIR
      sprintf(argv[2], "%s", "0");

      argc += 3;
      RLOGD("RIL_REQUEST_CONFERENCE_DIAL dialMethod(%d) PhoneNumber(%d),clir(%s)",
          argv[1], argv[2], argv[3]);
      sendAtciRequest(req.request_id, reqStr, argc, argv);
    }
  }
  default: {
    RLOGD("conference error");
    break;
  }
  }
  return SYS_SUCC;
}

int atci_cc_dial_hdlr(char *cmd, int op_mode, int target, char *response) {
  int ret;
  int op = -1;
  int uriflag = 0;
  char *tmp = NULL;
  char *p_out = NULL;
  char ch_tmp;
  int i = 0;

  switch (op_mode) {
  case AT_SET_MODE:
  case AT_READ_MODE:
  case AT_ACTIVE_MODE:
  case AT_TEST_MODE: {
    //paser parameter
    //send to target handle
    //ex: at%dial=int,string
    RLOGD("input cmd[%s]", cmd);

    telephonyRequestDial dial_info;
    dial_info.clir = 0;

    if (SYS_FAIL == atci_at_to_equal(&cmd)) {
      //input error
      return SYS_FAIL;
      break;
    }

    RLOGD("remain data is[%s]", cmd);

    tmp = cmd;

    if (SYS_FAIL == atci_at_get_nexthexint(&cmd, &op)) {
      //return SYS_FAIL;
      //break ;
      op = -1;
    }

    RLOGD("operation info is %d", op);

    if (op >= 0 && op < 5) {
      // get number (string)
      if (SYS_FAIL == atci_at_hasmore(&cmd)) {
        return SYS_FAIL;
        break;
      }

      if (SYS_FAIL == atci_at_get_next_key(&cmd, &p_out)) {
        return SYS_FAIL;
        break;
      }

      strcpy(dial_info.phonyNumber, p_out);

      RLOGD("read string is %s", dial_info.phonyNumber);
    } else {
      if (SYS_FAIL == atci_at_get_next_key(&tmp, &p_out)) {
        return SYS_FAIL;
        break;
      }

      strcpy(dial_info.phonyNumber, p_out);

      RLOGD("read string is %s", dial_info.phonyNumber);
    }

    //wrire data to target
    atci_data_req_t req;

    for (i = 0; i < strlen(dial_info.phonyNumber); i++) {
      ch_tmp = dial_info.phonyNumber[i];
      if ((ch_tmp < '0' || ch_tmp > '9') && ch_tmp != '+') {
        uriflag = 1;
        break;
      }
    }

    if (uriflag == 0) {
      req.request_id = RIL_REQUEST_DIAL;
      RLOGD("request id is RIL_REQUEST_DIAL!\n");
    } else {
      req.request_id = RIL_REQUEST_DIAL_WITH_SIP_URI;
      RLOGD("request id is TELEPHONY_REQUEST_DIAL_WITH_SIP_URI!\n");
    }

    req.data_len = sizeof(dial_info);
    req.data = &dial_info;

    int argc = 1;
    char* cPoint;
    char parser_buf[SOCKET_BUF_SIZE] = { 0 };
    char reqStr[RIL_REQUEST_STRING_LENGTH] = {0};
    cPoint = parser_buf;
    memcpy(reqStr, request2RILStr(req.request_id),
        strlen(request2RILStr(req.request_id)) + 1);
    char* argv[3] = { 0 };
    argv[0] = reqStr;

    argv[2] = cPoint;  //clir
    cPoint += sizeof(dial_info.clir);
    sprintf(argv[2], "%d", dial_info.clir);

    argv[1] = cPoint;  //phonyNumber
    sprintf(argv[1], "%s", dial_info.phonyNumber);

    argc += 2;
    RLOGD("%s(%s) PhoneNumber(%s)", reqStr, argv[2], argv[1]);
    sendAtciRequest(req.request_id, reqStr, argc, argv);
    break;
  }
  default: {
    RLOGD("dial error");
    break;
  }
  }
  return SYS_SUCC;
}

