#include <vendor-ril/telephony/ril.h>
#include <string.h>
#include <log/log.h>

#include "ATCI.h"
#include "atci_util.h"
#include "atci_at_util.h"
#include "atci_ss_cmd.h"

#undef LOG_TAG
#define LOG_TAG "MULTI_USER_ATCI_SS"
atci_cmd_type_t atci_ss_cmd_table[] = {
    //cmd_name                    target_type                 handler
    { "at%supplementaryservice", TARGET_TELEPHONY, atci_ss_hdlr },
    { NULL, TARGET_UNKNOWN, NULL }
};

int atci_ss_init(void *arg) {
  int ret;
  ret = atci_cmd_register(atci_ss_cmd_table);
  return ret;
}

char *InfoClassToMmiBSCodeString(AtInfoClassE infoClass) {
  /**
   * Basic Service
   * group number (note)  Telecommunication Service       MMI Service Code
   *
   * 1 to 12              All tele and bearer services    no code required
   *
   *                      Teleservices
   * 1 to 6, 12           All teleservices                10
   * 1                    Telephony                       11
   * 2 to 6               All data teleservices           12
   * 6                    Facsimile services              13
   * 2                    Short Message Services          16
   * 1, 3 to 6, 12        All teleservices except SMS     19
   * 12                   Voice group services
   *                      Voice Group Call Service (VGCS) 17
   *                      Voice Broadcast Service (VBS)   18
   *
   *                      Bearer Service
   * 7 to 11              All bearer services             20
   * 7                    All async services              21
   * 8                    All sync services               22
   * 8                    All data circuit sync           24
   * 7                    All data circuit async          25
   * 13                   All GPRS bearer services        99
   */

  switch (infoClass) {
  case CLASS_NONE:
    return BS_ALL;
    break;
  case CLASS_VOICE:
    return BS_TELEPHONY;
    break;
  case (CLASS_DATASYNC_OR_DATAASYNC):
    return BS_DATA_ALL;
    break;
  case CLASS_FAX:
    return BS_TELE_FAX;
    break;
  case CLASS_SMS:
    return BS_TELE_SMS;
    break;
  case (CLASS_VOICE_OR_SMS_OR_FAX):
    return BS_TELE_ALL;
    break;
  case (CLASS_SMS_OR_FAX):
    return BS_TELE_DATA_ALL;
    break;
  case (CLASS_VOICE_OR_FAX):
    return BS_TELE_ALL_EXCEPT_SMS;
    break;
  case CLASS_DATA_SYNC:
    return BS_DATA_CIRCUIT_SYNC;
    break;
  case CLASS_DATA_ASYNC:
    return BS_DATA_CIRCUIT_ASYNC;
    break;
  case (CLASS_DATASYNC_OR_DEDICATEDPACKETACCESS):
    return BS_DATA_SYNC_ALL;
    break;
  case (CLASS_DATASYNC_OR_DEDICATEDPADACCESS):
    return BS_DATA_ASYNC_ALL;
    break;
  case (CLASS_DATASYNC_OR_VOICE):
    return BS_DATA_SYNC_TELE;
    break;
  case CLASS_DEDICATED_PACKET_ACCESS:
    return BS_GPRS_ALL;
    break;
  case (CLASS_MTKVIDEO_OR_DATASYNC):
    return BS_DATA_CIRCUIT_SYNC;
    break;
  case CLASS_MTK_VIDEO:
    return BS_DATA_CIRCUIT_SYNC;
    break;
  default:
    RLOGE("ATCI unknown infoClass: %d", infoClass);
    break;
  }
  return "";
}

int atci_ss_hdlr(char *cmd, int op_mode, int target, char *response) {
  int ret = 0;
  atci_data_req_t req = { 0 };
  int status = 0;
  int service_code = 0;

  //check parameter
  switch (op_mode) {
  case AT_SET_MODE:
  case AT_READ_MODE:
  case AT_ACTIVE_MODE:
  case AT_TEST_MODE: {
    //paser parameter
    //char *input = "MSG_XXXXXX";
    //char  output[1024];
    //int   len = strlen(input);

    RLOGD("input cmd[%s]", cmd);
    //
    if (SYS_FAIL == atci_at_to_equal(&cmd)) {
      //input error
      break;
    }
    RLOGD("ss reamin data is[%s]", cmd);

    atci_at_skip_space(&cmd);
    RLOGD("after remove space, ss reamin data is[%s]", cmd);

    // get status=int1
    if (SYS_FAIL == atci_at_get_nextint(&cmd, &status)) {
      RLOGE("For ss, the first param must be int");
      break;
    }
    RLOGD("status is [%d]", status);

    // get service code, such as CFB(67), CFU(21), CF-No Reply(61), CF-Not Reachable(62), CF-Not logged in(68)
    //call waiting(43)
    //incoming call barring while roaming(351)
    if (SYS_FAIL == atci_at_get_nextint(&cmd, &service_code)) {
      RLOGE("For ss, the second param must be string(service_code)");
      break;
    }
    RLOGD("read service_code is [%d]", service_code);

    if ((service_code == 67) || (service_code == 21) || (service_code == 61)
        || (service_code == 62) || (service_code == 68)) {
      telephonyRequestSetCallForward set_CF_data;
      char *num = NULL;
      int service_class = 0;
      char *MMI_BS_Code = NULL;
      int int_MMI_BS_Code = 0;

      memset(&set_CF_data, 0, sizeof(telephonyRequestSetCallForward));

      if (SYS_FAIL == atci_at_get_next_key(&cmd, &num)) {
        RLOGE("For ss CF, the third param must be string(number)");
        break;
      }
      RLOGD("num is [%s]", num);

      if (SYS_FAIL == atci_at_get_nextint(&cmd, &service_class)) {
        RLOGE("For ss CF, the forth param must be string(service_class)");
        break;
      }
      MMI_BS_Code = InfoClassToMmiBSCodeString((AtInfoClassE)service_class);
      RLOGD("CF service_class is [%d], MMI_BS_Code is %s", service_class,
          MMI_BS_Code);
      int_MMI_BS_Code = atoi(MMI_BS_Code);
      RLOGD("int_MMI_BS_Code=%d", int_MMI_BS_Code);

      if ((service_code == 61) && (status == 1)) {
        int timeout_second = 0;
        if (SYS_FAIL == atci_at_get_nextint(&cmd, &timeout_second)) {
          RLOGE("For ss enable CF-No Reply, the fifth param must be int");
          break;
        }
        RLOGD("timeout_second is [%d]", timeout_second);
        set_CF_data.time_seconds = timeout_second;
      }

      //enable SS means register SS
      if (status == 1) {
        set_CF_data.status = status + 2;
      } else {
        set_CF_data.status = status;
      }
      set_CF_data.reason = service_code;
      strcpy(set_CF_data.number, num);
      set_CF_data.service_class = int_MMI_BS_Code;

      //write data to DEMO APP
      req.request_id = RIL_REQUEST_SET_CALL_FORWARD;
      req.data_len = sizeof(telephonyRequestSetCallForward);
      req.data = &set_CF_data;
      RLOGD("input CF_req data");
      int argc = 1;
      char* cPoint;
      char parser_buf[SOCKET_BUF_SIZE] = { 0 };
      char reqStr[RIL_REQUEST_STRING_LENGTH] = {0};
      cPoint = parser_buf;
      memcpy(reqStr, request2RILStr(req.request_id),
          strlen(request2RILStr(req.request_id)) + 1);
      char* argv[7] = { 0 };
      argv[0] = reqStr;

      //cmd parameter sequence: status, reason, number, time_seconds, service_class; other not need.
      argv[1] = cPoint;  //status
      cPoint += sizeof(set_CF_data.status);
      sprintf(argv[1], "%d", set_CF_data.status);

      argv[2] = cPoint; //reason
      cPoint += sizeof(set_CF_data.reason);
      sprintf(argv[2], "%d", set_CF_data.reason);

      argv[5] = cPoint; //service_class
      cPoint += sizeof(set_CF_data.service_class);
      sprintf(argv[5], "%d", set_CF_data.service_class);

      argv[6] = cPoint; //toa
      cPoint += sizeof(set_CF_data.toa);
      sprintf(argv[6], "%d", set_CF_data.toa);

      argv[3] = cPoint;  //number
      cPoint += sizeof(set_CF_data.number);
      sprintf(argv[3], "%s", set_CF_data.number);

      argv[4] = cPoint; //time_seconds
      sprintf(argv[4], "%d", set_CF_data.time_seconds);

      argc += 5; //remove toa
      RLOGD(
          "RIL_REQUEST_SET_CALL_FORWARD status(%s) reason(%s) number(%s) time_seconds(%s) service_class(%s) --toa(%s)",
          argv[1], argv[2], argv[3], argv[4], argv[5], argv[6]);
      sendAtciRequest(req.request_id, reqStr, argc, argv);
      RLOGD("input CF_req data success");
    } else if (service_code == 43) {
      telephonyRequestSetCallWaiting set_CW_data;
      int service_class = 0;
      char *MMI_BS_Code = NULL;
      int int_MMI_BS_Code = 0;

      memset(&set_CW_data, 0, sizeof(telephonyRequestSetCallWaiting));

      if (SYS_FAIL == atci_at_get_nextint(&cmd, &service_class)) {
        RLOGE("For ss CW, the third param must be string(service_class)");
        break;
      }
      MMI_BS_Code = InfoClassToMmiBSCodeString((AtInfoClassE)service_class);
      RLOGD("CW service_class is [%d], MMI_BS_Code is %s", service_class,
          MMI_BS_Code);
      int_MMI_BS_Code = atoi(MMI_BS_Code);
      RLOGD("int_MMI_BS_Code=%d", int_MMI_BS_Code);

      set_CW_data.status = status;
      set_CW_data.service_class = int_MMI_BS_Code;

      //write data to DEMO APP
      req.request_id = RIL_REQUEST_SET_CALL_WAITING;
      req.data_len = sizeof(telephonyRequestSetCallWaiting);
      req.data = &set_CW_data;
      RLOGD("input CW_req data");
      int argc = 1;
      char* cPoint;
      char parser_buf[SOCKET_BUF_SIZE] = { 0 };
      char reqStr[RIL_REQUEST_STRING_LENGTH] = {0};
      cPoint = parser_buf;
      memcpy(reqStr, request2RILStr(req.request_id),
          strlen(request2RILStr(req.request_id)) + 1);
      char* argv[3] = { 0 };
      argv[0] = reqStr;

      //cmd parameter sequence: statue, service_code
      argv[1] = cPoint;  //status
      cPoint += sizeof(set_CW_data.status);
      sprintf(argv[1], "%d", set_CW_data.status);

      argv[2] = cPoint; //service_class
      sprintf(argv[2], "%d", set_CW_data.service_class);

      argc += 2;
      RLOGD("RIL_REQUEST_SET_CALL_WAITING status(%s) service_class(%s)",argv[1], argv[2]);
      sendAtciRequest(req.request_id, reqStr, argc, argv);
      RLOGD("input CW_req data success");
    } else if (service_code == 351) {
      telephonyRequestSetCallBarring set_CB_data;
      char *password = NULL;
      int service_class = 0;
      char *MMI_BS_Code = NULL;
      int int_MMI_BS_Code = 0;

      memset(&set_CB_data, 0, sizeof(telephonyRequestSetCallBarring));

      if (SYS_FAIL == atci_at_get_next_key(&cmd, &password)) {
        RLOGE("For ss CB, the third param must be string(password)");
        break;
      }
      RLOGD("password is [%s]", password);

      if (SYS_FAIL == atci_at_get_nextint(&cmd, &service_class)) {
        RLOGE("For ss CB, the forth param must be string(service_class)");
        break;
      }
      MMI_BS_Code = InfoClassToMmiBSCodeString((AtInfoClassE)service_class);
      RLOGD("CB service_class is [%d], MMI_BS_Code is %s", service_class,
          MMI_BS_Code);
      int_MMI_BS_Code = atoi(MMI_BS_Code);
      RLOGD("int_MMI_BS_Code=%d", int_MMI_BS_Code);

      set_CB_data.serviceClass = int_MMI_BS_Code;
      set_CB_data.status = status;
      strcpy(set_CB_data.password, password);
      sprintf(set_CB_data.facility, "%d", service_code);

      //write data to DEMO APP
      req.request_id = RIL_REQUEST_SET_FACILITY_LOCK;
      req.data_len = sizeof(telephonyRequestSetCallBarring);
      req.data = &set_CB_data;
      RLOGD("input CB_req data");
      int argc = 1;
      char* cPoint;
      char parser_buf[SOCKET_BUF_SIZE] = { 0 };
      char reqStr[RIL_REQUEST_STRING_LENGTH] = {0};
      cPoint = parser_buf;
      memcpy(reqStr, request2RILStr(req.request_id),
          strlen(request2RILStr(req.request_id)) + 1);
      char* argv[5] = { 0 };
      argv[0] = reqStr;

      //cmd parameter sequence: facility, password, serviceclass,enable; other not need.
      argv[4] = cPoint;  //status
      cPoint += sizeof(set_CB_data.status);
      sprintf(argv[4], "%d", set_CB_data.status);

      argv[1] = cPoint;  //facility
      cPoint += sizeof(set_CB_data.facility);
      sprintf(argv[1], "%s", set_CB_data.facility);

      argv[2] = cPoint;  //password
      cPoint += sizeof(set_CB_data.password);
      sprintf(argv[2], "%s", set_CB_data.password);

      argv[3] = cPoint;  //serviceclass
      cPoint += sizeof(set_CB_data.serviceClass);
      sprintf(argv[3], "%d", set_CB_data.serviceClass);

      argc += 4;
      RLOGD("RIL_REQUEST_SET_FACILITY_LOCK facility(%s) password(%s) service_class(%s) status(enable)(%s)",
          argv[1], argv[2], argv[3], argv[4]);
      sendAtciRequest(req.request_id, reqStr, argc, argv);
      RLOGD("input CB_req data success");
    } else {
      RLOGE("the service code [%d] is not supported by ATCI_SS now",
          service_code);
      return SYS_SUCC;
    }
    return SYS_SUCC;
  }
  default: {
    break;
  }
  }
  RLOGD("SS error");
  return SYS_SUCC;
}

