#!/bin/bash
#Copyright (c) 2016, MediaTek Inc. All rights reserved.
#This software/firmware and related documentation ("MediaTek Software") are protected under relevant copyright laws.
#The information contained herein is confidential and proprietary to MediaTek Inc. and/or its licensors.
#Except as otherwise provided in  the applicable licensing terms with MediaTek Inc. and/or its licensors, any reproduction, 
#modification, use or disclosure of MediaTek Software, and information contained herein, in whole or in part, shall be strictly prohibited.

echo "send a CDMA DTMF message"
if [ "$1" == "-h" ]
then
	echo -E "Usage:$0 <dtmfString> <on> <off>"
	echo -E "dtmfString is string representing the dialing digit(s) in the active call(characters 0-9, *, #)"
	echo -E "on the DTMF ON length in milliseconds, or 0 for default"
	echo -E "off the DTMF OFF length in milliseconds, or 0 for default"
	exit 0
fi

if [ "$#" != 3 ]
then
	echo -E "Usage:$0 <dtmfString> <on> <off>"
	echo -E "dtmfString is string representing the dialing digit(s) in the active call(characters 0-9, *, #)"
	echo -E "on the DTMF ON length in milliseconds, or 0 for default"
	echo -E "off the DTMF OFF length in milliseconds, or 0 for default"
	exit 1
fi

dtmfString=$1
on=$2
off=$3

#echo "paremeters is ${dtmfString} ${on} ${off}"

#open a socket, communicated with Service.
exec 9<>/dev/udp/127.0.0.1/8000

#make a MO call
echo "RIL_REQUEST_CDMA_BURST_DTMF ${dtmfString} ${on} ${off}"  >&9

#close socket R/W
exec 9>&-
exec 9<&-
exit 0