#!/bin/bash
#Copyright (c) 2016, MediaTek Inc. All rights reserved.
#This software/firmware and related documentation ("MediaTek Software") are protected under relevant copyright laws.
#The information contained herein is confidential and proprietary to MediaTek Inc. and/or its licensors.
#Except as otherwise provided in  the applicable licensing terms with MediaTek Inc. and/or its licensors, any reproduction, 
#modification, use or disclosure of MediaTek Software, and information contained herein, in whole or in part, shall be strictly prohibited.


#******************************************************************************************
# if the parameters cann't find and replace it with null. 
#USAGE:  sh initial_attach.sh  apn user password authType normalprotocol
#
#Apn: 运营商提供的配置信息，必须有
#user：运营商提供的配置信息，如果没有填写null
#password：运营商提供的配置信息, ，如果没有填写null
#authType：运营商提供的配置信息，如果没有填写null
#normalprotocol：运营商提供的配置信息，为这些值中的一个IPV4,IPV6,IPV4V6,如果没有填写null
#
#一般选择type类型是ia的APN，如果没有选择ims的
#  <apn carrier="T-Mobile Internet"
#      mcc="204"
#      mnc="20"
#      apn=""
#      type="ia"
#  />
#  <apn carrier="Orange IMS APN"
#      mcc="208"
#      mnc="01"
#      apn="ims"
#      type="ims"
#  />
#command is : sh initial_attach.sh ims, null, null, null, null
#***********************************************************************************************
upper2lower(){
    value="$(echo $1 | tr '[:upper:]' '[:lower:]')"
    echo $value
}

lower2upper(){
    value="$(echo $1 | tr '[:lower:]' '[:upper:]')"
    echo $value
}

#initial attach PDN, this command cann't modify
echo "Initial attach ps"
if [ -z $1 ]
then
echo -n "please input apn: "
read apn
else
apn=$1
fi

if [ -z $2 ]
then
echo -n "please input normalprotocol(if no exsit, input "null"): "
read normalprotocol
else
normalprotocol=$2
fi

if [ -z $3 ]
then
echo -n "please input authType(if no exsit, input "null"): "
read authType
else
authType=$3
fi

if [ -z $4 ]
then
echo -n "please input user(if no exsit, input "null"): "
read user
else
user=$4
fi

if [ -z $5 ]
then
echo -n "please input password(if no exsit, input "null"): "
read password
else
password=$5
fi

apntype=$(upper2lower $apntype)

normalprotocol=$(lower2upper $normalprotocol)

echo "apn: $apn, normalprotocol: $normalprotocol, authType: $authType,  user: $user, password: $password,"
#open a socket, communicated with Service.
exec 9<> /dev/udp/127.0.0.1/8000

#send Terminal response CMD
echo "RIL_REQUEST_SET_INITIAL_ATTACH_APN $apn $normalprotocol $authType $user $password" >&9

#close socket R/W
exec 9>&-
exec 9<&-
exit 0