#!/bin/bash
#Copyright (c) [2016], MediaTek Inc. All rights reserved.
#This software/firmware and related documentation ("MediaTek Software") are protected under relevant copyright laws.
#The information contained herein is confidential and proprietary to MediaTek Inc. and/or its licensors.
#Except as otherwise provided in  the applicable licensing terms with MediaTek Inc. and/or its licensors, any reproduction, 
#modification, use or disclosure of MediaTek Software, and information contained herein, in whole or in part, shall be strictly prohibited.

echo "Set Band Mode"
if [ ! -n "$1" ]
then
        echo -E "Error:"
        echo -E "please input parameter, you can input 'SetBandMode -h' for more details"
        exit 1
fi

if [ "$1" == "-h" ]
then
	echo -E "set band mode."
	echo -E "Usage: SetBandMode bandmode"
	echo -E "where bandmode := {0|1|2|3|4|5|6|7|8|9|10|11|12|13|14|15|16|17|18}"
	echo -E "0 : /*unspecified (selected by baseband automatically)*/"
	echo -E "1 : /*EURO band (GSM-900 / DCS-1800 / WCDMA-IMT-2000)*/"
	echo -E "2 : /*US band (GSM-850 / PCS-1900 / WCDMA-850 / WCDMA-PCS-1900)*/"
	echo -E "3 : /*JPN band (WCDMA-800 / WCDMA-IMT-2000)*/"
	echo -E "4 : /*AUS band (GSM-900 / DCS-1800 / WCDMA-850 / WCDMA-IMT-2000)*/"
	echo -E "5 : /*AUS band 2 (GSM-900 / DCS-1800 / WCDMA-850)*/"
	echo -E "6 : /*Cellular (800-MHz Band)*/"
	echo -E "7 : /*PCS (1900-MHz Band)*/"
	echo -E "8 : /*Band Class 3 (JTACS Band)*/"
	echo -E "9 : /*Band Class 4 (Korean PCS Band)*/"
	echo -E "10 : /*Band Class 5 (450-MHz Band)*/"
	echo -E "11 : /*Band Class 6 (2-GMHz IMT2000 Band)*/"
	echo -E "12 : /*Band Class 7 (Upper 700-MHz Band)*/"
	echo -E "13 : /*Band Class 8 (1800-MHz Band)*/"
	echo -E "14 : /*Band Class 9 (900-MHz Band)*/"
	echo -E "15 : /*Band Class 10 (Secondary 800-MHz Band)*/"
	echo -E "16 : /*Band Class 11 (400-MHz European PAMR Band)*/"
	echo -E "17 : /*Band Class 15 (AWS Band)*/"
	echo -E "18 : /*Band Class 16 (US 2.5-GHz Band)*/"
 	exit 0
fi
bandmode=$1

#open a socket, communicated with Service.
exec 9<> /dev/udp/127.0.0.1/8000

#send Terminal response CMD
echo "RIL_REQUEST_SET_BAND_MODE $bandmode" >&9

#close socket R/W
exec 9>&-
exec 9<&-
exit 0