#!/bin/bash
#Copyright (c) [2016], MediaTek Inc. All rights reserved.
#This software/firmware and related documentation ("MediaTek Software") are protected under relevant copyright laws.
#The information contained herein is confidential and proprietary to MediaTek Inc. and/or its licensors.
#Except as otherwise provided in  the applicable licensing terms with MediaTek Inc. and/or its licensors, any reproduction, 
#modification, use or disclosure of MediaTek Software, and information contained herein, in whole or in part, shall be strictly prohibited.

if [ ! -n "$1" ]
then
	echo -E "Error:"
	echo -E "please input parameter, you can input ' SetPrefferredNetworkType -h' for more details"
	exit 1
fi
if [ "$1" == "-h" ]
then
	echo -E "Usage: SetPrefferredNetworkType PreferredNetworkType"
	echo -E "0 : GSM/WCDMA (WCDMA preferred)"
	echo -E "1 : GSM only"
	echo -E "2 : WCDMA"
	echo -E "3 : GSM/WCDMA (auto mode, according to PRL)"
	echo -E "4 : CDMA and EvDo (auto mode, according to PRL)"
	echo -E "5 : CDMA only"
	echo -E "6 : EvDo only"
	echo -E "7 : GSM/WCDMA, CDMA, and EvDo (auto mode, according to PRL)"
	echo -E "8 : LTE, CDMA and EvDo"
	echo -E "9 : LTE, GSM/WCDMA"
	echo -E "10: LTE, CDMA, EvDo, GSM/WCDMA"
	echo -E "11: LTE only"
	echo -E "12: LTE/WCDMA"
	echo -E "13: TD-SCDMA only"
	echo -E "14: TD-SCDMA and WCDMA"
	echo -E "15: TD-SCDMA and LTE"
	echo -E "16: TD-SCDMA and GSM"
	echo -E "17: TD-SCDMA,GSM and LTE"
	echo -E "18: TD-SCDMA, GSM/WCDMA"
	echo -E "19: TD-SCDMA, WCDMA and LTE"
	echo -E "20: TD-SCDMA, GSM/WCDMA and LTE"
	echo -E "21: TD-SCDMA, GSM/WCDMA, CDMA and EvDo"
	echo -E "22: TD-SCDMA, LTE, CDMA, EvDo GSM/WCDMA"
	exit 0
fi

PreferredNetworkType=$1
echo "set prefferred network type."
#open a socket, communicated with Service.
exec 9<> /dev/udp/127.0.0.1/8000

#send Terminal response CMD
echo "RIL_REQUEST_SET_PREFERRED_NETWORK_TYPE $PreferredNetworkType" >&9

#close socket R/W
exec 9>&-
exec 9<&-
exit 0
