#!/bin/bash
#Copyright (c) [2016], MediaTek Inc. All rights reserved.
#This software/firmware and related documentation ("MediaTek Software") are protected under relevant copyright laws.
#The information contained herein is confidential and proprietary to MediaTek Inc. and/or its licensors.
#Except as otherwise provided in  the applicable licensing terms with MediaTek Inc. and/or its licensors, any reproduction, 
#modification, use or disclosure of MediaTek Software, and information contained herein, in whole or in part, shall be strictly prohibited.

echo "Send sms ims"
if [ "$1" == "-h" ]
then
	echo -E "SendSMSIMS <Receiver Number> <CharSet> <Message Content> <Retry Number> <MessageRef: Last Server Return Result> [SMS Center Number]"
	exit 0
fi

if [ "$4" == "" ]
then
	echo -E "Need MessageRef!"
	exit 1
fi

ReceiverNum=$1
CharSet=$2
MessageStr=$3
RetryNum=$4
MessageRef=$5
SmscNum=$6

if [ ${#MessageStr} -gt 970 ]
then
echo "message lenth is ${#MessageStr}"
echo "message lenth is more than 970. truncate!"
MessageStr=${MessageStr:0:970}
fi

echo -E "Send message ${MessageStr} to Receiver Number ${ReceiverNum} with MessageRef ${MessageRef} in charset $CharSet. Retry Number is ${RetryNum}."
echo -E "SMS center Number is $SmscNum."

#open a socket, communicated with Service.
exec 9<> /dev/udp/127.0.0.1/8000

#send Terminal response CMD
echo "RIL_REQUEST_IMS_SEND_SMS $ReceiverNum $CharSet \"$MessageStr\" $RetryNum $MessageRef $SmscNum " >&9

#close socket R/W
exec 9>&-
exec 9<&-
exit 0
