#!/bin/bash
#Copyright (c) [Year], MediaTek Inc. All rights reserved.
#This software/firmware and related documentation ("MediaTek Software") are protected under relevant copyright laws.
#The information contained herein is confidential and proprietary to MediaTek Inc. and/or its licensors.
#Except as otherwise provided in  the applicable licensing terms with MediaTek Inc. and/or its licensors, any reproduction,
#modification, use or disclosure of MediaTek Software, and information contained herein, in whole or in part, shall be strictly prohibited.
help()
{
    echo -e "\033[34m"
    echo "Usage:$0 <activate>"
    echo "int activate;    /* indicates to activate or turn off the reception of GSM/WCDMA Cell Broadcast SMS, 0-1, 0 - Activate, 1 - Turn off"
    echo -e "\033[0m"
}

fail_tip()
{
    echo -e "\033[31m"
    echo -E "parameter is invaild!"
    echo -e "\033[0m"
    help
}
is_num()
{
    re='^[+-]?[0-9]+$'
    if ! [[ $1 =~ $re ]]
    then
        return 0
    else
        return 1
    fi
}


if [ "$1" == "-h" ]
then
    help
    exit 0
fi

if [ "$#" != 1 ]
then
    fail_tip
    exit 0
fi

for var in "$1"
do
    if is_num $var
    then
        fail_tip
        exit 0
    fi
done

echo -E "Enable or disable the reception of GSM/WCDMA Cell Broadcast SMS: $1"

#open a socket, communicated with Service.
exec 9<> /dev/udp/127.0.0.1/8000

#send Terminal response CMD
echo "RIL_REQUEST_GSM_SMS_BROADCAST_ACTIVATION $1" >&9

#close socket R/W
exec 9>&-
exec 9<&-
exit 0
