#!/bin/bash
#Copyright (c) [2016], MediaTek Inc. All rights reserved.
#This software/firmware and related documentation ("MediaTek Software") are protected under relevant copyright laws.
#The information contained herein is confidential and proprietary to MediaTek Inc. and/or its licensors.
#Except as otherwise provided in  the applicable licensing terms with MediaTek Inc. and/or its licensors, any reproduction, 
#modification, use or disclosure of MediaTek Software, and information contained herein, in whole or in part, shall be strictly prohibited.

if [ "$1" == "-h" ]
then
	echo -E "Usage:$0 <Receiver Number> <Message Content>"
	echo -E "Receiver Number: the received phone SIM card number."
	echo -E "Message Content: the message that you want send to received phone number"
	exit 0
fi
ReceiverNum=$1
MessageStr=$2
if [ "$#" != 2 ]
then
	echo -E "parameter is invaild!"
	echo -E "Usage:$0 <Receiver Number> <Message Content>"
	echo -E "Receiver Number: the received phone SIM card number."
	echo -E "Message Content: the message that you want send to received phone number"
	exit 0
fi


echo -E "message (${MessageStr}) , Receiver Number ${ReceiverNum}."

#open a socket, communicated with Service.
exec 9<> /dev/udp/127.0.0.1/8000

#send Terminal response CMD
echo "RIL_REQUEST_CDMA_WRITE_SMS_TO_RUIM $ReceiverNum \"$MessageStr\""  >&9

#close socket R/W
exec 9>&-
exec 9<&-
exit 0
