#!/bin/bash
#Copyright (c) [Year], MediaTek Inc. All rights reserved.
#This software/firmware and related documentation ("MediaTek Software") are protected under relevant copyright laws.
#The information contained herein is confidential and proprietary to MediaTek Inc. and/or its licensors.
#Except as otherwise provided in  the applicable licensing terms with MediaTek Inc. and/or its licensors, any reproduction,
#modification, use or disclosure of MediaTek Software, and information contained herein, in whole or in part, shall be strictly prohibited.
help()
{
    echo -e "\033[34m"
    echo "Usage:$0 <type> <sourceAddress> <sourcePort> <destinationAddress> <destinationPort> <netif_id> <keepIdleTime> <keepIntervalTime> <retryCount>"
    echo "RIL_PacketType type;                      /* Type of keepalive packet */"
    echo "char sourceAddress[MAX_INADDR_LEN];      /* Source address in network-byte order */"
    echo "int sourcePort;                          /* Source port if applicable, or 0x7FFFFFFF;the maximum value is 65535 */"
    echo "char destinationAddress[MAX_INADDR_LEN]; /* Destination address in network-byte order */"
    echo "int destinationPort;                     /* Destination port if applicable or 0x7FFFFFFF;the maximum value is 65535 */"
    echo "int netif_id;"
    echo "int keepIdleTime;                         /*Sec. If no data during these time, start detecting, */"
    echo "int keepIntervalTime;                     /*seconds between two packets*/"
    echo "int retryCount;                           /*Detecting counts*/      "
    echo -e "\033[0m"
}

fail_tip()
{
    echo -e "\033[31m"
    echo -E "parameter is invaild!"
    echo -e "\033[0m"
    help
}
is_num()
{
    re='^[+-]?[0-9]+$'
    if ! [[ $1 =~ $re ]]
    then
        return 0
    else
        return 1
    fi
}


if [ "$1" == "-h" ]
then
    help
    exit 0
fi

if [ "$#" != 9 ]
then
    fail_tip
    exit 0
fi

for var in "$1" "$3" "$5" "$6" "$7" "$8" "$9"
do
    if is_num $var
    then
        fail_tip
        exit 0
    fi
done

echo -E "Start a keepalive session: $1 $2 $3 $4 $5 $6 $7 $8 $9"

#open a socket, communicated with Service.
exec 9<> /dev/udp/127.0.0.1/8000

#send Terminal response CMD
echo "RIL_REQUEST_START_KEEPALIVE_PRO $1 $2 $3 $4 $5 $6 $7 $8 $9" >&9

#close socket R/W
exec 9>&-
exec 9<&-
exit 0
