/* Copyright Statement:
 *
 * This software/firmware and related documentation ("MediaTek Software") are
 * protected under relevant copyright laws. The information contained herein
 * is confidential and proprietary to MediaTek Inc. and/or its licensors.
 * Without the prior written permission of MediaTek inc. and/or its licensors,
 * any reproduction, modification, use or disclosure of MediaTek Software,
 * and information contained herein, in whole or in part, shall be strictly prohibited.
 */
/* MediaTek Inc. (C) 2010. All rights reserved.
 *
 * BY OPENING THIS FILE, RECEIVER HEREBY UNEQUIVOCALLY ACKNOWLEDGES AND AGREES
 * THAT THE SOFTWARE/FIRMWARE AND ITS DOCUMENTATIONS ("MEDIATEK SOFTWARE")
 * RECEIVED FROM MEDIATEK AND/OR ITS REPRESENTATIVES ARE PROVIDED TO RECEIVER ON
 * AN "AS-IS" BASIS ONLY. MEDIATEK EXPRESSLY DISCLAIMS ANY AND ALL WARRANTIES,
 * EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE IMPLIED WARRANTIES OF
 * MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE OR NONINFRINGEMENT.
 * NEITHER DOES MEDIATEK PROVIDE ANY WARRANTY WHATSOEVER WITH RESPECT TO THE
 * SOFTWARE OF ANY THIRD PARTY WHICH MAY BE USED BY, INCORPORATED IN, OR
 * SUPPLIED WITH THE MEDIATEK SOFTWARE, AND RECEIVER AGREES TO LOOK ONLY TO SUCH
 * THIRD PARTY FOR ANY WARRANTY CLAIM RELATING THERETO. RECEIVER EXPRESSLY ACKNOWLEDGES
 * THAT IT IS RECEIVER'S SOLE RESPONSIBILITY TO OBTAIN FROM ANY THIRD PARTY ALL PROPER LICENSES
 * CONTAINED IN MEDIATEK SOFTWARE. MEDIATEK SHALL ALSO NOT BE RESPONSIBLE FOR ANY MEDIATEK
 * SOFTWARE RELEASES MADE TO RECEIVER'S SPECIFICATION OR TO CONFORM TO A PARTICULAR
 * STANDARD OR OPEN FORUM. RECEIVER'S SOLE AND EXCLUSIVE REMEDY AND MEDIATEK'S ENTIRE AND
 * CUMULATIVE LIABILITY WITH RESPECT TO THE MEDIATEK SOFTWARE RELEASED HEREUNDER WILL BE,
 * AT MEDIATEK'S OPTION, TO REVISE OR REPLACE THE MEDIATEK SOFTWARE AT ISSUE,
 * OR REFUND ANY SOFTWARE LICENSE FEES OR SERVICE CHARGE PAID BY RECEIVER TO
 * MEDIATEK FOR SUCH MEDIATEK SOFTWARE AT ISSUE.
 *
 * The following software/firmware and/or related documentation ("MediaTek Software")
 * have been modified by MediaTek Inc. All revisions are subject to any receiver's
 * applicable license agreements with MediaTek Inc.
 */
#ifndef __RIL_EM_API__
#define __RIL_EM_API__

#include  <vendor-ril/telephony/ril.h>
#include <string>
#include <vector>

#include  "common.h"

typedef struct em_arry_{
    char *name;  /* main test name. */
    int subcnt;
    struct em_arry_ *subarray; 	  /* Function to call to do the job. */
    int unsol;
    int reply;
} em_arry_t;
extern em_arry_t lte_info[];
extern em_arry_t ims_setting[];
extern em_arry_t ims_common[];
extern em_arry_t ims_call[] ;
extern em_arry_t ims_registration[];
extern em_arry_t ims[];
extern em_arry_t gprs[];
extern em_arry_t networkselection[];
extern em_arry_t modem_cta[];
extern em_arry_t modem_fta[];
extern em_arry_t modem_C2K_Test_MODEM[];
extern em_arry_t modemtest[];
extern em_arry_t hspa[];
extern em_arry_t cfu[];
extern em_arry_t bandmode[];
extern em_arry_t networkinfo[];
extern em_arry_t antenna_4Gmode[];
extern em_arry_t antenna_3Gmode[];
extern em_arry_t antennatest[];
extern em_arry_t time_reg[];
extern em_arry_t c2k_modem_setting[];
extern em_arry_t set_get[];
extern em_arry_t rfdesense_gsm_band[];
extern em_arry_t rfdesense_gsm_pattern[];
extern em_arry_t rfdesense_gsm_sub[];
extern em_arry_t rfdesense_gsm[];
extern em_arry_t rfdesense_tdscdma_band[];
extern em_arry_t rfdesense_tdscdma_sub[];
extern em_arry_t rfdesense_tdscdma[];
extern em_arry_t rfdesense_wcdma_band[];
extern em_arry_t rfdesense_wcdma_sub[];
extern em_arry_t rfdesense_wcdma[];
extern em_arry_t rfdesense_lte_mode[];
extern em_arry_t rfdesense_fdd_band[] ;
extern em_arry_t rfdesense_lte_bandwidth[];
extern em_arry_t  rfdesense_lte_mcs[];
extern em_arry_t rfdesense_fdd_sub[];
extern em_arry_t rfdesense_lte_fdd[];
extern em_arry_t rfdesense_tdd_band[];
extern em_arry_t rfdesense_tdd_config[];
extern em_arry_t rfdesense_tdd_special[];
extern em_arry_t rfdesense_tdd_sub[];
extern em_arry_t rfdesense_lte_tdd[];
extern em_arry_t rfdesense_cdma_band[];
extern em_arry_t rfdesense_cdma_modulation[];
extern em_arry_t rfdesense_cdma_sub[];
extern em_arry_t rfdesense_cdma[];
extern em_arry_t sub_tx_test[];
extern em_arry_t desense_test[];
extern em_arry_t emmain[];

#define RET_STRING_IMS_SUCCESS "IMS test success\ndone\n"
#define RET_STRING_IMS_FAIL "IMS test fail\ndone\n"
#define RET_STRING_GPRS_SUCCESS "GPRS test success\ndone\n"
#define RET_STRING_GPRS_FAIL "GPRS test fail\ndone\n"
#define RET_STRING_NWSELECTION_SUCCESS "Network Selection success\ndone\n"
#define RET_STRING_NWSELECTION_FAIL "Network Selection fail\ndone\n"
#define RET_STRING_MODEMTEST_SUCCESS "Modem test success\ndone\n"
#define RET_STRING_MODEMTEST_FAIL "Modem test fail\ndone\n"
#define RET_STRING_HSPA_SUCCESS "HSPA test success\ndone\n"
#define RET_STRING_HSPA_FAIL "HSPA test fail\ndone\n"
#define RET_STRING_LTE_SUCCESS "LTE success\ndone\n"
#define RET_STRING_LTE_FAIL "LTE fail\ndone\n"
#define RET_STRING_CFU_SUCCESS "CFU success\ndone\n"
#define RET_STRING_CFU_FAIL "CFU fail\ndone\n"
#define RET_STRING_BANDMODE_SUCCESS "Bandmode success\ndone\n"
#define RET_STRING_BANDMODE_FAIL "Bandmode fail\ndone\n"
#define RET_STRING_NWINFO_SUCCESS "NetworkInfo success\ndone\n"
#define RET_STRING_NWINFO_FAIL "NetworkInfo fail\ndone\n"
#define RET_STRING_ANTENNATEST_SUCCESS "Antenna test success\ndone\n"
#define RET_STRING_ANTENNATEST_FAIL "Antenna test fail\ndone\n"
#define RET_STRING_C2K_MODEM_SETTING_SUCCESS "c2k modem setting success\ndone\n";
#define RET_STRING_C2K_MODEM_SETTING_FAIL "c2k modem setting fail\ndone\n";

int emImsStart(int argc, int *item,char *value);
int emGprsStart(int argc, int *item,char *value);
int emNetworkSelectionStart(int argc,int selectpos);
int emModemtestStart(int argc, int multicnt,int *item);
int emHspaStart(int argc, int *item);
int lte_em_start(int argc, int multicnt,int *item);
int em_el1_start(int argc, int multicnt,int *item);
int emCfuStart(int argc, int *item);
int emBandmodeStart(int len,int *item,int multilen,char *value[]);
int emNwInfoStart(int argc, int multicnt,int *item);
int emAntennaTestStart(int argc, int *item,char *value);
int emC2kModemSettingStart(int argc, int multicnt,int *item);
int emRfDesenseStart(int len,int *item,int multilen,char *value[]);

std::vector<std::string> getCdmaCmdArr(std::vector<std::string> cmdArray);
int em_result_notify_fail(std::string str);
int em_result_notify_ok(std::string str);
int em_result_notify_error(std::string str);
int emResultNotifyWithDone(std::string str);
int emResultNotifyEx(std::string str);
int em_result_only_msg(std::string str);
void emSendATCommand(const char *cmd, int soc_id);
void emEnableRadio(bool isEnable, int soc_id);
int em_start(int argc, char *argv[], RIL_SOCKET_ID socket_id, RequestInfo *pRI);
#endif
