//SPDX-License-Identifier: MediaTekProprietary
/* Copyright Statement:
 *
 * This software/firmware and related documentation ("MediaTek Software") are
 * protected under relevant copyright laws. The information contained herein
 * is confidential and proprietary to MediaTek Inc. and/or its licensors.
 * Without the prior written permission of MediaTek inc. and/or its licensors,
 * any reproduction, modification, use or disclosure of MediaTek Software,
 * and information contained herein, in whole or in part, shall be strictly prohibited.
 */
/* MediaTek Inc. (C) 2010. All rights reserved.
 *
 * BY OPENING THIS FILE, RECEIVER HEREBY UNEQUIVOCALLY ACKNOWLEDGES AND AGREES
 * THAT THE SOFTWARE/FIRMWARE AND ITS DOCUMENTATIONS ("MEDIATEK SOFTWARE")
 * RECEIVED FROM MEDIATEK AND/OR ITS REPRESENTATIVES ARE PROVIDED TO RECEIVER ON
 * AN "AS-IS" BASIS ONLY. MEDIATEK EXPRESSLY DISCLAIMS ANY AND ALL WARRANTIES,
 * EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE IMPLIED WARRANTIES OF
 * MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE OR NONINFRINGEMENT.
 * NEITHER DOES MEDIATEK PROVIDE ANY WARRANTY WHATSOEVER WITH RESPECT TO THE
 * SOFTWARE OF ANY THIRD PARTY WHICH MAY BE USED BY, INCORPORATED IN, OR
 * SUPPLIED WITH THE MEDIATEK SOFTWARE, AND RECEIVER AGREES TO LOOK ONLY TO SUCH
 * THIRD PARTY FOR ANY WARRANTY CLAIM RELATING THERETO. RECEIVER EXPRESSLY ACKNOWLEDGES
 * THAT IT IS RECEIVER'S SOLE RESPONSIBILITY TO OBTAIN FROM ANY THIRD PARTY ALL PROPER LICENSES
 * CONTAINED IN MEDIATEK SOFTWARE. MEDIATEK SHALL ALSO NOT BE RESPONSIBLE FOR ANY MEDIATEK
 * SOFTWARE RELEASES MADE TO RECEIVER'S SPECIFICATION OR TO CONFORM TO A PARTICULAR
 * STANDARD OR OPEN FORUM. RECEIVER'S SOLE AND EXCLUSIVE REMEDY AND MEDIATEK'S ENTIRE AND
 * CUMULATIVE LIABILITY WITH RESPECT TO THE MEDIATEK SOFTWARE RELEASED HEREUNDER WILL BE,
 * AT MEDIATEK'S OPTION, TO REVISE OR REPLACE THE MEDIATEK SOFTWARE AT ISSUE,
 * OR REFUND ANY SOFTWARE LICENSE FEES OR SERVICE CHARGE PAID BY RECEIVER TO
 * MEDIATEK FOR SUCH MEDIATEK SOFTWARE AT ISSUE.
 *
 * The following software/firmware and/or related documentation ("MediaTek Software")
 * have been modified by MediaTek Inc. All revisions are subject to any receiver's
 * applicable license agreements with MediaTek Inc.
 */
#include <vendor-ril/telephony/ril.h>
#include <stdlib.h>
#include <stdio.h>
#include <cutils/jstring.h>
#include <log/log.h>
#include <unistd.h>
#include <math.h>
#include  "common.h"
#include "em/em.h"
#include "Radio_capability_switch_util.h"
#include "WorldPhoneUtil.h"
#include "../util/AtLine.h"
#if EM_MODE_SUPPORT

#undef LOG_TAG
#define LOG_TAG "EM_HSPA"

char *hspa_info_mode_array_td[] = {
    "HSDPA off\n",
    "HSDPA on\nHSUPA off\n",
    "HSDPA on\nHSUPA on\n",
    "HSDPA on\nHSUPA on\n",
};

char *hspa_info_mode_array_fd[] = {
    "HSDPA off\n",
    "HSDPA on\nHSUPA off\n",
    "HSDPA on\nHSUPA on\nHSPA+ off\n",
    "HSDPA on\nHSUPA on\nHSPA+ on\n",
};

const int EVENT_HSPA_INFO = 1;
//const int EVENT_DC_HSPA_INFO = 2;
const int EVENT_SET_HSPA = 3;
#define QUERY_CMD "AT+EHSM?"
#define SET_CMD "AT+EHSM="
#define RESPONSE_CMD "+EHSM:"
int mCurrentEmhspaFlag = 0;
int hspamode = 0;

void  sendATCommand_ehspa(const char *cmd,int msg)
{
    mCurrentEmhspaFlag = msg;
    emSendATCommand(cmd, Radio_capability_switch_util::get_main_capability_phone_id());
    return ;
}

void showHspa(int mode) {
    RLOGD("showHspa, mode=%d", mode);
    if (mode < 0 || mode >= 4) {
        RLOGD("Modem return invalid mode: %d", mode);
        android::emResultNotify(RET_STRING_HSPA_FAIL);
        return;
    }
    if (WorldPhoneUtil::getModemType() == WorldPhoneUtil::MODEM_TD) {
        android::emResultNotify(hspa_info_mode_array_td[mode]);
    } else {
        android::emResultNotify(hspa_info_mode_array_fd[mode]);
    }
}

void parseHspaAtCmd(const char* line) {
    if (strstr(line, RESPONSE_CMD) != NULL) {
        AtLine* atLine = new AtLine(line, NULL);
        int err;
        atLine->atTokStart(&err);
        if (err < 0) {
            RLOGW("this is not a valid response string");
            delete atLine;
            return;
        }
        int mode = atLine->atTokNextint(&err);
        if (err < 0) {
            RLOGW("parse rat fail");
            delete atLine;
            return;
        }
        showHspa(mode);
        delete atLine;
    }
}

void emHspaAtCmdHandle(char*response, int responselen) {
    switch (mCurrentEmhspaFlag) {
        case EVENT_HSPA_INFO:
        {
            //parse hspa mode.
            if ((responselen > 0) && (response != NULL)) {
                RLOGD("EVENT_HSPA_INFO response: %s\n",response);
                parseHspaAtCmd(response);
            }
            else {
                android::emResultNotify(RET_STRING_HSPA_FAIL);
                RLOGD("send fail ");
            }
            break;
        }
        case EVENT_SET_HSPA:
        {
            if ((responselen > 0) && (response != NULL)) {
                RLOGD("EVENT_SET_HSPA success: %s.\n",response);
            }
            else {
                RLOGD("send fail ");
            }
            break;
        }
        default:
            break;
    }
}


//create thread to send command
void * emHspaThread(void* arg)
{
    char cmd_str[32] = {0};
    //sprintf(cmd_str,"%s%d,0", SET_CMD,hspamode);
    //sendATCommand_ehspa(cmd_str,EVENT_SET_HSPA);
    sendATCommand_ehspa(QUERY_CMD,EVENT_HSPA_INFO);
    android::unregisterNetwork();
    //android::emResultNotify(RET_STRING_HSPA_SUCCESS);
    pthread_exit(0);
}

int emHspaStart(int argc, int *item)
{
    RLOGD("emHspaStart called");
    if(argc < 1)
    {
        RLOGD("emHspaStart: please select mode to test: \
                0: off, 2: on");
        android::emResultNotify(RET_STRING_HSPA_FAIL);
        return -1;
    }
    if((item[0] > 1 ) || (item[0] < 0)){
        RLOGD("emHspaStart: invalid parameter %d",item[0]);
        android::emResultNotify(RET_STRING_HSPA_FAIL);
        return -1;
    }
    //int modemapping[2] = {0,2};
    mCurrentEmhspaFlag = 0;
    //hspamode = modemapping[item[0]];
    android::registerForATcmdResponse(emHspaAtCmdHandle);
    pthread_t emhspa_thread;
    pthread_create(&emhspa_thread,NULL, emHspaThread, NULL);
    return (0);
}
#endif

