/* Copyright Statement:
 *
 * This software/firmware and related documentation ("MediaTek Software") are
 * protected under relevant copyright laws. The information contained herein
 * is confidential and proprietary to MediaTek Inc. and/or its licensors.
 * Without the prior written permission of MediaTek inc. and/or its licensors,
 * any reproduction, modification, use or disclosure of MediaTek Software,
 * and information contained herein, in whole or in part, shall be strictly prohibited.
 *
 * MediaTek Inc. (C) 2016. All rights reserved.
 *
 * BY OPENING THIS FILE, RECEIVER HEREBY UNEQUIVOCALLY ACKNOWLEDGES AND AGREES
 * THAT THE SOFTWARE/FIRMWARE AND ITS DOCUMENTATIONS ("MEDIATEK SOFTWARE")
 * RECEIVED FROM MEDIATEK AND/OR ITS REPRESENTATIVES ARE PROVIDED TO RECEIVER ON
 * AN "AS-IS" BASIS ONLY. MEDIATEK EXPRESSLY DISCLAIMS ANY AND ALL WARRANTIES,
 * EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE IMPLIED WARRANTIES OF
 * MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE OR NONINFRINGEMENT.
 * NEITHER DOES MEDIATEK PROVIDE ANY WARRANTY WHATSOEVER WITH RESPECT TO THE
 * SOFTWARE OF ANY THIRD PARTY WHICH MAY BE USED BY, INCORPORATED IN, OR
 * SUPPLIED WITH THE MEDIATEK SOFTWARE, AND RECEIVER AGREES TO LOOK ONLY TO SUCH
 * THIRD PARTY FOR ANY WARRANTY CLAIM RELATING THERETO. RECEIVER EXPRESSLY ACKNOWLEDGES
 * THAT IT IS RECEIVER'S SOLE RESPONSIBILITY TO OBTAIN FROM ANY THIRD PARTY ALL PROPER LICENSES
 * CONTAINED IN MEDIATEK SOFTWARE. MEDIATEK SHALL ALSO NOT BE RESPONSIBLE FOR ANY MEDIATEK
 * SOFTWARE RELEASES MADE TO RECEIVER'S SPECIFICATION OR TO CONFORM TO A PARTICULAR
 * STANDARD OR OPEN FORUM. RECEIVER'S SOLE AND EXCLUSIVE REMEDY AND MEDIATEK'S ENTIRE AND
 * CUMULATIVE LIABILITY WITH RESPECT TO THE MEDIATEK SOFTWARE RELEASED HEREUNDER WILL BE,
 * AT MEDIATEK'S OPTION, TO REVISE OR REPLACE THE MEDIATEK SOFTWARE AT ISSUE,
 * OR REFUND ANY SOFTWARE LICENSE FEES OR SERVICE CHARGE PAID BY RECEIVER TO
 * MEDIATEK FOR SUCH MEDIATEK SOFTWARE AT ISSUE.
 *
 * The following software/firmware and/or related documentation ("MediaTek Software")
 * have been modified by MediaTek Inc. All revisions are subject to any receiver's
 * applicable license agreements with MediaTek Inc.
 */

#ifndef RFDESENSETXTESTLTE_H_
#define RFDESENSETXTESTLTE_H_

#include <string>
#include <vector>
#include <map>

#include "util/utils.h"

class RfDesenseTxTestLte {
public:
    RfDesenseTxTestLte(int type);
    virtual ~RfDesenseTxTestLte();
    void show_default();
    std::string get_command();
    std::string get_band();
    std::string get_power();
    bool set_mode(int value);
    bool set_band(int value);
    bool set_bandwith(int value);
    bool set_freq(std::string str);
    bool set_tdd_config(int value);
    bool set_tdd_special(int value);
    bool set_start(std::string str);
    bool set_length(std::string str);
    bool set_mcs(int value);
    bool set_power(std::string str);
    void show_freq();
    void show_start();
    void show_length();
    void show_power();
private:
    bool check_band(std::string band);
    bool check_band_width(std::string band_width);
    bool check_freq(std::string freq);
    bool check_tdd_config(std::string config);
    bool check_tdd_special(std::string special);
    bool check_vrb_start(std::string start);
    bool check_vrb_length(std::string length);
    bool check_mcs(std::string mcs);
    bool check_power(std::string power);
    bool check_mode(std::string mode);
    std::string modemTypeToString(int type);

    std::string command;
    static const int INDEX_BAND;
    static const int INDEX_BAND_WIDTH;
    static const int INDEX_FREQ;
    static const int INDEX_VRB_START;
    static const int INDEX_VRB_LENGTH;
    static const int INDEX_MCS;
    static const int INDEX_POWER;
    static const int INDEX_MODE;
    static const int INDEX_TDD_CONFIG;
    static const int INDEX_TDD_SPECIAL;
    static std::string band;
    static std::string band_width;
    static std::string freq;
    static std::string tdd_config;
    static std::string tdd_special;
    static std::string vrb_start;
    static std::string vrb_length;
    static std::string mcs;
    static std::string power;
    static std::string mode;
    static std::map<int, std::string> lte_fdd_values;
    static std::map<int, std::string> lte_tdd_valuse;
    int modem_type = utils::MODEM_UNKNOWN;
    static const std::vector<std::string> band_fdd;
    static const std::vector<std::string> band_tdd;
    static const std::vector<std::vector<std::string>> fdd_freq_limits;
    static const std::vector<std::vector<std::string>> tdd_freq_limits;
};

#endif /* RFDESENSETXTESTLTE_H_ */
