/* Copyright Statement:
 *
 * This software/firmware and related documentation ("MediaTek Software") are
 * protected under relevant copyright laws. The information contained herein
 * is confidential and proprietary to MediaTek Inc. and/or its licensors.
 * Without the prior written permission of MediaTek inc. and/or its licensors,
 * any reproduction, modification, use or disclosure of MediaTek Software,
 * and information contained herein, in whole or in part, shall be strictly prohibited.
 */
/* MediaTek Inc. (C) 2010. All rights reserved.
 *
 * BY OPENING THIS FILE, RECEIVER HEREBY UNEQUIVOCALLY ACKNOWLEDGES AND AGREES
 * THAT THE SOFTWARE/FIRMWARE AND ITS DOCUMENTATIONS ("MEDIATEK SOFTWARE")
 * RECEIVED FROM MEDIATEK AND/OR ITS REPRESENTATIVES ARE PROVIDED TO RECEIVER ON
 * AN "AS-IS" BASIS ONLY. MEDIATEK EXPRESSLY DISCLAIMS ANY AND ALL WARRANTIES,
 * EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE IMPLIED WARRANTIES OF
 * MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE OR NONINFRINGEMENT.
 * NEITHER DOES MEDIATEK PROVIDE ANY WARRANTY WHATSOEVER WITH RESPECT TO THE
 * SOFTWARE OF ANY THIRD PARTY WHICH MAY BE USED BY, INCORPORATED IN, OR
 * SUPPLIED WITH THE MEDIATEK SOFTWARE, AND RECEIVER AGREES TO LOOK ONLY TO SUCH
 * THIRD PARTY FOR ANY WARRANTY CLAIM RELATING THERETO. RECEIVER EXPRESSLY ACKNOWLEDGES
 * THAT IT IS RECEIVER'S SOLE RESPONSIBILITY TO OBTAIN FROM ANY THIRD PARTY ALL PROPER LICENSES
 * CONTAINED IN MEDIATEK SOFTWARE. MEDIATEK SHALL ALSO NOT BE RESPONSIBLE FOR ANY MEDIATEK
 * SOFTWARE RELEASES MADE TO RECEIVER'S SPECIFICATION OR TO CONFORM TO A PARTICULAR
 * STANDARD OR OPEN FORUM. RECEIVER'S SOLE AND EXCLUSIVE REMEDY AND MEDIATEK'S ENTIRE AND
 * CUMULATIVE LIABILITY WITH RESPECT TO THE MEDIATEK SOFTWARE RELEASED HEREUNDER WILL BE,
 * AT MEDIATEK'S OPTION, TO REVISE OR REPLACE THE MEDIATEK SOFTWARE AT ISSUE,
 * OR REFUND ANY SOFTWARE LICENSE FEES OR SERVICE CHARGE PAID BY RECEIVER TO
 * MEDIATEK FOR SUCH MEDIATEK SOFTWARE AT ISSUE.
 *
 * The following software/firmware and/or related documentation ("MediaTek Software")
 * have been modified by MediaTek Inc. All revisions are subject to any receiver's
 * applicable license agreements with MediaTek Inc.
 */

#include "BitwiseInputStream.h"
#include <algorithm>
using namespace std;

BitwiseInputStream::BitwiseInputStream(std::vector<uint8_t> buf) {
  mBuf = buf;
  mEnd = buf.size() << 3;
  mPos = 0;

}

BitwiseInputStream::~BitwiseInputStream() {
  // TODO Auto-generated destructor stub
}

int BitwiseInputStream::available() {
  return mEnd - mPos;
}

uint32_t BitwiseInputStream::read(uint32_t bits) {
  uint32_t index = mPos >> 3;
  uint32_t offset = 16 - (mPos & 0x07) - bits;  // &7==%8
  if ((bits < 0) || (bits > 8) || ((mPos + bits) > mEnd)) {
    //TDB
    return -1;
  }
  uint32_t data = (mBuf[index] & 0xFF) << 8;
  if (offset < 8)
    data |= mBuf[index + 1] & 0xFF;
  data >>= offset;
  data &= (0xFFFFFFFF >> (32 - bits));
  mPos += bits;
  return data;
}

//uint8_t* BitwiseInputStream::readByteArray(uint32_t bits, int* length) {
//  uint32_t bytes = (bits >> 3) + ((bits & 0x07) > 0 ? 1 : 0);  // &7==%8
//  uint8_t* arr = new uint8_t[bytes];
//  for (int i = 0; i < bytes; i++) {
//    int increment = std::min((uint32_t) 8, bits - (i << 3));
//    arr[i] = (uint8_t) (read(increment) << (8 - increment));
//  }
//  return arr;
//}

std::vector<uint8_t> BitwiseInputStream::readByteVector(uint32_t bits) {
  uint32_t bytes = (bits >> 3) + ((bits & 0x07) > 0 ? 1 : 0);  // &7==%8
  std::vector<uint8_t> arr;
  //uint8_t* arr = new uint8_t[bytes];
  for (int i = 0; i < bytes; i++) {
    int increment = std::min((uint32_t) 8, bits - (i << 3));
    arr.push_back((uint8_t) (read(increment) << (8 - increment)));
    //arr[i] = (uint8_t) (read(increment) << (8 - increment));
  }
  return arr;
}

void BitwiseInputStream::skip(uint32_t bits) {
  if ((mPos + bits) > mEnd) {
    //TBD log
    return;
  }
  mPos += bits;
}
