/* Copyright Statement:
 *
 * This software/firmware and related documentation ("MediaTek Software") are
 * protected under relevant copyright laws. The information contained herein
 * is confidential and proprietary to MediaTek Inc. and/or its licensors.
 * Without the prior written permission of MediaTek inc. and/or its licensors,
 * any reproduction, modification, use or disclosure of MediaTek Software,
 * and information contained herein, in whole or in part, shall be strictly prohibited.
 */
/* MediaTek Inc. (C) 2010. All rights reserved.
 *
 * BY OPENING THIS FILE, RECEIVER HEREBY UNEQUIVOCALLY ACKNOWLEDGES AND AGREES
 * THAT THE SOFTWARE/FIRMWARE AND ITS DOCUMENTATIONS ("MEDIATEK SOFTWARE")
 * RECEIVED FROM MEDIATEK AND/OR ITS REPRESENTATIVES ARE PROVIDED TO RECEIVER ON
 * AN "AS-IS" BASIS ONLY. MEDIATEK EXPRESSLY DISCLAIMS ANY AND ALL WARRANTIES,
 * EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE IMPLIED WARRANTIES OF
 * MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE OR NONINFRINGEMENT.
 * NEITHER DOES MEDIATEK PROVIDE ANY WARRANTY WHATSOEVER WITH RESPECT TO THE
 * SOFTWARE OF ANY THIRD PARTY WHICH MAY BE USED BY, INCORPORATED IN, OR
 * SUPPLIED WITH THE MEDIATEK SOFTWARE, AND RECEIVER AGREES TO LOOK ONLY TO SUCH
 * THIRD PARTY FOR ANY WARRANTY CLAIM RELATING THERETO. RECEIVER EXPRESSLY ACKNOWLEDGES
 * THAT IT IS RECEIVER'S SOLE RESPONSIBILITY TO OBTAIN FROM ANY THIRD PARTY ALL PROPER LICENSES
 * CONTAINED IN MEDIATEK SOFTWARE. MEDIATEK SHALL ALSO NOT BE RESPONSIBLE FOR ANY MEDIATEK
 * SOFTWARE RELEASES MADE TO RECEIVER'S SPECIFICATION OR TO CONFORM TO A PARTICULAR
 * STANDARD OR OPEN FORUM. RECEIVER'S SOLE AND EXCLUSIVE REMEDY AND MEDIATEK'S ENTIRE AND
 * CUMULATIVE LIABILITY WITH RESPECT TO THE MEDIATEK SOFTWARE RELEASED HEREUNDER WILL BE,
 * AT MEDIATEK'S OPTION, TO REVISE OR REPLACE THE MEDIATEK SOFTWARE AT ISSUE,
 * OR REFUND ANY SOFTWARE LICENSE FEES OR SERVICE CHARGE PAID BY RECEIVER TO
 * MEDIATEK FOR SUCH MEDIATEK SOFTWARE AT ISSUE.
 *
 * The following software/firmware and/or related documentation ("MediaTek Software")
 * have been modified by MediaTek Inc. All revisions are subject to any receiver's
 * applicable license agreements with MediaTek Inc.
 */

#ifndef SMSHEADER_H_
#define SMSHEADER_H_
#include <cstdint>
#include <list>
#include <memory>
#include <vector>
#include <string>
class SmsHeader {
public:
  SmsHeader();
  virtual ~SmsHeader();

  // TODO(cleanup): this data structure is generally referred to as
  // the 'user data header' or UDH, and so the class name should
  // change to reflect this...

  /** SMS user data header information element identifiers.
   * (see TS 23.040 9.2.3.24)
   */
  static constexpr int ELT_ID_CONCATENATED_8_BIT_REFERENCE = 0x00;
  static constexpr int ELT_ID_SPECIAL_SMS_MESSAGE_INDICATION = 0x01;
  static constexpr int ELT_ID_APPLICATION_PORT_ADDRESSING_8_BIT = 0x04;
  static constexpr int ELT_ID_APPLICATION_PORT_ADDRESSING_16_BIT = 0x05;
  static constexpr int ELT_ID_SMSC_CONTROL_PARAMS = 0x06;
  static constexpr int ELT_ID_UDH_SOURCE_INDICATION = 0x07;
  static constexpr int ELT_ID_CONCATENATED_16_BIT_REFERENCE = 0x08;
  static constexpr int ELT_ID_WIRELESS_CTRL_MSG_PROTOCOL = 0x09;
  static constexpr int ELT_ID_TEXT_FORMATTING = 0x0A;
  static constexpr int ELT_ID_PREDEFINED_SOUND = 0x0B;
  static constexpr int ELT_ID_USER_DEFINED_SOUND = 0x0C;
  static constexpr int ELT_ID_PREDEFINED_ANIMATION = 0x0D;
  static constexpr int ELT_ID_LARGE_ANIMATION = 0x0E;
  static constexpr int ELT_ID_SMALL_ANIMATION = 0x0F;
  static constexpr int ELT_ID_LARGE_PICTURE = 0x10;
  static constexpr int ELT_ID_SMALL_PICTURE = 0x11;
  static constexpr int ELT_ID_VARIABLE_PICTURE = 0x12;
  static constexpr int ELT_ID_USER_PROMPT_INDICATOR = 0x13;
  static constexpr int ELT_ID_EXTENDED_OBJECT = 0x14;
  static constexpr int ELT_ID_REUSED_EXTENDED_OBJECT = 0x15;
  static constexpr int ELT_ID_COMPRESSION_CONTROL = 0x16;
  static constexpr int ELT_ID_OBJECT_DISTR_INDICATOR = 0x17;
  static constexpr int ELT_ID_STANDARD_WVG_OBJECT = 0x18;
  static constexpr int ELT_ID_CHARACTER_SIZE_WVG_OBJECT = 0x19;
  static constexpr int ELT_ID_EXTENDED_OBJECT_DATA_REQUEST_CMD = 0x1A;
  static constexpr int ELT_ID_RFC_822_EMAIL_HEADER = 0x20;
  static constexpr int ELT_ID_HYPERLINK_FORMAT_ELEMENT = 0x21;
  static constexpr int ELT_ID_REPLY_ADDRESS_ELEMENT = 0x22;
  static constexpr int ELT_ID_ENHANCED_VOICE_MAIL_INFORMATION = 0x23;
  static constexpr int ELT_ID_NATIONAL_LANGUAGE_SINGLE_SHIFT = 0x24;
  static constexpr int ELT_ID_NATIONAL_LANGUAGE_LOCKING_SHIFT = 0x25;

  static constexpr int PORT_WAP_PUSH = 2948;
  static constexpr int PORT_WAP_WSP = 9200;

  class PortAddrs {
  public:
    int destPort;
    int origPort;
    bool areEightBits;
  };

  class ConcatRef {
  public:
    int refNumber;
    int seqNumber;
    int msgCount;
    bool isEightBits;
  };

  class SpecialSmsMsg {
  public:
    int msgIndType;
    int msgCount;
  };

  /**
   * A header element that is not explicitly parsed, meaning not
   * PortAddrs or ConcatRef or SpecialSmsMsg.
   */
  class MiscElt {
  public:
    int id;
    std::vector<uint8_t> data;
    //uint8_t* data; //Remember to free
    //uint32_t data_length;
  };

  std::shared_ptr<PortAddrs> portAddrs = nullptr;
  std::shared_ptr<ConcatRef> concatRef;
  std::list<std::shared_ptr<SpecialSmsMsg>> specialSmsMsgList;
  std::list<std::shared_ptr<MiscElt>> miscEltList;
  //list<SpecialSmsMsg> specialSmsMsgList = new ArrayList<SpecialSmsMsg>();
  //ArrayList<MiscElt> miscEltList = new ArrayList<MiscElt>();

  /** 7 bit national language locking shift table, or 0 for GSM default 7 bit alphabet. */
  int languageTable;

  /** 7 bit national language single shift table, or 0 for GSM default 7 bit extension table. */
  int languageShiftTable;
  static std::shared_ptr<SmsHeader> fromByteArray(std::vector<uint8_t> v);
  static std::vector<uint8_t> toByteArray(std::shared_ptr<SmsHeader> smsHeader);
  std::string toString();
};

#endif /* SMSHEADER_H_ */
