/* Copyright Statement:
 *
 * This software/firmware and related documentation ("MediaTek Software") are
 * protected under relevant copyright laws. The information contained herein
 * is confidential and proprietary to MediaTek Inc. and/or its licensors.
 * Without the prior written permission of MediaTek inc. and/or its licensors,
 * any reproduction, modification, use or disclosure of MediaTek Software,
 * and information contained herein, in whole or in part, shall be strictly prohibited.
 */
/* MediaTek Inc. (C) 2010. All rights reserved.
 *
 * BY OPENING THIS FILE, RECEIVER HEREBY UNEQUIVOCALLY ACKNOWLEDGES AND AGREES
 * THAT THE SOFTWARE/FIRMWARE AND ITS DOCUMENTATIONS ("MEDIATEK SOFTWARE")
 * RECEIVED FROM MEDIATEK AND/OR ITS REPRESENTATIVES ARE PROVIDED TO RECEIVER ON
 * AN "AS-IS" BASIS ONLY. MEDIATEK EXPRESSLY DISCLAIMS ANY AND ALL WARRANTIES,
 * EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE IMPLIED WARRANTIES OF
 * MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE OR NONINFRINGEMENT.
 * NEITHER DOES MEDIATEK PROVIDE ANY WARRANTY WHATSOEVER WITH RESPECT TO THE
 * SOFTWARE OF ANY THIRD PARTY WHICH MAY BE USED BY, INCORPORATED IN, OR
 * SUPPLIED WITH THE MEDIATEK SOFTWARE, AND RECEIVER AGREES TO LOOK ONLY TO SUCH
 * THIRD PARTY FOR ANY WARRANTY CLAIM RELATING THERETO. RECEIVER EXPRESSLY ACKNOWLEDGES
 * THAT IT IS RECEIVER'S SOLE RESPONSIBILITY TO OBTAIN FROM ANY THIRD PARTY ALL PROPER LICENSES
 * CONTAINED IN MEDIATEK SOFTWARE. MEDIATEK SHALL ALSO NOT BE RESPONSIBLE FOR ANY MEDIATEK
 * SOFTWARE RELEASES MADE TO RECEIVER'S SPECIFICATION OR TO CONFORM TO A PARTICULAR
 * STANDARD OR OPEN FORUM. RECEIVER'S SOLE AND EXCLUSIVE REMEDY AND MEDIATEK'S ENTIRE AND
 * CUMULATIVE LIABILITY WITH RESPECT TO THE MEDIATEK SOFTWARE RELEASED HEREUNDER WILL BE,
 * AT MEDIATEK'S OPTION, TO REVISE OR REPLACE THE MEDIATEK SOFTWARE AT ISSUE,
 * OR REFUND ANY SOFTWARE LICENSE FEES OR SERVICE CHARGE PAID BY RECEIVER TO
 * MEDIATEK FOR SUCH MEDIATEK SOFTWARE AT ISSUE.
 *
 * The following software/firmware and/or related documentation ("MediaTek Software")
 * have been modified by MediaTek Inc. All revisions are subject to any receiver's
 * applicable license agreements with MediaTek Inc.
 */

#include <cstdint>
#include <algorithm>
#include "SmsMessageConverter.h"
#include "SmsEnvelope.h"
#include "CdmaSmsAddress.h"
#include "CdmaSmsSubaddress.h"
#include "SmsMessage.h"
#include <log/log.h>

#undef LOG_TAG
#define LOG_TAG "MULTI_USER_CDMA_SMS"
SmsMessageConverter::SmsMessageConverter() {
  // TODO Auto-generated constructor stub

}

SmsMessageConverter::~SmsMessageConverter() {
  // TODO Auto-generated destructor stub
}

std::shared_ptr<SmsMessage> SmsMessageConverter::newCdmaSmsMessageFromRil(
    RIL_CDMA_SMS_Message *p_cur) {
  // Note: Parcel.readByte actually reads one Int and masks to byte
  auto env = std::make_shared<SmsEnvelope>();
  auto addr = std::make_shared<CdmaSmsAddress>();
  auto subaddr = std::make_shared<CdmaSmsSubaddress>();
  std::vector<uint8_t> data;
  uint8_t count;
  int countInt;
  int addressDigitMode;

  //currently not supported by the modem-lib: env.mMessageType
  env->teleService = p_cur->uTeleserviceID;

  if (p_cur->bIsServicePresent) {
    env->messageType = SmsEnvelope::MESSAGE_TYPE_BROADCAST;
  } else {
    if (SmsEnvelope::TELESERVICE_NOT_SET == env->teleService) {
      // assume type ACK
      env->messageType = SmsEnvelope::MESSAGE_TYPE_ACKNOWLEDGE;
    } else {
      env->messageType = SmsEnvelope::MESSAGE_TYPE_POINT_TO_POINT;
    }
  }
  env->serviceCategory = p_cur->uServicecategory;

  // address
  addressDigitMode = p_cur->sAddress.digit_mode;
  addr->digitMode = (uint8_t) (0xFF & addressDigitMode);
  addr->numberMode = (uint8_t) (0xFF & p_cur->sAddress.number_mode);
  addr->ton = p_cur->sAddress.number_type;
  addr->numberPlan = (uint8_t) (0xFF & p_cur->sAddress.number_plan);
  count = std::min((p_cur->sAddress.number_of_digits), (uint8_t) RIL_CDMA_SMS_ADDRESS_MAX);
  addr->numberOfDigits = count;
  //data = new byte[count];
  std::string str;
  for (int index = 0; index < count; index++) {
    data.push_back(p_cur->sAddress.digits[index]);
    // convert the value if it is 4-bit DTMF to 8 bit
    if (addressDigitMode == CdmaSmsAddress::DIGIT_MODE_4BIT_DTMF) {
      data[index] = SmsMessage::convertDtmfToAscii(data[index]);
      str.push_back((char)(data[index]));
    }
  }
  if (addressDigitMode == CdmaSmsAddress::DIGIT_MODE_4BIT_DTMF) {
      RLOGD("address: %s", str.empty() ? "": str.c_str());
      printf("address: %s\n", str.empty() ? "": str.c_str());
  }

  addr->origBytes = data;

  subaddr->type = p_cur->sSubAddress.subaddressType;
  subaddr->odd = (uint8_t) (p_cur->sSubAddress.odd ? 1 : 0);
  count = std::min((p_cur->sSubAddress.number_of_digits),
      (uint8_t) RIL_CDMA_SMS_SUBADDRESS_MAX);

  if (count < 0) {
    count = 0;
  }

  // p_cur->sSubAddress.digits[digitCount] :

  data.clear();

  for (int index = 0; index < count; ++index) {
    data.push_back(p_cur->sSubAddress.digits[index]);
  }

  subaddr->origBytes = data;

  /* currently not supported by the modem-lib:
   env.bearerReply
   env.replySeqNo
   env.errorClass
   env.causeCode
   */

  // bearer data
  countInt = std::min((p_cur->uBearerDataLen), RIL_CDMA_SMS_BEARER_DATA_MAX);
  if (countInt < 0) {
    countInt = 0;
  }

  data.clear();
  for (int index = 0; index < countInt; index++) {
    data.push_back(p_cur->aBearerData[index]);
  }
  // BD gets further decoded when accessed in SMSDispatcher
  env->bearerData = data;

  // link the the filled objects to the SMS
  env->origAddress = addr;
  env->origSubaddress = subaddr;

  auto msg = std::make_shared<SmsMessage>(addr, env);

  return msg;
}
